/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.monitor;

import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.monitor.annotation.ProbeAtEntry;
import com.ibm.websphere.monitor.annotation.ProbeAtReturn;
import com.ibm.websphere.monitor.annotation.ProbeSite;
import com.ibm.websphere.monitor.annotation.PublishedMetric;
import com.ibm.websphere.monitor.annotation.This;
import com.ibm.websphere.monitor.meters.MeterCollection;
import io.openliberty.grpc.internal.monitor.GrpcServerStats;
import io.openliberty.grpc.internal.monitor.GrpcServerStatsMonitor;

@Monitor(group={"GrpcServer"})
public class GrpcServerMonitor {
    @PublishedMetric
    public MeterCollection<GrpcServerStats> grpcServerCountByName = new MeterCollection("GrpcServer", (Object)this);

    @ProbeAtEntry
    @ProbeSite(clazz="io.openliberty.grpc.internal.monitor.GrpcServerStatsMonitor", method="recordCallStarted")
    public void atGrpcServerStart(@This Object serverStats) {
        GrpcServerStatsMonitor stats = (GrpcServerStatsMonitor)serverStats;
        this.getGrpcServerStats(stats.getAppName(), stats.getServiceName()).recordCallStarted();
    }

    @ProbeAtReturn
    @ProbeSite(clazz="io.openliberty.grpc.internal.monitor.GrpcServerStatsMonitor", method="recordServerHandled")
    public void atGrpcServerHandled(@This Object serverStats) {
        GrpcServerStatsMonitor stats = (GrpcServerStatsMonitor)serverStats;
        GrpcServerStats grpcServerStats = this.getGrpcServerStats(stats.getAppName(), stats.getServiceName());
        grpcServerStats.recordServerHandled();
        long elapsed = stats.getLatency();
        grpcServerStats.recordLatency(elapsed < 0L ? 0L : elapsed);
    }

    @ProbeAtReturn
    @ProbeSite(clazz="io.openliberty.grpc.internal.monitor.GrpcServerStatsMonitor", method="recordMsgReceived")
    public void atGrpcServerMsgReceived(@This Object serverStats) {
        GrpcServerStatsMonitor stats = (GrpcServerStatsMonitor)serverStats;
        this.getGrpcServerStats(stats.getAppName(), stats.getServiceName()).incrementReceivedMsgCountBy(1);
    }

    @ProbeAtReturn
    @ProbeSite(clazz="io.openliberty.grpc.internal.monitor.GrpcServerStatsMonitor", method="recordMsgSent")
    public void atGrpcServerMsgSent(@This Object serverStats) {
        GrpcServerStatsMonitor stats = (GrpcServerStatsMonitor)serverStats;
        this.getGrpcServerStats(stats.getAppName(), stats.getServiceName()).incrementSentMsgCountBy(1);
    }

    private synchronized GrpcServerStats getGrpcServerStats(String appName, String serviceName) {
        GrpcServerStats stats = (GrpcServerStats)this.grpcServerCountByName.get(serviceName);
        if (stats == null) {
            stats = new GrpcServerStats(appName, serviceName);
            this.grpcServerCountByName.put(serviceName, (Object)stats);
        }
        return stats;
    }
}

