/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.dispatch;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sip.stack.dispatch.ConnectionAcceptedEvent;
import com.ibm.ws.sip.stack.dispatch.ConnectionClosedEvent;
import com.ibm.ws.sip.stack.dispatch.Event;
import com.ibm.ws.sip.stack.dispatch.IncomingDataEvent;
import com.ibm.ws.sip.stack.dispatch.TimerEvent;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transport.TransportCommLayerMgr;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import com.ibm.ws.sip.stack.transaction.util.Debug;
import com.ibm.ws.sip.stack.util.ThreadLocalStorage;
import java.util.LinkedList;

public class Dispatcher
implements Runnable {
    private static final LogMgr s_logger = Log.get(Dispatcher.class);
    private static Dispatcher s_instance = new Dispatcher();
    private LinkedList m_events = new LinkedList();
    private int m_maxQueueSize;
    private boolean m_isOverLoaded = false;
    private long m_lastOverLoadMessageTime = 0L;
    private boolean m_overloadLogged = false;
    private static final int s_numberOfThreads = SIPTransactionStack.instance().getConfiguration().getNumberOfDispatchThreads();
    private final Thread[] m_threads = s_numberOfThreads == 0 ? null : new Thread[s_numberOfThreads];
    private static int s_reportInterval = ApplicationProperties.getProperties().getInt("statReportInterval");
    private static long s_lastReport = 0L;
    private static int s_nHistory = 0;
    private static int s_peak = 0;
    private static final int N_EVENT_TYPES = 18;
    private static int[] s_nQueuedDist = new int[18];
    private static int[] s_nHistoryDist = new int[18];
    private static final Object s_reportLock = new Object();

    public static Dispatcher instance() {
        return s_instance;
    }

    private Dispatcher() {
        this.m_maxQueueSize = ApplicationProperties.getProperties().getInt("maxDispatchQueueSize");
        if (this.m_threads != null) {
            for (int i = 0; i < this.m_threads.length; ++i) {
                Thread thread = new Thread((Runnable)this, "SIP Stack Dispatch-" + i);
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("SIP stack dispatch thread started");
        }
        block10: while (true) {
            try {
                while (true) {
                    Event event;
                    Dispatcher dispatcher = this;
                    synchronized (dispatcher) {
                        if (this.m_events.isEmpty()) {
                            this.wait();
                        }
                        event = this.m_events.isEmpty() ? null : (Event)this.m_events.removeFirst();
                    }
                    if (event == null) {
                        if (!s_logger.isTraceDebugEnabled()) continue;
                        s_logger.traceDebug("Error: SIP dispatch awakened for no reason");
                        continue;
                    }
                    if (s_reportInterval > 0) {
                        int eventType = Dispatcher.eventType(event);
                        Object object = s_reportLock;
                        synchronized (object) {
                            int n = eventType;
                            s_nQueuedDist[n] = s_nQueuedDist[n] - 1;
                        }
                        this.report(event);
                    }
                    try {
                        event.onExecute();
                        continue block10;
                    }
                    catch (Exception e2) {
                        FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sip.stack.dispatch.Dispatcher.run", (String)"1", (Object)this);
                        if (!s_logger.isTraceDebugEnabled()) continue;
                        s_logger.traceDebug("Unhandled exception in SIP stack dispatch thread");
                        s_logger.traceDebug("SIP stack dispatch will try to continue normally");
                        s_logger.traceDebug(this, "run", "Exception", e2);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e3) {
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug(this, "run", "InterruptedException", e3);
                }
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("SIP stack dispatch thread terminated");
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queue(Event event) {
        if (s_reportInterval > 0) {
            int eventType = Dispatcher.eventType(event);
            Object object = s_reportLock;
            synchronized (object) {
                ++s_nHistory;
                int n = eventType;
                s_nHistoryDist[n] = s_nHistoryDist[n] + 1;
                int n2 = eventType;
                s_nQueuedDist[n2] = s_nQueuedDist[n2] + 1;
            }
            int currentSize = this.m_events.size();
            if (currentSize > s_peak) {
                s_peak = currentSize;
            }
            this.report(event);
        }
        Dispatcher eventType = this;
        synchronized (eventType) {
            this.m_events.addLast(event);
            this.notify();
        }
        if (this.m_maxQueueSize > 0) {
            boolean isOverLoadedNow;
            boolean bl = isOverLoadedNow = this.m_events.size() > this.m_maxQueueSize;
            if (s_logger.isWarnEnabled() && !this.m_isOverLoaded && isOverLoadedNow) {
                long now = System.currentTimeMillis();
                if (this.m_lastOverLoadMessageTime + 60000L < now) {
                    s_logger.warn("warn.dispatch.queue.overloaded", "Report.PERFORMANCE", new Object[]{this.m_maxQueueSize});
                    this.m_lastOverLoadMessageTime = now;
                    this.m_overloadLogged = true;
                }
            } else if (s_logger.isInfoEnabled() && this.m_isOverLoaded && !isOverLoadedNow && this.m_overloadLogged) {
                this.m_overloadLogged = false;
                s_logger.info("info.dispatch.queue.normal", (Object)"Report.PERFORMANCE", null);
            }
            this.m_isOverLoaded = isOverLoadedNow;
        }
    }

    public void queueIncomingDataEvent(SipMessageByteBuffer buffer, SIPConnection source) {
        if (source == null) {
            throw new IllegalArgumentException("queueIncomingDataEvent: source is null!");
        }
        if (this.m_threads == null) {
            if (s_logger.isTraceDebugEnabled()) {
                int len = buffer.getMarkedBytesNumber();
                StringBuffer msg = new StringBuffer();
                msg.append('[');
                msg.append(len);
                msg.append("] bytes received from [");
                msg.append(source.toString());
                msg.append("]\n");
                boolean hide = SIPTransactionStack.instance().getConfiguration().hideAnything();
                if (hide) {
                    msg.append("<raw packet is hidden>");
                } else {
                    Debug.hexDump(buffer.getBytes(), 0, len, msg);
                }
                s_logger.traceDebug(msg.toString());
            }
            TransportCommLayerMgr.instance().onRead(buffer, source);
        } else {
            IncomingDataEvent event = new IncomingDataEvent(buffer, source);
            this.queue(event);
        }
    }

    public void queueConnectionClosedEvent(SIPConnection connection) {
        if (this.m_threads == null) {
            TransportCommLayerMgr.instance().onConnectionClosed(connection);
        } else {
            ConnectionClosedEvent event = new ConnectionClosedEvent(connection);
            this.queue(event);
        }
    }

    public void queueConnectionAcceptedEvent(SIPListenningConnection listener, SIPConnection connection) {
        if (this.m_threads == null) {
            TransportCommLayerMgr.instance().onConnectionCreated(listener, connection);
        } else {
            ConnectionAcceptedEvent event = new ConnectionAcceptedEvent(listener, connection);
            this.queue(event);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void queueTimerEvent(TimerEvent event) {
        if (this.m_threads == null) {
            try {
                String callID = event.getCallId();
                ThreadLocalStorage.setCallID(callID);
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug(this, "queueTimerEvent", "storing the call ID on the current thread: " + callID);
                }
                event.onExecute();
                return;
            }
            catch (Throwable t) {
                if (!s_logger.isTraceFailureEnabled()) return;
                s_logger.traceFailure(this, "queueTimerEvent", "exception occured while executing timer event " + t);
                return;
            }
            finally {
                ThreadLocalStorage.setCallID(null);
            }
        } else {
            this.queue(event);
        }
    }

    public boolean isOverLoaded() {
        return this.m_isOverLoaded;
    }

    private static int eventType(Event event) {
        String className = event.getClass().getName();
        int eventType = className.endsWith(".ConnectionAcceptedEvent") ? 1 : (className.endsWith(".ConnectionClosedEvent") ? 2 : (className.endsWith(".IncomingDataEvent") ? 3 : (className.endsWith(".IncomingMessageEvent") ? 4 : (className.endsWith(".ApiTimer") ? 5 : (className.endsWith(".CancelTimer") ? 6 : (className.endsWith("CleanupTimer") ? 7 : (className.endsWith("TimerA") ? 8 : (className.endsWith("TimerAPI") ? 9 : (className.endsWith("TimerB") ? 10 : (className.endsWith("TimerD") ? 11 : (className.endsWith("TimerE") ? 12 : (className.endsWith("TimerF") ? 13 : (className.endsWith("TimerG") ? 14 : (className.endsWith("TimerH") ? 15 : (className.endsWith("TimerJ") ? 16 : (className.endsWith("TimerK") ? 17 : 0))))))))))))))));
        return eventType;
    }

    private void report(Event event) {
        long now = System.currentTimeMillis();
        if (now - s_lastReport < (long)s_reportInterval) {
            return;
        }
        s_lastReport = now;
        int peak = s_peak;
        s_peak = 0;
        StringBuffer report = new StringBuffer(1024);
        int nEvents = this.m_events.size();
        report.append("dispatch [").append(nEvents);
        report.append('/').append(peak);
        report.append('/').append(s_nHistory).append(']');
        for (int i = 0; i < 18; ++i) {
            report.append(' ');
            report.append(i).append('-').append(s_nQueuedDist[i]);
            report.append('/').append(s_nHistoryDist[i]);
        }
        System.out.println(report);
    }
}

