/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was.extension;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.was.extension.SipServletWrapper;
import com.ibm.ws.webcontainer.extension.WebExtensionProcessor;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class SipExtensionProcessor
extends WebExtensionProcessor {
    private static final LogMgr c_logger = Log.get(SipExtensionProcessor.class);
    public static final String URL_EXTENSION_PROCESSOR_INDICATOR = "/ibm_sip_ep/";
    private final Object m_lock = new Object();
    private SipAppDesc _sipApp;

    public SipExtensionProcessor(IServletContext servletCtx, SipContainer sipContainer, SipAppDesc sipApp) {
        super(servletCtx);
        this._sipApp = sipApp;
    }

    public IServletWrapper createServletWrapper(IServletConfig config) throws Exception {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry((Object)this, "createServletWrapper");
        }
        SipServletWrapper wrapper = new SipServletWrapper(this.extensionContext);
        wrapper.initialize(config);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit((Object)this, "createServletWrapper");
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry((Object)this, "handleRequest");
        }
        if (req instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)req;
            IServletConfig sconfig = this.getConfig(request);
            String path = request.getServletPath();
            RequestProcessor target = null;
            target = this.extensionContext.getMappingTarget(path);
            if (target == this) {
                target = this.createServletWrapper(sconfig);
                target = this.extensionContext.getMappingTarget(path.replace(URL_EXTENSION_PROCESSOR_INDICATOR, "/"));
                Object object = this.m_lock;
                synchronized (object) {
                    this.extensionContext.replaceMappingTarget(path, target);
                }
            }
            target.handleRequest(req, res);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("handleRequest: request is not instance of HttpServletRequest. req=" + req);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit((Object)this, "handleRequest");
        }
    }

    public List getPatternList() {
        ArrayList<String> patterns = new ArrayList<String>();
        for (SipServletDesc desc : this._sipApp.getSipServlets()) {
            String name = desc.getName();
            patterns.add(URL_EXTENSION_PROCESSOR_INDICATOR + name);
            if (!c_logger.isTraceDebugEnabled()) continue;
            c_logger.traceDebug((Object)this, "getPatternList", "pattern = /ibm_sip_ep/" + name);
        }
        return patterns;
    }

    private IServletConfig getConfig(HttpServletRequest req) throws ServletException {
        String sipletName = this.getSipletName(req);
        return this.extensionContext.getWebAppConfig().getServletInfo(sipletName);
    }

    private String getSipletName(HttpServletRequest req) {
        String uri = req.getRequestURI();
        int lastSlash = uri.lastIndexOf(47);
        return uri.substring(lastSlash + 1);
    }
}

