/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.util;

public class OperationTimeMeasurer {
    protected long _reportTimeInterval = 1000L;
    protected String _operationName;
    protected boolean _reportPeriodically = false;
    protected boolean _enabled = false;
    private long _startTime = 0L;
    private int _operationCount = 0;
    private long _totalTime = 0L;
    private long _operationsIntervalStart = 0L;
    private boolean _reportedOnce = false;

    public OperationTimeMeasurer(String operationName) {
        this._operationName = operationName;
    }

    public OperationTimeMeasurer(String operationName, long reportTimeInterval) {
        this._operationName = operationName;
        this._reportTimeInterval = reportTimeInterval;
    }

    public OperationTimeMeasurer(String operationName, long reportTimeInterval, boolean reportPeriodically) {
        this._operationName = operationName;
        this._reportTimeInterval = reportTimeInterval;
        this._reportPeriodically = reportPeriodically;
    }

    public void enable(boolean enable) {
        this._enabled = enable;
    }

    public void start() {
        if (!this._enabled) {
            return;
        }
        this._startTime = System.currentTimeMillis();
        if (this._operationsIntervalStart == 0L) {
            this._operationsIntervalStart = this._startTime;
        }
        ++this._operationCount;
    }

    public void finish() {
        if (!this._enabled) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        this._totalTime += currentTime - this._startTime;
        if (!this._reportedOnce) {
            this.report(this._totalTime / (long)this._operationCount, this._operationCount);
            this._reportedOnce = true;
            return;
        }
        if (this._reportPeriodically) {
            if (currentTime - this._operationsIntervalStart >= this._reportTimeInterval) {
                this.report(this._totalTime / (long)this._operationCount, this._operationCount);
                this._operationsIntervalStart = 0L;
            }
        } else if (this._totalTime >= this._reportTimeInterval) {
            this.report(this._totalTime / (long)this._operationCount, this._operationCount);
            this._operationCount = 0;
            this._totalTime = 0L;
        }
    }

    protected void report(long calcTime, int count) {
        System.out.println("Operation " + this._operationName + " duration measured " + calcTime + " ms , operation executed" + (!this._reportedOnce ? " for the first time " : (this._reportPeriodically ? " during " : " with total time of about ") + this._reportTimeInterval + " ms: count=" + this._operationCount));
    }
}

