/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.util;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.util.ContainerObjectPoolListener;
import java.util.Vector;

public class ContainerObjectPool {
    private static final LogMgr c_logger = Log.get(ContainerObjectPool.class);
    private final Class m_class;
    private ContainerObjectPoolListener m_listener;
    private int m_maxPoolSize = 1000;
    private boolean _isOverloaded = false;
    private long _lastOverLoadMessageTime;
    private final Vector m_objects;

    public ContainerObjectPool(Class type, String propertiesFlag) {
        this.m_class = type;
        this.m_objects = new Vector();
        int maxPoolSize = PropertiesStore.getInstance().getProperties().getInt(propertiesFlag);
        if (maxPoolSize > 0) {
            this.m_maxPoolSize = maxPoolSize;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "ContainerObjectPool", "Max Pool Size: " + this.m_maxPoolSize + " for: " + this.m_class.getName());
        }
    }

    public ContainerObjectPool(Class type, String propertiesFlag, ContainerObjectPoolListener listener) {
        this(type, propertiesFlag);
        this.m_listener = listener;
    }

    public ContainerObjectPool(Class type, ContainerObjectPoolListener listener, int size) {
        this.m_class = type;
        this.m_objects = new Vector(size < 1 ? 10 : size);
        this.m_maxPoolSize = size;
        this.m_listener = listener;
    }

    public synchronized Object get() {
        Object obj = null;
        if (this.m_objects.isEmpty()) {
            try {
                obj = this.m_class.newInstance();
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            if (null == obj) {
                throw new RuntimeException("Cannot create Object in pool");
            }
        } else {
            obj = this.m_objects.remove(this.m_objects.size() - 1);
        }
        return obj;
    }

    public synchronized void putBack(Object obj) {
        if (this.m_class.isInstance(obj)) {
            if (this.m_listener != null) {
                this.m_listener.objectReturned(obj);
            }
            if (this.m_maxPoolSize < 1 || this.m_objects.size() < this.m_maxPoolSize) {
                this.m_objects.addElement(obj);
                this._isOverloaded = false;
            } else if (!this._isOverloaded) {
                this._isOverloaded = true;
                long cTime = System.currentTimeMillis();
                if (this._lastOverLoadMessageTime + 60000L < cTime && c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "putBack", this.m_class.getName() + " Object pool is full, returned objects are dropped");
                    this._lastOverLoadMessageTime = cTime;
                }
            }
        } else {
            throw new IllegalArgumentException("argument type invalid for pool");
        }
    }

    public void setObjectPoolListener(ContainerObjectPoolListener listener) {
        this.m_listener = listener;
    }
}

