/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.transaction;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.naptr.ISenderListener;
import com.ibm.ws.sip.container.naptr.SendProcessor;
import com.ibm.ws.sip.container.naptr.SenderFactory;
import com.ibm.ws.sip.container.proxy.SubsequentRequestListener;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletRequest;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.transaction.ClientTransactionListener;
import com.ibm.ws.sip.container.transaction.SipTransaction;
import com.ibm.ws.sip.container.transaction.TransactionTable;
import com.ibm.ws.sip.container.tu.TUKey;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.SipUtil;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import com.ibm.ws.sip.stack.transport.virtualhost.SipVirtualHostAdapter;
import com.ibm.ws.sip.stack.util.SipStackUtil;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.SipURL;
import java.io.IOException;

public class ClientTransaction
extends SipTransaction
implements ISenderListener {
    private static final LogMgr c_logger = Log.get(ClientTransaction.class);
    private SendProcessor _sender;
    private SipURL _target;

    protected ClientTransaction(SipServletRequestImpl request) {
        super(request);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "ClientTransaction", "request.getMethod()=" + request.getMethod());
        }
    }

    public void setClientTransactionListener(ClientTransactionListener listener) {
        this.setTransactionListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean sendRequest() throws IOException {
        rc = true;
        if (ClientTransaction.c_logger.isTraceEntryExitEnabled()) {
            ClientTransaction.c_logger.traceEntry(this, "sendRequest");
        }
        try {
            request = (OutgoingSipServletRequest)this.getOriginalRequest();
            if (ClientTransaction.c_logger.isTraceDebugEnabled()) {
                ClientTransaction.c_logger.traceDebug(this, "sendRequest", "Client Transaction: send " + request.getMethod());
            }
            if (rc = this.getListener().onSendingRequest(request)) {
                destinationIsKnown = false;
                if (request.isMarkedForErrorResponse()) {
                    this.processCompositionError();
                    var4_4 = rc = false;
                    return var4_4;
                }
                request.setupRequestUri();
                desc = request.getTransactionUser().getSipServletDesc();
                vhName = null;
                appName = null;
                if (desc != null) {
                    vhName = desc.getSipApp().getVirtualHostName();
                    appName = desc.getSipApp().getApplicationName();
                }
                isLoopBack = false;
                if (desc == null || !SipVirtualHostAdapter.isVirtualHostExcludedFromComposition(vhName)) {
                    if (ClientTransaction.c_logger.isTraceDebugEnabled()) {
                        ClientTransaction.c_logger.traceDebug((Object)null, "sendRequest", "appName = " + appName + ", vhName=" + vhName + " not excluded from composition");
                    }
                    try {
                        if (request.isExternalRoute() || !request.checkIsLoopback()) ** GOTO lbl36
                        isLoopBack = true;
                    }
                    catch (SipParseException e) {
                        if (ClientTransaction.c_logger.isErrorEnabled()) {
                            ClientTransaction.c_logger.error("error.send.request", "Request", new Object[]{this}, (Throwable)e);
                        }
                        request.logExceptionToSessionLog(0x100004, e);
                        throw new IOException(e.getMessage());
                    }
                } else if (ClientTransaction.c_logger.isTraceDebugEnabled()) {
                    ClientTransaction.c_logger.traceDebug((Object)null, "sendRequest", "appName = " + appName + ", vhName=" + vhName + " is on excluded from composition list, continuing with request send without calling application router");
                }
lbl36:
                // 5 sources

                if (request.getMethod().equals("CANCEL")) {
                    this._target = this.getListener().getUsedDestination();
                    destinationIsKnown = true;
                    if (this._target == null) {
                        rc = false;
                        if (ClientTransaction.c_logger.isTraceDebugEnabled()) {
                            ClientTransaction.c_logger.traceDebug(this, "sendRequest", "Failed to send CANCEL - target was not found !!!! ");
                        }
                    }
                } else {
                    this._target = (SipURL)SipStackUtil.createTargetFromMessage(request.getRequest()).clone();
                }
                try {
                    if (SipStackUtil.isOutOfDialogRequest(request.getRequest())) {
                        SipStackUtil.fixHeaders(request.getRequest());
                    }
                }
                catch (SipParseException e) {
                    throw new IOException(e.getMessage());
                }
                request.setupParametersBeforeSent(this._target, isLoopBack);
                if (rc) {
                    if (ClientTransaction.c_logger.isTraceDebugEnabled()) {
                        ClientTransaction.c_logger.traceDebug(this, "sendRequest", "TargetUri = " + this._target);
                    }
                    this._sender = SenderFactory.getNaptrProcessor(destinationIsKnown);
                    if (ClientTransaction.c_logger.isTraceDebugEnabled()) {
                        ClientTransaction.c_logger.traceDebug(this, "sendRequest", "Got new Sender = " + this._sender);
                    }
                    this._sender.sendRequest(request, this);
                    if (request.getMethod().equals("ACK")) {
                        this.finishToUseSender();
                    }
                }
            } else if (ClientTransaction.c_logger.isTraceDebugEnabled()) {
                ClientTransaction.c_logger.traceDebug(this, "sendRequest", "Request was not sent - intercepted by listener");
            }
            var3_3 = rc;
            return var3_3;
        }
        finally {
            if (ClientTransaction.c_logger.isTraceEntryExitEnabled()) {
                ClientTransaction.c_logger.traceExit((Object)this, "sendRequest", rc);
            }
        }
    }

    public void processResponse(SipServletResponseImpl response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{Integer.toString(response.getStatus()), response.getReasonPhrase()};
            c_logger.traceEntry((Object)this, "processResponse", params);
        }
        this._sender.responseReceived(response, this);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "processResponse");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseReceived(SipServletResponseImpl response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{Integer.toString(response.getStatus()), response.getReasonPhrase()};
            c_logger.traceEntry((Object)this, "responseReceived", params);
        }
        response.setRequest(this.getOriginalRequest());
        ClientTransactionListener listenerToUse = this.getListener();
        int status = response.getStatus();
        try {
            TransactionUserWrapper transactionUser = this.getOriginalRequest().getTransactionUser();
            if (transactionUser != null && response.getProxyBranch() == null && !(this.m_listener instanceof SubsequentRequestListener)) {
                String receivedTag;
                if (SipUtil.canCreateDerivedSession(response) && (receivedTag = response.getResponse().getToHeader().getTag()) != null && transactionUser.getRemoteTag() != null) {
                    String tagToCompare = null;
                    boolean lookForTU = false;
                    if (transactionUser.isProxying()) {
                        if (!receivedTag.equals(transactionUser.getRemoteTag_2()) && !receivedTag.equals(transactionUser.getRemoteTag())) {
                            lookForTU = true;
                        }
                    } else if (!receivedTag.equals(transactionUser.getRemoteTag())) {
                        lookForTU = true;
                    }
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "responseReceived", "Tag Received = " + receivedTag + "Tag toCompare = " + tagToCompare);
                    }
                    if (lookForTU) {
                        TUKey key = ThreadLocalStorage.getTUKey();
                        key.setParams(response.getResponse(), SipServletMessageImpl.MessageType.INCOMING_RESPONSE);
                        transactionUser = SessionRepository.getInstance().getTuWrapper(key);
                        if (transactionUser == null) {
                            transactionUser = this.getOriginalRequest().getTransactionUser().createDerivedTU(response.getResponse(), "ClientTransactoin - response with different tag is received");
                        }
                        listenerToUse = transactionUser;
                    }
                }
                response.setTransactionUser(transactionUser);
                transactionUser.updateSession(response);
            }
            if (response.getMethod().equals("INVITE") && this.isProvisional(response)) {
                listenerToUse.setUsedDestination(this._sender.getLastUsedDestination(this));
            }
            if (status >= 200) {
                this.markAsTerminated();
            }
            listenerToUse.processResponse(response);
        }
        finally {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "responseReceived", "Clean transaction if need for status = " + status);
            }
            if (status >= 200) {
                this.onFinalResponse(response);
                this.finishToUseSender();
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "responseReceived");
        }
    }

    private boolean isProvisional(SipServletResponseImpl response) {
        return response.getStatus() >= 100 && response.getStatus() < 200;
    }

    @Override
    public void failedToSendRequest(boolean errorDuringSent) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "failedToSendRequest", "Request failed to be sent. errorDuringSent " + errorDuringSent + " Request = " + this.getOriginalRequest());
        }
        TransactionTable tt = TransactionTable.getInstance();
        SipTransaction clientTr = tt.getTransaction(this.getTransactionID());
        this.timedOut();
        if (clientTr == null && errorDuringSent) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "failedToSendRequest", "This ClientTransaction was ended with error during sent but not added to the TransactionTable yet. Notify Listener. TransactionId =  " + this.getTransactionID());
            }
            this.getListener().removeTransaction(this.getOriginalRequest().getMethod());
        }
    }

    @Override
    public void processTimeout() {
        this._sender.processTimeout(this);
    }

    @Override
    public void timedOut() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "timedOut", "Listener has timed out, process the timeout");
        }
        this.finishToUseSender();
        this.getListener().processTimeout(this.getOriginalRequest());
        super.processTimeout();
    }

    public void processCompositionError() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "processCompositionError");
        }
        this._sender = SenderFactory.getNaptrProcessor(true);
        this.finishToUseSender();
        this.getListener().processCompositionError(this.getOriginalRequest());
        super.processTimeout();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "processCompositionError");
        }
    }

    public void clearTransaction() {
        this.markAsTerminated();
        this.removeFromTransactionTable(null);
        this.finishToUseSender();
    }

    private void finishToUseSender() {
        SenderFactory.finishToUseSender(this._sender);
    }

    @Override
    public void saveTransactionId(long transactionId) {
        super.setId(transactionId);
        if (this.getTransactionID() != -1L && !this.getOriginalRequest().getMethod().equals("ACK")) {
            TransactionTable.getInstance().putTransaction(this);
            this.getOriginalRequest().getTransactionUser().storeClientTransaction(this);
        }
    }

    @Override
    protected void transactionTerminated(SipServletRequestImpl request) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "transactionTerminated", "transaction terminated, remove client transaction ");
        }
        this.getListener().clientTransactionTerminated(request);
        request.getTransactionUser().removeClientTransaction(this);
    }

    @Override
    public OutgoingSipServletRequest getOutgoingRequest() {
        return (OutgoingSipServletRequest)this.getOriginalRequest();
    }

    @Override
    public SipURL getTarget() {
        return this._target;
    }

    public ClientTransactionListener getListener() {
        return (ClientTransactionListener)this.m_listener;
    }

    @Override
    protected void notifyDerivedTUs() {
    }

    @Override
    public void addReferece(TransactionUserWrapper dtu) {
    }

    @Override
    protected void replaceListener() {
    }
}

