/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.extensions.RAckHeader;
import com.ibm.ws.jain.protocol.ip.sip.extensions.RSeqHeader;
import com.ibm.ws.sip.container.servlets.ReliableResponse;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import jain.protocol.ip.sip.header.HeaderParseException;
import java.util.Iterator;
import java.util.LinkedList;

public class ReliableResponsesProcessor {
    private static final LogMgr c_logger = Log.get(ReliableResponsesProcessor.class);
    private TransactionUserWrapper _transactioUser;
    private LinkedList _waitingResponses;
    private boolean _firstWasAcknowledged = false;
    private int _offersCounter = 0;
    private long m_localRSeq = 1L;
    private long m_lastRemoteRseg = -1L;
    private long m_lastRemoteAnsweredRseg = -1L;

    public ReliableResponsesProcessor(TransactionUserWrapper tUser) {
        this._transactioUser = tUser;
    }

    public int getOffersCounter() {
        return this._offersCounter;
    }

    public void addOffer() {
        ++this._offersCounter;
    }

    public void removeOffer() {
        --this._offersCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(SipServletResponseImpl response) {
        ReliableResponse responseObj = null;
        ReliableResponsesProcessor reliableResponsesProcessor = this;
        synchronized (reliableResponsesProcessor) {
            if (this._waitingResponses == null) {
                this._waitingResponses = new LinkedList();
                responseObj = new ReliableResponse(response, this);
                this._waitingResponses.addFirst(responseObj);
            } else if (this._firstWasAcknowledged) {
                responseObj = new ReliableResponse(response, this);
                this._waitingResponses.addLast(responseObj);
            } else {
                throw new IllegalStateException("The next Reliable Response can be sent only after the first one will be answered: " + this);
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Provisional response with CallId = <");
            buff.append(response.getCallId());
            buff.append("> and RSeq = <");
            String rseq = response.getHeader("RSeq");
            buff.append(rseq);
            buff.append("> will be sent now ");
            c_logger.traceDebug(this, "sendResponse", buff.toString());
        }
    }

    private RAckHeader getRackHeader(SipServletRequestImpl request) {
        RAckHeader rack = null;
        try {
            rack = (RAckHeader)request.getRequest().getHeader("RAck", true);
        }
        catch (HeaderParseException e2) {
            e2.printStackTrace();
        }
        catch (IllegalArgumentException e3) {
            e3.printStackTrace();
        }
        return rack;
    }

    private int matchFirstPrack(SipServletRequestImpl request, RAckHeader rack) {
        int rc = 481;
        ReliableResponse response = (ReliableResponse)this._waitingResponses.getFirst();
        if (response != null) {
            if (!response.getServletResponse().getMethod().equals(rack.getMethod()) || response.getCSeq() != rack.getSequenceNumber()) {
                rc = 400;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "isLegalPrack", "The SCeq parameters inside RAck header are wrong");
                }
            } else if (rack.getResponseNumber() == response.getRSeq()) {
                this._firstWasAcknowledged = true;
                response.acknowledged();
                this._waitingResponses.remove(response);
                rc = 200;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "isLegalPrack", "The PRACK on the first reliable response was received");
                }
            }
        }
        return rc;
    }

    private int matchPrack(SipServletRequestImpl request, RAckHeader rack) {
        int rc = 481;
        ReliableResponse rObj = null;
        boolean testMethod = true;
        Iterator iter = this._waitingResponses.iterator();
        while (iter.hasNext()) {
            rObj = (ReliableResponse)iter.next();
            if (testMethod) {
                if (!rObj.getServletResponse().getMethod().equals(rack.getMethod()) || rObj.getCSeq() != rack.getSequenceNumber()) {
                    rc = 400;
                    if (!c_logger.isTraceDebugEnabled()) break;
                    c_logger.traceDebug(this, "isLegalPrack", "The SCeq parameters inside RAck header are wrong");
                    break;
                }
                testMethod = false;
            }
            if (rack.getResponseNumber() == rObj.getRSeq()) {
                rObj.acknowledged();
                iter.remove();
                rc = 200;
                break;
            }
            if (rack.getResponseNumber() > rObj.getRSeq()) {
                rObj.cancel();
                iter.remove();
                continue;
            }
            rc = 481;
            break;
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int isLegalPrack(SipServletRequestImpl request) {
        int rc = 200;
        ReliableResponsesProcessor reliableResponsesProcessor = this;
        synchronized (reliableResponsesProcessor) {
            if (this._waitingResponses != null && this._waitingResponses.size() > 0) {
                RAckHeader rack = this.getRackHeader(request);
                if (rack == null) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "isLegalPrackReceived", "Filed to find RSeq in the PRACK");
                    }
                    rc = 400;
                } else {
                    rc = !this._firstWasAcknowledged ? this.matchFirstPrack(request, rack) : this.matchPrack(request, rack);
                }
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "isLegalPrack", "isLegal return error " + rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSendReliableResponses() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry((Object)this, "stopSendReliableResponses", (Object)this._transactioUser.getId());
        }
        if (this._waitingResponses != null && this._waitingResponses.size() > 0) {
            ReliableResponsesProcessor reliableResponsesProcessor = this;
            synchronized (reliableResponsesProcessor) {
                for (ReliableResponse rObj : this._waitingResponses) {
                    rObj.cancel();
                }
            }
            this._waitingResponses = null;
        }
        this._transactioUser.cleanReliableObject();
        this._transactioUser = null;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit(this, "stopSendReliableResponses");
        }
    }

    public void checkPrack(SipServletRequestImpl request) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry((Object)this, "checkPrack", (Object)request);
        }
        try {
            RAckHeader rack = (RAckHeader)request.getRequest().getHeader("RAck", true);
            if (rack == null) {
                throw new IllegalStateException("The PRACK request SHOULD contain RAck header " + this);
            }
            this.updateLastAnsweredRemoteCseq(rack.getResponseNumber());
        }
        catch (HeaderParseException e2) {
            throw new IllegalStateException(e2.getMessage() + ' ' + this);
        }
        finally {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceExit((Object)this, "checkPrack", "m_lastRemoteAnsweredRseg=" + this.m_lastRemoteAnsweredRseg);
            }
        }
    }

    public boolean sendFinalResponse(SipServletResponseImpl response) {
        if (response.getStatus() >= 200 && response.getStatus() < 300) {
            if (this._offersCounter > 0) {
                throw new IllegalStateException("Unable to send 2xx final response prior to receiving acknowledgement outstanding reliable provisional responses that has an offer per RFC 3262 section 3" + this);
            }
        } else {
            this.stopSendReliableResponses();
        }
        return true;
    }

    public synchronized long getNextRseg() {
        return this.m_localRSeq++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processReliableResponse(SipServletResponseImpl response) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry((Object)this, "processReliableResponse", (Object)response);
        }
        boolean isOk = false;
        try {
            long newRseq;
            RSeqHeader rseq = (RSeqHeader)response.getResponse().getHeader("RSeq", true);
            if (rseq != null && (newRseq = rseq.getResponseNumber()) > this.m_lastRemoteRseg && newRseq != this.m_lastRemoteAnsweredRseg) {
                this.updateLastRemoteCseq(newRseq);
                isOk = true;
            }
        }
        catch (HeaderParseException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processReliableResponse", "Exception " + e2.getMessage());
            }
        }
        catch (IllegalArgumentException e3) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processReliableResponse", "Exception " + e3.getMessage());
            }
        }
        finally {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceExit((Object)this, "processReliableResponse", new Boolean(isOk));
            }
        }
        return isOk;
    }

    private void updateLastRemoteCseq(long newCseq) {
        this.m_lastRemoteRseg = newCseq;
    }

    private void updateLastAnsweredRemoteCseq(long newCseq) {
        this.m_lastRemoteAnsweredRseg = newCseq;
    }
}

