/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl.chfw;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.ws.sip.channel.resolver.impl.chfw.SipResolver;
import com.ibm.ws.sip.channel.resolver.impl.chfw.SipURILookupImpl;
import com.ibm.wsspi.sip.channel.resolver.SIPUri;
import com.ibm.wsspi.sip.channel.resolver.SipURILookup;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupCallback;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Timer;
import java.util.Vector;
import java.util.regex.Pattern;

public class SipResolverService {
    private static final LogMgr c_logger = Log.get(SipResolverService.class);
    private static boolean initialized = false;
    private static SipResolver sipResolver = null;
    private static Timer resolverTimer = null;
    private static int timerCounter = 0;
    private static boolean _addTTL = false;
    private static boolean usePreciseSystemTimer = false;
    private static Hashtable<SIPUri, SipURILookupImpl> lookupCache = new Hashtable();
    private static long lookupCacheTimeout = 600000L;
    private static final String SIP_RFC3263_NAMESERVER = "SIP_RFC3263_nameserver";
    private static final String SIP_RFC3263_EDNS = "SIP_RFC3263_edns";
    private static final String SIP_RFC3263_TIMEOUT = "SIP_RFC3263_REQUEST_CACHE_TIMEOUT_MIN";
    private static final String SIP_RFC3263_ADD_TTL = "add_ttl";
    private static final String SIP_DNS_QUERY_TIMEOUT = "SIP_DNS_QUERY_TIMEOUT";
    private static final String SIP_USE_PRECISE_SYSTEM_TIMER = "SIP_USE_PRECISE_SYSTEM_TIMER";

    public static synchronized void initialize(Properties containerProps, CHFWBundle chfwb) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(SipResolverService.class, "SipResolverService: initialize(Properties): entry");
        }
        if (!initialized) {
            initialized = true;
            Object tempObject = containerProps.get(SIP_DNS_QUERY_TIMEOUT);
            if (tempObject != null) {
                Long messageTimeout = tempObject instanceof Long ? (Long)tempObject : 0L;
                if (messageTimeout != 0L) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverService: initialize: SIP_DNS_QUERY_TIMEOUT = " + messageTimeout);
                    }
                    SipURILookupImpl.setMessageTimeoutValue(messageTimeout);
                } else if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverService: initialize:  <SIP_DNS_QUERY_TIMEOUT>  is the wrong data type");
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverService: initialize:  <SIP_DNS_QUERY_TIMEOUT>  is not set");
            }
            _addTTL = (Boolean)containerProps.get("addTtl");
            String serverString = containerProps.getProperty("dnsServers");
            if (serverString == null) {
                if (c_logger.isInfoEnabled()) {
                    c_logger.info("info.sip.resolver.not.initialized");
                }
                initialized = false;
                return;
            }
            Vector<InetSocketAddress> nameServers = SipResolverService.serverStringtoVector(serverString);
            if (!nameServers.isEmpty()) {
                String sTimeout;
                String sEDNS;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("nameServers is not empty");
                }
                if ((sEDNS = containerProps.getProperty("dnsEdns")) != null) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverService: sEDNS is: " + sEDNS);
                    }
                    if ((sEDNS = sEDNS.trim()).equalsIgnoreCase("off")) {
                        SipResolver.setEDNS(false);
                    } else if (sEDNS.equalsIgnoreCase("on")) {
                        SipResolver.setEDNS(true);
                    }
                } else if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverService: sEDNS property is: null ");
                }
                sipResolver = SipResolver.createResolver(nameServers, containerProps, chfwb);
                Short sPayload = (Short)containerProps.get("dnsUdpPayloadSize");
                if (sPayload != null) {
                    if (512 <= sPayload && sPayload <= Short.MAX_VALUE) {
                        sipResolver.setUdpPayloadSize(sPayload);
                    } else if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverService: initialize: invalid SIP_RFC3263_udp_payload_size" + sPayload);
                    }
                }
                if ((sTimeout = containerProps.getProperty(SIP_RFC3263_TIMEOUT)) != null && sTimeout.length() > 0) {
                    block35: {
                        try {
                            long l = Long.parseLong(sTimeout);
                            if (l >= 10L) {
                                lookupCacheTimeout = l * 60L * 1000L;
                            }
                        }
                        catch (NumberFormatException e2) {
                            if (!c_logger.isTraceDebugEnabled()) break block35;
                            c_logger.traceDebug("SipResolverService: initialize: invalid SIP_RFC3263_TIMEOUT " + sTimeout);
                        }
                    }
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverService: initialize: SIP_RFC3263_TIMEOUT " + lookupCacheTimeout / 1000L);
                    }
                }
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("nameServers is empty");
                }
                if (c_logger.isInfoEnabled()) {
                    c_logger.info("info.sip.resolver.not.initialized");
                }
                initialized = false;
                return;
            }
            resolverTimer = new Timer();
            if (c_logger.isInfoEnabled()) {
                InetSocketAddress socket2;
                InetSocketAddress socket1 = nameServers.firstElement();
                c_logger.info("info.sip.resolver.initialized", null, socket1.getAddress().getHostAddress() + "@" + socket1.getPort());
                if (nameServers.size() > 1 && (socket2 = nameServers.elementAt(1)) != null) {
                    c_logger.info("info.sip.resolver.initialized", null, socket2.getAddress().getHostAddress() + "@" + socket2.getPort());
                }
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(SipResolverService.class, "SipResolverService: initialize: exit");
        }
    }

    private static Vector<InetSocketAddress> serverStringtoVector(String serverString) {
        Vector<InetSocketAddress> nameServers = new Vector<InetSocketAddress>();
        Pattern pattern = Pattern.compile("\\s+");
        String[] split = pattern.split(serverString);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverService: serverStringtoVector split.length" + split.length);
        }
        for (int i = 0; i < split.length; ++i) {
            int port;
            String host;
            block7: {
                String[] tuple = split[i].split("\\@");
                host = tuple[0];
                port = 53;
                if (tuple.length > 1) {
                    try {
                        port = Integer.parseInt(tuple[1]);
                    }
                    catch (NumberFormatException e2) {
                        if (!c_logger.isTraceDebugEnabled()) break block7;
                        c_logger.traceDebug("SipResolverService: serverStringtoVector " + e2);
                    }
                }
            }
            try {
                if (host == null || host == "") continue;
                nameServers.add(new InetSocketAddress(InetAddress.getByName(host), port));
                continue;
            }
            catch (UnknownHostException e3) {
                if (!c_logger.isTraceDebugEnabled()) continue;
                c_logger.traceDebug("SipResolverService: serverStringtoVector " + e3);
            }
        }
        return nameServers;
    }

    public static synchronized void shutdown() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(SipResolverService.class, "SipResolverService: shutdown: entry");
        }
        if (initialized) {
            initialized = false;
            resolverTimer.cancel();
            sipResolver.shutdown();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(SipResolverService.class, "SipResolverService: shutdown: exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SipURILookup getInstance(SipURILookupCallback sll, SIPUri suri) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(SipResolverService.class, "SipResolverService: getInstance: entry");
        }
        if (c_logger.isTraceDebugEnabled()) {
            if (suri != null) {
                c_logger.traceDebug("  suri.getTransport(): " + suri.getTransport());
                c_logger.traceDebug("  suri.getPortInt(): " + suri.getPortInt());
                c_logger.traceDebug("  suri.getMaddr(): " + suri.getMaddr());
                c_logger.traceDebug("  suri.getHost(): " + suri.getHost());
                c_logger.traceDebug("  suri.getScheme(): " + suri.getScheme());
            } else {
                c_logger.traceDebug("suri is null");
            }
        }
        if (initialized) {
            SipURILookup lookUp;
            if (++timerCounter > 5000) {
                Timer timer = resolverTimer;
                synchronized (timer) {
                    if (timerCounter > 10000) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("SipResolverService: Timer task purge " + timerCounter);
                        }
                        resolverTimer.purge();
                        timerCounter = 0;
                    }
                }
            }
            if ((lookUp = (SipURILookup)lookupCache.get(suri)) == null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverService: getInstance: new SipURILookupImpl for " + suri.getBaseSIPUri());
                }
                lookUp = new SipURILookupImpl(sll, suri, resolverTimer, lookupCache, lookupCacheTimeout);
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverService: getInstance: cached SipURILookupImpl for: " + lookUp.getSipURI().getHost() + ":" + lookUp.getSipURI().getPort());
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(SipResolverService.class, "SipResolverService: getInstance: exit");
            }
            return lookUp;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverService: getInstance: Illegal State: exit");
        }
        throw new IllegalStateException("SipResolverService not initialized.");
    }

    public static SipResolver getResolver() {
        if (sipResolver == null) {
            throw new IllegalStateException("Sip Resolver has not been created.");
        }
        return sipResolver;
    }

    static boolean isAddTTL() {
        return _addTTL;
    }
}

