/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.ParametersHeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import java.util.Arrays;

public class GenericParametersHeaderImpl
extends ParametersHeaderImpl {
    private static final long serialVersionUID = 3856825838155515719L;
    private final String m_name;
    private String m_value;
    private static final String[] NON_PARAMETERABLES = new String[]{"Call-ID", "CSeq"};

    public GenericParametersHeaderImpl(String name) {
        this(name, null);
    }

    public GenericParametersHeaderImpl(String name, String value) {
        this.m_name = name;
        this.m_value = value;
    }

    private static boolean isParameterable(String name) {
        int p = Arrays.binarySearch(NON_PARAMETERABLES, name);
        return p < 0;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        String name = this.getName();
        if (!GenericParametersHeaderImpl.isParameterable(name)) {
            throw new SipParseException("not parameterable [" + name + ']');
        }
        this.m_value = parser.nextToken(';');
        super.parseValue(parser);
    }

    @Override
    protected void encodeValue(CharsBuffer buffer) {
        String value = this.m_value;
        if (value != null) {
            buffer.append(value);
        }
        super.encodeValue(buffer);
    }

    @Override
    protected boolean escapeParameters() {
        return false;
    }

    public void assign(GenericParametersHeaderImpl source) {
        this.m_value = source.m_value;
        super.assign(source);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setFieldValue(String value) {
        this.m_value = value;
    }

    public String getFieldValue() {
        return this.m_value;
    }

    @Override
    protected char getListSeparator() {
        return ';';
    }

    @Override
    protected char getParamSeparator() {
        return ';';
    }

    @Override
    public boolean isNested() {
        return false;
    }

    static {
        Arrays.sort(NON_PARAMETERABLES);
    }
}

