/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.spi.expression.literal;

import jakarta.data.expression.ComparableExpression;
import jakarta.data.spi.expression.literal.ComparableLiteralRecord;
import jakarta.data.spi.expression.literal.Literal;
import jakarta.data.spi.expression.literal.NumericLiteral;
import jakarta.data.spi.expression.literal.StringLiteral;
import jakarta.data.spi.expression.literal.TemporalLiteral;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;

public interface ComparableLiteral<V extends Comparable<?>>
extends ComparableExpression<Object, V>,
Literal<V> {
    public static <V extends Comparable<?>> ComparableLiteral<V> of(V value) {
        if (value instanceof String) {
            String s = (String)((Object)value);
            return StringLiteral.of(s);
        }
        if (value instanceof Long) {
            Long n = (Long)value;
            return NumericLiteral.of(n);
        }
        if (value instanceof Integer) {
            Integer n = (Integer)value;
            return NumericLiteral.of(n);
        }
        if (value instanceof Double) {
            Double n = (Double)value;
            return NumericLiteral.of(n);
        }
        if (value instanceof Float) {
            Float n = (Float)value;
            return NumericLiteral.of(n);
        }
        if (value instanceof BigDecimal) {
            BigDecimal n = (BigDecimal)value;
            return NumericLiteral.of(n);
        }
        if (value instanceof BigInteger) {
            BigInteger n = (BigInteger)value;
            return NumericLiteral.of(n);
        }
        if (value instanceof Byte) {
            Byte n = (Byte)value;
            return NumericLiteral.of(n);
        }
        if (value instanceof Short) {
            Short n = (Short)value;
            return NumericLiteral.of(n);
        }
        if (value instanceof Year) {
            Year y = (Year)value;
            return TemporalLiteral.of(y);
        }
        if (value instanceof LocalDate) {
            LocalDate l = (LocalDate)value;
            return TemporalLiteral.of(l);
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime l = (LocalDateTime)value;
            return TemporalLiteral.of(l);
        }
        if (value instanceof LocalTime) {
            LocalTime l = (LocalTime)value;
            return TemporalLiteral.of(l);
        }
        if (value instanceof Instant) {
            Instant i = (Instant)value;
            return TemporalLiteral.of(i);
        }
        return new ComparableLiteralRecord(value);
    }
}

