/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.constraint;

import jakarta.data.constraint.Constraint;
import jakarta.data.constraint.LikeRecord;
import jakarta.data.expression.TextExpression;
import jakarta.data.messages.Messages;
import jakarta.data.spi.expression.literal.StringLiteral;

public interface Like
extends Constraint<String> {
    public char escape();

    public static Like literal(String value) {
        Messages.requireNonNull(value, "value");
        StringLiteral expression = StringLiteral.of(LikeRecord.escape(value));
        return new LikeRecord(expression, '\\');
    }

    public TextExpression<?> pattern();

    public static Like pattern(String pattern) {
        return Like.pattern(pattern, '_', '%');
    }

    public static Like pattern(String pattern, char charWildcard, char stringWildcard) {
        Messages.requireNonNull(pattern, "pattern");
        StringLiteral expression = StringLiteral.of(LikeRecord.translate(pattern, charWildcard, stringWildcard, '\\', false));
        return new LikeRecord(expression, '\\');
    }

    public static Like pattern(String pattern, char charWildcard, char stringWildcard, char escape) {
        Messages.requireNonNull(pattern, "pattern");
        StringLiteral expression = StringLiteral.of(LikeRecord.translate(pattern, charWildcard, stringWildcard, escape, true));
        return new LikeRecord(expression, escape);
    }

    public static Like pattern(TextExpression<?> pattern, char escape) {
        Messages.requireNonNull(pattern, "pattern");
        return new LikeRecord(pattern, escape);
    }

    public static Like prefix(String prefix) {
        Messages.requireNonNull(prefix, "prefix");
        StringLiteral expression = StringLiteral.of(LikeRecord.escape(prefix) + "%");
        return new LikeRecord(expression, '\\');
    }

    public static Like substring(String substring) {
        Messages.requireNonNull(substring, "substring");
        StringLiteral expression = StringLiteral.of("%" + LikeRecord.escape(substring) + "%");
        return new LikeRecord(expression, '\\');
    }

    public static Like suffix(String suffix) {
        Messages.requireNonNull(suffix, "suffix");
        StringLiteral expression = StringLiteral.of("%" + LikeRecord.escape(suffix));
        return new LikeRecord(expression, '\\');
    }
}

