/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import jakarta.persistence.PersistenceConfiguration;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.eclipse.persistence.logging.AbstractSessionLog;

public abstract class JPAInitializer {
    protected boolean shouldCreateInternalLoader = true;
    protected ClassLoader initializationClassloader = null;
    protected Map<String, SEPersistenceUnitInfo> initialPuInfos;
    protected Map<String, SEPersistenceUnitInfo> customPuInfos = new ConcurrentHashMap<String, SEPersistenceUnitInfo>();
    protected Map<String, EntityManagerSetupImpl> initialEmSetupImpls;
    protected static Map<ClassLoader, JPAInitializer> initializers = new Hashtable<ClassLoader, JPAInitializer>();

    protected JPAInitializer() {
    }

    public static void initializeTopLinkLoggingFile() {
        String loggingFile = PrivilegedAccessHelper.getSystemProperty("eclipselink.logging.file");
        try {
            if (loggingFile != null) {
                AbstractSessionLog.getLog().setWriter(new FileWriter(loggingFile));
            }
        }
        catch (IOException e) {
            AbstractSessionLog.getLog().log(6, "cmp_init_default_logging_file_is_invalid", loggingFile, (Object)e);
        }
    }

    public EntityManagerSetupImpl callPredeploy(SEPersistenceUnitInfo persistenceUnitInfo, Map m, String persistenceUnitUniqueName, String sessionName) {
        AbstractSessionLog.getLog().log(2, "jpa", "cmp_init_invoke_predeploy", (Object)persistenceUnitInfo.getPersistenceUnitName());
        Map<Object, Object> mergedProperties = EntityManagerFactoryProvider.mergeMaps(m, persistenceUnitInfo.getProperties());
        this.checkWeaving(mergedProperties);
        Set<String> tempLoaderSet = PersistenceUnitProcessor.buildClassSet(persistenceUnitInfo, m);
        ClassLoader tempLoader = this.createTempLoader(tempLoaderSet);
        persistenceUnitInfo.setNewTempClassLoader(tempLoader);
        EntityManagerSetupImpl emSetupImpl = new EntityManagerSetupImpl(persistenceUnitUniqueName, sessionName);
        ClassTransformer transformer = emSetupImpl.predeploy(persistenceUnitInfo, mergedProperties);
        persistenceUnitInfo.setNewTempClassLoader(persistenceUnitInfo.getClassLoader());
        this.registerTransformer(transformer, persistenceUnitInfo, m);
        return emSetupImpl;
    }

    public abstract void checkWeaving(Map var1);

    protected abstract ClassLoader createTempLoader(Collection var1);

    protected abstract ClassLoader createTempLoader(Collection var1, boolean var2);

    public SEPersistenceUnitInfo findPersistenceUnitInfo(String puName, Map<?, ?> m) {
        this.validateConfiguredPersistenceUnitName(puName);
        return this.findPersistenceUnitInfoImpl(puName, m);
    }

    private SEPersistenceUnitInfo findPersistenceUnitInfoImpl(String puName, Map<?, ?> m) {
        SEPersistenceUnitInfo persistenceUnitInfo = null;
        if (this.initialPuInfos != null) {
            persistenceUnitInfo = this.initialPuInfos.get(puName);
        }
        if (persistenceUnitInfo != null) {
            return persistenceUnitInfo;
        }
        persistenceUnitInfo = (SEPersistenceUnitInfo)m.get("eclipselink.se-puinfo");
        if (persistenceUnitInfo != null) {
            return persistenceUnitInfo;
        }
        return this.findPersistenceUnitInfoInArchives(puName, m);
    }

    public SEPersistenceUnitInfo customPersistenceUnitInfo(PersistenceConfiguration configuration, URL rootURL) {
        this.validateCustomPersistenceUnitName(configuration);
        SEPersistenceUnitInfo persistenceUnitInfo = this.customPuInfos.get(configuration.name());
        if (persistenceUnitInfo != null) {
            return persistenceUnitInfo;
        }
        persistenceUnitInfo = new SEPersistenceUnitInfo(configuration, rootURL);
        this.customPuInfos.put(configuration.name(), persistenceUnitInfo);
        return persistenceUnitInfo;
    }

    private void validateCustomPersistenceUnitName(PersistenceConfiguration configuration) {
        if (this.findPersistenceUnitInfoImpl(configuration.name(), Collections.emptyMap()) != null) {
            throw new PersistenceException(ExceptionLocalization.buildMessage("custom_pu_name_conflict", new String[]{configuration.name()}));
        }
    }

    private void validateConfiguredPersistenceUnitName(String puName) {
        if (this.customPuInfos.containsKey(puName)) {
            throw new PersistenceException(ExceptionLocalization.buildMessage("configured_pu_name_conflict", new String[]{puName}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SEPersistenceUnitInfo findPersistenceUnitInfoInArchives(String puName, Map<?, ?> m) {
        SEPersistenceUnitInfo persistenceUnitInfo = null;
        String descriptorPath = (String)m.get("eclipselink.persistencexml");
        Set<Archive> pars = descriptorPath != null ? PersistenceUnitProcessor.findPersistenceArchives(this.initializationClassloader, descriptorPath) : PersistenceUnitProcessor.findPersistenceArchives(this.initializationClassloader);
        try {
            for (Archive archive : pars) {
                persistenceUnitInfo = this.findPersistenceUnitInfoInArchive(puName, archive, m);
                if (persistenceUnitInfo == null) continue;
                break;
            }
        }
        finally {
            for (Archive archive : pars) {
                archive.close();
            }
        }
        return persistenceUnitInfo;
    }

    protected SEPersistenceUnitInfo findPersistenceUnitInfoInArchive(String puName, Archive archive, Map<?, ?> m) {
        for (SEPersistenceUnitInfo persistenceUnitInfo : PersistenceUnitProcessor.getPersistenceUnits(archive, this.initializationClassloader)) {
            if (!this.isPersistenceProviderSupported(persistenceUnitInfo.getPersistenceProviderClassName()) || !persistenceUnitInfo.getPersistenceUnitName().equals(puName)) continue;
            return persistenceUnitInfo;
        }
        return null;
    }

    public boolean isPersistenceProviderSupported(String providerClassName) {
        return providerClassName == null || providerClassName.isEmpty() || providerClassName.equals(EntityManagerFactoryProvider.class.getName()) || providerClassName.equals(PersistenceProvider.class.getName());
    }

    protected Set loadEntityClasses(Collection entityNames, ClassLoader classLoader) {
        HashSet entityClasses = new HashSet();
        AbstractSessionLog.getLog().log(2, "jpa", "cmp_loading_entities_using_loader", (Object)classLoader);
        for (String entityClassName : entityNames) {
            try {
                entityClasses.add(classLoader.loadClass(entityClassName));
            }
            catch (ClassNotFoundException cnfEx) {
                throw ValidationException.entityClassNotFound(entityClassName, classLoader, cnfEx);
            }
        }
        return entityClasses;
    }

    public abstract void registerTransformer(ClassTransformer var1, PersistenceUnitInfo var2, Map var3);

    public boolean isPersistenceUnitUniquelyDefinedByName() {
        return true;
    }

    public String createUniquePersistenceUnitName(PersistenceUnitInfo puInfo) {
        if (puInfo instanceof SEPersistenceUnitInfo) {
            SEPersistenceUnitInfo sePUInfo = (SEPersistenceUnitInfo)puInfo;
            return PersistenceUnitProcessor.buildPersistenceUnitName(sePUInfo.getPersistenceUnitRootUrl(), sePUInfo.getPersistenceUnitName(), sePUInfo.getConfigHash());
        }
        return PersistenceUnitProcessor.buildPersistenceUnitName(puInfo.getPersistenceUnitRootUrl(), puInfo.getPersistenceUnitName(), null);
    }

    public EntityManagerSetupImpl extractInitialEmSetupImpl(String puName) {
        if (this.initialEmSetupImpls != null) {
            return this.initialEmSetupImpls.remove(puName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Map m) {
        boolean keepInitialMaps = this.keepAllPredeployedPersistenceUnits();
        if (keepInitialMaps) {
            this.initialPuInfos = new HashMap<String, SEPersistenceUnitInfo>();
        }
        this.initialEmSetupImpls = new HashMap<String, EntityManagerSetupImpl>();
        String descriptorPath = (String)m.get("eclipselink.persistencexml");
        Set<Archive> pars = descriptorPath != null ? PersistenceUnitProcessor.findPersistenceArchives(this.initializationClassloader, descriptorPath) : PersistenceUnitProcessor.findPersistenceArchives(this.initializationClassloader);
        try {
            for (Archive archive : pars) {
                AbstractSessionLog.getLog().log(2, "jpa", "cmp_init_initialize", (Object)archive);
                this.initPersistenceUnits(archive, m);
            }
        }
        finally {
            for (Archive archive : pars) {
                archive.close();
            }
            this.initialEmSetupImpls = null;
        }
    }

    protected void initPersistenceUnits(Archive archive, Map m) {
        for (SEPersistenceUnitInfo persistenceUnitInfo : PersistenceUnitProcessor.getPersistenceUnits(archive, this.initializationClassloader)) {
            if (!this.isPersistenceProviderSupported(persistenceUnitInfo.getPersistenceProviderClassName())) continue;
            String puName = persistenceUnitInfo.getPersistenceUnitName();
            if (EntityManagerSetupImpl.mustBeCompositeMember(persistenceUnitInfo)) continue;
            EntityManagerSetupImpl anotherEmSetupImpl = null;
            if (this.initialEmSetupImpls != null) {
                anotherEmSetupImpl = this.initialEmSetupImpls.get(puName);
            }
            if (anotherEmSetupImpl != null) {
                EntityManagerSetupImpl.throwPersistenceUnitNameAlreadyInUseException(puName, persistenceUnitInfo, anotherEmSetupImpl.getPersistenceUnitInfo());
            }
            String sessionName = EntityManagerSetupImpl.getOrBuildSessionName(Collections.emptyMap(), persistenceUnitInfo, puName);
            EntityManagerSetupImpl emSetupImpl = this.callPredeploy(persistenceUnitInfo, m, puName, sessionName);
            if (this.initialEmSetupImpls != null) {
                this.initialEmSetupImpls.put(puName, emSetupImpl);
            }
            if (this.initialPuInfos == null) continue;
            this.initialPuInfos.put(puName, persistenceUnitInfo);
        }
    }

    protected boolean keepAllPredeployedPersistenceUnits() {
        return false;
    }

    public ClassLoader getInitializationClassLoader() {
        return this.initializationClassloader;
    }
}

