/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.persistence.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.persistence.InMemoryMappingFile;
import com.ibm.wsspi.persistence.internal.util.DoPrivHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PersistenceClassLoader
extends ClassLoader {
    final ClassLoader[] _delegates;
    private final Map<String, URL> _resourceMap;
    static final long serialVersionUID = 86483360639248139L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public PersistenceClassLoader(ClassLoader appLoader, ClassLoader ... delegates) {
        super(appLoader);
        this._delegates = delegates;
        this._resourceMap = new ConcurrentHashMap<String, URL>();
    }

    @Override
    public URL getResource(final String resourceName) {
        if (System.getSecurityManager() == null) {
            return this.getResourceInternal(resourceName);
        }
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){
            static final long serialVersionUID = 5519867259378862084L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public URL run() {
                return PersistenceClassLoader.this.getResourceInternal(resourceName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.persistence.internal.util.PersistenceClassLoader$1", 1.class, (String)"persistenceService", (String)"com.ibm.wsspi.persistence.internal.PersistenceServiceMessages");
            }
        });
    }

    private URL getResourceInternal(String resourceName) {
        URL res = super.getResource(resourceName);
        if (res == null) {
            for (ClassLoader del : this._delegates) {
                res = del.getResource(resourceName);
                if (res == null) continue;
                return res;
            }
            res = this._resourceMap.get(resourceName);
        }
        return res;
    }

    @Override
    public Enumeration<URL> getResources(String resourceName) throws IOException {
        ArrayList<URL> res = new ArrayList<URL>();
        res.addAll(Collections.list(super.getResources(resourceName)));
        for (ClassLoader del : this._delegates) {
            res.addAll(Collections.list(del.getResources(resourceName)));
        }
        URL url = this._resourceMap.get(resourceName);
        if (url != null) {
            res.add(url);
        }
        return Collections.enumeration(res);
    }

    /*
     * WARNING - void declaration
     */
    public void registerFileResource(String file) {
        try {
            this._resourceMap.put(file, new File(file).toURI().toURL());
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.persistence.internal.util.PersistenceClassLoader", (String)"102", (Object)this, (Object[])new Object[]{file});
            throw new RuntimeException((Throwable)e);
        }
    }

    public URL registerInMemoryResource(InMemoryMappingFile file) {
        URL url = DoPrivHelper.newInMemoryMappingFileURL(file);
        this._resourceMap.put(file.getName(), url);
        return url;
    }

    @Override
    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        ClassNotFoundException cnfe = null;
        for (ClassLoader del : this._delegates) {
            try {
                return del.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                cnfe = e;
            }
        }
        throw cnfe;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.persistence.internal.util.PersistenceClassLoader", PersistenceClassLoader.class, (String)"persistenceService", (String)"com.ibm.wsspi.persistence.internal.PersistenceServiceMessages");
    }
}

