/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security.internal;

import com.ibm.ws.security.token.ltpa.LTPAConfiguration;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.condition.Condition;

@Component(service={}, immediate=true)
public class LTPACondition
implements Condition {
    static final String LTPA_CONDITION_ID = "com.ibm.ws.security.token.ltpa.LTPAConfiguration";
    static final String LTPA_CONDITION_FILTER = "(osgi.condition.id=com.ibm.ws.security.token.ltpa.LTPAConfiguration)";
    private final AtomicReference<ServiceRegistration<Condition>> ltpaConditionReg = new AtomicReference();
    private final boolean waitForLTPAConfiguration;
    private final BundleContext context;
    private final CountDownLatch ltpaOnRestore = new CountDownLatch(1);

    @Activate
    public LTPACondition(BundleContext context) {
        this.context = context;
        boolean beforeCheckpoint = CheckpointPhase.getPhase().addMultiThreadedHook(Integer.MAX_VALUE, new CheckpointHook(){

            public void restore() {
                try {
                    LTPACondition.this.ltpaOnRestore.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        boolean bl = this.waitForLTPAConfiguration = !beforeCheckpoint;
        if (!this.waitForLTPAConfiguration) {
            this.ltpaConditionReg.set((ServiceRegistration<Condition>)context.registerService(Condition.class, (Object)this, FrameworkUtil.asDictionary(Collections.singletonMap("osgi.condition.id", LTPA_CONDITION_ID))));
        }
    }

    @Deactivate
    protected void deactivate() {
        this.unregisterLTPACondition();
    }

    private void unregisterLTPACondition() {
        ServiceRegistration reg = this.ltpaConditionReg.getAndSet(null);
        if (reg != null) {
            reg.unregister();
        }
    }

    @Reference(service=LTPAConfiguration.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    void setLTPAConfiguration(ServiceReference<LTPAConfiguration> ref) {
        if (this.waitForLTPAConfiguration) {
            this.ltpaConditionReg.set((ServiceRegistration<Condition>)this.context.registerService(Condition.class, (Object)this, FrameworkUtil.asDictionary(Collections.singletonMap("osgi.condition.id", LTPA_CONDITION_ID))));
        }
        this.ltpaOnRestore.countDown();
    }

    void unsetLTPAConfiguration(ServiceReference<LTPAConfiguration> ref) {
        if (this.waitForLTPAConfiguration) {
            this.unregisterLTPACondition();
        }
    }
}

