/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.iiop;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jndi.WSName;
import com.ibm.ws.jndi.iiop.ImmutableBitSet;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.omg.CosNaming.NameComponent;

public final class CosNameUtil
extends Enum<CosNameUtil> {
    private static final TraceComponent tc;
    private static final Pattern PERCENT_TRIPLET;
    private static final Pattern ILLEGAL_NAME;
    private static final ImmutableBitSet ESCAPE_NOT_NEEDED;
    private static final Pattern ALL_LEGAL_CHARS;
    private static final /* synthetic */ CosNameUtil[] $VALUES;

    public static CosNameUtil[] values() {
        return (CosNameUtil[])$VALUES.clone();
    }

    public static CosNameUtil valueOf(String name) {
        return Enum.valueOf(CosNameUtil.class, name);
    }

    public static String escapeCorbanameUrlIfNecessary(String url) {
        Matcher matcher;
        String methodName = "escapeCorbanameUrlIfNecessary(): ";
        if (null == url || !url.startsWith("corbaname:") || url.contains("\\")) {
            return url;
        }
        String[] twoParts = url.split("#", 2);
        if (twoParts.length < 2) {
            return url;
        }
        String stringifiedName = twoParts[1];
        if (stringifiedName.isEmpty()) {
            return url;
        }
        if (PERCENT_TRIPLET.matcher(stringifiedName).find()) {
            return url;
        }
        if (ALL_LEGAL_CHARS.matcher(stringifiedName).matches() && !(matcher = ILLEGAL_NAME.matcher(stringifiedName)).find()) {
            return url;
        }
        String sn = stringifiedName.replace("\\", "\\\\").replace(".", "\\.");
        StringBuilder escaped = new StringBuilder(twoParts[0]).append("#");
        for (byte b : sn.getBytes(StandardCharsets.UTF_8)) {
            if (ESCAPE_NOT_NEEDED.get(b)) {
                escaped.append((char)b);
                continue;
            }
            escaped.append(String.format("%%%02x", 0xFF & b));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("escapeCorbanameUrlIfNecessary(): escaped original url " + url + " to " + escaped), (Object[])new Object[0]);
        }
        return escaped.toString();
    }

    static NameComponent[] cosify(WSName name) {
        NameComponent[] cosName = new NameComponent[name.size()];
        for (int i = 0; i < cosName.length; ++i) {
            cosName[i] = new NameComponent(name.get(i), "");
        }
        return cosName;
    }

    @FFDCIgnore(value={InvalidNameException.class})
    static <T extends NamingException> T detailed(T toThrow, Exception initCause, NameComponent ... nameRemainder) {
        toThrow.initCause(initCause);
        if (nameRemainder != null && nameRemainder.length > 0) {
            try {
                toThrow.setRemainingName(CosNameUtil.compose(nameRemainder));
            }
            catch (InvalidNameException e) {
                toThrow.addSuppressed(e);
            }
        }
        return toThrow;
    }

    private static CompositeName compose(NameComponent ... nameRemainder) throws InvalidNameException {
        WSName wsName = new WSName();
        for (NameComponent nc : nameRemainder) {
            wsName = wsName.plus(nc.id);
        }
        CompositeName cName = new CompositeName();
        cName.add(wsName.toString());
        return cName;
    }

    private static /* synthetic */ CosNameUtil[] $values() {
        return new CosNameUtil[0];
    }

    static {
        $VALUES = CosNameUtil.$values();
        tc = Tr.register(CosNameUtil.class);
        PERCENT_TRIPLET = Pattern.compile("%(?:[0-9a-f]{2}|[0-9A-F]{2})");
        ILLEGAL_NAME = Pattern.compile("(?:[^/]\\./|\\.[^/]*\\.|([^/]\\.$))");
        String unescapedChars = "-;/:?@&=+$,_.!~*\u2019()0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        BitSet escapeNotNeeded = new BitSet();
        for (char c : "-;/:?@&=+$,_.!~*\u2019()0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray()) {
            escapeNotNeeded.set(c);
        }
        ESCAPE_NOT_NEEDED = new ImmutableBitSet(escapeNotNeeded);
        ALL_LEGAL_CHARS = Pattern.compile("[-;/:?@&=+$,_.!~*\u2019()0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ]*");
    }
}

