/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.setup.config.PropertySingleValueConfiguration;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TimerBucketMinConfiguration
extends PropertySingleValueConfiguration<Duration> {
    private static final TraceComponent tc = Tr.register(TimerBucketMinConfiguration.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = -8566042606146426500L;

    public TimerBucketMinConfiguration(String metricName, Duration value) {
        super(metricName, value);
    }

    public static Collection<TimerBucketMinConfiguration> parse(String input) {
        String[] metricValuePairs;
        ArrayDeque<TimerBucketMinConfiguration> sloMinConfigCollection = new ArrayDeque<TimerBucketMinConfiguration>();
        if (input == null || input.length() == 0) {
            return null;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String val;
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            TimerBucketMinConfiguration sloMinConfiguration = null;
            Duration dur = null;
            if (keyValueSplit.length != 2) continue;
            String s = keyValueSplit[1];
            if (s.matches("[0-9]+ms")) {
                val = s.substring(0, s.length() - 2);
                dur = Duration.ofMillis(Long.parseLong(val));
            } else if (s.matches("[0-9]+s")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofSeconds(Long.parseLong(val));
            } else if (s.matches("[0-9]+m")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofMinutes(Long.parseLong(val));
            } else if (s.matches("[0-9]+h")) {
                val = s.substring(0, s.length() - 1);
                dur = Duration.ofHours(Long.parseLong(val));
            } else if (s.matches("[0-9]+")) {
                dur = Duration.ofMillis(Long.parseLong(s));
            } else {
                Tr.warning((TraceComponent)tc, (String)"invalidTimerValueConfigured.warning.CWMMC0016W", (Object[])new Object[]{s, "mp.metrics.distribution.timer.buckets"});
            }
            if (dur == null) continue;
            sloMinConfiguration = new TimerBucketMinConfiguration(metricName, dur);
            sloMinConfigCollection.addFirst(sloMinConfiguration);
        }
        return sloMinConfigCollection;
    }
}

