/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.cdi;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.data.internal.persistence.DataProvider;
import io.openliberty.data.internal.persistence.EntityManagerBuilder;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.RepositoryImpl;
import io.openliberty.data.internal.persistence.Util;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import io.openliberty.data.internal.persistence.cdi.FutureEMBuilder;
import io.openliberty.data.internal.version.DataVersionCompatibility;
import jakarta.data.exceptions.DataException;
import jakarta.data.repository.Repository;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InterceptionFactory;
import jakarta.enterprise.inject.spi.Producer;
import jakarta.enterprise.inject.spi.ProducerFactory;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RepositoryProducer<R>
implements Producer<R>,
ProducerFactory<R>,
BeanAttributes<R> {
    private static final TraceComponent tc = Tr.register(RepositoryProducer.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private static final long INIT_TIMEOUT_SEC = TimeUnit.MINUTES.toSeconds(5L);
    private static final Set<Annotation> QUALIFIERS = Set.of(Any.Literal.INSTANCE, Default.Literal.INSTANCE);
    private final BeanManager beanMgr;
    private final Set<Type> beanTypes;
    private FutureEMBuilder futureEMBuilder;
    private final DataExtension extension;
    private final Map<R, R> intercepted = new ConcurrentHashMap<R, R>();
    private Class<?> primaryEntityClass;
    private final DataProvider provider;
    final Map<Class<?>, List<QueryInfo>> queriesPerEntityClass;
    private final AtomicReference<RepositoryImpl<?>> repositoryImplRef = new AtomicReference();
    private final Class<?> repositoryInterface;
    private boolean stateful = false;
    static final long serialVersionUID = -2799367813433206614L;

    RepositoryProducer(Class<?> repositoryInterface, BeanManager beanMgr, DataProvider provider, DataExtension extension, Map<Class<?>, List<QueryInfo>> queriesPerEntityClass) {
        this.beanMgr = beanMgr;
        this.beanTypes = Set.of(repositoryInterface);
        this.extension = extension;
        this.provider = provider;
        this.queriesPerEntityClass = queriesPerEntityClass;
        this.repositoryInterface = repositoryInterface;
    }

    @Trivial
    public <T> Producer<T> createProducer(Bean<T> bean) {
        return this;
    }

    public void dispose(R repository) {
        R r = this.intercepted.remove(repository);
        if (r != null) {
            repository = r;
        }
        RepositoryImpl handler = (RepositoryImpl)Proxy.getInvocationHandler(repository);
        this.repositoryImplRef.compareAndSet(handler, null);
        handler.beanDisposed();
    }

    @Trivial
    private DataException excTimedOut(Class<?> repositoryInterface, Throwable cause) {
        DataException x;
        if (CheckpointPhase.getPhase().restored()) {
            x = DataExtension.exc(DataException.class, "CWWKD1106.init.timed.out", repositoryInterface.getName(), this.futureEMBuilder.dataStore, this.futureEMBuilder.jeeName, INIT_TIMEOUT_SEC);
        } else {
            ComponentMetaData metadata = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            J2EEName jeeName = metadata == null ? this.futureEMBuilder.jeeName : metadata.getJ2EEName();
            x = DataExtension.exc(DataException.class, "CWWKD1107.init.timed.out.checkpoint", jeeName, repositoryInterface.getName());
        }
        x.initCause(cause);
        return x;
    }

    @Trivial
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Trivial
    public String getName() {
        return null;
    }

    @Trivial
    public Set<Annotation> getQualifiers() {
        return QUALIFIERS;
    }

    @Trivial
    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    @Trivial
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Trivial
    public Set<Type> getTypes() {
        return this.beanTypes;
    }

    @Trivial
    public List<QueryInfo> introspect(PrintWriter writer, String indent, List<RepositoryImpl<?>> repositoryImpls) {
        RepositoryImpl<?> repositoryImpl = this.repositoryImplRef.get();
        if (repositoryImpl != null) {
            repositoryImpls.add(repositoryImpl);
        }
        ArrayList<QueryInfo> queryInfos = new ArrayList<QueryInfo>();
        writer.println(indent + "RepositoryProducer@" + Integer.toHexString(this.hashCode()));
        writer.println(indent + "  repository: " + this.repositoryInterface.getName());
        writer.println(indent + "  stateful? " + this.stateful);
        writer.println(indent + "  primary entity: " + (this.primaryEntityClass == null ? null : this.primaryEntityClass.getName()));
        writer.println(indent + "  intercepted: " + String.valueOf(this.intercepted));
        writer.println();
        writer.println(Util.toString(this.repositoryInterface, indent + "  "));
        this.queriesPerEntityClass.forEach((entityClass, queries) -> {
            writer.println();
            if (QueryInfo.ENTITY_TBD.equals(entityClass)) {
                writer.println(indent + "  Queries for entity to be determined:");
            } else {
                writer.println(indent + "  Queries for entity " + entityClass.getName() + ":");
            }
            TreeMap<String, QueryInfo> sorted = new TreeMap<String, QueryInfo>();
            for (QueryInfo qi : queries) {
                sorted.put(qi.method.toString(), qi);
            }
            for (QueryInfo qi : sorted.values()) {
                writer.println(indent + "    " + qi.toString().replace('\r', ' ').replace('\n', ' '));
            }
            queryInfos.addAll((Collection<QueryInfo>)queries);
        });
        writer.println();
        if (this.futureEMBuilder != null) {
            this.futureEMBuilder.introspect(writer, "  " + indent);
        }
        return queryInfos;
    }

    @Trivial
    public boolean isAlternative() {
        return false;
    }

    @Trivial
    @ManualTrace
    @FFDCIgnore(value={Throwable.class})
    public R produce(CreationalContext<R> cc) {
        Class<?> repositoryInterface = this.repositoryInterface;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"produce", (Object[])new Object[]{cc, repositoryInterface.getName()});
        }
        try {
            InterceptionFactory interception = this.beanMgr.createInterceptionFactory(cc, repositoryInterface);
            boolean intercept = false;
            AnnotatedTypeConfigurator configurator = interception.configure();
            for (Annotation anno : configurator.getAnnotated().getAnnotations()) {
                if (!this.beanMgr.isInterceptorBinding(anno.annotationType())) continue;
                intercept = true;
                configurator.add(anno);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("add " + String.valueOf(anno) + " for " + String.valueOf(configurator.getAnnotated().getJavaClass())), (Object[])new Object[0]);
            }
            for (AnnotatedMethodConfigurator method : configurator.methods()) {
                for (Annotation anno : method.getAnnotated().getAnnotations()) {
                    if (!this.beanMgr.isInterceptorBinding(anno.annotationType())) continue;
                    intercept = true;
                    method.add(anno);
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("add " + String.valueOf(anno) + " for " + String.valueOf(method.getAnnotated().getJavaMember())), (Object[])new Object[0]);
                }
            }
            EntityManagerBuilder builder = (EntityManagerBuilder)this.futureEMBuilder.get(INIT_TIMEOUT_SEC, TimeUnit.SECONDS);
            RepositoryImpl handler = new RepositoryImpl(this.provider, this.extension, builder, repositoryInterface, this.primaryEntityClass, this.queriesPerEntityClass);
            Object instance = repositoryInterface.cast(Proxy.newProxyInstance(repositoryInterface.getClassLoader(), new Class[]{repositoryInterface}, handler));
            if (intercept) {
                Object r = interception.createInterceptedInstance(instance);
                this.intercepted.put(r, instance);
                instance = r;
            }
            this.repositoryImplRef.set(handler);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"produce", (Object)instance.toString());
            }
            return (R)instance;
        }
        catch (Throwable x) {
            if (!(x instanceof DataException) && !(x.getCause() instanceof DataException)) {
                Tr.error((TraceComponent)tc, (String)"CWWKD1095.repo.err", (Object[])new Object[]{repositoryInterface.getName(), repositoryInterface.getAnnotation(Repository.class), this.primaryEntityClass == null ? null : this.primaryEntityClass.getName(), x});
            }
            if (x instanceof TimeoutException) {
                DataException dx = this.excTimedOut(repositoryInterface, x);
                if (trace && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"produce", DataException.class);
                }
                throw dx;
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"produce", (Object)x);
            }
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            if (x instanceof Error) {
                throw (Error)x;
            }
            if (x instanceof ExecutionException) {
                throw this.toRuntimeException((ExecutionException)x);
            }
            throw new DataException(x);
        }
    }

    @Trivial
    public DataVersionCompatibility compat() {
        return this.provider.compat;
    }

    @Trivial
    void setFutureEMBuilder(FutureEMBuilder futureEMBuilder) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setFutureEMBuilder", (Object[])new Object[]{futureEMBuilder});
        }
        this.futureEMBuilder = futureEMBuilder;
    }

    @Trivial
    void setPrimaryEntityClass(Class<?> primaryEntityClass) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setPrimaryEntityClass", (Object[])new Object[]{primaryEntityClass});
        }
        this.primaryEntityClass = primaryEntityClass;
    }

    @Trivial
    void setStateful() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setStateful", (Object[])new Object[0]);
        }
        this.stateful = true;
    }

    @Trivial
    public final boolean stateful() {
        return this.stateful;
    }

    @Trivial
    @FFDCIgnore(value={Throwable.class})
    private RuntimeException toRuntimeException(ExecutionException xx) {
        Throwable cause;
        Throwable x;
        block4: {
            x = null;
            cause = xx.getCause();
            if (cause instanceof RuntimeException) {
                try {
                    Class<?> cl = cause.getClass();
                    Constructor<?> cons = cl.getConstructor(String.class, Throwable.class);
                    x = (RuntimeException)cons.newInstance(cause.getMessage(), cause);
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("no matching constructor for " + String.valueOf(cause.getClass())), (Object[])new Object[0]);
                }
            }
        }
        if (x == null) {
            x = new DataException(cause.getMessage(), cause);
        }
        x.setStackTrace(xx.getStackTrace());
        return x;
    }
}

