/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.framework;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.JMXThreadFactory;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.codec.PropertyData;
import org.apache.aries.jmx.codec.ServiceData;
import org.apache.aries.jmx.codec.ServiceEventData;
import org.apache.aries.jmx.framework.StateConfig;
import org.apache.aries.jmx.util.FrameworkUtils;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.JmxConstants;
import org.osgi.jmx.framework.ServiceStateMBean;

public class ServiceState
extends NotificationBroadcasterSupport
implements ServiceStateMBean,
MBeanRegistration {
    protected Logger logger;
    private BundleContext bundleContext;
    private StateConfig stateConfig;
    protected ExecutorService eventDispatcher;
    protected AllServiceListener serviceListener;
    private AtomicInteger notificationSequenceNumber = new AtomicInteger(1);
    private AtomicInteger attributeChangeNotificationSequenceNumber = new AtomicInteger(1);
    private AtomicInteger registrations = new AtomicInteger(0);
    private Lock lock = new ReentrantLock();
    public static String SERVICE_EVENT = "org.osgi.service.event";

    public ServiceState(BundleContext bundleContext, StateConfig stateConfig, Logger logger) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Argument bundleContext cannot be null");
        }
        this.bundleContext = bundleContext;
        this.stateConfig = stateConfig;
        this.logger = logger;
    }

    public long getBundleIdentifier(long serviceId) throws IOException {
        ServiceReference reference = FrameworkUtils.resolveService(this.bundleContext, serviceId);
        return reference.getBundle().getBundleId();
    }

    public String[] getObjectClass(long serviceId) throws IOException {
        ServiceReference reference = FrameworkUtils.resolveService(this.bundleContext, serviceId);
        return (String[])reference.getProperty("objectClass");
    }

    public TabularData getProperties(long serviceId) throws IOException {
        ServiceReference reference = FrameworkUtils.resolveService(this.bundleContext, serviceId);
        TabularDataSupport propertiesTable = new TabularDataSupport(JmxConstants.PROPERTIES_TYPE);
        for (String propertyKey : reference.getPropertyKeys()) {
            propertiesTable.put(PropertyData.newInstance(propertyKey, reference.getProperty(propertyKey)).toCompositeData());
        }
        return propertiesTable;
    }

    public CompositeData getProperty(long serviceId, String key) throws IOException {
        ServiceReference reference = FrameworkUtils.resolveService(this.bundleContext, serviceId);
        return PropertyData.newInstance(key, reference.getProperty(key)).toCompositeData();
    }

    public long[] getUsingBundles(long serviceId) throws IOException {
        ServiceReference reference = FrameworkUtils.resolveService(this.bundleContext, serviceId);
        Bundle[] usingBundles = reference.getUsingBundles();
        return FrameworkUtils.getBundleIds(usingBundles);
    }

    public CompositeData getService(long serviceId) throws IOException {
        return new ServiceData(FrameworkUtils.resolveService(this.bundleContext, serviceId)).toCompositeData();
    }

    public TabularData listServices() throws IOException {
        return this.listServices(null, null);
    }

    public TabularData listServices(String clazz, String filter) throws IOException {
        return this.listServices(clazz, filter, ServiceStateMBean.SERVICE_TYPE.keySet());
    }

    public TabularData listServices(String clazz, String filter, String ... serviceTypeItems) throws IOException {
        return this.listServices(clazz, filter, Arrays.asList(serviceTypeItems));
    }

    private TabularData listServices(String clazz, String filter, Collection<String> serviceTypeItems) throws IOException {
        TabularDataSupport servicesTable = new TabularDataSupport(SERVICES_TYPE);
        ServiceReference[] allServiceReferences = null;
        try {
            allServiceReferences = this.bundleContext.getAllServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Failed to retrieve all service references", e);
        }
        if (allServiceReferences != null) {
            for (ServiceReference reference : allServiceReferences) {
                servicesTable.put(new ServiceData(reference).toCompositeData(serviceTypeItems));
            }
        }
        return servicesTable;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo eventInfo = new MBeanNotificationInfo(new String[]{SERVICE_EVENT}, Notification.class.getName(), "A ServiceEvent issued from the Framework describing a service lifecycle change");
        MBeanNotificationInfo attributeChangeInfo = new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "An attribute of this MBean has changed");
        return new MBeanNotificationInfo[]{eventInfo, attributeChangeInfo};
    }

    public long[] getServiceIds() throws IOException {
        try {
            ServiceReference[] refs = this.bundleContext.getAllServiceReferences(null, null);
            long[] ids = new long[refs.length];
            for (int i = 0; i < refs.length; ++i) {
                long id;
                ServiceReference ref = refs[i];
                ids[i] = id = ((Long)ref.getProperty("service.id")).longValue();
            }
            Arrays.sort(ids);
            return ids;
        }
        catch (InvalidSyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public void postDeregister() {
        if (this.registrations.decrementAndGet() < 1) {
            this.shutDownDispatcher();
        }
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue() && this.registrations.incrementAndGet() == 1) {
            this.eventDispatcher = Executors.newSingleThreadExecutor(new JMXThreadFactory("JMX OSGi Service State Event Dispatcher"));
            this.bundleContext.addServiceListener((ServiceListener)this.serviceListener);
        }
    }

    @Override
    public void preDeregister() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.lock.lock();
        try {
            if (this.serviceListener == null) {
                this.serviceListener = new AllServiceListener(){

                    public void serviceChanged(ServiceEvent serviceevent) {
                        try {
                            final Notification notification = new Notification("ServiceEvent", "osgi.core:type=serviceState,version=1.7", ServiceState.this.notificationSequenceNumber.getAndIncrement());
                            notification.setUserData(new ServiceEventData(serviceevent).toCompositeData());
                            final AttributeChangeNotification attributeChangeNotification = ServiceState.this.getAttributeChangeNotification(serviceevent);
                            ServiceState.this.eventDispatcher.submit(new Runnable(){

                                @Override
                                public void run() {
                                    ServiceState.this.sendNotification(notification);
                                    if (attributeChangeNotification != null) {
                                        ServiceState.this.sendNotification(attributeChangeNotification);
                                    }
                                }
                            });
                        }
                        catch (RejectedExecutionException re) {
                            ServiceState.this.logger.log(2, "Task rejected for JMX Notification dispatch of event [" + serviceevent + "] - Dispatcher may have been shutdown");
                        }
                        catch (Exception e) {
                            ServiceState.this.logger.log(2, "Exception occured on JMX Notification dispatch for event [" + serviceevent + "]", e);
                        }
                    }
                };
            }
        }
        finally {
            this.lock.unlock();
        }
        return name;
    }

    protected AttributeChangeNotification getAttributeChangeNotification(ServiceEvent serviceevent) throws IOException {
        if (this.stateConfig != null && !this.stateConfig.isAttributeChangeNotificationEnabled()) {
            return null;
        }
        int eventType = serviceevent.getType();
        switch (eventType) {
            case 1: 
            case 4: {
                long serviceID = (Long)serviceevent.getServiceReference().getProperty("service.id");
                long[] ids = this.getServiceIds();
                ArrayList<Long> without = new ArrayList<Long>(ids.length);
                for (long id : ids) {
                    if (id == serviceID) continue;
                    without.add(id);
                }
                ArrayList<Long> with = new ArrayList<Long>(without);
                with.add(serviceID);
                Collections.sort(with);
                ArrayList<Long> oldList = eventType == 1 ? without : with;
                ArrayList<Long> newList = eventType == 1 ? with : without;
                long[] oldIDs = new long[oldList.size()];
                for (int i = 0; i < oldIDs.length; ++i) {
                    oldIDs[i] = (Long)oldList.get(i);
                }
                long[] newIDs = new long[newList.size()];
                for (int i = 0; i < newIDs.length; ++i) {
                    newIDs[i] = (Long)newList.get(i);
                }
                return new AttributeChangeNotification("osgi.core:type=serviceState,version=1.7", this.attributeChangeNotificationSequenceNumber.getAndIncrement(), System.currentTimeMillis(), "ServiceIds changed", "ServiceIds", "Array of long", oldIDs, newIDs);
            }
        }
        return null;
    }

    protected void shutDownDispatcher() {
        if (this.serviceListener != null) {
            try {
                this.bundleContext.removeServiceListener((ServiceListener)this.serviceListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.shutdown();
        }
    }

    protected ExecutorService getEventDispatcher() {
        return this.eventDispatcher;
    }
}

