/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.client.rest.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class Activator {
    private static final String PKGS_KEY = "jmx.remote.protocol.provider.pkgs";
    private static final String PKGS = "com.ibm.ws.jmx.connector.client";
    private static final Pattern P = Pattern.compile("(?:\\A|,)com.ibm.ws.jmx.connector.client(?:\\z|,)");

    @Activate
    protected void activate() {
        String jmx = System.getProperty(PKGS_KEY);
        System.setProperty(PKGS_KEY, Activator.add(jmx));
    }

    @Deactivate
    protected void deactivate() {
        String jmx = System.getProperty(PKGS_KEY);
        if (PKGS.equals(jmx)) {
            System.clearProperty(PKGS_KEY);
        } else {
            System.setProperty(PKGS_KEY, Activator.remove(jmx));
        }
    }

    static String add(String jmx) {
        if (jmx == null) {
            return PKGS;
        }
        return jmx + "," + PKGS;
    }

    static String remove(String jmx) {
        Matcher m = P.matcher(jmx);
        return m.replaceAll("");
    }
}

