/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.util.Utils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.LeaseInfo;
import com.ibm.ws.recoverylog.spi.LeaseLogImpl;
import com.ibm.ws.recoverylog.spi.PeerLeaseData;
import com.ibm.ws.recoverylog.spi.PeerLeaseTable;
import com.ibm.ws.recoverylog.spi.SharedServerLeaseLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.time.Instant;
import java.util.stream.Stream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FileSharedServerLeaseLog
extends LeaseLogImpl
implements SharedServerLeaseLog {
    Path _tranRecoveryLogDirStem;
    String _localRecoveryIdentity;
    Path _leaseLogDirectory;
    String _recoveryGroup;
    Path _serverInstallLeaseLogDir;
    boolean leaseLogWrittenInThisRun;
    Path _controlFile;
    Path _localLeasePath;
    private Path _localLeaseLockPath;
    private int _leaseTimeout;
    private static final String LOCK_SUFFIX = ".lock";
    private FileLock _peerLeaseLock;
    private FileLock _localLeaseLock;
    private FileChannel _localLeaseLockChannel;
    private static FileSharedServerLeaseLog _instance;
    private static final TraceComponent tc;
    static final long serialVersionUID = 2103907337563199342L;

    @ManualTrace
    @FFDCIgnore(value={IOException.class})
    public static FileSharedServerLeaseLog getFileSharedServerLeaseLog(Path logDirStem, String localRecoveryIdentity, String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFileSharedServerLeaseLog", (Object[])new Object[]{logDirStem, localRecoveryIdentity, recoveryGroup});
        }
        if (_instance == null) {
            try {
                _instance = new FileSharedServerLeaseLog(logDirStem, localRecoveryIdentity, recoveryGroup);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFileSharedServerLeaseLog", (Object)_instance);
        }
        return _instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ManualTrace
    private FileSharedServerLeaseLog(Path logDirStem, String localRecoveryIdentity, String recoveryGroup) throws IOException {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"FileSharedServerLeaseLog", (Object[])new Object[]{logDirStem, localRecoveryIdentity, recoveryGroup});
            }
            if (recoveryGroup == null) {
                recoveryGroup = "defaultGroup";
            }
            this._recoveryGroup = recoveryGroup;
            this._localRecoveryIdentity = localRecoveryIdentity;
            Path leasesDir = logDirStem.getParent();
            ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
            Path wlpUserDir = Paths.get(cp.getUserDir(), new String[0]);
            Path serverOutputDir = wlpUserDir.resolve(Paths.get("servers", cp.getServerName()));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"leasesDirCanonicalPath: {0}\nserverOutputDir: {1}\nwlpUserDir: {2}", (Object[])new Object[]{leasesDir, serverOutputDir, wlpUserDir});
            }
            this._serverInstallLeaseLogDir = leasesDir.equals(serverOutputDir) || localRecoveryIdentity == null || localRecoveryIdentity.trim().isEmpty() ? wlpUserDir.resolve(Paths.get("shared", "leases", recoveryGroup)) : leasesDir.resolve(Paths.get("leases", recoveryGroup));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("_serverInstallLeaseLogDir: " + this._serverInstallLeaseLogDir.toString()), (Object[])new Object[0]);
            }
            this._tranRecoveryLogDirStem = logDirStem;
            if (this._leaseLogDirectory == null) {
                this._leaseLogDirectory = this._serverInstallLeaseLogDir;
                AccessController.doPrivileged(new PrivilegedAction<Void>(){
                    static final long serialVersionUID = 8544355332675373508L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Void run() {
                        try {
                            if (!Files.isDirectory(FileSharedServerLeaseLog.this._leaseLogDirectory, new LinkOption[0])) {
                                Files.createDirectories(FileSharedServerLeaseLog.this._leaseLogDirectory, new FileAttribute[0]);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Created: {0}", (Object[])new Object[]{FileSharedServerLeaseLog.this._leaseLogDirectory});
                                }
                            }
                            FileSharedServerLeaseLog.this._controlFile = FileSystems.getDefault().getPath(FileSharedServerLeaseLog.this._serverInstallLeaseLogDir.toString(), "control");
                            if (!Files.exists(FileSharedServerLeaseLog.this._controlFile, new LinkOption[0])) {
                                Files.createFile(FileSharedServerLeaseLog.this._controlFile, new FileAttribute[0]);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Created: {0}", (Object[])new Object[]{FileSharedServerLeaseLog.this._controlFile});
                                }
                            }
                        }
                        catch (IOException iOException) {
                            void e;
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$1", (String)"197", (Object)this, (Object[])new Object[0]);
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog.setLeaseLog", (String)"191");
                        }
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$1", 1.class, null, null);
                    }
                });
            }
            this._localLeasePath = this._serverInstallLeaseLogDir.resolve(localRecoveryIdentity);
            this._localLeaseLockPath = this._serverInstallLeaseLogDir.resolve(localRecoveryIdentity + LOCK_SUFFIX);
            this._localLeaseLockChannel = FileChannel.open(this._localLeaseLockPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
            this._localLeaseLock = this._localLeaseLockChannel.tryLock();
            if (this._localLeaseLock == null) {
                if (!tc.isEntryEnabled()) throw new IOException();
                Tr.exit((TraceComponent)tc, (String)"FileSharedServerLeaseLog", (Object)"Could not lock local lease");
                throw new IOException();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Locked local lease {0} {1}", (Object[])new Object[]{this._localLeaseLockPath, this._localLeaseLock});
            }
            FileChannel localLeaseChannel = FileChannel.open(this._localLeasePath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
            try {
                String line;
                ByteBuffer byteBuffer = null;
                if (tc.isDebugEnabled()) {
                    byteBuffer = ByteBuffer.allocate((int)localLeaseChannel.size());
                    localLeaseChannel.position(0L);
                    localLeaseChannel.read(byteBuffer);
                    byteBuffer.flip();
                    line = new String(byteBuffer.array());
                    Tr.debug((TraceComponent)tc, (String)"Originally {0} lease file length {1} contains {2}", (Object[])new Object[]{this._localRecoveryIdentity, line.length(), line});
                }
                byteBuffer = ByteBuffer.wrap(this._tranRecoveryLogDirStem.toString().getBytes());
                localLeaseChannel.position(0L);
                localLeaseChannel.write(byteBuffer);
                byteBuffer = ByteBuffer.wrap(("\n" + this.getBackendURL()).getBytes());
                localLeaseChannel.write(byteBuffer);
                localLeaseChannel.force(false);
                if (tc.isDebugEnabled()) {
                    byteBuffer = ByteBuffer.allocate((int)localLeaseChannel.size());
                    localLeaseChannel.position(0L);
                    localLeaseChannel.read(byteBuffer);
                    byteBuffer.flip();
                    line = new String(byteBuffer.array());
                    Tr.debug((TraceComponent)tc, (String)"On writing {0} lease file length {1} contains {2}", (Object[])new Object[]{this._localRecoveryIdentity, line.length(), line});
                }
                if (localLeaseChannel == null) break block13;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"221", (Object)this, (Object[])new Object[]{logDirStem, localRecoveryIdentity, recoveryGroup});
                if (localLeaseChannel == null) throw throwable;
                try {
                    localLeaseChannel.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"221", (Object)this, (Object[])new Object[]{logDirStem, localRecoveryIdentity, recoveryGroup});
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            localLeaseChannel.close();
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"FileSharedServerLeaseLog", (Object)new Object[]{this._localLeasePath, this._localLeaseLockChannel});
    }

    @Override
    @ManualTrace
    public void updateServerLease(String recoveryIdentity, String recoveryGroup, boolean isServerStartup) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateServerLease", (Object[])new Object[]{recoveryIdentity, recoveryGroup, isServerStartup, this._tranRecoveryLogDirStem, this});
        }
        Files.setLastModifiedTime(this._localLeasePath, FileTime.from(Instant.now()));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateServerLease", (Object)this._localLeaseLock);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @ManualTrace
    @FFDCIgnore(value={FileNotFoundException.class, FileSystemException.class, NoSuchFileException.class, Throwable.class})
    public void deleteServerLease(String recoveryIdentity, boolean isPeerServer) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @ManualTrace
    @FFDCIgnore(value={PrivilegedActionException.class})
    public boolean claimPeerLeaseForRecovery(String recoveryIdentityToRecover, String myRecoveryIdentity, LeaseInfo leaseInfo) throws Exception {
        boolean claimedLease;
        block23: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, this});
            }
            claimedLease = false;
            try {
                FileTime newleaseTime;
                Path leaseFile;
                block22: {
                    PeerLeaseData pld;
                    boolean attemptClaim = true;
                    leaseFile = this._serverInstallLeaseLogDir.resolve(recoveryIdentityToRecover);
                    newleaseTime = AccessController.doPrivileged(new PrivilegedExceptionAction<FileTime>(){
                        static final long serialVersionUID = 942915722903378784L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public FileTime run() throws IOException {
                            return Files.getLastModifiedTime(leaseFile, new LinkOption[0]);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$2", 2.class, null, null);
                        }
                    });
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"recoveryId: {0}, new leaseTime: {1}", (Object[])new Object[]{recoveryIdentityToRecover, Utils.traceTime((FileTime)newleaseTime)});
                    }
                    if (!(pld = new PeerLeaseData(recoveryIdentityToRecover, newleaseTime, this._leaseTimeout)).isExpired()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"The lease file has not expired, or does not exist do not attempt recovery", (Object[])new Object[0]);
                        }
                        attemptClaim = false;
                    }
                    if (attemptClaim) {
                        if (this.lockPeerLease(recoveryIdentityToRecover)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Attempt to read lease file", (Object[])new Object[0]);
                            }
                            FileChannel channel = FileChannel.open(leaseFile, StandardOpenOption.READ, StandardOpenOption.WRITE);
                            try {
                                int newline;
                                long fileSize = channel.size();
                                ByteBuffer buffer = ByteBuffer.allocate((int)fileSize);
                                channel.read(buffer);
                                buffer.flip();
                                String line = new String(buffer.array());
                                if (tc.isDebugEnabled()) {
                                    Tr.info((TraceComponent)tc, (String)("On reading " + recoveryIdentityToRecover + " lease file length " + line.length() + " contains " + line), (Object[])new Object[0]);
                                }
                                if ((newline = line.indexOf("\n")) > 0) {
                                    line = line.substring(0, newline);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("String is now " + line + " of length " + line.length()), (Object[])new Object[0]);
                                }
                                leaseInfo.setLeaseDetail(new File(line));
                                ByteBuffer myBackendURL = null;
                                long filePos = 0L;
                                if (newline > 0) {
                                    channel.truncate(newline + 1);
                                    myBackendURL = ByteBuffer.wrap(this.getBackendURL().getBytes());
                                    filePos = newline + 1;
                                } else {
                                    myBackendURL = ByteBuffer.wrap(("\n" + this.getBackendURL()).getBytes());
                                    filePos = fileSize;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Write in our own backendURL {0} from file position {1}", (Object[])new Object[]{myBackendURL, filePos});
                                }
                                channel.write(myBackendURL, filePos);
                                channel.force(false);
                                if (tc.isDebugEnabled()) {
                                    buffer = ByteBuffer.allocate((int)channel.size());
                                    channel.position(0L);
                                    channel.read(buffer);
                                    buffer.flip();
                                    line = new String(buffer.array());
                                    Tr.info((TraceComponent)tc, (String)("On writing " + recoveryIdentityToRecover + " lease file length " + line.length() + " contains " + line), (Object[])new Object[0]);
                                }
                                claimedLease = true;
                                if (channel == null) break block22;
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"404", (Object)this, (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo});
                                if (channel == null) throw throwable;
                                try {
                                    channel.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"404", (Object)this, (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo});
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            channel.close();
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Failed to lock or read lease file", (Object[])new Object[0]);
                        }
                    }
                }
                Files.setLastModifiedTime(leaseFile, newleaseTime);
            }
            catch (IOException | PrivilegedActionException e) {
                if (!tc.isDebugEnabled()) break block23;
                Tr.debug((TraceComponent)tc, (String)("Caught an IOException - " + e), (Object[])new Object[0]);
            }
        }
        if (!tc.isEntryEnabled()) return claimedLease;
        Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)claimedLease);
        return claimedLease;
    }

    @Override
    @ManualTrace
    public void getLeasesForPeers(final PeerLeaseTable peerLeaseTable, String recoveryGroup) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLeasesForPeers", (Object[])new Object[]{peerLeaseTable, recoveryGroup, this._localLeaseLock, this});
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = -6776425850758784230L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Void run() {
                try {
                    FileChannel theChannel = FileChannel.open(FileSharedServerLeaseLog.this._controlFile, StandardOpenOption.READ, StandardOpenOption.WRITE);
                    try {
                        block15: {
                            FileLock lock = theChannel.tryLock();
                            try {
                                block14: {
                                    Stream<Path> files = Files.list(FileSharedServerLeaseLog.this._leaseLogDirectory);
                                    try {
                                        files.filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(path -> 0 != path.compareTo(FileSharedServerLeaseLog.this._controlFile)).filter(path -> !path.toString().endsWith(FileSharedServerLeaseLog.LOCK_SUFFIX)).filter(path -> !path.getFileName().toString().equals(FileSharedServerLeaseLog.this._localRecoveryIdentity)).forEach(peer -> {
                                            block2: {
                                                try {
                                                    peerLeaseTable.addPeerEntry(new PeerLeaseData(peer.getFileName().toString(), Files.getLastModifiedTime(peer, new LinkOption[0]), FileSharedServerLeaseLog.this._leaseTimeout));
                                                }
                                                catch (IOException e) {
                                                    if (!tc.isDebugEnabled()) break block2;
                                                    Tr.debug((TraceComponent)tc, (String)"Exception getting last modified time for {0}\n{1}", (Object[])new Object[]{peer, e});
                                                }
                                            }
                                        });
                                        if (files == null) break block14;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"489", (Object)this, (Object[])new Object[0]);
                                        if (files == null) throw throwable;
                                        try {
                                            files.close();
                                            throw throwable;
                                        }
                                        catch (Throwable throwable2) {
                                            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"489", (Object)this, (Object[])new Object[0]);
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                    files.close();
                                }
                                if (lock == null) break block15;
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"489", (Object)this, (Object[])new Object[0]);
                                if (lock == null) throw throwable;
                                try {
                                    lock.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable3) {
                                    FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"489", (Object)this, (Object[])new Object[0]);
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                            lock.close();
                        }
                        if (theChannel == null) return null;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"489", (Object)this, (Object[])new Object[0]);
                        if (theChannel == null) throw throwable;
                        try {
                            theChannel.close();
                            throw throwable;
                        }
                        catch (Throwable throwable4) {
                            FFDCFilter.processException((Throwable)throwable4, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"489", (Object)this, (Object[])new Object[0]);
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                    theChannel.close();
                    return null;
                }
                catch (Exception theChannel) {
                    void e;
                    FFDCFilter.processException((Throwable)theChannel, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"500", (Object)this, (Object[])new Object[0]);
                    if (!tc.isDebugEnabled()) return null;
                    Tr.debug((TraceComponent)tc, (String)"Exception locking lease control file: ", (Object[])new Object[]{e});
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", 3.class, null, null);
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLeasesForPeers", (Object)this);
        }
    }

    @Override
    public boolean lockPeerLease(String recoveryIdentity) {
        Path leaseLockFile = this._serverInstallLeaseLogDir.resolve(recoveryIdentity + LOCK_SUFFIX);
        try {
            this._peerLeaseLock = FileChannel.open(leaseLockFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ).tryLock();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"532", (Object)this, (Object[])new Object[]{recoveryIdentity});
        }
        return this._peerLeaseLock != null;
    }

    @Override
    public void releasePeerLease(String recoveryIdentity) throws Exception {
        if (this._peerLeaseLock != null) {
            this._peerLeaseLock.acquiredBy().close();
            this._peerLeaseLock = null;
        }
    }

    @Override
    @ManualTrace
    public void setPeerRecoveryLeaseTimeout(int leaseTimeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setPeerRecoveryLeaseTimeout", (Object[])new Object[]{leaseTimeout});
        }
        this._leaseTimeout = leaseTimeout;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setPeerRecoveryLeaseTimeout", (Object)this);
        }
    }

    @Override
    @ManualTrace
    @FFDCIgnore(value={FileNotFoundException.class, IOException.class, Throwable.class})
    public String getBackendURL(String recoveryId) {
        String filename = this._serverInstallLeaseLogDir + File.separator + recoveryId;
        String ret = null;
        int retries = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBackendURL", (Object[])new Object[]{filename});
        }
        while (true) {
            String string;
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            try {
                reader.readLine();
                ret = reader.readLine();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getBackendURL", (Object)ret);
                }
                string = ret;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"getBackendURL: Lease file not found. Recovery is probably done.", (Object[])new Object[0]);
                    break;
                }
                catch (IOException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"getBackendURL: Lease was probably being renewed. Wait 500ms and try again.", (Object[])new Object[]{e});
                    }
                    if (retries++ > 60) {
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)"getBackendURL: Couldn't access lease file even after retrying.", (Object[])new Object[0]);
                        break;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"607", (Object)this, (Object[])new Object[]{recoveryId});
                    }
                    continue;
                }
            }
            reader.close();
            return string;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBackendURL", ret);
        }
        return ret;
    }

    private static /* synthetic */ void lambda$deleteServerLease$0(Path p) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Lease directory contents: ", (Object[])new Object[]{p});
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        tc = Tr.register(FileSharedServerLeaseLog.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    }
}

