/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FeatureSuggestion {
    private static final TraceComponent tc = Tr.register(FeatureSuggestion.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private static final String FEATURE_JAXB = "jaxb-2.2";
    private static final String FEAUTRE_CORBA = "corba-2.4";
    private static final String FEATURE_JDBC = "jdbc-4.0";
    private static final String FEAUTRE_JAXWS = "jaxws-2.2";
    private static final Map<String, String> pkgToFeature = new HashMap<String, String>();
    private static final Set<String> suggestedFeatures = Collections.newSetFromMap(new ConcurrentHashMap());
    static final long serialVersionUID = -212168289053836687L;

    public static ClassNotFoundException getExceptionWithSuggestion(ClassNotFoundException original, String className, boolean returnNull) {
        String failingClassName = original == null ? className : original.getMessage();
        String suggestedFeature = FeatureSuggestion.getFeatureSuggestion(failingClassName);
        if (suggestedFeature == null) {
            return original;
        }
        if (!suggestedFeatures.contains(suggestedFeature)) {
            suggestedFeatures.add(suggestedFeature);
            Tr.info((TraceComponent)tc, (String)"cls.classloader.suggested.feature", (Object[])new Object[]{failingClassName, suggestedFeature});
        }
        if (returnNull) {
            return null;
        }
        String warnMsg = Tr.formatMessage((TraceComponent)tc, (String)"cls.classloader.suggested.feature", (Object[])new Object[]{failingClassName, suggestedFeature});
        ClassNotFoundException toThrow = original == null ? new ClassNotFoundException(warnMsg) : new ClassNotFoundException(warnMsg, original);
        return toThrow;
    }

    private static String getFeatureSuggestion(String name) {
        if (JavaInfo.majorVersion() < 9) {
            return null;
        }
        if (name == null) {
            return null;
        }
        if (!name.startsWith("javax.") && !name.startsWith("org.omg.")) {
            return null;
        }
        if (name.equals("javax.xml.ws.WebServiceRef")) {
            return null;
        }
        String pkg = name.substring(0, name.lastIndexOf(46));
        return pkgToFeature.get(pkg);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        pkgToFeature.put("javax.activation", FEATURE_JAXB);
        pkgToFeature.put("javax.activity", FEAUTRE_CORBA);
        pkgToFeature.put("javax.rmi", FEAUTRE_CORBA);
        pkgToFeature.put("javax.rmi.CORBA", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.CORBA", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.CORBA_2_3", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.CORBA_2_3.portable", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.CORBA.DynAnyPackage", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.CORBA.ORBPackage", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.CORBA.portable", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.CORBA.TypeCodePackage", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.CosNaming", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.CosNaming.NamingContextExtPackage", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.CosNaming.NamingContextPackage", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.Dynamic", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.DynamicAny", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.DynamicAny.DynAnyFactoryPackage", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.DynamicAny.DynAnyPackage", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.IOP", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.IOP.CodecFactoryPackage", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.IOP.CodecPackage", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.Messaging", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.PortableInterceptor", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.PortableInterceptor.ORBInitInfoPackage", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.PortableServer", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.PortableServer.CurrentPackage", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.PortableServer.POAManagerPackage", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.PortableServer.POAPackage", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.PortableServer.portable", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.PortableServer.ServantLocatorPackage", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.SendingContext", FEAUTRE_CORBA);
        pkgToFeature.put("org.omg.stub.java.rmi", FEAUTRE_CORBA);
        pkgToFeature.put("javax.transaction", FEATURE_JDBC);
        pkgToFeature.put("javax.xml.bind", FEATURE_JAXB);
        pkgToFeature.put("javax.xml.bind.annotation", FEATURE_JAXB);
        pkgToFeature.put("javax.xml.bind.annotation.adapters", FEATURE_JAXB);
        pkgToFeature.put("javax.xml.bind.attachment", FEATURE_JAXB);
        pkgToFeature.put("javax.xml.bind.helpers", FEATURE_JAXB);
        pkgToFeature.put("javax.xml.bind.util", FEATURE_JAXB);
        pkgToFeature.put("javax.jws", FEAUTRE_JAXWS);
        pkgToFeature.put("javax.jws.soap", FEAUTRE_JAXWS);
        pkgToFeature.put("javax.xml.soap", FEAUTRE_JAXWS);
        pkgToFeature.put("javax.xml.ws", FEAUTRE_JAXWS);
        pkgToFeature.put("javax.xml.ws.handler", FEAUTRE_JAXWS);
        pkgToFeature.put("javax.xml.ws.handler.soap", FEAUTRE_JAXWS);
        pkgToFeature.put("javax.xml.ws.http", FEAUTRE_JAXWS);
        pkgToFeature.put("javax.xml.ws.soap", FEAUTRE_JAXWS);
        pkgToFeature.put("javax.xml.ws.spi", FEAUTRE_JAXWS);
        pkgToFeature.put("javax.xml.ws.spi.http", FEAUTRE_JAXWS);
        pkgToFeature.put("javax.xml.ws.wsaddressing", FEAUTRE_JAXWS);
    }
}

