/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.sessions.Session;

public class ExpressionOperatorConverter
extends ObjectTypeConverter {
    @Override
    public Object convertObjectValueToDataValue(Object attributeValue, Session session) {
        Object fieldValue;
        if (attributeValue == null) {
            fieldValue = this.getAttributeToFieldValues().get(Helper.NULL_VALUE);
        } else {
            fieldValue = this.getAttributeToFieldValues().get(attributeValue);
            if (fieldValue == null) {
                if (((ExpressionOperator)attributeValue).getDatabaseStrings() != null) {
                    String databaseString = ((ExpressionOperator)attributeValue).getDatabaseStrings()[0];
                    fieldValue = databaseString.substring(0, databaseString.length() - 1);
                } else {
                    throw DescriptorException.noAttributeValueConversionToFieldValueProvided(attributeValue, this.getMapping());
                }
            }
        }
        return fieldValue;
    }

    @Override
    public Object convertDataValueToObjectValue(Object fieldValue, Session session) {
        ExpressionOperator attributeValue = null;
        if (fieldValue == null) {
            attributeValue = (ExpressionOperator)this.getFieldToAttributeValues().get(Helper.NULL_VALUE);
        } else {
            try {
                fieldValue = ((AbstractSession)session).getDatasourcePlatform().getConversionManager().convertObject(fieldValue, this.getFieldClassification());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), e);
            }
            attributeValue = (ExpressionOperator)this.getFieldToAttributeValues().get(fieldValue);
            if (attributeValue == null) {
                attributeValue = ExpressionOperator.simpleFunction(0, (String)fieldValue);
            }
        }
        return attributeValue;
    }
}

