/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.ResponseSideEffect;
import com.ibm.ws.ffdc.FFDCFilter;
import jakarta.servlet.http.HttpServletResponse;

public class CharacterEncodingSideEffect
implements ResponseSideEffect {
    private static final long serialVersionUID = -522999048151768022L;
    private String characterEncoding = null;

    public String toString() {
        StringBuffer sb = new StringBuffer("Character Encoding side effect: \n\t");
        sb.append("Character Encoding: ").append(this.characterEncoding).append("\n");
        return sb.toString();
    }

    public CharacterEncodingSideEffect(String charEnc) {
        this.characterEncoding = charEnc;
    }

    @Override
    public void performSideEffect(HttpServletResponse response) {
        try {
            if (response instanceof CacheProxyResponse) {
                CacheProxyResponse cpr = (CacheProxyResponse)response;
                if (!(cpr._gotWriter || cpr._gotOutputStream || cpr.getResponse().isCommitted())) {
                    cpr.setCharacterEncoding(this.characterEncoding);
                }
            }
        }
        catch (IllegalStateException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.servlet.ContentTypeSideEffect.performSideEffect", (String)"71", (Object)this);
        }
    }
}

