/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulWS.client.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.web.WebSecurityHelper;
import jakarta.servlet.http.Cookie;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.ClientRequestContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class LtpaHandler {
    private static final TraceComponent tc = Tr.register(LtpaHandler.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
    static final long serialVersionUID = -6526299382436882197L;

    public static void configClientLtpaHandler(ClientRequestContext crc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"configClientLtpaHandler - About to get a LTPA authentication token", (Object[])new Object[0]);
        }
        try {
            Cookie ssoCookie = WebSecurityHelper.getSSOCookieFromSSOToken();
            if (ssoCookie == null) {
                return;
            }
            String cookieName = ssoCookie.getName();
            String cookieValue = ssoCookie.getValue();
            if (cookieValue != null && !cookieValue.isEmpty() && cookieName != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Retrieved a LTPA authentication token. About to set a request cookie: " + cookieName + "=" + cookieValue), (Object[])new Object[0]);
                }
                crc.getHeaders().putSingle((Object)"Cookie", (Object)(ssoCookie.getName() + "=" + ssoCookie.getValue()));
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot find a ltpa authentication token off of the thread, you may need enable feature appSecurity-4.0 or transportSecurity-1.0", (Object[])new Object[0]);
            }
        }
        catch (NoClassDefFoundError ncdfe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"configClientLtpaHandler - caught NCDFE - expected if app security feature not enabled", (Object[])new Object[]{ncdfe});
            }
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }
}

