/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.pipeline;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.Objects;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AccessLoggerHandler
extends ChannelDuplexHandler {
    private final HttpChannelConfig config;
    static final long serialVersionUID = 62248270032525254L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AccessLoggerHandler(HttpChannelConfig config) {
        Objects.requireNonNull(config);
        this.config = config;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (Objects.nonNull(msg) && msg instanceof HttpInboundServiceContextImpl) {
            HttpInboundServiceContextImpl isc = (HttpInboundServiceContextImpl)msg;
            this.config.getAccessLog().log(isc.getRequest(), isc.getResponse(), isc.getRequestVersion().getName(), null, isc.getRemoteAddr().getHostAddress(), isc.getNumBytesWritten());
        }
        super.write(ctx, msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!ctx.channel().hasAttr(NettyHttpConstants.REQUEST_START_TIME)) {
            long startTime = System.nanoTime();
            ctx.channel().attr(NettyHttpConstants.REQUEST_START_TIME).set((Object)startTime);
        }
        super.channelRead(ctx, msg);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.pipeline.AccessLoggerHandler", AccessLoggerHandler.class, null, null);
    }
}

