/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import jakarta.faces.FacesException;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.AjaxBehavior;
import jakarta.faces.component.behavior.Behavior;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.render.ClientBehaviorRenderer;
import org.apache.myfaces.core.api.shared.lang.SharedStringBuilder;
import org.apache.myfaces.renderkit.html.util.AjaxScriptBuilder;

public class HtmlAjaxBehaviorRenderer
extends ClientBehaviorRenderer {
    private static final String ERR_NO_AJAX_BEHAVIOR = "The behavior must be an instance of AjaxBehavior";
    private static final String AJAX_SB = "oam.renderkit.AJAX_SB";

    public void decode(FacesContext context, UIComponent component, ClientBehavior behavior) {
        this.assertBehavior(behavior);
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled() || !component.isRendered()) {
            return;
        }
        this.dispatchBehaviorEvent(component, ajaxBehavior);
    }

    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        this.assertBehavior(behavior);
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled()) {
            return null;
        }
        StringBuilder retVal = SharedStringBuilder.get((FacesContext)behaviorContext.getFacesContext(), (String)AJAX_SB, (int)60);
        AjaxScriptBuilder.build(behaviorContext.getFacesContext(), retVal, behaviorContext.getComponent(), behaviorContext.getSourceId(), behaviorContext.getEventName(), ajaxBehavior.getExecute(), ajaxBehavior.getRender(), ajaxBehavior.getDelay(), ajaxBehavior.isResetValues(), ajaxBehavior.getOnerror(), ajaxBehavior.getOnevent(), behaviorContext.getParameters(), null);
        return retVal.toString();
    }

    private void dispatchBehaviorEvent(UIComponent component, AjaxBehavior ajaxBehavior) {
        AjaxBehaviorEvent event = new AjaxBehaviorEvent(component, (Behavior)ajaxBehavior);
        boolean isImmediate = ajaxBehavior.isImmediateSet() ? ajaxBehavior.isImmediate() : this.isComponentImmediate(component);
        PhaseId phaseId = isImmediate ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.INVOKE_APPLICATION;
        event.setPhaseId(phaseId);
        component.queueEvent((FacesEvent)event);
    }

    private boolean isComponentImmediate(UIComponent component) {
        boolean isImmediate = false;
        if (component instanceof EditableValueHolder) {
            isImmediate = ((EditableValueHolder)component).isImmediate();
        } else if (component instanceof ActionSource) {
            isImmediate = ((ActionSource)component).isImmediate();
        }
        return isImmediate;
    }

    private void assertBehavior(ClientBehavior behavior) {
        if (!(behavior instanceof AjaxBehavior)) {
            throw new FacesException(ERR_NO_AJAX_BEHAVIOR);
        }
    }
}

