/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitors.helper;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.lang.reflect.Method;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ThreadPoolStatsHelper {
    private static final TraceComponent tc = Tr.register(ThreadPoolStatsHelper.class, (String)"pmi", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    private final String poolName;
    private Method met_getPoolSize;
    private Method met_getActiveCount;
    private final Object objThreadPoolExecutorImpl;
    static final long serialVersionUID = 2132408992960321818L;

    public ThreadPoolStatsHelper(String _pName, Object _objThreadPoolExecutorImpl) {
        this.poolName = _pName;
        this.objThreadPoolExecutorImpl = _objThreadPoolExecutorImpl;
        for (Method method : _objThreadPoolExecutorImpl.getClass().getDeclaredMethods()) {
            if (method.getName().equals("getPoolSize")) {
                this.met_getPoolSize = method;
                continue;
            }
            if (!method.getName().equals("getActiveCount")) continue;
            this.met_getActiveCount = method;
        }
    }

    public String getPoolName() {
        return this.poolName;
    }

    public int getPoolSize() {
        Integer t;
        block4: {
            t = null;
            try {
                t = (Integer)this.met_getPoolSize.invoke(this.objThreadPoolExecutorImpl, null);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Failed to Invoke getPoolSize Method on ThreadPoolExecutorImpl. Error=" + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (t == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to Invoke getPoolSize Method on ThreadPoolExecutorImpl. PoolSize returned was NULL", (Object[])new Object[0]);
            }
            return -1;
        }
        return t;
    }

    public int getActiveThreads() {
        Integer t;
        block4: {
            t = null;
            try {
                t = (Integer)this.met_getActiveCount.invoke(this.objThreadPoolExecutorImpl, null);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Failed to Invoke getActiveCount Method on ThreadPoolExecutorImpl. Error=" + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (t == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to Invoke getActiveCount Method on ThreadPoolExecutorImpl. ActiveCounte returned was NULL", (Object[])new Object[0]);
            }
            return -1;
        }
        return t;
    }
}

