/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.netty.channel;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.http.netty.pipeline.inbound.LibertyHttpRequestHandler;
import com.ibm.ws.netty.upgrade.NettyServletUpgradeHandler;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.openliberty.http.netty.timeout.TimeoutHandler;

@ChannelHandler.Sharable
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class TransportHandler
extends ChannelDuplexHandler {
    public static final TransportHandler INSTANCE;
    static final long serialVersionUID = -6459257477975296300L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        FullHttpRequest request;
        String acceptEncoding;
        if (message instanceof FullHttpRequest && (acceptEncoding = (request = (FullHttpRequest)message).headers().get((CharSequence)HttpHeaderNames.ACCEPT_ENCODING)) != null) {
            context.channel().attr(NettyHttpConstants.ACCEPT_ENCODING).set((Object)acceptEncoding);
        }
        context.fireChannelRead(message);
    }

    public void write(ChannelHandlerContext context, Object message, ChannelPromise promise) throws Exception {
        if (!(message instanceof HttpResponse)) {
            context.write(message, promise);
            return;
        }
        HttpResponse response = (HttpResponse)message;
        boolean switching = response.status().equals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS);
        ChannelFuture future = context.write(message, promise);
        if (!switching) {
            return;
        }
        future.addListener(f -> {
            if (f.isSuccess()) {
                ChannelPipeline pipeline = context.pipeline();
                pipeline.remove((ChannelHandler)this);
                TransportHandler.removeIfPresent(pipeline, HttpServerCodec.class);
                TransportHandler.removeIfPresent(pipeline, TimeoutHandler.class);
                TransportHandler.removeIfPresent(pipeline, LibertyHttpRequestHandler.class);
                if (pipeline.get(NettyServletUpgradeHandler.class) == null) {
                    pipeline.addLast(new ChannelHandler[]{new NettyServletUpgradeHandler(context.channel())});
                }
            }
        });
    }

    private static void removeIfPresent(ChannelPipeline pipeline, Class<? extends ChannelHandler> handler) {
        if (pipeline.get(handler) != null) {
            pipeline.remove(handler);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.http.netty.channel.TransportHandler", TransportHandler.class, null, null);
        INSTANCE = new TransportHandler();
    }
}

