/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.registry;

import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.resteasy.core.ResourceLocatorInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.registry.ConstantResourceInvoker;
import org.jboss.resteasy.core.registry.MatchCache;
import org.jboss.resteasy.core.registry.MethodExpression;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.DefaultOptionsMethodException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.config.ConfigurationFactory;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.util.WeightedMediaType;

public class SegmentNode {
    public static final String RESTEASY_CHOSEN_ACCEPT = "RESTEASY_CHOSEN_ACCEPT";
    public static final String RESTEASY_SERVER_HAS_PRODUCES = "RESTEASY-SERVER-HAS-PRODUCES";
    public static final String RESTEASY_SERVER_HAS_PRODUCES_LC = "RESTEASY-SERVER-HAS-PRODUCES".toLowerCase();
    public static final MediaType[] WILDCARD_ARRAY = new MediaType[]{MediaType.WILDCARD_TYPE};
    public static final List<MediaType> DEFAULT_ACCEPTS = new ArrayList<MediaType>();
    protected String segment;
    protected Map<String, SegmentNode> children = new HashMap<String, SegmentNode>();
    protected List<MethodExpression> targets = new ArrayList<MethodExpression>();

    public SegmentNode(String segment) {
        this.segment = segment;
    }

    public MatchCache match(HttpRequest request, int start) {
        ResteasyUriInfo uriInfo = (ResteasyUriInfo)request.getUri();
        String path = uriInfo.getMatchingPath();
        RESTEasyTracingLogger logger2 = RESTEasyTracingLogger.getInstance(request);
        logger2.log("MATCH_PATH_FIND", path);
        if (start < path.length() && path.charAt(start) == '/') {
            ++start;
        }
        ArrayList<MethodExpression> potentials = new ArrayList<MethodExpression>();
        this.potentials(path, start, potentials);
        Collections.sort(potentials);
        boolean expressionMatched = false;
        ArrayList<Match> matches = new ArrayList<Match>();
        for (MethodExpression expression : potentials) {
            if (expressionMatched && expression.isLocator()) {
                logger2.log("MATCH_PATH_SKIPPED", expression.getRegex());
                continue;
            }
            Pattern pattern = expression.getPattern();
            Matcher matcher = pattern.matcher(path);
            matcher.region(start, path.length());
            if (matcher.matches()) {
                expressionMatched = true;
                ResourceInvoker invoker = expression.getInvoker();
                if (invoker instanceof ResourceLocatorInvoker) {
                    MatchCache ctx = new MatchCache(expression.getPathExpression());
                    ctx.invoker = invoker;
                    int length = matcher.start(expression.getNumGroups() + 1);
                    if (length == -1) {
                        uriInfo.pushMatchedPath(path);
                        uriInfo.pushMatchedURI(path);
                    } else {
                        Pattern p = expression.getPattern();
                        Matcher m = p.matcher(path);
                        m.region(start, path.length());
                        String substring = path;
                        while (m.find()) {
                            int indx;
                            String endText = m.group(m.groupCount());
                            if (endText == null || endText.isEmpty() || (indx = path.indexOf(endText, length)) <= -1) continue;
                            substring = path.substring(0, indx);
                        }
                        uriInfo.pushMatchedPath(substring);
                        uriInfo.pushMatchedURI(substring);
                    }
                    expression.populatePathParams(request, matcher, path);
                    logger2.log("MATCH_LOCATOR", invoker.getMethod());
                    uriInfo.addMatchedResourceTemplate(expression.getPathExpression());
                    return ctx;
                }
                matches.add(new Match(expression, matcher));
                continue;
            }
            logger2.log("MATCH_PATH_NOT_MATCHED", expression.getRegex());
        }
        if (matches.size() == 0) {
            throw new NotFoundException(Messages.MESSAGES.couldNotFindResourceForFullPath(request.getUri().getRequestUri()));
        }
        MatchCache match = this.match(matches, request.getHttpMethod(), request);
        if (match.match != null) {
            match.match.expression.populatePathParams(request, match.match.matcher, path);
            uriInfo.addMatchedResourceTemplate(match.match.expression.getPathExpression());
            logger2.log("MATCH_PATH_SELECTED", match.match.expression.getRegex());
        }
        return match;
    }

    public void potentials(String path, int start, List<MethodExpression> matches) {
        if (start == path.length()) {
            matches.addAll(this.targets);
            return;
        }
        if (start < path.length()) {
            String simpleSegment = null;
            int endOfSegmentIndex = path.indexOf(47, start);
            simpleSegment = endOfSegmentIndex > -1 ? path.substring(start, endOfSegmentIndex) : path.substring(start);
            SegmentNode child = this.children.get(simpleSegment);
            if (child != null) {
                int next = start + simpleSegment.length();
                if (endOfSegmentIndex > -1) {
                    ++next;
                }
                child.potentials(path, next, matches);
            }
        }
        for (MethodExpression exp : this.targets) {
            if (exp.getNumGroups() <= 0 && !(exp.getInvoker() instanceof ResourceLocatorInvoker)) continue;
            matches.add(exp);
        }
    }

    public static SortFactor createSortFactor(MediaType client, MediaType server) {
        String val;
        String name;
        String qs;
        SortFactor sortFactor = new SortFactor();
        if (client.isWildcardType() != server.isWildcardType()) {
            sortFactor.type = client.isWildcardType() ? server.getType() : client.getType();
            ++sortFactor.d;
        } else {
            sortFactor.type = client.getType();
        }
        if (client.isWildcardSubtype() != server.isWildcardSubtype()) {
            sortFactor.subtype = client.isWildcardSubtype() ? server.getSubtype() : client.getSubtype();
            ++sortFactor.d;
        } else {
            sortFactor.subtype = client.getSubtype();
        }
        String q = (String)client.getParameters().get("q");
        if (q != null) {
            sortFactor.q = Float.parseFloat(q);
        }
        if ((qs = (String)server.getParameters().get("qs")) != null) {
            sortFactor.qs = Float.parseFloat(qs);
        }
        sortFactor.dm = 0;
        for (Map.Entry entry : client.getParameters().entrySet()) {
            name = (String)entry.getKey();
            if ("q".equals(name) || "qs".equals(name)) continue;
            val = (String)server.getParameters().get(name);
            if (val == null) {
                ++sortFactor.dm;
                continue;
            }
            if (val.equals(entry.getValue())) continue;
            ++sortFactor.dm;
        }
        for (Map.Entry entry : server.getParameters().entrySet()) {
            name = (String)entry.getKey();
            if ("q".equals(name) || "qs".equals(name)) continue;
            val = (String)client.getParameters().get(name);
            if (val == null) {
                ++sortFactor.dm;
                continue;
            }
            if (val.equals(entry.getValue())) continue;
            ++sortFactor.dm;
        }
        return sortFactor;
    }

    public MatchCache match(List<Match> matches, String httpMethod, HttpRequest request) {
        MediaType contentType = request.getHttpHeaders().getMediaType();
        List<MediaType> requestAccepts = request.getHttpHeaders().getAcceptableMediaTypes();
        ArrayList<WeightedMediaType> weightedAccepts = new ArrayList<WeightedMediaType>();
        for (MediaType accept : requestAccepts) {
            weightedAccepts.add(WeightedMediaType.parse(accept));
        }
        ArrayList<Match> list = new ArrayList<Match>();
        boolean methodMatch = false;
        boolean consumeMatch = false;
        for (Match match : matches) {
            ResourceMethodInvoker resourceMethodInvoker = (ResourceMethodInvoker)match.expression.getInvoker();
            if (!resourceMethodInvoker.getHttpMethods().contains(httpMethod.toUpperCase())) continue;
            methodMatch = true;
            if (!resourceMethodInvoker.doesConsume(contentType)) continue;
            consumeMatch = true;
            if (!resourceMethodInvoker.doesProduce(weightedAccepts)) continue;
            list.add(match);
        }
        if (list.size() == 0) {
            if (!methodMatch) {
                HashSet<String> allowed = new HashSet<String>();
                for (Match match : matches) {
                    allowed.addAll(((ResourceMethodInvoker)match.expression.getInvoker()).getHttpMethods());
                }
                if (httpMethod.equalsIgnoreCase("HEAD") && allowed.contains("GET")) {
                    return this.match(matches, "GET", request);
                }
                if (allowed.contains("GET")) {
                    allowed.add("HEAD");
                }
                allowed.add("OPTIONS");
                StringBuilder stringBuilder = new StringBuilder("");
                boolean bl = true;
                for (String allow : allowed) {
                    boolean bl2;
                    if (bl2) {
                        bl2 = false;
                    } else {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(allow);
                }
                String allowHeaderValue = stringBuilder.toString();
                if (httpMethod.equals("OPTIONS")) {
                    MediaType acceptType = MediaType.TEXT_PLAIN_TYPE;
                    Response.ResponseBuilder resBuilder = Response.ok((Object)allowHeaderValue.toString(), (MediaType)acceptType).header("Allow", (Object)allowHeaderValue.toString());
                    if (allowed.contains("PATCH")) {
                        HashSet<MediaType> patchAccepts = new HashSet<MediaType>(8);
                        for (Match match : matches) {
                            if (!((ResourceMethodInvoker)match.expression.getInvoker()).getHttpMethods().contains("PATCH")) continue;
                            patchAccepts.addAll(Arrays.asList(((ResourceMethodInvoker)match.expression.getInvoker()).getConsumes()));
                        }
                        StringBuilder acceptPatch = new StringBuilder("");
                        boolean bl3 = true;
                        for (MediaType mediaType : patchAccepts) {
                            boolean bl4;
                            if (bl4) {
                                bl4 = false;
                            } else {
                                acceptPatch.append(", ");
                            }
                            acceptPatch.append(mediaType.toString());
                        }
                        resBuilder.header("Accept-Patch", (Object)acceptPatch.toString());
                    }
                    if (SegmentNode.getConfigValue("dev.resteasy.throw.options.exception")) {
                        throw new DefaultOptionsMethodException(Messages.MESSAGES.noResourceMethodFoundForOptions(), resBuilder.build());
                    }
                    MatchCache cache = new MatchCache("/");
                    cache.chosen = acceptType;
                    cache.match = null;
                    cache.invoker = new ConstantResourceInvoker(resBuilder.build());
                    return cache;
                }
                Response res = Response.status((int)405).header("Allow", (Object)allowHeaderValue).build();
                throw new NotAllowedException(Messages.MESSAGES.noResourceMethodFoundForHttpMethod(httpMethod), res);
            }
            if (!consumeMatch) {
                throw new NotSupportedException(Messages.MESSAGES.cannotConsumeContentType());
            }
            throw new NotAcceptableException(Messages.MESSAGES.noMatchForAcceptHeader());
        }
        ArrayList<SortEntry> sortList = new ArrayList<SortEntry>();
        for (Match match : list) {
            MediaType[] produces;
            MediaType[] consumes;
            ResourceMethodInvoker invoker = (ResourceMethodInvoker)match.expression.getInvoker();
            if (contentType == null) {
                contentType = MediaType.WILDCARD_TYPE;
            }
            if ((consumes = invoker.getConsumes()).length == 0) {
                consumes = WILDCARD_ARRAY;
            }
            if ((produces = invoker.getProduces()).length == 0) {
                produces = WILDCARD_ARRAY;
            }
            ArrayList<SortFactor> consumeCombo = new ArrayList<SortFactor>();
            for (MediaType consume : consumes) {
                consumeCombo.add(SegmentNode.createSortFactor(contentType, consume));
            }
            for (MediaType produce : produces) {
                List<MediaType> acceptableMediaTypes = requestAccepts;
                if (acceptableMediaTypes.size() == 0) {
                    acceptableMediaTypes = DEFAULT_ACCEPTS;
                }
                for (MediaType accept : acceptableMediaTypes) {
                    if (!accept.isCompatible(produce)) continue;
                    SortFactor sortFactor = SegmentNode.createSortFactor(accept, produce);
                    for (SortFactor consume : consumeCombo) {
                        sortList.add(new SortEntry(match, consume, sortFactor, produce));
                    }
                }
            }
        }
        Collections.sort(sortList);
        SortEntry sortEntry = (SortEntry)sortList.get(0);
        String[] stringArray = this.matchingMethods(sortList);
        if (stringArray != null) {
            if (SegmentNode.isFailFast()) {
                throw new RuntimeException(Messages.MESSAGES.multipleMethodsMatchFailFast(this.requestToString(request), stringArray));
            }
            LogMessages.LOGGER.multipleMethodsMatch(this.requestToString(request), stringArray);
        }
        MediaType acceptType = sortEntry.getAcceptType();
        request.setAttribute(RESTEASY_CHOSEN_ACCEPT, acceptType);
        MatchCache ctx = new MatchCache(sortEntry.match.expression.getPathExpression());
        ctx.chosen = acceptType;
        ctx.match = sortEntry.match;
        ctx.invoker = sortEntry.match.expression.invoker;
        return ctx;
    }

    protected void addExpression(MethodExpression expression) {
        this.targets.add(expression);
        Collections.sort(this.targets);
    }

    private String requestToString(HttpRequest request) {
        return "\"" + request.getHttpMethod() + " " + request.getUri().getPath() + "\"";
    }

    private String[] matchingMethods(List<SortEntry> sortList) {
        SortEntry a;
        HashSet<Method> s = null;
        Iterator<SortEntry> it = sortList.iterator();
        SortEntry b = it.next();
        Method first = b.match.expression.getInvoker().getMethod();
        while (it.hasNext() && (a = b).compareTo(b = it.next()) == 0) {
            if (s == null) {
                s = new HashSet<Method>();
                s.add(first);
            }
            s.add(b.match.expression.getInvoker().getMethod());
        }
        if (s != null && s.size() > 1) {
            String[] names = new String[s.size()];
            Iterator iterator = s.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                names[i++] = ((Method)iterator.next()).toString();
            }
            return names;
        }
        return null;
    }

    private static boolean isFailFast() {
        return SegmentNode.getConfigValue("resteasy.fail.fast.on.multiple.resources.matching");
    }

    private static boolean getConfigValue(String key) {
        if (System.getSecurityManager() == null) {
            return ConfigurationFactory.getInstance().getConfiguration().getOptionalValue(key, Boolean.TYPE).orElse(false);
        }
        return AccessController.doPrivileged(() -> ConfigurationFactory.getInstance().getConfiguration().getOptionalValue(key, Boolean.TYPE).orElse(false));
    }

    static {
        DEFAULT_ACCEPTS.add(MediaType.WILDCARD_TYPE);
    }

    protected static class Match {
        MethodExpression expression;
        Matcher matcher;

        public Match(MethodExpression expression, Matcher matcher) {
            this.expression = expression;
            this.matcher = matcher;
        }
    }

    public static class SortFactor {
        public float q = 1.0f;
        public float qs = 1.0f;
        public int d;
        public int dm;
        public String type;
        public String subtype;
        public Map<String, String> params;

        public boolean isWildcardType() {
            return this.type.equals("*");
        }

        public boolean isWildcardSubtype() {
            return this.subtype.equals("*");
        }
    }

    protected class SortEntry
    implements Comparable<SortEntry> {
        Match match;
        MediaType serverProduce;
        SortFactor consumes;
        SortFactor produces;

        public SortEntry(Match match, SortFactor consumes, SortFactor produces, MediaType serverProduce) {
            this.serverProduce = serverProduce;
            this.match = match;
            this.consumes = consumes;
            this.produces = produces;
        }

        public MediaType getAcceptType() {
            HashMap<String, String> params = new HashMap<String, String>();
            for (Map.Entry entry : this.serverProduce.getParameters().entrySet()) {
                String name = (String)entry.getKey();
                if ("q".equals(name) || "qs".equals(name)) continue;
                params.put(name, (String)entry.getValue());
            }
            if (this.match.expression.invoker.hasProduces()) {
                params.put(SegmentNode.RESTEASY_SERVER_HAS_PRODUCES, "true");
            }
            return new MediaType(this.produces.type, this.produces.subtype, params);
        }

        @Override
        public int compareTo(SortEntry o) {
            if (this.consumes.isWildcardType() && !o.consumes.isWildcardType()) {
                return 1;
            }
            if (!this.consumes.isWildcardType() && o.consumes.isWildcardType()) {
                return -1;
            }
            if (this.consumes.isWildcardSubtype() && !o.consumes.isWildcardSubtype()) {
                return 1;
            }
            if (!this.consumes.isWildcardSubtype() && o.consumes.isWildcardSubtype()) {
                return -1;
            }
            if (this.consumes.q > o.consumes.q) {
                return -1;
            }
            if (this.consumes.q < o.consumes.q) {
                return 1;
            }
            if (this.consumes.qs > o.consumes.qs) {
                return -1;
            }
            if (this.consumes.qs < o.consumes.qs) {
                return 1;
            }
            if (this.consumes.d < o.consumes.d) {
                return -1;
            }
            if (this.consumes.d > o.consumes.d) {
                return 1;
            }
            if (this.consumes.dm < o.consumes.dm) {
                return -1;
            }
            if (this.consumes.dm > o.consumes.dm) {
                return 1;
            }
            if (this.produces.isWildcardType() && !o.produces.isWildcardType()) {
                return 1;
            }
            if (!this.produces.isWildcardType() && o.produces.isWildcardType()) {
                return -1;
            }
            if (this.produces.isWildcardSubtype() && !o.produces.isWildcardSubtype()) {
                return 1;
            }
            if (!this.produces.isWildcardSubtype() && o.produces.isWildcardSubtype()) {
                return -1;
            }
            if (this.produces.q > o.produces.q) {
                return -1;
            }
            if (this.produces.q < o.produces.q) {
                return 1;
            }
            if (this.produces.qs > o.produces.qs) {
                return -1;
            }
            if (this.produces.qs < o.produces.qs) {
                return 1;
            }
            if (this.produces.d < o.produces.d) {
                return -1;
            }
            if (this.produces.d > o.produces.d) {
                return 1;
            }
            if (this.produces.dm < o.produces.dm) {
                return -1;
            }
            if (this.produces.dm > o.produces.dm) {
                return 1;
            }
            return this.match.expression.compareTo(o.match.expression);
        }
    }
}

