/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.codec.BatchResult;
import org.osgi.jmx.framework.FrameworkMBean;

public class BatchActionResult
extends BatchResult {
    private long[] remainingItems;
    private long bundleInError;

    public BatchActionResult(long[] completedItems) {
        this.completed = completedItems;
        this.success = true;
    }

    public BatchActionResult(String error) {
        this.error = error;
        this.success = false;
    }

    public BatchActionResult(long[] completedItems, String error, long[] remainingItems, long bundleInError) {
        this(completedItems, error, remainingItems, false, bundleInError);
    }

    public BatchActionResult(long[] completedItems, String error, long[] remainingItems, boolean success, long bundleInError) {
        this.bundleInError = bundleInError;
        this.completed = completedItems;
        this.error = error;
        this.remainingItems = remainingItems;
        this.success = success;
    }

    public CompositeData toCompositeData() {
        try {
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("BundleInError", this.bundleInError);
            items.put("Completed", this.toLongArray(this.completed));
            items.put("Error", this.error);
            items.put("Remaining", this.toLongArray(this.remainingItems));
            items.put("Success", this.success);
            return new CompositeDataSupport(FrameworkMBean.BATCH_ACTION_RESULT_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData" + e);
        }
    }

    public static BatchActionResult from(CompositeData data) {
        if (data == null) {
            return null;
        }
        long bundleInError = (Long)data.get("BundleInError");
        long[] completedItems = BatchActionResult.toLongPrimitiveArray((Long[])data.get("Completed"));
        long[] remainingItems = BatchActionResult.toLongPrimitiveArray((Long[])data.get("Remaining"));
        String error = (String)data.get("Error");
        Boolean success = (Boolean)data.get("Success");
        return new BatchActionResult(completedItems, error, remainingItems, success, bundleInError);
    }

    public long[] getRemainingItems() {
        return this.remainingItems;
    }

    public long getBundleInError() {
        return this.bundleInError;
    }
}

