/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.DataProvider;
import io.openliberty.data.internal.persistence.EntityInfo;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import jakarta.data.exceptions.DataException;
import jakarta.data.exceptions.MappingException;
import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientConnectionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class EntityManagerBuilder {
    private static final TraceComponent tc = Tr.register(EntityManagerBuilder.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    Set<Class<?>> convertibleTypes;
    protected final String dataStore;
    protected final ConcurrentHashMap<Class<?>, CompletableFuture<EntityInfo>> entityInfoMap = new ConcurrentHashMap();
    public final DataProvider provider;
    protected final ClassLoader repositoryClassLoader;
    protected final Set<Class<?>> repositoryInterfaces;
    static final long serialVersionUID = -5577689605289022238L;

    @Trivial
    protected EntityManagerBuilder(DataProvider provider, ClassLoader repositoryClassLoader, Set<Class<?>> repositoryInterfaces, String dataStore) {
        this.provider = provider;
        this.repositoryClassLoader = repositoryClassLoader;
        this.repositoryInterfaces = repositoryInterfaces;
        this.dataStore = dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={Throwable.class})
    protected void collectEntityInfo(Set<Class<?>> entityTypes, Set<Class<?>> convertibleTypes) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.convertibleTypes = convertibleTypes;
        try (EntityManager em = this.createEntityManager();){
            HashSet missingEntityTypes = new HashSet(entityTypes);
            Metamodel model = em.getMetamodel();
            for (EntityType entityType : model.getEntities()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                HashMap<String, List<Member>> attributeAccessors = new HashMap<String, List<Member>>();
                TreeSet<String> attributeNamesForUpdate = new TreeSet<String>();
                TreeMap attributeTypes = new TreeMap();
                SortedMap<String, Member> idClassAttributeAccessors = null;
                HashMap collectionElementTypes = new HashMap();
                HashMap relationAttributeNames = new HashMap();
                LinkedList<Attribute> relationships = new LinkedList<Attribute>();
                LinkedList<Object> relationPrefixes = new LinkedList<Object>();
                LinkedList<List<Member>> relationAccessors = new LinkedList<List<Member>>();
                Class<?> recordClass = this.getRecordClass(entityType.getJavaType());
                Class idType = null;
                String versionAttrName = null;
                Class<?> jpaEntityClass = entityType.getJavaType();
                Class<?> userEntityClass = recordClass == null ? jpaEntityClass : recordClass;
                missingEntityTypes.remove(userEntityClass);
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("collecting info for " + userEntityClass.getName()), (Object[])new Object[0]);
                }
                try {
                    Set idClassAttributes;
                    Type<?> idClassType;
                    Attribute attr;
                    for (Attribute attr2 : entityType.getAttributes()) {
                        SingularAttribute singleAttr;
                        String attributeName = attr2.getName();
                        Attribute.PersistentAttributeType attributeType = attr2.getPersistentAttributeType();
                        switch (attributeType) {
                            case BASIC: 
                            case ELEMENT_COLLECTION: {
                                if (attributeNamesForUpdate == null) break;
                                attributeNamesForUpdate.add(attributeName);
                                break;
                            }
                            case ONE_TO_ONE: 
                            case MANY_TO_ONE: {
                                attributeNamesForUpdate = null;
                            }
                            case EMBEDDED: {
                                relationAttributeNames.put(attr2.getJavaType(), new ArrayList());
                                relationships.add(attr2);
                                relationPrefixes.add(attributeName);
                                relationAccessors.add(Collections.singletonList(attr2.getJavaMember()));
                                break;
                            }
                            case ONE_TO_MANY: 
                            case MANY_TO_MANY: {
                                attributeNamesForUpdate = null;
                                break;
                            }
                            default: {
                                throw new RuntimeException();
                            }
                        }
                        Member accessor = recordClass == null ? attr2.getJavaMember() : recordClass.getMethod(attributeName, new Class[0]);
                        hashMap.put(attributeName.toLowerCase(), attributeName);
                        attributeAccessors.put(attributeName, Collections.singletonList(accessor));
                        attributeTypes.put(attributeName, attr2.getJavaType());
                        if (attr2.isCollection()) {
                            if (!(attr2 instanceof PluralAttribute)) continue;
                            collectionElementTypes.put(attributeName, ((PluralAttribute)attr2).getElementType().getJavaType());
                            continue;
                        }
                        SingularAttribute singularAttribute = singleAttr = attr2 instanceof SingularAttribute ? (SingularAttribute)attr2 : null;
                        if (singleAttr != null && singleAttr.isId()) {
                            hashMap.put("id(this)", attributeName);
                            idType = singleAttr.getJavaType();
                            continue;
                        }
                        if (singleAttr != null && singleAttr.isVersion()) {
                            versionAttrName = attributeName;
                            continue;
                        }
                        if (!Collection.class.isAssignableFrom(attr2.getJavaType())) continue;
                        collectionElementTypes.put(attributeName, Object.class);
                    }
                    HashSet<Class> entityTypeClasses = new HashSet<Class>();
                    entityTypeClasses.add(entityType.getJavaType());
                    while ((attr = (Attribute)relationships.poll()) != null) {
                        String prefix = (String)relationPrefixes.poll();
                        List accessors = (List)relationAccessors.poll();
                        ManagedType relation = model.managedType(attr.getJavaType());
                        if (relation instanceof EntityType && !entityTypeClasses.add(attr.getJavaType())) break;
                        List relAttributeList = (List)relationAttributeNames.get(attr.getJavaType());
                        for (Attribute relAttr : relation.getAttributes()) {
                            String relationAttributeName = relAttr.getName();
                            String fullAttributeName = prefix + "." + relationAttributeName;
                            LinkedList<Member> relAccessors = new LinkedList<Member>(accessors);
                            relAccessors.add(relAttr.getJavaMember());
                            relAttributeList.add(fullAttributeName);
                            Attribute.PersistentAttributeType attributeType = relAttr.getPersistentAttributeType();
                            switch (attributeType) {
                                case BASIC: 
                                case ELEMENT_COLLECTION: {
                                    if (attributeNamesForUpdate == null) break;
                                    attributeNamesForUpdate.add(fullAttributeName);
                                    break;
                                }
                                case ONE_TO_ONE: 
                                case MANY_TO_ONE: {
                                    attributeNamesForUpdate = null;
                                }
                                case EMBEDDED: {
                                    relationAttributeNames.put(relAttr.getJavaType(), new ArrayList());
                                    relationships.add(relAttr);
                                    relationPrefixes.add(fullAttributeName);
                                    relationAccessors.add(relAccessors);
                                    break;
                                }
                                case ONE_TO_MANY: 
                                case MANY_TO_MANY: {
                                    attributeNamesForUpdate = null;
                                    break;
                                }
                                default: {
                                    throw new RuntimeException();
                                }
                            }
                            String fullAttributeNameLower = fullAttributeName.toLowerCase();
                            hashMap.put(fullAttributeNameLower, fullAttributeName);
                            String relationAttributeName_ = fullAttributeNameLower.replace('.', '_');
                            String conflictingAttribute = hashMap.putIfAbsent(relationAttributeName_, fullAttributeName);
                            if (conflictingAttribute != null) {
                                throw DataExtension.exc(MappingException.class, "CWWKD1075.entity.attr.conflict", userEntityClass.getName(), fullAttributeName, conflictingAttribute);
                            }
                            String relationAttributeNameUndelimited = fullAttributeNameLower.replace(".", "");
                            conflictingAttribute = hashMap.putIfAbsent(relationAttributeNameUndelimited, fullAttributeName);
                            if (conflictingAttribute != null && trace && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("overlapping undelimited name " + relationAttributeNameUndelimited + " will resolve to basic attribute " + conflictingAttribute + " instead of " + fullAttributeName), (Object[])new Object[0]);
                            }
                            attributeAccessors.put(fullAttributeName, relAccessors);
                            attributeTypes.put(fullAttributeName, relAttr.getJavaType());
                            if (relAttr.isCollection()) {
                                if (!(relAttr instanceof PluralAttribute)) continue;
                                collectionElementTypes.put(fullAttributeName, ((PluralAttribute)relAttr).getElementType().getJavaType());
                                continue;
                            }
                            if (!(relAttr instanceof SingularAttribute)) continue;
                            SingularAttribute singleAttr = (SingularAttribute)relAttr;
                            if (singleAttr.isId() && hashMap.putIfAbsent("id(this)", fullAttributeName) == null) {
                                idType = singleAttr.getJavaType();
                                continue;
                            }
                            if (!singleAttr.isVersion()) continue;
                            versionAttrName = relationAttributeName_;
                        }
                    }
                    String idAttrName = (String)hashMap.get("id(this)");
                    if (attributeNamesForUpdate != null) {
                        attributeNamesForUpdate.remove("id(this)");
                        if (idAttrName != null) {
                            attributeNamesForUpdate.remove(idAttrName);
                        }
                        if (versionAttrName != null) {
                            attributeNamesForUpdate.remove(versionAttrName);
                        }
                    }
                    if (!entityType.hasSingleIdAttribute() && (idClassType = EntityManagerBuilder.getIdType(entityType)) != null && (idClassAttributes = entityType.getIdClassAttributes()) != null) {
                        hashMap.remove("id(this)");
                        idType = idClassType.getJavaType();
                        idClassAttributeAccessors = EntityManagerBuilder.getIdClassAccessors(idType, idClassAttributes);
                    }
                    EntityInfo entityInfo = new EntityInfo(entityType.getName(), jpaEntityClass, recordClass, attributeAccessors, hashMap, attributeNamesForUpdate, attributeTypes, collectionElementTypes, relationAttributeNames, idType, idClassAttributeAccessors, versionAttrName, this);
                    this.entityInfoMap.computeIfAbsent(userEntityClass, EntityInfo::newFuture).complete(entityInfo);
                }
                catch (Throwable x) {
                    if (!(x instanceof DataException)) {
                        x = DataExtension.exc(CompletionException.class, "CWWKD1081.entity.general.err", userEntityClass.getName(), EntityManagerBuilder.getClassNames(this.repositoryInterfaces), this.dataStore, x.getMessage()).initCause(x);
                    }
                    this.entityInfoMap.computeIfAbsent(userEntityClass, EntityInfo::newFuture).completeExceptionally(x);
                }
            }
            if (!missingEntityTypes.isEmpty()) {
                DataException x = DataExtension.exc(DataException.class, "CWWKD1082.entity.classes.missing", this.dataStore, EntityManagerBuilder.getClassNames(missingEntityTypes), EntityManagerBuilder.getClassNames(this.repositoryInterfaces));
                for (Class clazz : missingEntityTypes) {
                    this.entityInfoMap.computeIfAbsent(clazz, EntityInfo::newFuture).completeExceptionally((Throwable)x);
                }
            }
        }
    }

    public abstract EntityManager createEntityManager();

    @Trivial
    public static final String getClassNames(Iterable<Class<?>> classes) {
        TreeSet<String> names = new TreeSet<String>();
        for (Class<?> c : classes) {
            names.add(c.getName());
        }
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (String name : names) {
            if (first) {
                s.append(name);
                first = false;
                continue;
            }
            s.append(", ").append(name);
        }
        return s.toString();
    }

    public abstract DataSource getDataSource(Method var1, Class<?> var2);

    @FFDCIgnore(value={NoSuchFieldException.class})
    private static final SortedMap<String, Member> getIdClassAccessors(Class<?> idType, Set<SingularAttribute<?, ?>> idClassAttributes) throws IntrospectionException, NoSuchFieldException, NoSuchMethodException, SecurityException {
        TreeMap<String, Member> accessors = new TreeMap<String, Member>();
        boolean isIdClassRecord = idType.isRecord();
        for (SingularAttribute<?, ?> attr : idClassAttributes) {
            AccessibleObject idClassMember;
            String entityAttrName;
            block6: {
                entityAttrName = attr.getName();
                idClassMember = null;
                if (isIdClassRecord) {
                    idClassMember = idType.getMethod(entityAttrName, new Class[0]);
                } else {
                    try {
                        idClassMember = idType.getField(entityAttrName);
                    }
                    catch (NoSuchFieldException x) {
                        for (PropertyDescriptor pd : Introspector.getBeanInfo(idType).getPropertyDescriptors()) {
                            if (!entityAttrName.equals(pd.getName())) continue;
                            idClassMember = pd.getReadMethod();
                            break;
                        }
                        if (idClassMember != null) break block6;
                        throw x;
                    }
                }
            }
            accessors.put(entityAttrName.toLowerCase(), (Member)((Object)idClassMember));
        }
        return accessors;
    }

    @Trivial
    protected Class<?> getRecordClass(Class<?> generatedEntityClass) {
        return null;
    }

    @Trivial
    @FFDCIgnore(value={RuntimeException.class})
    private static Type<?> getIdType(EntityType<?> entityType) {
        Type idType;
        try {
            idType = entityType.getIdType();
        }
        catch (RuntimeException x) {
            if ("ConversionException".equals(x.getClass().getSimpleName())) {
                idType = null;
            }
            throw x;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(entityType.getName() + " getIdType: " + String.valueOf(idType)), (Object[])new Object[0]);
        }
        return idType;
    }

    @Trivial
    protected ClassLoader getRepositoryClassLoader() {
        return this.repositoryClassLoader;
    }

    public void introspect(PrintWriter writer, String indent) {
        writer.println(indent + this.toString());
        writer.println(indent + "  dataStore: " + this.dataStore);
        writer.println(indent + "  repository class loader: " + String.valueOf(this.repositoryClassLoader));
        writer.println(indent + "  repositories:");
        for (Class<?> r : this.repositoryInterfaces) {
            writer.println(indent + "    " + r.getName());
        }
    }

    public boolean isConnectionError(SQLException cause) {
        return cause instanceof SQLRecoverableException || cause instanceof SQLNonTransientConnectionException || cause instanceof SQLTransientConnectionException;
    }
}

