/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class IndexUtils {
    private static final TraceComponent tc = Tr.register(IndexUtils.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    static final long serialVersionUID = -2303287153857385993L;

    public static Index getIndex(WebModuleInfo webModuleInfo, ModuleClassesContainerInfo moduleClassesContainerInfo, OpenApiConfig config) {
        long startTime = System.currentTimeMillis();
        Indexer indexer = new Indexer();
        FilteredIndexView filter = new FilteredIndexView(null, config);
        for (ContainerInfo ci : moduleClassesContainerInfo.getClassesContainerInfo()) {
            if (ci.getType() == ContainerInfo.Type.WEB_INF_CLASSES) {
                IndexUtils.indexContainer(ci.getContainer(), null, indexer, filter);
                continue;
            }
            if (ci.getType() != ContainerInfo.Type.WEB_INF_LIB || !IndexUtils.acceptJarForScanning(config, ci.getContainer().getName())) continue;
            IndexUtils.indexContainer(ci.getContainer(), null, indexer, filter);
        }
        Index index = indexer.complete();
        long endTime = System.currentTimeMillis();
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Index size: " + index.getKnownClasses().size()), (Object[])new Object[0]);
            Tr.event((TraceComponent)tc, (String)("Indexing elapsed time: " + (endTime - startTime)), (Object[])new Object[0]);
        }
        return index;
    }

    private static void indexContainer(Container container, String packageName, Indexer indexer, FilteredIndexView filter) {
        for (Entry entry : container) {
            String entryName = entry.getName();
            try {
                if (entryName.endsWith(".class")) {
                    int nameLength = entryName.length() - ".class".length();
                    String className = entryName.substring(0, nameLength);
                    String qualifiedName = packageName == null ? className : packageName + "." + className;
                    if (!IndexUtils.acceptClassForScanning(filter, qualifiedName)) continue;
                    InputStream is = (InputStream)entry.adapt(InputStream.class);
                    try {
                        indexer.index(is);
                        if (is == null) continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.openapi20.internal.utils.IndexUtils", (String)"98", null, (Object[])new Object[]{container, packageName, indexer, filter});
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                FFDCFilter.processException((Throwable)throwable2, (String)"io.openliberty.microprofile.openapi20.internal.utils.IndexUtils", (String)"98", null, (Object[])new Object[]{container, packageName, indexer, filter});
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                    continue;
                }
                Container entryContainer = (Container)entry.adapt(Container.class);
                if (entryContainer == null) continue;
                String entryPackageName = packageName == null ? entryContainer.getName() : packageName + "." + entryContainer.getName();
                IndexUtils.indexContainer(entryContainer, entryPackageName, indexer, filter);
            }
            catch (UnableToAdaptException | IOException throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.openapi20.internal.utils.IndexUtils", (String)"114", null, (Object[])new Object[]{container, packageName, indexer, filter});
            }
        }
    }

    private static boolean acceptClassForScanning(FilteredIndexView filter, String className) {
        boolean acceptClass = false;
        if (className != null && !className.isEmpty()) {
            acceptClass = filter.accepts(DotName.createSimple((String)className));
        }
        return acceptClass;
    }

    private static boolean acceptJarForScanning(OpenApiConfig config, String jarFileName) {
        boolean acceptJar = false;
        if (!config.scanDependenciesDisable()) {
            Set scanDependenciesJars = config.scanDependenciesJars();
            String nameOnly = new File(jarFileName).getName();
            if (scanDependenciesJars.isEmpty() || scanDependenciesJars.contains(nameOnly)) {
                acceptJar = true;
            }
        }
        return acceptJar;
    }
}

