/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.framework;

import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.lifecycle.SingletonsReady;
import com.ibm.ws.sib.jfapchannel.approxtime.QuickApproxTime;
import com.ibm.ws.sib.jfapchannel.framework.FrameworkException;
import com.ibm.ws.sib.jfapchannel.framework.NetworkTransportFactory;
import com.ibm.ws.sib.jfapchannel.impl.CommsClientServiceFacade;
import com.ibm.ws.sib.jfapchannel.richclient.framework.impl.RichClientFramework;
import com.ibm.ws.sib.jfapchannel.threadpool.ThreadPool;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.net.InetAddress;
import java.util.Map;

public abstract class Framework {
    private static String CLASS_NAME = Framework.class.getName();
    private static final TraceComponent tc = SibTr.register(Framework.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static Framework instance = null;
    private QuickApproxTime approxTimeImpl = null;
    private AlarmManager alarmManagerImpl = null;

    public static Framework getInstance() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInstance");
        }
        if (instance == null) {
            if (RuntimeInfo.isThinClient()) {
                try {
                    Class<?> clazz = Class.forName("com.ibm.ws.sib.jfapchannel.framework.impl.ThinClientFramework");
                    instance = (Framework)clazz.newInstance();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getInstance"), (String)"00250001", (Object)"com.ibm.ws.sib.jfapchannel.framework.impl.ThinClientFramework");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Unable to instantiate thin client framework", (Object)e);
                    }
                    throw new SIErrorException((Throwable)e);
                }
            }
            try {
                instance = new RichClientFramework();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getInstance"), (String)"00250002", (Object)RichClientFramework.class.getName());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Unable to instantiate rich client framework", (Object)e);
                }
                throw new SIErrorException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getInstance", (Object)instance);
        }
        return instance;
    }

    public QuickApproxTime getApproximateTimeKeeper() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getApproximateTimeKeeper");
        }
        if (this.approxTimeImpl == null) {
            if (RuntimeInfo.isThinClient()) {
                try {
                    Class<?> clazz = Class.forName("com.ibm.ws.sib.jfapchannel.approxtime.impl.ThinQuickApproxTimeImpl");
                    this.approxTimeImpl = (QuickApproxTime)clazz.newInstance();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getInstance"), (String)"00250005", (Object)"com.ibm.ws.sib.jfapchannel.approxtime.impl.ThinQuickApproxTimeImpl");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Unable to instantiate thin client approx time keeper", (Object)e);
                    }
                    throw new SIErrorException((Throwable)e);
                }
            }
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.sib.jfapchannel.richclient.approxtime.impl.RichQuickApproxTimeImpl");
                this.approxTimeImpl = (QuickApproxTime)clazz.newInstance();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getInstance"), (String)"00250006", (Object)"com.ibm.ws.sib.jfapchannel.richclient.approxtime.impl.RichQuickApproxTimeImpl");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Unable to instantiate rich client approx time keeper", (Object)e);
                }
                throw new SIErrorException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getApproximateTimeKeeper", (Object)this.approxTimeImpl);
        }
        return this.approxTimeImpl;
    }

    public ThreadPool getThreadPool(String threadPoolName, int minSize, int maxSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getThreadPool", (Object)new Object[]{threadPoolName, minSize, maxSize});
        }
        ThreadPool threadPool = null;
        if (RuntimeInfo.isThinClient()) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.sib.jfapchannel.threadpool.impl.ThinThreadPoolImpl");
                threadPool = (ThreadPool)clazz.newInstance();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getInstance"), (String)"00250003", (Object)"com.ibm.ws.sib.jfapchannel.threadpool.impl.ThinThreadPoolImpl");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Unable to instantiate thin client thread pool", (Object)e);
                }
                throw new SIErrorException((Throwable)e);
            }
        }
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.sib.jfapchannel.richclient.threadpool.impl.RichThreadPoolImpl");
            threadPool = (ThreadPool)clazz.newInstance();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getInstance"), (String)"00250004", (Object)"com.ibm.ws.sib.jfapchannel.richclient.threadpool.impl.RichThreadPoolImpl");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Unable to instantiate rich client thread pool", (Object)e);
            }
            throw new SIErrorException((Throwable)e);
        }
        threadPool.initialise(threadPoolName, minSize, maxSize);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getThreadPool", (Object)threadPool);
        }
        return threadPool;
    }

    public AlarmManager getAlarmManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAlarmManager");
        }
        if (this.alarmManagerImpl == null) {
            if (RuntimeInfo.isThinClient()) {
                try {
                    Class<?> clazz = Class.forName("com.ibm.ws.sib.jfapchannel.am.impl.ThinAlarmManagerImpl");
                    this.alarmManagerImpl = (AlarmManager)clazz.newInstance();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getInstance"), (String)"00250007", (Object)"com.ibm.ws.sib.jfapchannel.am.impl.ThinAlarmManagerImpl");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Unable to instantiate thin client alarm manager", (Object)e);
                    }
                    throw new SIErrorException((Throwable)e);
                }
            } else {
                this.alarmManagerImpl = ((CommsClientServiceFacade)SingletonsReady.requireService(CommsClientServiceFacade.class)).getAlarmManager();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAlarmManager", (Object)this.alarmManagerImpl);
        }
        return this.alarmManagerImpl;
    }

    public abstract NetworkTransportFactory getNetworkTransportFactory();

    public abstract Map getOutboundConnectionProperties(String var1);

    public abstract Map getOutboundConnectionProperties(Object var1);

    public abstract Object prepareOutboundConnection(Object var1) throws FrameworkException;

    public abstract InetAddress getHostAddress(Object var1);

    public abstract int getHostPort(Object var1);

    public abstract boolean areEndPointsEqual(Object var1, Object var2);

    public abstract int getEndPointHashCode(Object var1);

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client/src/com/ibm/ws/sib/jfapchannel/framework/Framework.java, SIB.comms, WASX.SIB, uu1215.01 1.6");
        }
    }
}

