/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry20.logging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MpTelemetryAuditEventMappingUtils {
    private static final String[][] AUDIT_EVENT_TABLE;
    private static final String[][] AUDIT_OBSERVER_TABLE;
    private static final String[][] AUDIT_TARGET_TABLE;
    private static final String[][] AUDIT_TARGET_MESSAGING_TABLE;
    private static final String[][] AUDIT_TARGET_JMX_TABLE;
    private static final String[][] AUDIT_INITIATOR_TABLE;
    private static final String[][] AUDIT_REASON_TABLE;
    private static final int AUDIT_TYPE_FIELD_INDEX = 0;
    private static final int OTEL_AUDIT_TYPE_FIELD_INDEX = 1;
    static final long serialVersionUID = 6165199656941840577L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String getOTelMappedAuditEventKeyName(String auditKey) {
        String formattedAuditKey = MpTelemetryAuditEventMappingUtils.getFormattedAuditEventKey(auditKey);
        StringBuffer sb = new StringBuffer();
        sb.append("io.openliberty.");
        sb.append("audit.");
        sb.append(formattedAuditKey);
        return sb.toString();
    }

    private static String getFormattedAuditEventKey(String auditKey) {
        String[][] auditTable = MpTelemetryAuditEventMappingUtils.getAuditTypeTableFromKey(auditKey);
        String formattedKey = null;
        if (auditTable != null) {
            for (String[] field : auditTable) {
                if (!field[0].equals(auditKey)) continue;
                formattedKey = field[1];
                break;
            }
        }
        if (formattedKey == null) {
            formattedKey = auditKey;
        }
        return formattedKey;
    }

    private static String[][] getAuditTypeTableFromKey(String auditKey) {
        if (auditKey.startsWith("event")) {
            return AUDIT_EVENT_TABLE;
        }
        if (auditKey.startsWith("observer")) {
            return AUDIT_OBSERVER_TABLE;
        }
        if (auditKey.startsWith("target")) {
            if (auditKey.contains("target.messaging")) {
                return AUDIT_TARGET_MESSAGING_TABLE;
            }
            if (auditKey.contains("target.jmx")) {
                return AUDIT_TARGET_JMX_TABLE;
            }
            return AUDIT_TARGET_TABLE;
        }
        if (auditKey.startsWith("initiator")) {
            return AUDIT_INITIATOR_TABLE;
        }
        if (auditKey.startsWith("reason")) {
            return AUDIT_REASON_TABLE;
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry20.logging.internal.MpTelemetryAuditEventMappingUtils", MpTelemetryAuditEventMappingUtils.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        AUDIT_EVENT_TABLE = new String[][]{{"eventName", "event_name"}, {"eventSequenceNumber", "event_sequence_number"}};
        AUDIT_OBSERVER_TABLE = new String[][]{{"observer.typeURI", "observer.type_uri"}};
        AUDIT_TARGET_TABLE = new String[][]{{"target.typeURI", "target.type_uri"}, {"target.repositoryId", "target.repository_id"}, {"target.uniqueName", "target.unique_name"}, {"target.entityType", "target.entity_type"}, {"target.extendedProperties", "target.extended_properties"}, {"target.applicationId", "target.application_id"}, {"target.tokenId", "target.token_id"}, {"target.clientId", "target.client_id"}, {"target.initiatorRole", "target.initiator_role"}, {"target.numberRevoked", "target.number_revoked"}, {"target.userId", "target.user_id"}};
        AUDIT_TARGET_MESSAGING_TABLE = new String[][]{{"target.messaging.loginType", "target.messaging.login_type"}, {"target.messaging.remote.chainName", "target.messaging.remote.chain_name"}, {"target.messaging.userName", "target.messaging.user_name"}, {"target.messaging.operationType", "target.messaging.operation_type"}, {"target.messaging.callType", "target.messaging.call_type"}, {"target.messaging.jmsResource", "target.messaging.jms_resource"}, {"target.messaging.jmsActions", "target.messaging.jms_actions"}, {"target.messaging.jmsRoles", "target.messaging.jms_roles"}, {"target.messaging.jmsRequestorType", "target.messaging.jms_requestor_type"}, {"target.messaging.queuePermissions", "target.messaging.queue_permissions"}, {"target.messaging.topicPermissions", "target.messaging.topic_permissions"}, {"target.messaging.tempDestinationPermissions", "target.messaging.temp_destination_permissions"}};
        AUDIT_TARGET_JMX_TABLE = new String[][]{{"target.jmx.mbean.queryExp", "target.jmx.mbean.query_exp"}};
        AUDIT_INITIATOR_TABLE = new String[][]{{"initiator.typeURI", "initiator.type_uri"}};
        AUDIT_REASON_TABLE = new String[][]{{"reason.reasonCode", "reason.reason_code"}, {"reason.reasonType", "reason.reason_type"}};
    }
}

