/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.jasper.el.ELContextImpl;
import org.apache.jasper.el.ExpressionEvaluatorImpl;
import org.apache.jasper.el.FunctionMapperImpl;
import org.apache.jasper.el.VariableResolverImpl;
import org.apache.jasper.runtime.BodyContentImpl;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspWriterImpl;
import org.apache.jasper.runtime.ProtectedFunctionMapper;
import org.apache.jasper.runtime.ServletResponseWrapperInclude;

public class PageContextImpl
extends PageContext {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "org.apache.jasper.runtime.PageContextImpl";
    private VariableResolver variableResolver;
    private BodyContentImpl[] outs;
    private int depth;
    private Servlet servlet;
    private ServletConfig config;
    private ServletContext context;
    private JspFactory factory;
    private JspApplicationContextImpl applicationContext;
    private boolean needsSession;
    private String errorPageURL;
    private boolean autoFlush;
    private int bufferSize;
    private int bodyContentBufferSize;
    private transient HashMap attributes;
    private transient ServletRequest request;
    private transient ServletResponse response;
    private transient Object page;
    private transient HttpSession session;
    private boolean isIncluded;
    private transient ELContextImpl elContext;
    private transient JspWriter out;
    private transient JspWriterImpl baseOut;
    private boolean wasReleased = false;
    private boolean alreadyInitialized = false;

    PageContextImpl(JspFactory factory) {
        this(factory, 512);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "PageContextImpl", "PageContextImpl ctor 1 buffsize=[512]  this=[" + (Object)((Object)this) + "]");
        }
    }

    PageContextImpl(JspFactory factory, int bodyContentBufferSize) {
        this.factory = factory;
        this.outs = new BodyContentImpl[0];
        this.attributes = new HashMap(16);
        this.depth = -1;
        this.bodyContentBufferSize = bodyContentBufferSize;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "PageContextImpl", "PageContextImpl ctor 2 buffsize=[" + this.bodyContentBufferSize + "]  this=[" + (Object)((Object)this) + "]");
        }
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException {
        this._initialize(servlet, request, response, errorPageURL, needsSession, bufferSize, autoFlush);
    }

    private void _initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException {
        this.wasReleased = false;
        if (this.alreadyInitialized) {
            logger.logp(Level.SEVERE, CLASS_NAME, "initialize", "jsp.error.pageContext.multipleInitOrRelease");
        }
        this.servlet = servlet;
        this.config = servlet.getServletConfig();
        this.context = this.config.getServletContext();
        this.needsSession = needsSession;
        this.errorPageURL = errorPageURL;
        this.bufferSize = bufferSize;
        this.autoFlush = autoFlush;
        this.request = request;
        this.response = response;
        this.applicationContext = JspApplicationContextImpl.getInstance(this.context);
        if (request instanceof HttpServletRequest && needsSession) {
            this.session = ((HttpServletRequest)request).getSession();
        }
        if (needsSession && this.session == null) {
            throw new IllegalStateException("Page needs a session and none is available");
        }
        this.depth = -1;
        if (this.baseOut == null) {
            this.baseOut = this._createOut(bufferSize, autoFlush);
        } else {
            this.baseOut.init(response, bufferSize, autoFlush);
        }
        this.out = this.baseOut;
        if (this.out == null) {
            throw new IllegalStateException("failed initialize JspWriter");
        }
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        this.setAttribute("javax.servlet.jsp.jspRequest", request);
        this.setAttribute("javax.servlet.jsp.jspResponse", response);
        if (this.session != null) {
            this.setAttribute("javax.servlet.jsp.jspSession", this.session);
        }
        this.setAttribute("javax.servlet.jsp.jspPage", servlet);
        this.setAttribute("javax.servlet.jsp.jspConfig", this.config);
        this.setAttribute("javax.servlet.jsp.jspPageContext", (Object)this);
        this.setAttribute("javax.servlet.jsp.jspApplication", this.context);
        this.isIncluded = request.getAttribute("javax.servlet.include.servlet_path") != null;
        this.alreadyInitialized = true;
    }

    public void release() {
        block4: {
            if (this.wasReleased) {
                logger.logp(Level.SEVERE, CLASS_NAME, "release", "jsp.error.pageContext.multipleInitOrRelease");
            }
            this.out = this.baseOut;
            try {
                ((JspWriterImpl)this.out).flushBuffer();
            }
            catch (IOException ex) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) break block4;
                logger.logp(Level.WARNING, CLASS_NAME, "release", "failed to flush response buffer during PageContext.release().", ex);
            }
        }
        this.servlet = null;
        this.config = null;
        this.context = null;
        this.needsSession = false;
        this.errorPageURL = null;
        this.bufferSize = -1;
        this.autoFlush = true;
        this.request = null;
        this.response = null;
        this.depth = -1;
        this.session = null;
        this.applicationContext = null;
        this.elContext = null;
        this.attributes.clear();
        for (BodyContentImpl body : this.outs) {
            body.recycle();
        }
        this.baseOut.recycle(((JspFactoryImpl)this.factory).poolFreePageContextIfNotFull(this));
        this.wasReleased = true;
        this.alreadyInitialized = false;
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        return this.attributes.get(name);
    }

    public Object getAttribute(String name, int scope) {
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        switch (scope) {
            case 1: {
                return this.attributes.get(name);
            }
            case 2: {
                return this.request.getAttribute(name);
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException("jsp.error.page.noSession");
                }
                return this.session.getAttribute(name);
            }
            case 4: {
                return this.context.getAttribute(name);
            }
        }
        throw new IllegalArgumentException("Invalid scope");
    }

    public void setAttribute(String name, Object attribute) {
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        if (attribute != null) {
            this.attributes.put(name, attribute);
        } else {
            this.removeAttribute(name, 1);
        }
    }

    public void setAttribute(String name, Object o, int scope) {
        block9: {
            block8: {
                if (name == null) {
                    throw new NullPointerException("Null name");
                }
                if (o == null) break block8;
                switch (scope) {
                    case 1: {
                        this.attributes.put(name, o);
                        break block9;
                    }
                    case 2: {
                        this.request.setAttribute(name, o);
                        break block9;
                    }
                    case 3: {
                        if (this.session == null) {
                            throw new IllegalStateException("jsp.error.page.noSession");
                        }
                        this.session.setAttribute(name, o);
                        break block9;
                    }
                    case 4: {
                        this.context.setAttribute(name, o);
                        break block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid scope");
                    }
                }
            }
            this.removeAttribute(name, scope);
        }
    }

    public void removeAttribute(String name, int scope) {
        if (name == null) {
            throw new NullPointerException("jsp.error.attribute.null_name");
        }
        switch (scope) {
            case 1: {
                this.attributes.remove(name);
                break;
            }
            case 2: {
                this.request.removeAttribute(name);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException("jsp.error.page.noSession");
                }
                this.session.removeAttribute(name);
                break;
            }
            case 4: {
                this.context.removeAttribute(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope");
            }
        }
    }

    public int getAttributesScope(String name) {
        block8: {
            if (name == null) {
                throw new NullPointerException("jsp.error.attribute.null_name");
            }
            if (this.attributes.get(name) != null) {
                return 1;
            }
            if (this.request.getAttribute(name) != null) {
                return 2;
            }
            if (this.session != null) {
                try {
                    if (this.session.getAttribute(name) != null) {
                        return 3;
                    }
                }
                catch (IllegalStateException ex) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block8;
                    logger.logp(Level.FINE, CLASS_NAME, "PageContextImpl", "The session was invalid and method getAttributesScope(String name) was called.", ex);
                }
            }
        }
        if (this.context.getAttribute(name) != null) {
            return 4;
        }
        return 0;
    }

    public Object findAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("jsp.error.attribute.null_name");
        }
        Object o = this.attributes.get(name);
        if (o != null) {
            return o;
        }
        o = this.request.getAttribute(name);
        if (o != null) {
            return o;
        }
        if (this.session != null) {
            block7: {
                try {
                    o = this.session.getAttribute(name);
                }
                catch (IllegalStateException ex) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block7;
                    logger.logp(Level.FINE, CLASS_NAME, "PageContextImpl", "The session was invalid and method findAttribute(String name) was called.", ex);
                }
            }
            if (o != null) {
                return o;
            }
        }
        return this.context.getAttribute(name);
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                return Collections.enumeration(this.attributes.keySet());
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException("jsp.error.page.noSession");
                }
                return this.session.getAttributeNames();
            }
            case 4: {
                return this.context.getAttributeNames();
            }
        }
        throw new IllegalArgumentException("Invalid scope");
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("jsp.error.attribute.null_name");
        }
        try {
            block6: {
                this.removeAttribute(name, 1);
                this.removeAttribute(name, 2);
                if (this.session != null) {
                    try {
                        this.removeAttribute(name, 3);
                    }
                    catch (IllegalStateException ex) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block6;
                        logger.logp(Level.FINE, CLASS_NAME, "PageContextImpl", "The session was invalid and method removeAttribute(String name) was called.", ex);
                    }
                }
            }
            this.removeAttribute(name, 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JspWriter getOut() {
        return this.out;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        return (Exception)this.request.getAttribute("javax.servlet.jsp.jspException");
    }

    public Object getPage() {
        return this.servlet;
    }

    private final String getAbsolutePathRelativeToContext(String relativeUrlPath) {
        String path = relativeUrlPath;
        if (!path.startsWith("/")) {
            String uri = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
            if (uri == null) {
                uri = ((HttpServletRequest)this.request).getServletPath();
            }
            String baseURI = uri.substring(0, uri.lastIndexOf(47));
            path = baseURI + '/' + path;
        }
        return path;
    }

    public void include(String relativeUrlPath) throws ServletException, IOException {
        JspRuntimeLibrary.include(this.request, this.response, relativeUrlPath, (Writer)this.out, true);
    }

    public void include(String relativeUrlPath, boolean flush) throws ServletException, IOException {
        JspRuntimeLibrary.include(this.request, this.response, relativeUrlPath, (Writer)this.out, flush);
    }

    public VariableResolver getVariableResolver() {
        return new VariableResolverImpl(this.getELContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(String relativeUrlPath) throws ServletException, IOException {
        try {
            this.out.clear();
        }
        catch (IOException ex) {
            throw new IllegalStateException("jsp.error.attempt_to_clear_flushed_buffer");
        }
        while (this.response instanceof ServletResponseWrapperInclude) {
            this.response = ((ServletResponseWrapperInclude)this.response).getResponse();
        }
        String path = this.getAbsolutePathRelativeToContext(relativeUrlPath);
        String includeUri = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
        ServletResponse fresponse = this.response;
        ServletRequest frequest = this.request;
        if (includeUri != null) {
            this.request.removeAttribute("javax.servlet.include.servlet_path");
        }
        try {
            this.context.getRequestDispatcher(path).forward(this.request, this.response);
        }
        finally {
            if (includeUri != null) {
                this.request.setAttribute("javax.servlet.include.servlet_path", (Object)includeUri);
            }
            this.request.setAttribute("javax.servlet.forward.seen", (Object)"true");
        }
    }

    public BodyContent pushBody() {
        return (BodyContent)this.pushBody(null);
    }

    public JspWriter pushBody(Writer writer) {
        ++this.depth;
        if (this.depth >= this.outs.length) {
            BodyContentImpl[] newOuts = new BodyContentImpl[this.depth + 1];
            for (int i = 0; i < this.outs.length; ++i) {
                newOuts[i] = this.outs[i];
            }
            newOuts[this.depth] = new BodyContentImpl(this.out, this.bodyContentBufferSize);
            this.outs = newOuts;
        }
        this.outs[this.depth].setWriter(writer);
        this.out = this.outs[this.depth];
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        return this.outs[this.depth];
    }

    public JspWriter popBody() {
        --this.depth;
        this.out = this.depth >= 0 ? this.outs[this.depth] : this.baseOut;
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        return this.out;
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return new ExpressionEvaluatorImpl(this.applicationContext.getExpressionFactory());
    }

    public void handlePageException(Exception ex) throws IOException, ServletException {
        this.handlePageException((Throwable)ex);
    }

    public void handlePageException(Throwable t) throws IOException, ServletException {
        if (t == null) {
            throw new NullPointerException("null Throwable");
        }
        if (this.errorPageURL != null && !this.errorPageURL.equals("")) {
            this.request.setAttribute("javax.servlet.jsp.jspException", (Object)t);
            this.request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
            this.request.setAttribute("javax.servlet.error.request_uri", (Object)((HttpServletRequest)this.request).getRequestURI());
            this.request.setAttribute("javax.servlet.error.servlet_name", (Object)this.config.getServletName());
            try {
                this.forward(this.errorPageURL);
            }
            catch (IllegalStateException ise) {
                this.include(this.errorPageURL);
            }
            Object newException = this.request.getAttribute("javax.servlet.error.exception");
            if (newException != null && newException == t) {
                this.request.removeAttribute("javax.servlet.error.exception");
            }
        } else {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            Throwable rootCause = null;
            if (t instanceof JspException) {
                rootCause = ((JspException)t).getRootCause();
            } else if (t instanceof ELException) {
                rootCause = ((ELException)t).getRootCause();
            }
            if (rootCause != null) {
                throw new ServletErrorReport(t.getMessage(), rootCause);
            }
            throw new ServletErrorReport(t);
        }
        this.request.removeAttribute("javax.servlet.error.status_code");
        this.request.removeAttribute("javax.servlet.error.request_uri");
        this.request.removeAttribute("javax.servlet.error.status_code");
        this.request.removeAttribute("javax.servlet.jsp.jspException");
    }

    private static String XmlEscape(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\'') {
                sb.append("&#039;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&#034;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Object proprietaryEvaluate(String expression, Class expectedType, PageContext pageContext, ProtectedFunctionMapper functionMap, boolean escape) throws ELException {
        ExpressionFactory exprFactorySetInPageContext = (ExpressionFactory)pageContext.getAttribute("_jspx_ExpressionFactoryImplObject");
        if (exprFactorySetInPageContext == null) {
            exprFactorySetInPageContext = JspFactory.getDefaultFactory().getJspApplicationContext(pageContext.getServletContext()).getExpressionFactory();
        }
        ExpressionFactory exprFactory = exprFactorySetInPageContext;
        ELContextImpl ctx = (ELContextImpl)pageContext.getELContext();
        ctx.setFunctionMapper(new FunctionMapperImpl(functionMap));
        ValueExpression ve = exprFactory.createValueExpression((ELContext)ctx, expression, expectedType);
        Object retValue = ve.getValue((ELContext)ctx);
        if (escape && retValue != null) {
            retValue = PageContextImpl.XmlEscape(retValue.toString());
        }
        return retValue;
    }

    private JspWriterImpl _createOut(int bufferSize, boolean autoFlush) throws IOException {
        try {
            return new JspWriterImpl(this.response, bufferSize, autoFlush);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public ELContext getELContext() {
        if (this.elContext == null) {
            this.elContext = this.applicationContext.createELContext((JspContext)this);
        }
        return this.elContext;
    }
}

