/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.message;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.genericbnf.internal.BNFHeadersImpl;
import com.ibm.ws.http.netty.message.NettyHeader;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpTrailerGenerator;
import com.ibm.wsspi.http.channel.HttpTrailers;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class NettyTrailers
implements HttpTrailers {
    private final HttpHeaders trailers;
    private transient Map<String, HttpTrailerGenerator> knownTGs = new HashMap<String, HttpTrailerGenerator>();
    static final long serialVersionUID = 997093925952373908L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public NettyTrailers(HttpHeaders trailers) {
        this.trailers = trailers;
    }

    @Override
    public void setDebugContext(Object o) {
        throw new UnsupportedOperationException("setDebugContext cannot be called under a Netty perspective");
    }

    @Override
    public HeaderField getHeader(String name) {
        if (Objects.isNull(name)) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (this.trailers.contains(name)) {
            return new NettyHeader(name, this.trailers.get(name));
        }
        return BNFHeadersImpl.NULL_HEADER;
    }

    @Override
    public HeaderField getHeader(byte[] name) {
        if (Objects.isNull(name)) {
            throw new IllegalArgumentException("Null input provided");
        }
        String nameString = new String(name);
        if (this.trailers.contains(nameString)) {
            return new NettyHeader(nameString, this.trailers.get(nameString));
        }
        return BNFHeadersImpl.NULL_HEADER;
    }

    @Override
    public HeaderField getHeader(HeaderKeys name) {
        if (Objects.isNull(name)) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (this.trailers.contains(name.getName())) {
            return new NettyHeader(name.getName(), this.trailers.get(name.getName()));
        }
        return BNFHeadersImpl.NULL_HEADER;
    }

    @Override
    public List<HeaderField> getHeaders(String name) {
        if (Objects.isNull(name)) {
            throw new IllegalArgumentException("Null input provided");
        }
        List values = this.trailers.getAll(name);
        ArrayList<HeaderField> trailerHeaderList = new ArrayList<HeaderField>(values.size());
        for (String value : values) {
            trailerHeaderList.add(new NettyHeader(name, value));
        }
        return trailerHeaderList;
    }

    @Override
    public List<HeaderField> getHeaders(byte[] name) {
        if (Objects.isNull(name)) {
            throw new IllegalArgumentException("Null input provided");
        }
        String nameString = new String(name);
        List values = this.trailers.getAll(nameString);
        ArrayList<HeaderField> trailerHeaderList = new ArrayList<HeaderField>(values.size());
        for (String value : values) {
            trailerHeaderList.add(new NettyHeader(nameString, value));
        }
        return trailerHeaderList;
    }

    @Override
    public List<HeaderField> getHeaders(HeaderKeys name) {
        if (Objects.isNull(name)) {
            throw new IllegalArgumentException("Null input provided");
        }
        List values = this.trailers.getAll(name.getName());
        ArrayList<HeaderField> trailerHeaderList = new ArrayList<HeaderField>(values.size());
        for (String value : values) {
            trailerHeaderList.add(new NettyHeader(name.getName(), value));
        }
        return trailerHeaderList;
    }

    @Override
    public List<HeaderField> getAllHeaders() {
        ArrayList<HeaderField> trailerList = new ArrayList<HeaderField>(this.trailers.size());
        for (Map.Entry header : this.trailers) {
            trailerList.add(new NettyHeader((String)header.getKey(), (String)header.getValue()));
        }
        return trailerList;
    }

    @Override
    public List<String> getAllHeaderNames() {
        return new ArrayList<String>(this.trailers.names());
    }

    @Override
    public Set<String> getAllHeaderNamesSet() {
        return this.trailers.names();
    }

    @Override
    public void appendHeader(byte[] header, byte[] value) {
        if (Objects.isNull(header) || Objects.isNull(value)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.add(new String(header), (Object)value);
    }

    @Override
    public void appendHeader(byte[] header, byte[] value, int offset, int length) {
        throw new UnsupportedOperationException("appendHeader with offset not supported yet!!");
    }

    @Override
    public void appendHeader(byte[] header, String value) {
        if (Objects.isNull(header) || Objects.isNull(value)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.add(new String(header), (Object)value);
    }

    @Override
    public void appendHeader(HeaderKeys header, byte[] value) {
        if (Objects.isNull(header) || Objects.isNull(value)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.add(header.getName(), (Object)value);
    }

    @Override
    public void appendHeader(HeaderKeys header, byte[] value, int offset, int length) {
        throw new UnsupportedOperationException("appendHeader with offset not supported yet!!");
    }

    @Override
    public void appendHeader(HeaderKeys header, String value) {
        if (Objects.isNull(header) || Objects.isNull(value)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.add(header.getName(), (Object)value);
    }

    @Override
    public void appendHeader(String header, byte[] value) {
        if (Objects.isNull(header) || Objects.isNull(value)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.add(header, (Object)value);
    }

    @Override
    public void appendHeader(String header, byte[] value, int offset, int length) {
        throw new UnsupportedOperationException("appendHeader with offset not supported yet!!");
    }

    @Override
    public void appendHeader(String header, String value) {
        if (Objects.isNull(header) || Objects.isNull(value)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.add(header, (Object)value);
    }

    @Override
    public int getNumberOfHeaderInstances(String header) {
        if (Objects.isNull(header)) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.trailers.getAll(header).size();
    }

    @Override
    public boolean containsHeader(byte[] header) {
        if (Objects.isNull(header)) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.trailers.contains(new String(header));
    }

    @Override
    public boolean containsHeader(HeaderKeys header) {
        if (Objects.isNull(header)) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.trailers.contains(header.getName());
    }

    @Override
    public boolean containsHeader(String header) {
        if (Objects.isNull(header)) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.trailers.contains(header);
    }

    @Override
    public int getNumberOfHeaderInstances(byte[] header) {
        if (Objects.isNull(header)) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.trailers.getAll(new String(header)).size();
    }

    @Override
    public int getNumberOfHeaderInstances(HeaderKeys header) {
        if (Objects.isNull(header)) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.trailers.getAll(header.getName()).size();
    }

    @Override
    public void removeHeader(byte[] header) {
        if (Objects.isNull(header)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.remove(new String(header));
    }

    @Override
    public void removeHeader(byte[] header, int instance) {
        throw new UnsupportedOperationException("removeHeader with instance not supported yet!!");
    }

    @Override
    public void removeHeader(HeaderKeys header) {
        if (Objects.isNull(header)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.remove(header.getName());
    }

    @Override
    public void removeHeader(HeaderKeys header, int instance) {
        throw new UnsupportedOperationException("removeHeader with instance not supported yet!!");
    }

    @Override
    public void removeHeader(String header) {
        if (Objects.isNull(header)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.remove(header);
    }

    @Override
    public void removeHeader(String header, int instance) {
        throw new UnsupportedOperationException("removeHeader with instance not supported yet!!");
    }

    @Override
    public void removeAllHeaders() {
        this.trailers.clear();
    }

    @Override
    public void setHeader(byte[] header, byte[] value) {
        if (Objects.isNull(header) || Objects.isNull(value)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.set(new String(header), (Object)value);
    }

    @Override
    public void setHeader(byte[] header, byte[] value, int offset, int length) {
        throw new UnsupportedOperationException("removeHeader with offset not supported yet!!");
    }

    @Override
    public void setHeader(byte[] header, String value) {
        if (Objects.isNull(header) || Objects.isNull(value)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.set(new String(header), (Object)value);
    }

    @Override
    public void setHeader(HeaderKeys header, byte[] value) {
        if (Objects.isNull(header) || Objects.isNull(value)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.set(header.getName(), (Object)value);
    }

    @Override
    public void setHeader(HeaderKeys header, byte[] value, int offset, int length) {
        throw new UnsupportedOperationException("removeHeader with offset not supported yet!!");
    }

    @Override
    public void setHeader(HeaderKeys header, String value) {
        if (Objects.isNull(header) || Objects.isNull(value)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.set(header.getName(), (Object)value);
    }

    @Override
    public HeaderField setHeaderIfAbsent(HeaderKeys header, String value) {
        if (Objects.isNull(header) || Objects.isNull(value)) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (!this.trailers.contains(header.getName())) {
            this.trailers.set(header.getName(), (Object)value);
        }
        return new NettyHeader(header.getName(), this.trailers);
    }

    @Override
    public void setHeader(String header, byte[] value) {
        if (Objects.isNull(header) || Objects.isNull(value)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.set(header, (Object)value);
    }

    @Override
    public void setHeader(String header, byte[] value, int offset, int length) {
        throw new UnsupportedOperationException("removeHeader with offset not supported yet!!");
    }

    @Override
    public void setHeader(String header, String value) {
        if (Objects.isNull(header) || Objects.isNull(value)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.trailers.set(header, (Object)value);
    }

    @Override
    public void setLimitOnNumberOfHeaders(int number) {
        throw new UnsupportedOperationException("setLimitOnNumberOfHeaders not supported yet!!");
    }

    @Override
    public int getLimitOnNumberOfHeaders() {
        throw new UnsupportedOperationException("getLimitOnNumberOfHeaders not supported yet!!");
    }

    @Override
    public void setLimitOfTokenSize(int size) {
        throw new UnsupportedOperationException("setLimitOfTokenSize not supported yet!!");
    }

    @Override
    public int getLimitOfTokenSize() {
        throw new UnsupportedOperationException("getLimitOfTokenSize not supported yet!!");
    }

    @Override
    public boolean containsDeferredTrailer(String target) {
        if (Objects.isNull(target)) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.knownTGs.containsKey(target);
    }

    @Override
    public boolean containsDeferredTrailer(HeaderKeys target) {
        if (Objects.isNull(target)) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.knownTGs.containsKey(target.getName());
    }

    @Override
    public void setDeferredTrailer(HeaderKeys hdr, HttpTrailerGenerator htg) {
        if (Objects.isNull(hdr) || Objects.isNull(htg)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.knownTGs.put(hdr.getName(), htg);
    }

    @Override
    public void setDeferredTrailer(String hdr, HttpTrailerGenerator htg) {
        if (Objects.isNull(hdr) || Objects.isNull(htg)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.knownTGs.put(hdr, htg);
    }

    @Override
    public void removeDeferredTrailer(String hdr) {
        if (Objects.isNull(hdr)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.knownTGs.remove(hdr);
    }

    @Override
    public void removeDeferredTrailer(HeaderKeys hdr) {
        if (Objects.isNull(hdr)) {
            throw new IllegalArgumentException("Null input provided");
        }
        this.knownTGs.remove(hdr.getName());
    }

    @Override
    public void computeRemainingTrailers() {
        for (String key : this.knownTGs.keySet()) {
            this.setHeader(key, new String(this.knownTGs.get(key).generateTrailerValue(key, (HttpTrailers)this)));
        }
    }

    @Override
    public void clear() {
        this.trailers.clear();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.message.NettyTrailers", NettyTrailers.class, null, null);
    }
}

