/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.http.HttpSessionAttributeObserver;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.IProtocolAdapter;
import com.ibm.wsspi.session.ISession;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingEvent;
import java.util.ArrayList;
import java.util.logging.Level;

public class WasHttpAppSessionAttributeObserver
extends HttpSessionAttributeObserver {
    private static final String methodClassName = "WasHttpAppSessionAttributeObserver";

    public WasHttpAppSessionAttributeObserver(ArrayList listeners, IProtocolAdapter adapter) {
        super(listeners, adapter);
    }

    @Override
    public void sessionAttributeSet(ISession session, Object name, Object oldValue, Boolean oldIsListener, Object newValue, Boolean newIsListener) {
        HttpSession httpsession = (HttpSession)this._adapter.adapt(session);
        HttpSessionBindingEvent addEvent = null;
        HttpSessionBindingEvent replaceEvent = null;
        HttpSessionAttributeListener listener = null;
        for (int i = 0; i < this._sessionAttributeListeners.size(); ++i) {
            listener = (HttpSessionAttributeListener)this._sessionAttributeListeners.get(i);
            if (oldValue != null) {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionAttrSet", "Calling attributeReplace on listener:" + listener);
                }
                if (replaceEvent == null) {
                    replaceEvent = new HttpSessionBindingEvent(httpsession, (String)name, oldValue);
                }
                listener.attributeReplaced(replaceEvent);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionAttrSet", "Calling attributeCreated on listener:" + listener);
            }
            if (addEvent == null) {
                addEvent = new HttpSessionBindingEvent(httpsession, (String)name, newValue);
            }
            listener.attributeAdded(addEvent);
        }
    }

    @Override
    public void sessionAttributeRemoved(ISession session, Object name, Object value, Boolean oldIsBindingListener) {
        HttpSessionAttributeListener listener = null;
        HttpSessionBindingEvent event = null;
        HttpSession httpsession = (HttpSession)this._adapter.adapt(session);
        event = new HttpSessionBindingEvent(httpsession, (String)name, value);
        for (int i = 0; i < this._sessionAttributeListeners.size(); ++i) {
            listener = (HttpSessionAttributeListener)this._sessionAttributeListeners.get(i);
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionAttributeRemoved", "SessionManager calling attributeRemoved on listener:" + listener);
            }
            listener.attributeRemoved(event);
        }
    }
}

