/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.object.hpel;

import com.ibm.websphere.logging.hpel.reader.RemoteListCache;
import com.ibm.ws.logging.object.hpel.RemoteRepositoryCache;
import java.io.IOException;
import java.io.ObjectInputStream;

public class RemoteListCacheImpl
implements RemoteListCache {
    private static final long serialVersionUID = 5769609124765147250L;
    private final RemoteRepositoryCache logCache;
    private final RemoteRepositoryCache traceCache;
    private transient int size = -1;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.size = -1;
    }

    public RemoteListCacheImpl(RemoteRepositoryCache logCache, RemoteRepositoryCache traceCache) {
        this.logCache = logCache;
        this.traceCache = traceCache;
    }

    public RemoteRepositoryCache getLogCache() {
        return this.logCache;
    }

    public RemoteRepositoryCache getTraceCache() {
        return this.traceCache;
    }

    @Override
    public boolean isComplete() {
        return !(this.logCache != null && !this.logCache.isComplete() || this.traceCache != null && !this.traceCache.isComplete());
    }

    @Override
    public int getSize() {
        if (this.size < 0) {
            this.size = this.logCache == null ? 0 : this.logCache.getSize();
            this.size += this.traceCache == null ? 0 : this.traceCache.getSize();
        }
        return this.size;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.logCache == null ? 0 : this.logCache.hashCode());
        result = 31 * result + (this.traceCache == null ? 0 : this.traceCache.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteListCacheImpl other = (RemoteListCacheImpl)obj;
        if (this.logCache == null ? other.logCache != null : !this.logCache.equals(other.logCache)) {
            return false;
        }
        return !(this.traceCache == null ? other.traceCache != null : !this.traceCache.equals(other.traceCache));
    }
}

