/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.internal.jpa.jpql.AbstractObjectLevelReadQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkAnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.HierarchicalQueryClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderSiblingsByClause;
import org.eclipse.persistence.queries.ReadAllQuery;

class ReadAllQueryVisitor
extends AbstractObjectLevelReadQueryVisitor {
    ReadAllQueryVisitor(JPQLQueryContext queryContext, ReadAllQuery query) {
        super(queryContext, query);
    }

    @Override
    public void visit(HierarchicalQueryClause expression) {
        org.eclipse.persistence.expressions.Expression startWithClause = null;
        if (expression.hasStartWithClause()) {
            startWithClause = this.queryContext.buildExpression(expression.getStartWithClause());
        }
        org.eclipse.persistence.expressions.Expression connectByClause = this.queryContext.buildExpression(expression.getConnectByClause());
        List<org.eclipse.persistence.expressions.Expression> orderItems = Collections.emptyList();
        if (expression.hasOrderSiblingsByClause()) {
            OrderSiblingsByClauseVisitor visitor = new OrderSiblingsByClauseVisitor();
            expression.getOrderSiblingsByClause().accept(visitor);
            orderItems = visitor.orderByItems;
        }
        ReadAllQuery query = (ReadAllQuery)this.query;
        query.setHierarchicalQueryClause(startWithClause, connectByClause, orderItems);
    }

    private class OrderSiblingsByClauseVisitor
    extends EclipseLinkAnonymousExpressionVisitor {
        List<org.eclipse.persistence.expressions.Expression> orderByItems = new ArrayList<org.eclipse.persistence.expressions.Expression>();

        OrderSiblingsByClauseVisitor() {
        }

        @Override
        public void visit(CollectionExpression expression) {
            expression.acceptChildren(this);
        }

        @Override
        public void visit(OrderSiblingsByClause expression) {
            expression.getOrderByItems().accept(this);
        }

        @Override
        public void visit(Expression expression) {
            this.orderByItems.add(ReadAllQueryVisitor.this.queryContext.buildExpression(expression));
        }
    }
}

