/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.diagnostics.AbstractIntrospection;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpenJPAIntrospection
extends AbstractIntrospection {
    private static final String FFDCCN = OpenJPAIntrospection.class.getName();

    public static void dumpOpenJPAPCRegistry(List<ClassLoader> puInfoTCL, PrintWriter out) {
        if (puInfoTCL == null || puInfoTCL.isEmpty()) {
            return;
        }
        for (ClassLoader c : puInfoTCL) {
            try {
                Class<?> pcRegClass = c.loadClass("org.apache.openjpa.enhance.PCRegistry");
                OpenJPAIntrospection.doDumpOpenJPAPCRegistry(pcRegClass, out);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
    }

    @Override
    public void dumpJPAEntityManagerFactoryState(Object emf, PrintWriter out) {
        this.doDumpOpenJPAEntityManagerFactoryState(emf, out);
    }

    private void doDumpOpenJPAEntityManagerFactoryState(Object emf, PrintWriter out) {
        out.println("OpenJPA EntityManagerFactory: " + OpenJPAIntrospection.getInstanceClassAndAddress(emf));
        try {
            Object brokerFactory = OpenJPAIntrospection.reflectObjValue(emf, "_factory");
            out.println("   _factory = " + brokerFactory);
            out.println("   _metaModel = " + OpenJPAIntrospection.reflectObjValue(emf, "_metaModel"));
            while (brokerFactory != null && OpenJPAIntrospection.isCastable("org.apache.openjpa.kernel.DelegatingBrokerFactory", brokerFactory.getClass())) {
                Object broker = OpenJPAIntrospection.reflectObjValue(brokerFactory, "_factory");
                if (broker == null) {
                    brokerFactory = OpenJPAIntrospection.reflectObjValue(brokerFactory, "_del");
                    continue;
                }
                brokerFactory = broker;
                break;
            }
            out.println("   Actual Broker Factory = " + brokerFactory);
            if (brokerFactory != null && OpenJPAIntrospection.isCastable("org.apache.openjpa.kernel.AbstractBrokerFactory", brokerFactory.getClass())) {
                out.println();
                out.println("   Unwrapped _factory = " + brokerFactory);
                out.println("   AbstractBrokerFactory values:");
                out.println("      _closed = " + OpenJPAIntrospection.reflectObjValue(emf, "_closed"));
                out.println("      _readOnly = " + OpenJPAIntrospection.reflectObjValue(emf, "_readOnly"));
                Object _conf = OpenJPAIntrospection.reflectObjValue(brokerFactory, "_conf");
                this.printOpenJPAConfiguration(_conf, out, "      _conf: ");
                if (_conf != null) {
                    out.println();
                    Object mdr = OpenJPAIntrospection.reflectObjValue(_conf, "metaRepository");
                    if (mdr != null) {
                        this.printOpenJPAMetadataRepository(mdr, out, "      mdr: ");
                    }
                }
                HashSet brokers = new HashSet();
                Set _brokers = (Set)OpenJPAIntrospection.reflectObjValue(brokerFactory, "_brokers");
                if (_brokers != null) {
                    brokers.addAll(_brokers);
                }
                if (brokers.size() > 0) {
                    out.println();
                    out.println("   Active OpenJPA Brokers (Persistence Contexts): ");
                    for (Object broker : brokers) {
                        this.printOpenBrokerImpl(broker, out, "      ");
                    }
                }
            }
            if (brokerFactory != null && OpenJPAIntrospection.isCastable("org.apache.openjpa.jdbc.kernel.JDBCBrokerFactory", brokerFactory.getClass())) {
                out.println("   JDBCBrokerFactory values:");
                out.println("      _synchronizedMappings = " + OpenJPAIntrospection.reflectObjValue(emf, "_synchronizedMappings"));
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(FFDCCN + ".doDumpOpenJPAEntityManagerFactoryState"), (String)"689");
        }
    }

    private void printOpenJPAConfiguration(Object config, PrintWriter out, String indent) {
        out.println(indent + "OpenJPA Configuration = " + config);
        if (config == null || indent == null) {
            return;
        }
        try {
            if (config != null) {
                out.println(indent + " ._appCL = " + OpenJPAIntrospection.reflectObjValue(config, "_appCL"));
                List<Method> getMethods = OpenJPAIntrospection.getMethodsWithPrefix(config.getClass(), "get");
                int nullValCount = 0;
                for (Method m : getMethods) {
                    try {
                        Object val = OpenJPAIntrospection.reflectMethodCall(config, m);
                        if (val == null) {
                            ++nullValCount;
                            continue;
                        }
                        out.print(indent + " ." + m.getName().substring(3) + " = ");
                        out.println(OpenJPAIntrospection.poa(val, indent + "      ", true));
                    }
                    catch (Throwable t) {
                        out.println(indent + " . problem calling " + m.getName());
                    }
                }
                out.println(indent + " # of get methods = " + getMethods.size());
                out.println(indent + " # of null properties = " + nullValCount);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void printOpenJPAMetadataRepository(Object mdr, PrintWriter out, String indent) throws Exception {
        out.println(indent + "OpenJPA MetaDataRepository = " + mdr);
        if (mdr == null || indent == null) {
            return;
        }
        boolean isMDR = OpenJPAIntrospection.isCastable("org.apache.openjpa.meta.MetaDataRepository", mdr.getClass());
        boolean isMR = OpenJPAIntrospection.isCastable("org.apache.openjpa.jdbc.meta.MappingRepository", mdr.getClass());
        if (isMDR || isMR) {
            out.println(indent + " ._factory = " + OpenJPAIntrospection.reflectObjValue(mdr, "_factory"));
            out.println(indent + " ._filterRegisteredClasses = " + OpenJPAIntrospection.reflectObjValue(mdr, "_filterRegisteredClasses"));
            out.println(indent + " ._locking = " + OpenJPAIntrospection.reflectObjValue(mdr, "_locking"));
            out.println(indent + " ._preload = " + OpenJPAIntrospection.reflectObjValue(mdr, "_preload"));
            out.println(indent + " ._preloadComplete = " + OpenJPAIntrospection.reflectObjValue(mdr, "_preloadComplete"));
            out.println();
            Map _metas = (Map)OpenJPAIntrospection.reflectObjValue(mdr, "_metas");
            out.println(indent + " _metas = " + OpenJPAIntrospection.getInstanceClassAndAddress(_metas) + " (" + _metas.size() + " items)");
            HashMap metasCopy = new HashMap(_metas);
            for (Map.Entry entry : metasCopy.entrySet()) {
                out.println(indent + "   " + entry.getKey() + " = " + OpenJPAIntrospection.poa(entry.getValue(), indent + "      ", true));
            }
            out.println();
            Map _metaStringMap = (Map)OpenJPAIntrospection.reflectObjValue(mdr, "_metaStringMap");
            out.println(indent + " _metaStringMap = " + OpenJPAIntrospection.getInstanceClassAndAddress(_metaStringMap) + " (" + _metaStringMap.size() + " items)");
            HashMap metasStringMapCopy = new HashMap(_metaStringMap);
            for (Map.Entry entry : metasStringMapCopy.entrySet()) {
                out.println(indent + "   " + entry.getKey() + " = " + OpenJPAIntrospection.poa(entry.getValue(), indent + "      ", true));
            }
            out.println();
            Map _impls = (Map)OpenJPAIntrospection.reflectObjValue(mdr, "_impls");
            out.println(indent + " _impls = " + OpenJPAIntrospection.getInstanceClassAndAddress(_impls) + " (" + _impls.size() + " items)");
            HashMap implsCopy = new HashMap(_impls);
            for (Map.Entry entry : implsCopy.entrySet()) {
                out.println(indent + "   " + entry.getKey() + " = " + OpenJPAIntrospection.poa(entry.getValue(), indent + "      ", true));
            }
            out.println();
            Map _ifaces = (Map)OpenJPAIntrospection.reflectObjValue(mdr, "_ifaces");
            out.println(indent + " _ifaces = " + OpenJPAIntrospection.getInstanceClassAndAddress(_ifaces) + " (" + _ifaces.size() + " items)");
            HashMap ifacesCopy = new HashMap(_ifaces);
            for (Map.Entry entry : ifacesCopy.entrySet()) {
                out.println(indent + "   " + entry.getKey() + " = " + OpenJPAIntrospection.poa(entry.getValue(), indent + "      ", true));
            }
            out.println();
            Map _queries = (Map)OpenJPAIntrospection.reflectObjValue(mdr, "_queries");
            out.println(indent + " _queries = " + OpenJPAIntrospection.getInstanceClassAndAddress(_queries) + " (" + _queries.size() + " items)");
            HashMap queriesCopy = new HashMap(_queries);
            for (Map.Entry entry : queriesCopy.entrySet()) {
                out.println(indent + "   " + entry.getKey() + " = " + OpenJPAIntrospection.poa(entry.getValue(), indent + "      ", true));
            }
            out.println();
            Map _seqs = (Map)OpenJPAIntrospection.reflectObjValue(mdr, "_seqs");
            out.println(indent + " _seqs = " + OpenJPAIntrospection.getInstanceClassAndAddress(_seqs) + " (" + _seqs.size() + " items)");
            HashMap seqsCopy = new HashMap(_seqs);
            for (Map.Entry entry : seqsCopy.entrySet()) {
                out.println(indent + "   " + entry.getKey() + " = " + OpenJPAIntrospection.poa(entry.getValue(), indent + "      ", true));
            }
            out.println();
            Map _aliases = (Map)OpenJPAIntrospection.reflectObjValue(mdr, "_aliases");
            out.println(indent + " _aliases = " + OpenJPAIntrospection.getInstanceClassAndAddress(_aliases) + " (" + _aliases.size() + " items)");
            HashMap aliasesCopy = new HashMap(_aliases);
            for (Map.Entry entry : aliasesCopy.entrySet()) {
                out.println(indent + "   " + entry.getKey() + " = " + OpenJPAIntrospection.poa(entry.getValue(), indent + "      ", true));
            }
            out.println();
            Map _metamodel = (Map)OpenJPAIntrospection.reflectObjValue(mdr, "_metamodel");
            out.println(indent + " _metamodel = " + OpenJPAIntrospection.getInstanceClassAndAddress(_metamodel) + " (" + _metamodel.size() + " items)");
            HashMap metamodelCopy = new HashMap(_metamodel);
            for (Map.Entry entry : metamodelCopy.entrySet()) {
                out.println(indent + "   " + entry.getKey() + " = " + OpenJPAIntrospection.poa(entry.getValue(), indent + "      ", true));
            }
            out.println();
            Map _subs = (Map)OpenJPAIntrospection.reflectObjValue(mdr, "_subs");
            out.println(indent + " _subs = " + OpenJPAIntrospection.getInstanceClassAndAddress(_subs) + " (" + _subs.size() + " items)");
            HashMap _subsCopy = new HashMap(_subs);
            for (Map.Entry entry : _subsCopy.entrySet()) {
                out.println(indent + "   " + entry.getKey() + " = " + OpenJPAIntrospection.poa(entry.getValue(), indent + "      ", true));
            }
        }
        if (isMR) {
            out.println();
            out.println(indent + " MappingRepository Specific Values");
            out.println(indent + "  ._dict = " + OpenJPAIntrospection.reflectObjValue(mdr, "_dict"));
            out.println(indent + "  ._defaults = " + OpenJPAIntrospection.reflectObjValue(mdr, "_defaults"));
            out.println(indent + "  ._results = " + OpenJPAIntrospection.poa(OpenJPAIntrospection.reflectObjValue(mdr, "_results"), indent + "     ", true));
            out.println(indent + "  ._schema = " + OpenJPAIntrospection.reflectObjValue(mdr, "_schema"));
            out.println(indent + "  ._installer = " + OpenJPAIntrospection.reflectObjValue(mdr, "_installer"));
        }
    }

    private void printOpenBrokerImpl(Object brokerImpl, PrintWriter out, String indent) throws Exception {
        out.println(indent + "OpenJPA BrokerImpl = " + brokerImpl);
        if (brokerImpl == null || indent == null) {
            return;
        }
        try {
            out.println(indent + " ._compat = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_compat"));
            out.println(indent + " ._runtime = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_runtime"));
            out.println(indent + " ._lm = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_lm"));
            out.println(indent + " ._im = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_im"));
            out.println(indent + " ._call = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_call"));
            out.println(indent + " ._instm = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_instm"));
            out.println(indent + " ._loader = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_loader"));
            out.println(indent + " ._nontransRead = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_nontransRead"));
            out.println(indent + " ._nontransWrite = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_nontransWrite"));
            out.println(indent + " ._retainState = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_retainState"));
            out.println(indent + " ._autoClear = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_autoClear"));
            out.println(indent + " ._restoreState = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_restoreState"));
            out.println(indent + " ._optimistic = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_optimistic"));
            out.println(indent + " ._ignoreChanges = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_ignoreChanges"));
            out.println(indent + " ._multithreaded = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_multithreaded"));
            out.println(indent + " ._managed = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_managed"));
            out.println(indent + " ._syncManaged = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_syncManaged"));
            out.println(indent + " ._connRetainMode = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_connRetainMode"));
            out.println(indent + " ._evictDataCache = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_evictDataCache"));
            out.println(indent + " ._populateDataCache = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_connRetainMode"));
            out.println(indent + " ._connRetainMode = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_populateDataCache"));
            out.println(indent + " ._largeTransaction = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_largeTransaction"));
            out.println(indent + " ._autoDetach = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_autoDetach"));
            out.println(indent + " ._detachState = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_detachState"));
            out.println(indent + " ._detachedNew = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_detachedNew"));
            out.println(indent + " ._orderDirty = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_orderDirty"));
            out.println(indent + " ._cachePreparedQuery = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_cachePreparedQuery"));
            out.println(indent + " ._cacheFinderQuery = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_cacheFinderQuery"));
            out.println(indent + " ._suppressBatchOLELogging = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_suppressBatchOLELogging"));
            out.println(indent + " ._allowReferenceToSiblingContext = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_allowReferenceToSiblingContext"));
            out.println(indent + " ._postLoadOnMerge = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_postLoadOnMerge"));
            out.println(indent + " ._flags = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_flags"));
            out.println(indent + " ._isSerializing = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_isSerializing"));
            out.println(indent + " ._closed = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_closed"));
            out.println(indent + " ._transEventManager = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_transEventManager"));
            out.println(indent + " ._transCallbackMode = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_transCallbackMode"));
            out.println(indent + " ._lifeEventManager = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_lifeEventManager"));
            out.println(indent + " ._lifeCallbackMode = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_lifeCallbackMode"));
            out.println(indent + " ._dmLite = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_dmLite"));
            out.println(indent + " ._initializeWasInvoked = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_initializeWasInvoked"));
            out.println(indent + " ._fromWriteBehindCallback = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_fromWriteBehindCallback"));
            out.println(indent + " ._fcs = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_fcs"));
            out.println(indent + " ._printParameters = " + OpenJPAIntrospection.reflectObjValue(brokerImpl, "_printParameters"));
            Map _userObjects = (Map)OpenJPAIntrospection.reflectObjValue(brokerImpl, "_userObjects");
            out.println(indent + " ._userObjects size = " + (_userObjects != null ? _userObjects.size() : 0));
            Map _cache = (Map)OpenJPAIntrospection.reflectObjValue(brokerImpl, "_cache");
            out.println(indent + " ._cache = " + _cache);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doDumpOpenJPAPCRegistry(Class pcRegClass, PrintWriter out) {
        out.println();
        out.println("################################################################################");
        out.println("OpenJPA PCRegistry Dump");
        out.println("################################################################################");
        try {
            Field _metas = pcRegClass.getDeclaredField("_metas");
            boolean accessible = _metas.isAccessible();
            Object _metasObjVal = null;
            try {
                _metas.setAccessible(true);
                _metasObjVal = _metas.get(null);
            }
            finally {
                _metas.setAccessible(accessible);
            }
            if (_metasObjVal == null) {
                return;
            }
            Map _metasMap = (Map)_metasObjVal;
            for (Map.Entry entry : _metasMap.entrySet()) {
                Class cls = (Class)entry.getKey();
                Object metaObj = entry.getValue();
                out.println();
                out.println("Class " + cls.getName() + " " + OpenJPAIntrospection.getObjectAddress(cls));
                out.println("  ClassLoader: " + OpenJPAIntrospection.poa(cls.getClassLoader()));
                out.println("  CodeSource: " + OpenJPAIntrospection.poa(cls.getProtectionDomain().getCodeSource()));
                if (metaObj == null) continue;
                try {
                    Object[] fieldTypes;
                    Object[] fieldNames;
                    Class<?> metaObjClass = metaObj.getClass();
                    String alias = (String)OpenJPAIntrospection.reflectObjValue(metaObj, "alias");
                    Object pc = OpenJPAIntrospection.reflectObjValue(metaObj, "pc");
                    Class pcSuper = (Class)OpenJPAIntrospection.reflectObjValue(metaObj, "pcSuper");
                    String pcTxt = OpenJPAIntrospection.getInstanceClassAndAddress(pc);
                    out.println("  Meta alias: " + alias);
                    out.println("  Meta pc: " + OpenJPAIntrospection.poa(pcTxt));
                    out.println("  Meta pcSuper: " + OpenJPAIntrospection.poa(pcSuper));
                    out.print("  Meta fieldNames: ");
                    for (Object o : fieldNames = (Object[])OpenJPAIntrospection.reflectObjValue(metaObj, "fieldNames")) {
                        out.print(OpenJPAIntrospection.poa(o));
                        out.print(" ");
                    }
                    out.println();
                    out.print("  Meta fieldTypes: ");
                    for (Object o : fieldTypes = (Object[])OpenJPAIntrospection.reflectObjValue(metaObj, "fieldTypes")) {
                        out.print(OpenJPAIntrospection.poa(o));
                        out.print(" ");
                    }
                    out.println();
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)(FFDCCN + ".doDumpOpenJPAPCRegistry"), (String)"708");
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(FFDCCN + ".doDumpOpenJPAPCRegistry"), (String)"713");
        }
    }
}

