/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow;

import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.SwitchCase;
import org.apache.myfaces.flow.Freezable;

public class SwitchCaseImpl
extends SwitchCase
implements Freezable {
    private String fromOutcome;
    private Boolean condition;
    private ValueExpression conditionEL;
    private boolean initialized;

    public String getFromOutcome() {
        return this.fromOutcome;
    }

    public Boolean getCondition(FacesContext context) {
        if (this.conditionEL != null) {
            Object value = this.conditionEL.getValue(context.getELContext());
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
            return (Boolean)value;
        }
        return this.condition;
    }

    @Override
    public void freeze() {
        this.initialized = true;
    }

    private void checkInitialized() throws IllegalStateException {
        if (this.initialized) {
            throw new IllegalStateException("Flow is inmutable once initialized");
        }
    }

    public void setFromOutcome(String fromOutcome) {
        this.checkInitialized();
        this.fromOutcome = fromOutcome;
    }

    public void setCondition(Boolean condition) {
        this.checkInitialized();
        this.condition = condition;
        this.conditionEL = null;
    }

    public void setCondition(ValueExpression conditionEL) {
        this.checkInitialized();
        this.conditionEL = conditionEL;
        this.condition = null;
    }
}

