/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.util.Collection;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class CacheBasedValueHolder
extends DatabaseValueHolder {
    protected transient ForeignReferenceMapping mapping;
    protected Object[] references;
    protected boolean shouldAllowInstantiationDeferral = true;

    public CacheBasedValueHolder(Object[] pks, AbstractRecord foreignKeys, AbstractSession session, ForeignReferenceMapping mapping) {
        this.references = pks;
        this.mapping = mapping;
        this.session = session;
        this.row = foreignKeys;
    }

    public Object[] getCachedPKs() {
        return this.references;
    }

    @Override
    public Object getValue(UnitOfWorkImpl uow) {
        if (this.references != null && this.references.length != 0) {
            if (this.mapping.isCollectionMapping()) {
                Collection<Object> result = uow.getIdentityMapAccessorInstance().getAllFromIdentityMapWithEntityPK(this.references, this.mapping.getReferenceDescriptor()).values();
                if (result.size() == this.references.length) {
                    ContainerPolicy cp = this.mapping.getContainerPolicy();
                    Object container = cp.containerInstance(result.size());
                    for (Object object : result) {
                        cp.addInto(object, container, uow);
                    }
                    return container;
                }
            } else {
                return uow.getIdentityMapAccessorInstance().getFromIdentityMap(this.references[0], this.mapping.getReferenceClass());
            }
        }
        return null;
    }

    @Override
    protected Object instantiate() throws DatabaseException {
        return this.instantiate(this.session);
    }

    protected Object instantiate(AbstractSession localSession) throws DatabaseException {
        if (this.session == null) {
            throw ValidationException.instantiatingValueholderWithNullSession();
        }
        return this.mapping.valueFromPKList(this.references, this.row, localSession);
    }

    @Override
    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        return this.instantiate(unitOfWorkValueHolder.getUnitOfWork());
    }

    @Override
    public boolean isPessimisticLockingValueHolder() {
        return false;
    }

    public void setShouldAllowInstantiationDeferral(boolean shouldAllowInstantiationDeferral) {
        this.shouldAllowInstantiationDeferral = shouldAllowInstantiationDeferral;
    }

    @Override
    public boolean shouldAllowInstantiationDeferral() {
        return this.shouldAllowInstantiationDeferral;
    }
}

