/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.util.AttributeKey;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class NettyHttpConstants {
    public static final AttributeKey<String> FORWARDED_PROTO_KEY;
    public static final AttributeKey<String> FORWARDED_HOST_KEY;
    public static final AttributeKey<String> FORWARDED_PORT_KEY;
    public static final AttributeKey<String[]> FORWARDED_BY_KEY;
    public static final AttributeKey<String[]> FORWARDED_FOR_KEY;
    public static final AttributeKey<Long> REQUEST_START_TIME;
    public static final AttributeKey<Long> RESPONSE_BYTES_WRITTEN;
    public static final AttributeKey<Boolean> IS_SECURE;
    public static final AttributeKey<String> ACCEPT_ENCODING;
    public static final AttributeKey<Boolean> CHUNCKED_ENCODING;
    public static final AttributeKey<String> COMPRESSION_ENCODING;
    public static final AttributeKey<Long> CONTENT_LENGTH;
    public static final AttributeKey<Boolean> IS_OUTBOUND_KEY;
    public static final AttributeKey<String> PROTOCOL;
    public static final AttributeKey<String> ENDPOINT_PID;
    public static final AttributeKey<Boolean> HANDLING_REQUEST;
    public static final AttributeKey<Boolean> THROW_FFDC;
    public static final AttributeKey<Integer> NUMBER_OF_HTTP_REQUESTS;
    public static final AttributeKey<Integer> STREAMS_REFUSED;
    static final long serialVersionUID = -2798277719726993770L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.NettyHttpConstants", NettyHttpConstants.class, null, null);
        FORWARDED_PROTO_KEY = AttributeKey.valueOf((String)"forwardedProto");
        FORWARDED_HOST_KEY = AttributeKey.valueOf((String)"forwardedHost");
        FORWARDED_PORT_KEY = AttributeKey.valueOf((String)"forwardedPort");
        FORWARDED_BY_KEY = AttributeKey.valueOf((String)"forwardedBy");
        FORWARDED_FOR_KEY = AttributeKey.valueOf((String)"forwardedFor");
        REQUEST_START_TIME = AttributeKey.valueOf((String)"requestStartTime");
        RESPONSE_BYTES_WRITTEN = AttributeKey.valueOf((String)"bytesWritten");
        IS_SECURE = AttributeKey.valueOf((String)"isSecure");
        ACCEPT_ENCODING = AttributeKey.valueOf((String)"acceptEncoding");
        CHUNCKED_ENCODING = AttributeKey.valueOf((String)"chunkedEncodingSet");
        COMPRESSION_ENCODING = AttributeKey.valueOf((String)"compressionEncoding");
        CONTENT_LENGTH = AttributeKey.valueOf((String)"contentLength");
        IS_OUTBOUND_KEY = AttributeKey.valueOf((String)"isOutbound");
        PROTOCOL = AttributeKey.valueOf((String)"protocol");
        ENDPOINT_PID = AttributeKey.valueOf((String)"endpointPID");
        HANDLING_REQUEST = AttributeKey.valueOf((String)"handlingRequest");
        THROW_FFDC = AttributeKey.valueOf((String)"throwFFDC");
        NUMBER_OF_HTTP_REQUESTS = AttributeKey.valueOf((String)"numberOfHttpRequests");
        STREAMS_REFUSED = AttributeKey.valueOf((String)"streamsRefused");
    }

    public static enum ProtocolName {
        HTTP1("HTTP1"),
        HTTP2("HTTP2"),
        WEBSOCKET("WebSocket"),
        UNKNOWN("UNKNOWN");

        public final String protocol;

        private ProtocolName(String protocol) {
            this.protocol = protocol;
        }

        public static ProtocolName from(String protocol) {
            if (protocol == null) {
                return UNKNOWN;
            }
            for (ProtocolName p : ProtocolName.values()) {
                if (!p.protocol.equals(protocol)) continue;
                return p;
            }
            return UNKNOWN;
        }
    }
}

