/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.netty.pipeline.HttpPipelineInitializer;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.http.options.TcpOption;
import io.openliberty.transport.config.options.EndpointOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NettyHttpChannelConfig
extends HttpChannelConfig {
    private static final TraceComponent tc = Tr.register(NettyHttpChannelConfig.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private boolean suppressHandshakeError;
    private int suppressHandshakeErrorCount;
    Map<EndpointOption, Object> config;
    static final long serialVersionUID = -9158410022433586548L;

    private NettyHttpChannelConfig(NettyConfigBuilder builder) {
        Objects.nonNull(builder);
        this.useNetty = Boolean.TRUE;
        this.useCompressionOptions = builder.useCompression;
        this.useRemoteIpOptions = builder.useForwardingHeaders;
        this.useHeadersOptions = builder.useHeaders;
        this.useSameSiteOptions = builder.useSameSite;
        this.config = new HashMap<EndpointOption, Object>();
        this.parseConfig(builder.options);
    }

    public void clear() {
        this.clearSameSiteOptions();
    }

    public void registerAccessLog(String endpointName) {
        this.parseAccessLog(endpointName);
    }

    private void parseConfig(Map<String, Object> config) {
        if (Objects.isNull(config) || config.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"parseConfig", (Object[])new Object[]{"The configuration provided was invalid, default values will be used."});
            }
            return;
        }
        if (this.useCompressionOptions) {
            this.parseCompressionOptions(config);
        }
        if (this.useHeadersOptions) {
            this.parseHeaderOptions(config);
        }
        if (this.useRemoteIpOptions) {
            this.parseRemoteIpOptions(config);
        }
        this.parseSameSiteOptions(config);
        this.parseHttpOptions(config);
        this.parseTCPOptions(config);
    }

    private void parseCompressionOptions(Map<String, Object> options) {
        Objects.requireNonNull(options);
        if (this.useCompressionOptions) {
            this.includedCompressionContentTypes = new HashSet();
            this.includedCompressionContentTypes.add("text/*");
            this.includedCompressionContentTypes.add("application/javascript");
            this.excludedCompressionContentTypes = new HashSet();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"parseCompressionOptions", (Object[])new Object[]{"Http Channel Config: compression has been enabled"});
            }
            this.parseCompressionTypes(options.get("types"));
            this.parseCompressionPreferredAlgorithm(options.get("serverPreferredAlgorithm"));
        }
    }

    @ManualTrace
    private void parseHeaderOptions(Map<String, Object> options) {
        String method = "parseHeaderOptions";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)method, (Object[])new Object[0]);
        }
        if (options.containsKey("add") || options.containsKey("set") || options.containsKey("remove") || options.containsKey("setIfMissing")) {
            this.configuredHeadersToAdd = new HashMap();
            this.configuredHeadersToSet = new HashMap();
            this.configuredHeadersToSetIfMissing = new HashMap();
            this.configuredHeadersToRemove = new HashMap();
            this.configuredHeadersErrorSet = new HashSet();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)method, (Object[])new Object[]{"Http Channel Config: <headers> config has been enabled"});
            }
            this.parseHeadersToRemove(options.get("remove"));
            this.parseHeadersToAdd(options.get("add"));
            this.parseHeadersToSet(options.get("set"));
            this.parseHeadersToSetIfMissing(options.get("setIfMissing"));
            this.logHeadersConfig();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)method);
        }
    }

    private void parseHttpOptions(Map<String, Object> options) {
        this.parseAllowRetries(options.get("allowRetries"));
        this.parseAttemptPurgeData(options.get("PurgeDataDuringClose"));
        this.parseAutoDecompression(options.get("AutoDecompression"));
        this.parseBufferType(options.get("useDirectBuffers"));
        this.parseCookieUpdate(options.get("NoCacheCookiesControl"), options.get("CookiesConfigureNoCache"));
        this.parseDateHeaderRange(options.get("DateHeaderRange"));
        this.parseDecompressionRatioLimit(options.get("decompressionRatioLimit"));
        this.parseDecompressionTolerance(options.get("decompressionTolerance"));
        this.parseDoNotAllowDuplicateSetCookies(options.get("DoNotAllowDuplicateSetCookies"));
        this.parseIncomingBodyBufferSize(options.get("incomingBodyBufferSize"));
        this.parseIncomingHdrBufferSize(options.get("incomingHdrBufferSize"));
        this.parseLimitFieldSize(options.get("limitFieldSize"));
        this.parseLimitMessageSize(options.get("MessageSizeLimit"));
        this.parseLimitNumberHeaders(options.get("limitNumHeaders"));
        this.parseLimitNumberResponses(options.get("LimitNumberResponses"));
        this.parseOutgoingBufferSize(options.get("outgoingHdrBufferSize"));
        this.parseOutgoingVersion(options.get("outgoingVersion"));
        this.parsePersistTimeout(options.get("persistTimeout"));
        this.parsePersistence(options.get("KeepAliveEnabled"), options.get("MaxKeepAliveRequests"));
        this.parsePurgeRemainingResponseBody();
        this.parseReadTimeout(options.get("readTimeout"));
        this.parseRequestSmugglingProtection(options.get("EnableSmugglingProtection"));
        this.parseServerHeader(options.get("RemoveServerHeader"), options.get("ServerHeaderValue"));
        this.parseSkipCookiePathQuotes(options.get("SkipCookiePathQuotes"));
        this.parseWriteTimeout(options.get("writeTimeout"));
        this.parsev0CookieDateRFC1123compat(options.get("v0CookieDateRFC1123compat"));
        this.parseIgnoreWriteAfterCommit(options.get("ignoreWriteAfterCommit"));
        this.parseHttp2Options(options);
    }

    private void parseHttp2Options(Map<String, Object> options) {
        this.parseH2ConnCloseTimeout(options.get("H2ConnCloseTimeout"));
        this.parseH2ConnectionIdleTimeout(options.get("http2ConnectionIdleTimeout"));
        this.parseH2ConnectionWindowSize(options.get("connectionWindowSize"));
        this.parseH2LimitWindowUpdateFrames(options.get("limitWindowUpdateFrames"));
        this.parseH2MaxConcurrentStreams(options.get("maxConcurrentStreams"));
        this.parseH2MaxFrameSize(options.get("maxFrameSize"));
        this.parseProtocolVersion(options.get("protocolVersionInternal"));
        this.parseH2SettingsInitialWindowSize(options.get("settingsInitialWindowSize"));
        this.parseH2MaxHeaderBlockSize(options.get("maxHeaderBlockSize"));
    }

    @ManualTrace
    private void parseRemoteIpOptions(Map<String, Object> options) {
        String method = "parseRemoteIpOptions";
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)method, (Object[])new Object[0]);
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)method, (Object[])new Object[]{"HTTP Channel Config: remoteIp has been enabled"});
            }
        }
        this.parseRemoteIpProxies(options.get("proxies"));
        this.parseRemoteIpAccessLog(options.get("useRemoteIpInAccessLog"));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)method);
        }
    }

    private void clearSameSiteOptions() {
        this.useSameSiteOptions = false;
        this.sameSiteCookies = new HashMap();
        this.sameSiteErrorCookies = new HashSet();
        this.sameSiteStringPatterns = new HashMap();
        this.sameSitePatterns = null;
        this.onlySameSiteStar = false;
        this.isPartitioned = false;
    }

    @ManualTrace
    private void parseSameSiteOptions(Map<String, Object> options) {
        String method = "parseSameSiteOptions";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseSameSiteOptions", (Object[])new Object[0]);
        }
        this.sameSiteCookies = new HashMap();
        this.sameSiteErrorCookies = new HashSet();
        this.sameSiteStringPatterns = new HashMap();
        this.sameSitePatterns = null;
        this.onlySameSiteStar = false;
        this.isPartitioned = false;
        if (this.useSameSiteOptions && (options.containsKey("lax") || options.containsKey("none") || options.containsKey("strict") || options.containsKey("partitioned"))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)method, (Object[])new Object[]{"Http Channel Config: SameSite configuration has been enabled"});
            }
            this.parseCookiesSameSiteLax(options.get("lax"));
            this.parseCookiesSameSiteNone(options.get("none"));
            this.parseCookiesSameSiteStrict(options.get("strict"));
            this.parseCookiesSameSitePartitioned(options.get("partitioned"));
            this.initSameSiteCookiesPatterns();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)method);
        }
    }

    public void parseTCPOptions(Map<String, Object> options) {
        this.config.putIfAbsent(TcpOption.INACTIVITY_TIMEOUT, TcpOption.INACTIVITY_TIMEOUT.parse(options));
    }

    public Object get(EndpointOption option) {
        return this.config.getOrDefault(option, option.getDefaultValue());
    }

    public void disableRemoteIp() {
        this.useRemoteIpOptions = Boolean.FALSE;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class NettyConfigBuilder {
        private boolean useCompression;
        private boolean useHeaders;
        private boolean useForwardingHeaders;
        private boolean useSameSite;
        private final Map<String, Object> options = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        private Map<String, Object> compressionOptions;
        private Map<String, Object> headerOptions;
        private Map<String, Object> httpOptions;
        private Map<String, Object> forwardingOptions;
        private Map<String, Object> sameSiteOptions;
        private Map<String, Object> sslOptions;
        private Map<String, Object> tcpOptions;
        static final long serialVersionUID = -4381053899117138294L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NettyConfigBuilder() {
            this.useCompression = Boolean.FALSE;
            this.useHeaders = Boolean.FALSE;
            this.useForwardingHeaders = Boolean.FALSE;
            this.useSameSite = Boolean.FALSE;
            this.compressionOptions = Collections.emptyMap();
            this.headerOptions = Collections.emptyMap();
            this.httpOptions = Collections.emptyMap();
            this.forwardingOptions = Collections.emptyMap();
            this.sameSiteOptions = Collections.emptyMap();
            this.sslOptions = Collections.emptyMap();
            this.tcpOptions = Collections.emptyMap();
        }

        public NettyConfigBuilder with(HttpPipelineInitializer.ConfigElement config, Map<String, Object> options) {
            if (Objects.isNull(options) || options.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No properties provided, exiting", (Object[])new Object[0]);
                }
                return this;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Http Configuration - " + (Object)((Object)config)), (Object[])new Object[0]);
            }
            switch (config) {
                case COMPRESSION: {
                    this.useCompression = Boolean.TRUE;
                    this.compressionOptions = options;
                    break;
                }
                case HEADERS: {
                    this.useHeaders = Boolean.TRUE;
                    this.headerOptions = options;
                    break;
                }
                case HTTP_OPTIONS: {
                    this.httpOptions = options;
                    break;
                }
                case REMOTE_IP: {
                    this.useForwardingHeaders = Boolean.TRUE;
                    this.forwardingOptions = options;
                    break;
                }
                case SAMESITE: {
                    this.useSameSite = Boolean.TRUE;
                    this.sameSiteOptions = options;
                    break;
                }
                case SSL_OPTIONS: {
                    this.sslOptions = options;
                    break;
                }
                case TCP_OPTIONS: {
                    this.tcpOptions = options;
                    break;
                }
            }
            return this;
        }

        private void collectOptions() {
            this.compressionOptions.forEach(this.options::putIfAbsent);
            this.headerOptions.forEach(this.options::putIfAbsent);
            this.httpOptions.forEach(this.options::putIfAbsent);
            this.forwardingOptions.forEach(this.options::putIfAbsent);
            this.sameSiteOptions.forEach(this.options::putIfAbsent);
            this.sslOptions.forEach(this.options::putIfAbsent);
            this.tcpOptions.forEach(this.options::putIfAbsent);
        }

        public NettyHttpChannelConfig build() {
            this.collectOptions();
            return new NettyHttpChannelConfig(this);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.NettyHttpChannelConfig$NettyConfigBuilder", NettyConfigBuilder.class, null, null);
        }
    }
}

