/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.security;

import io.smallrye.openapi.runtime.io.IOContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class SecurityIO<V, A extends V, O extends V, AB, OB> {
    private final IOContext<V, A, O, AB, OB> context;

    public SecurityIO(IOContext<V, A, O, AB, OB> context) {
        this.context = context;
    }

    public List<SecurityRequirement> readRequirements(AnnotationTarget target) {
        return Stream.of(this.context.securityRequirementIO().readList(target), this.context.securityRequirementsSetIO().readList(target)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<SecurityRequirement> readRequirements(AnnotationValue annotations, AnnotationValue setAnnotations) {
        List requirements = Stream.of(this.context.securityRequirementIO().readList(annotations), this.context.securityRequirementsSetIO().readList(setAnnotations)).filter(Objects::nonNull).collect(Collectors.toList());
        if (requirements.isEmpty()) {
            return null;
        }
        return requirements.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Map<String, SecurityScheme> readSchemes(AnnotationTarget target) {
        return this.context.securitySchemeIO().readMap(target);
    }
}

