/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.common.http;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SupportedHttpMethodHandler {
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    static final long serialVersionUID = 8958869809836306668L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SupportedHttpMethodHandler(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public boolean isValidHttpMethodForRequest(HttpMethod requestMethod) {
        return true;
    }

    public void sendHttpOptionsResponse() throws IOException {
        Set<HttpMethod> supportedMethods = this.getAllHttpMethods();
        this.setAllowHeaderAndSendResponse(supportedMethods);
    }

    public void sendUnsupportedMethodResponse() throws IOException {
        this.response.sendError(405);
    }

    protected void setAllowHeaderAndSendResponse(Set<HttpMethod> supportedMethods) {
        String allowHeaderValue = this.buildHeaderValue(supportedMethods);
        if (allowHeaderValue != null) {
            this.response.setHeader("Allow", allowHeaderValue);
        }
        this.response.setStatus(200);
    }

    String buildHeaderValue(Set<HttpMethod> supportedMethods) {
        if (supportedMethods == null) {
            return null;
        }
        String allowHeaderValue = "";
        Iterator<HttpMethod> iter = supportedMethods.iterator();
        while (iter.hasNext()) {
            allowHeaderValue = allowHeaderValue + (Object)((Object)iter.next());
            if (!iter.hasNext()) continue;
            allowHeaderValue = allowHeaderValue + ", ";
        }
        return allowHeaderValue;
    }

    private Set<HttpMethod> getAllHttpMethods() {
        HttpMethod[] allMethodsArray;
        HashSet<HttpMethod> allMethods = new HashSet<HttpMethod>();
        for (HttpMethod method : allMethodsArray = HttpMethod.values()) {
            allMethods.add(method);
        }
        return allMethods;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.security.common.http.SupportedHttpMethodHandler", SupportedHttpMethodHandler.class, null, null);
    }

    public static enum HttpMethod {
        GET,
        HEAD,
        POST,
        DELETE,
        PUT,
        TRACE,
        OPTIONS;

    }
}

