/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.db;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import io.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.annotation.Nullable;

abstract class DbClientCommonAttributesExtractor<REQUEST, RESPONSE, GETTER extends DbClientCommonAttributesGetter<REQUEST>>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    final GETTER getter;

    DbClientCommonAttributesExtractor(GETTER getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.DB_SYSTEM, this.getter.getSystem(request));
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.DB_USER, this.getter.getUser(request));
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.DB_NAME, this.getter.getName(request));
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.DB_CONNECTION_STRING, this.getter.getConnectionString(request));
    }

    @Override
    public final void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }

    @Override
    public SpanKey internalGetSpanKey() {
        return SpanKey.DB_CLIENT;
    }
}

