/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.AttributeConstraint;
import io.openliberty.data.internal.QueryType;
import io.openliberty.data.internal.persistence.CursoredPageImpl;
import io.openliberty.data.internal.persistence.EntityInfo;
import io.openliberty.data.internal.persistence.PageImpl;
import io.openliberty.data.internal.persistence.QueryEdit;
import io.openliberty.data.internal.persistence.RepositoryImpl;
import io.openliberty.data.internal.persistence.Util;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import io.openliberty.data.internal.persistence.cdi.RepositoryProducer;
import io.openliberty.data.internal.version.DataVersionCompatibility;
import jakarta.data.Limit;
import jakarta.data.Order;
import jakarta.data.Sort;
import jakarta.data.exceptions.DataException;
import jakarta.data.exceptions.EmptyResultException;
import jakarta.data.exceptions.MappingException;
import jakarta.data.exceptions.NonUniqueResultException;
import jakarta.data.exceptions.OptimisticLockingFailureException;
import jakarta.data.page.CursoredPage;
import jakarta.data.page.Page;
import jakarta.data.page.PageRequest;
import jakarta.data.repository.By;
import jakarta.data.repository.Delete;
import jakarta.data.repository.Find;
import jakarta.data.repository.Insert;
import jakarta.data.repository.OrderBy;
import jakarta.data.repository.Param;
import jakarta.data.repository.Save;
import jakarta.data.repository.Update;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class QueryInfo {
    private static final TraceComponent tc = Tr.register(QueryInfo.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    public static final Class<?> ENTITY_TBD = jakarta.data.repository.Query.class;
    private static final int[] NONE = new int[0];
    private static final int[] NONE_QUERY_LANGUAGE_ONLY = new int[0];
    private static final int[] NONE_STATIC_SORT_ONLY = new int[0];
    EntityInfo entityInfo;
    final Class<?> entityParamType;
    private String entityVar = "o";
    private String entityVar_ = "o.";
    private boolean hasWhere;
    final boolean isOptional;
    String jpql;
    String jpqlAfterCursor;
    String jpqlBeforeCursor;
    String jpqlCount;
    String jpqlDelete;
    int jpqlParamCount;
    private Set<String> jpqlParamNames = Collections.emptySet();
    int maxResults;
    public final Method method;
    final Class<?> multiType;
    final RepositoryProducer<?> producer;
    final Class<?> repositoryInterface;
    final Class<?> returnArrayType;
    final Class<?> singleType;
    final Class<?> singleTypeElementType;
    private int[] sortPositions = NONE;
    List<Sort<Object>> sorts;
    QueryType type;
    boolean validateParams;
    boolean validateResult;
    static final long serialVersionUID = 6314444973613072660L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Trivial
    @ManualTrace
    public QueryInfo(RepositoryProducer<?> repositoryProducer, Class<?> repositoryInterface, Method method, Class<?> entityParamType, Class<?> returnArrayType, List<Class<?>> returnTypeAtDepth) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            StringBuilder b = new StringBuilder(200).append(method.getGenericReturnType().getTypeName()).append(' ').append(repositoryInterface.getName()).append('.').append(method.getName());
            boolean first = true;
            for (Type p : method.getGenericParameterTypes()) {
                b.append(first ? "(" : ", ").append(p.getTypeName());
                first = false;
            }
            b.append(first ? "()" : ")");
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{b.toString(), entityParamType, returnArrayType, returnTypeAtDepth});
        }
        this.producer = repositoryProducer;
        this.repositoryInterface = repositoryInterface;
        this.method = method;
        this.entityParamType = entityParamType;
        this.returnArrayType = returnArrayType;
        int d = 0;
        int depth = returnTypeAtDepth.size();
        Class<?> type = returnTypeAtDepth.get(d);
        if (CompletionStage.class.equals(type) || CompletableFuture.class.equals(type)) {
            if (++d >= depth) throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1004.general.rtrn.err", method.getGenericReturnType().getTypeName(), method.getName(), repositoryInterface.getName());
            type = returnTypeAtDepth.get(d);
        }
        if (this.isOptional = Optional.class.equals(type)) {
            this.multiType = null;
            if (++d >= depth) throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1004.general.rtrn.err", method.getGenericReturnType().getTypeName(), method.getName(), repositoryInterface.getName());
            type = returnTypeAtDepth.get(d);
        } else if (returnArrayType != null || Iterator.class.equals(type) || Iterable.class.isAssignableFrom(type) || BaseStream.class.isAssignableFrom(type)) {
            this.multiType = type;
            if (++d >= depth) throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1004.general.rtrn.err", method.getGenericReturnType().getTypeName(), method.getName(), repositoryInterface.getName());
            type = returnTypeAtDepth.get(d);
        } else {
            this.multiType = null;
        }
        this.singleType = type;
        this.singleTypeElementType = (this.singleType.isArray() || Iterable.class.isAssignableFrom(this.singleType)) && ++d < depth ? returnTypeAtDepth.get(d) : null;
        if (!trace || !tc.isEntryEnabled()) return;
        Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{this, "result isOptional? " + this.isOptional, "result multiType:  " + String.valueOf(this.multiType), "result singleType: " + String.valueOf(this.singleType), "          element: " + String.valueOf(this.singleTypeElementType)});
    }

    public QueryInfo(RepositoryProducer<?> repositoryProducer, Class<?> repositoryInterface, Method method, QueryType type) {
        this.method = method;
        this.entityParamType = null;
        this.multiType = null;
        this.isOptional = false;
        this.producer = repositoryProducer;
        this.repositoryInterface = repositoryInterface;
        this.returnArrayType = null;
        this.singleType = null;
        this.singleTypeElementType = null;
        this.type = type;
    }

    private QueryInfo(QueryInfo source, String jpql, List<Sort<Object>> sorts) {
        this.entityInfo = source.entityInfo;
        this.entityParamType = source.entityParamType;
        this.entityVar = source.entityVar;
        this.entityVar_ = source.entityVar_;
        this.hasWhere = source.hasWhere;
        this.isOptional = source.isOptional;
        this.jpql = jpql;
        this.jpqlAfterCursor = source.jpqlAfterCursor;
        this.jpqlBeforeCursor = source.jpqlBeforeCursor;
        this.jpqlCount = source.jpqlCount;
        this.jpqlDelete = source.jpqlDelete;
        this.jpqlParamCount = source.jpqlParamCount;
        this.jpqlParamNames = source.jpqlParamNames;
        this.maxResults = source.maxResults;
        this.method = source.method;
        this.multiType = source.multiType;
        this.repositoryInterface = source.repositoryInterface;
        this.producer = source.producer;
        this.returnArrayType = source.returnArrayType;
        this.singleType = source.singleType;
        this.singleTypeElementType = source.singleTypeElementType;
        this.sorts = sorts;
        this.type = source.type;
        this.validateParams = source.validateParams;
    }

    @Trivial
    private void addSort(boolean ignoreCase, String attribute, boolean descending) {
        if (this.entityInfo.idClassAttributeAccessors == null || !"id(this)".equalsIgnoreCase(attribute)) {
            String name = this.getAttributeName(attribute, true);
            this.sorts.add((Sort<Object>)(ignoreCase ? (descending ? Sort.descIgnoreCase((String)name) : Sort.ascIgnoreCase((String)name)) : (descending ? Sort.desc((String)name) : Sort.asc((String)name))));
        } else {
            for (String name : this.entityInfo.idClassAttributeAccessors.keySet()) {
                this.addSort(ignoreCase, name, descending);
            }
        }
    }

    @Trivial
    private final void appendAttributeName(String attrName, StringBuilder q) {
        if (attrName.charAt(attrName.length() - 1) != ')') {
            q.append(this.entityVar_);
        }
        q.append(attrName);
    }

    int computeOffset(Limit range) {
        long startIndex = range.startAt() - 1L;
        if (startIndex <= Integer.MAX_VALUE) {
            return (int)startIndex;
        }
        throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1073.offset.exceeds.max", startIndex + 1L, range, this.method.getName(), this.repositoryInterface.getName(), "Integer.MAX_VALUE (2147483647)");
    }

    int computeOffset(PageRequest pagination) {
        long pageIndex;
        if (pagination.mode() != PageRequest.Mode.OFFSET) {
            throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1035.incompat.page.mode", pagination.mode(), this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName(), CursoredPage.class.getSimpleName());
        }
        int maxPageSize = pagination.size();
        if ((long)(Integer.MAX_VALUE / maxPageSize) >= (pageIndex = pagination.page() - 1L)) {
            return (int)(pageIndex * (long)maxPageSize);
        }
        throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1043.offset.exceeds.max", BigInteger.valueOf(pageIndex).multiply(BigInteger.valueOf(maxPageSize)).toString(), pagination, this.method.getName(), this.repositoryInterface.getName(), "Integer.MAX_VALUE (2147483647)");
    }

    @Trivial
    @FFDCIgnore(value={ArithmeticException.class})
    private Object convert(Object value, Class<?> toType, boolean failIfNotConverted) {
        if (value == null) {
            if (toType.isPrimitive()) {
                throw DataExtension.exc(MappingException.class, "CWWKD1046.result.convert.err", null, this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName());
            }
            return null;
        }
        Class<?> fromType = value.getClass();
        ArithmeticException cause = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("convert " + this.loggableAppend(fromType.getSimpleName(), " (", value, ")") + " to " + toType.getSimpleName()), (Object[])new Object[0]);
        }
        if (value instanceof Number && (Util.PRIMITIVE_NUMERIC_TYPES.contains(toType) || Number.class.isAssignableFrom(toType))) {
            try {
                if (BigDecimal.class.equals(fromType)) {
                    v = (BigDecimal)value;
                    if (Long.TYPE.equals(toType) || Long.class.equals(toType)) {
                        return ((BigDecimal)v).longValueExact();
                    }
                    if (Integer.TYPE.equals(toType) || Integer.class.equals(toType)) {
                        return ((BigDecimal)v).intValueExact();
                    }
                    if (Short.TYPE.equals(toType) || Short.class.equals(toType)) {
                        return ((BigDecimal)v).shortValueExact();
                    }
                    if (Byte.TYPE.equals(toType) || Byte.class.equals(toType)) {
                        return ((BigDecimal)v).byteValueExact();
                    }
                    if (BigInteger.class.equals(toType)) {
                        return ((BigDecimal)v).toBigIntegerExact();
                    }
                } else if (BigInteger.class.equals(fromType)) {
                    v = (BigInteger)value;
                    if (Long.TYPE.equals(toType) || Long.class.equals(toType)) {
                        return ((BigInteger)v).longValueExact();
                    }
                    if (Integer.TYPE.equals(toType) || Integer.class.equals(toType)) {
                        return ((BigInteger)v).intValueExact();
                    }
                    if (Short.TYPE.equals(toType) || Short.class.equals(toType)) {
                        return ((BigInteger)v).shortValueExact();
                    }
                    if (Byte.TYPE.equals(toType) || Byte.class.equals(toType)) {
                        return ((BigInteger)v).byteValueExact();
                    }
                    if (BigDecimal.class.equals(toType)) {
                        return new BigDecimal((BigInteger)v);
                    }
                } else if (Double.TYPE.equals(fromType) || Double.class.equals(fromType)) {
                    v = (Double)value;
                    if (Double.TYPE.equals(toType)) {
                        return v;
                    }
                    if (BigDecimal.class.equals(toType)) {
                        return BigDecimal.valueOf((Double)v);
                    }
                } else if (Float.TYPE.equals(fromType) || Float.class.equals(fromType)) {
                    v = (Float)value;
                    if (Float.TYPE.equals(toType)) {
                        return v;
                    }
                    if (Double.TYPE.equals(toType)) {
                        return ((Float)v).doubleValue();
                    }
                    if (BigDecimal.class.equals(toType)) {
                        return BigDecimal.valueOf(((Float)v).floatValue());
                    }
                } else {
                    Number n = (Number)value;
                    long v = n.longValue();
                    if (Long.TYPE.equals(toType) || Long.class.equals(toType)) {
                        return v;
                    }
                    if (Integer.TYPE.equals(toType) || Integer.class.equals(toType)) {
                        if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
                            return n.intValue();
                        }
                        this.convertFail(n, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    } else if (Short.TYPE.equals(toType) || Short.class.equals(toType)) {
                        if (v >= -32768L && v <= 32767L) {
                            return n.shortValue();
                        }
                        this.convertFail(n, -32768L, 32767L);
                    } else if (Byte.TYPE.equals(toType) || Byte.class.equals(toType)) {
                        if (v >= -128L && v <= 127L) {
                            return n.byteValue();
                        }
                        this.convertFail(n, -128L, 127L);
                    } else {
                        if (BigInteger.class.equals(toType)) {
                            return BigInteger.valueOf(v);
                        }
                        if (BigDecimal.class.equals(toType)) {
                            return BigDecimal.valueOf(v);
                        }
                        if (Double.TYPE.equals(toType) || Double.class.equals(toType)) {
                            if (Integer.class.equals(fromType) || Short.class.equals(fromType) || Byte.class.equals(fromType) || v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
                                return n.doubleValue();
                            }
                        } else if ((Float.TYPE.equals(toType) || Float.class.equals(toType)) && (Short.class.equals(fromType) || Byte.class.equals(fromType) || v >= -32768L && v <= 32767L)) {
                            return Float.valueOf(n.floatValue());
                        }
                    }
                }
            }
            catch (ArithmeticException x) {
                cause = x;
            }
        } else if (value instanceof CharSequence && (Util.PRIMITIVE_NUMERIC_TYPES.contains(toType) || Number.class.isAssignableFrom(toType))) {
            if (Integer.TYPE.equals(toType) || Integer.class.equals(toType)) {
                return Integer.parseInt(value.toString());
            }
            if (Long.TYPE.equals(toType) || Long.class.equals(toType)) {
                return Long.parseLong(value.toString());
            }
            if (Short.TYPE.equals(toType) || Short.class.equals(toType)) {
                return Short.parseShort(value.toString());
            }
            if (Byte.TYPE.equals(toType) || Byte.class.equals(toType)) {
                return Byte.parseByte(value.toString());
            }
            if (Double.TYPE.equals(toType) || Double.class.equals(toType)) {
                return Double.parseDouble(value.toString());
            }
            if (Float.TYPE.equals(toType) || Float.class.equals(toType)) {
                return Float.valueOf(Float.parseFloat(value.toString()));
            }
            if (BigDecimal.class.equals(toType)) {
                return new BigDecimal(value.toString());
            }
            if (BigInteger.class.equals(toType)) {
                return new BigInteger(value.toString());
            }
        } else {
            if (String.class.equals(toType) || CharSequence.class.equals(toType)) {
                return value.toString();
            }
            if (Character.TYPE.equals(toType) || Character.class.equals(toType)) {
                if (value instanceof CharSequence) {
                    CharSequence chars = (CharSequence)value;
                    if (chars.length() == 1) {
                        return Character.valueOf(chars.charAt(0));
                    }
                    if (chars.isEmpty() && Character.class.equals(toType)) {
                        return null;
                    }
                }
            } else if (Boolean.TYPE.equals(toType) || Boolean.class.equals(toType)) {
                if (value instanceof Boolean) {
                    return value;
                }
                if (value instanceof CharSequence) {
                    String str = ((CharSequence)value).toString();
                    if ("true".equalsIgnoreCase(str)) {
                        return true;
                    }
                    if ("false".equalsIgnoreCase(str)) {
                        return false;
                    }
                }
            } else if (value instanceof List && Iterable.class.isAssignableFrom(toType)) {
                return this.convertToIterable((List)value, toType, this.singleTypeElementType, null);
            }
        }
        if (failIfNotConverted) {
            MappingException x = DataExtension.exc(MappingException.class, "CWWKD1046.result.convert.err", this.loggableAppend(fromType.getName(), " (", value, ")"), this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName());
            if (cause != null) {
                x = (MappingException)x.initCause((Throwable)cause);
            }
            throw x;
        }
        return value;
    }

    @Trivial
    private void convertFail(Number value, long min, long max) {
        throw DataExtension.exc(MappingException.class, "CWWKD1047.result.out.of.range", this.loggableAppend(value.getClass().getName(), " (", value, ")"), this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName(), min, max);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Trivial
    @ManualTrace
    private final Iterable<?> convertToIterable(List<?> results, Class<?> iterableType, Class<?> elementType, Query query) {
        Collection<Object> list;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"convertToIterable", (Object[])new Object[]{this.loggable(results), "to " + iterableType.getName(), elementType == null ? "of ?" : "of " + elementType.getName(), query});
        }
        if (iterableType.isInterface()) {
            if (iterableType.isAssignableFrom(ArrayList.class)) {
                list = new ArrayList(results.size());
            } else if (iterableType.isAssignableFrom(ArrayDeque.class)) {
                list = new ArrayDeque(results.size());
            } else {
                if (!iterableType.isAssignableFrom(LinkedHashSet.class)) throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1046.result.convert.err", List.class.getName(), this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName());
                list = new LinkedHashSet(results.size());
            }
        } else {
            try {
                Constructor<ArrayList> c = iterableType.getConstructor(new Class[0]);
                list = c.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException c) {
                void x;
                FFDCFilter.processException((Throwable)c, (String)"io.openliberty.data.internal.persistence.QueryInfo", (String)"841", (Object)this, (Object[])new Object[]{results, iterableType, elementType, query});
                throw (UnsupportedOperationException)DataExtension.exc(UnsupportedOperationException.class, "CWWKD1057.no.args.constr.inacc", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), iterableType.getName()).initCause((Throwable)x);
            }
            catch (InvocationTargetException x) {
                FFDCFilter.processException((Throwable)x, (String)"io.openliberty.data.internal.persistence.QueryInfo", (String)"851", (Object)this, (Object[])new Object[]{results, iterableType, elementType, query});
                throw (DataException)DataExtension.exc(DataException.class, "CWWKD1058.no.args.constr.err", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), iterableType.getName(), x.getMessage()).initCause((Throwable)x);
            }
        }
        if (results.size() == 1 && results.get(0) instanceof Object[]) {
            Object[] a = (Object[])results.get(0);
            for (int i = 0; i < a.length; ++i) {
                Object element = a[i];
                if (elementType != null && !elementType.isInstance(element)) {
                    element = this.convert(element, elementType, true);
                }
                list.add(element);
            }
        } else {
            for (Object element : results) {
                Object converted;
                if (elementType != null && !elementType.isInstance(element) && (converted = this.convert(element, elementType, false)) == element) {
                    throw this.excIncompatibleQueryResult(results, query);
                }
                list.add(element);
            }
        }
        if (!trace || !tc.isEntryEnabled()) return list;
        Tr.exit((Object)this, (TraceComponent)tc, (String)"convertToIterable", (Object)this.loggable(list));
        return list;
    }

    @Trivial
    @ManualTrace
    Object count(EntityManager em, Object ... args) throws Exception {
        Object returnValue;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"count", (Object[])new Object[]{"to be returned as " + this.singleType.getName()});
        }
        TypedQuery query = em.createQuery(this.jpql, Long.class);
        this.setParameters((Query)query, args);
        Long count = (Long)query.getSingleResult();
        if (Long.TYPE.equals(this.singleType) || Long.class.equals(this.singleType) || this.singleType.isAssignableFrom(Long.class)) {
            returnValue = count;
        } else if (Integer.TYPE.equals(this.singleType) || Integer.class.equals(this.singleType)) {
            if (count > Integer.MAX_VALUE) {
                throw DataExtension.exc(MappingException.class, "CWWKD1048.result.exceeds.max", count, this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName(), "Integer.MAX_VALUE (2147483647)");
            }
            returnValue = count.intValue();
        } else if (Short.TYPE.equals(this.singleType) || Short.class.equals(this.singleType)) {
            if (count > 32767L) {
                throw DataExtension.exc(MappingException.class, "CWWKD1048.result.exceeds.max", count, this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName(), "Short.MAX_VALUE (32767)");
            }
            returnValue = count.shortValue();
        } else if (Byte.TYPE.equals(this.singleType) || Byte.class.equals(this.singleType)) {
            if (count > 127L) {
                throw DataExtension.exc(MappingException.class, "CWWKD1048.result.exceeds.max", count, this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName(), "Byte.MAX_VALUE (127)");
            }
            returnValue = count.byteValue();
        } else if (BigInteger.class.equals(this.singleType)) {
            returnValue = BigInteger.valueOf(count);
        } else if (BigDecimal.class.equals(this.singleType)) {
            returnValue = BigDecimal.valueOf(count);
        } else {
            throw DataExtension.exc(MappingException.class, "CWWKD1049.count.convert.err", count, this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName());
        }
        Class<?> returnType = this.method.getReturnType();
        if (this.isOptional) {
            returnValue = Optional.of(returnValue);
        } else if (CompletableFuture.class.equals(returnType) || CompletionStage.class.equals(returnType)) {
            returnValue = CompletableFuture.completedFuture(returnValue);
        } else if (this.multiType != null) {
            throw DataExtension.exc(MappingException.class, "CWWKD1049.count.convert.err", count, this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName());
        }
        if (trace && tc.isEntryEnabled()) {
            if (count == returnValue) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"count", (Object)returnValue);
            } else {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"count", (Object)(count + " converted to " + String.valueOf(returnValue)));
            }
        }
        return returnValue;
    }

    @Trivial
    private void cursorSizeMismatchError(PageRequest.Cursor cursor) {
        ArrayList<String> keyTypes = new ArrayList<String>();
        for (int i = 0; i < cursor.size(); ++i) {
            keyTypes.add(cursor.get(i) == null ? null : cursor.get(i).getClass().getName());
        }
        throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1036.cursor.size.mismatch", cursor.size(), this.method.getName(), this.repositoryInterface.getName(), this.sorts.size(), this.loggable(cursor.elements()), this.sorts);
    }

    @Trivial
    @ManualTrace
    private void delete(List<?> results, EntityManager em) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"delete", (Object[])new Object[]{this.loggable(results)});
        }
        for (Object result : results) {
            if (result == null) {
                throw DataExtension.exc(DataException.class, "CWWKD1046.result.convert.err", null, this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName());
            }
            if (this.entityInfo.entityClass.isInstance(result)) {
                em.remove(result);
                continue;
            }
            if (this.entityInfo.idClassAttributeAccessors != null) {
                Query delete = em.createQuery(this.jpqlDelete);
                int numParams = 0;
                for (Member accessor : this.entityInfo.idClassAttributeAccessors.values()) {
                    Object value;
                    Object object = value = accessor instanceof Method ? ((Method)accessor).invoke(result, new Object[0]) : ((Field)accessor).get(result);
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)this.jpqlDelete, (Object[])new Object[]{"set ?" + (numParams + 1) + " " + String.valueOf(this.loggable(value))});
                    }
                    delete.setParameter(++numParams, value);
                }
                delete.executeUpdate();
                continue;
            }
            Object value = result;
            if (this.entityInfo.entityClass.isInstance(result) || this.entityInfo.recordClass != null && this.entityInfo.recordClass.isInstance(result)) {
                List<Member> accessors = this.entityInfo.attributeAccessors.get(this.entityInfo.attributeNames.get("id(this)"));
                if (accessors == null || accessors.isEmpty()) {
                    throw DataExtension.exc(MappingException.class, "CWWKD1025.missing.id.attr", this.entityInfo.getType().getName(), this.method.getName(), this.repositoryInterface);
                }
                for (Member accessor : accessors) {
                    value = accessor instanceof Method ? ((Method)accessor).invoke(value, new Object[0]) : ((Field)accessor).get(value);
                }
            } else if (!this.entityInfo.idType.isInstance(value) && (value = this.convert(result, this.entityInfo.idType, false)) == result) {
                throw DataExtension.exc(MappingException.class, "CWWKD1006.delete.rtrn.err", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), this.entityInfo.getType().getName(), this.entityInfo.idType);
            }
            Query delete = em.createQuery(this.jpqlDelete);
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)this.jpqlDelete, (Object[])new Object[]{"set ?1 " + String.valueOf(this.loggable(value))});
            }
            delete.setParameter(1, value);
            delete.executeUpdate();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"delete");
        }
    }

    @Trivial
    @ManualTrace
    Object delete(Object arg, EntityManager em) throws Exception {
        arg = arg instanceof Stream ? ((Stream)((Stream)((Object)arg)).sequential()).collect(Collectors.toList()) : arg;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"delete", (Object[])new Object[]{this.loggable(arg)});
        }
        int updateCount = 0;
        int numExpected = 0;
        if (arg instanceof Iterable) {
            for (Object e : (Iterable)arg) {
                ++numExpected;
                updateCount += this.deleteOne(e, em);
            }
        } else if (this.entityParamType.isArray()) {
            numExpected = Array.getLength(arg);
            for (int i = 0; i < numExpected; ++i) {
                updateCount += this.deleteOne(Array.get(arg, i), em);
            }
        } else {
            numExpected = 1;
            updateCount = this.deleteOne(arg, em);
        }
        if (numExpected == 0) {
            throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1092.lifecycle.arg.empty", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericParameterTypes()[0].getTypeName());
        }
        if (updateCount < numExpected) {
            if (numExpected == 1) {
                throw DataExtension.exc(OptimisticLockingFailureException.class, "CWWKD1051.single.opt.lock.exc", this.method.getName(), this.repositoryInterface.getName(), this.entityInfo.entityClass.getName(), Util.LIFE_CYCLE_METHODS_THAT_RETURN_ENTITIES_STATELESS);
            }
            throw DataExtension.exc(OptimisticLockingFailureException.class, "CWWKD1052.multi.opt.lock.exc", this.method.getName(), this.repositoryInterface.getName(), numExpected - updateCount, numExpected, this.entityInfo.entityClass.getName(), Util.LIFE_CYCLE_METHODS_THAT_RETURN_ENTITIES_STATELESS);
        }
        Object returnValue = this.toReturnValue(updateCount, this.method.getReturnType());
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"delete", (Object)this.loggable(returnValue));
        }
        return returnValue;
    }

    @ManualTrace
    private int deleteOne(Object e, EntityManager em) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"deleteOne", (Object[])new Object[]{this.loggable(e)});
        }
        Class<?> entityClass = this.entityInfo.getType();
        if (e == null) {
            throw DataExtension.exc(NullPointerException.class, "CWWKD1015.null.entity.param", this.method.getName(), this.repositoryInterface.getName());
        }
        if (!entityClass.isInstance(e)) {
            throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1016.incompat.entity.param", this.method.getName(), this.repositoryInterface.getName(), entityClass.getName(), e.getClass().getName());
        }
        String jpql = this.jpql;
        int versionParamIndex = (this.entityInfo.idClassAttributeAccessors == null ? 1 : this.entityInfo.idClassAttributeAccessors.size()) + 1;
        Object version = null;
        if (this.entityInfo.versionAttributeName != null && (version = this.getAttribute(e, this.entityInfo.versionAttributeName)) == null) {
            jpql = jpql.replace("=?" + versionParamIndex, " IS NULL");
        }
        Object id = null;
        String idAttributeName = null;
        if (this.entityInfo.idClassAttributeAccessors == null && (id = this.getAttribute(e, idAttributeName = this.getAttributeName("id(this)", true))) == null) {
            jpql = jpql.replace("=?" + (versionParamIndex - 1), " IS NULL");
            if (version != null) {
                jpql = jpql.replace("=?" + versionParamIndex, "=?" + (versionParamIndex - 1));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && jpql != this.jpql) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"JPQL adjusted for NULL id or version", (Object[])new Object[]{jpql});
        }
        TypedQuery delete = em.createQuery(jpql, this.entityInfo.entityClass);
        if (this.entityInfo.idClassAttributeAccessors == null) {
            int p = 1;
            if (id != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("set ?" + p + " " + String.valueOf(this.loggable(id))), (Object[])new Object[0]);
                }
                delete.setParameter(p++, id);
            }
            if (version != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("set ?" + p + " " + String.valueOf(this.loggable(version))), (Object[])new Object[0]);
                }
                delete.setParameter(p, version);
            }
        } else {
            this.setParametersFromIdClassAndVersion(1, (Query)delete, e, version);
        }
        int numDeleted = delete.executeUpdate();
        if (numDeleted == 0) {
            Class<?> returnType = this.method.getReturnType();
            if (Void.TYPE.equals(returnType) || Void.class.equals(returnType)) {
                if (idAttributeName == null) {
                    idAttributeName = "id(this)";
                }
                ArrayList<String> entityProps = new ArrayList<String>(2);
                if (id != null) {
                    entityProps.add(this.loggableAppend(idAttributeName, "=", id));
                }
                if (this.entityInfo.versionAttributeName != null && version != null) {
                    entityProps.add(this.loggableAppend(this.entityInfo.versionAttributeName, "=", version));
                }
                throw DataExtension.exc(OptimisticLockingFailureException.class, "CWWKD1050.opt.lock.exc", this.method.getName(), this.repositoryInterface.getName(), e.getClass().getName(), entityProps, Util.LIFE_CYCLE_METHODS_THAT_RETURN_ENTITIES_STATELESS);
            }
        } else if (numDeleted > 1) {
            throw new DataException("Found " + numDeleted + " matching entities.");
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"deleteOne", (Object)numDeleted);
        }
        return numDeleted;
    }

    @Trivial
    private static boolean endsWith(String searchFor, String text, int minStart, int endBefore) {
        int searchLen = searchFor.length();
        return endBefore - minStart >= searchLen && text.regionMatches(endBefore - searchLen, searchFor, 0, searchLen);
    }

    @Trivial
    private UnsupportedOperationException excCursorPaginationNotAllowed(String ql, int endOfWhereClause, boolean endsAtOrderClause) {
        if (endsAtOrderClause) {
            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1033.ql.orderby.disallowed", this.method.getName(), this.repositoryInterface.getName(), CursoredPage.class.getSimpleName(), OrderBy.class.getSimpleName(), ql);
        }
        throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1034.ql.req.end.in.where", this.method.getName(), this.repositoryInterface.getName(), CursoredPage.class.getSimpleName(), endOfWhereClause, ql.length(), ql);
    }

    @Trivial
    private EmptyResultException excEmptyResult() {
        return DataExtension.exc(EmptyResultException.class, "CWWKD1053.empty.result", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), List.of(List.class.getSimpleName(), Optional.class.getSimpleName(), Page.class.getSimpleName(), CursoredPage.class.getSimpleName(), Stream.class.getSimpleName()));
    }

    @Trivial
    private MappingException excExtraMethodArgNamedParams(Set<String> extras, Set<String> qlRequired) {
        String firstExtraParam = null;
        StringBuilder extraParamNames = new StringBuilder();
        for (String name : extras) {
            if (name.length() <= 0) continue;
            if (firstExtraParam == null) {
                firstExtraParam = name;
            } else {
                extraParamNames.append(", ");
            }
            extraParamNames.append(name);
        }
        if (firstExtraParam == null && !extras.isEmpty()) {
            return DataExtension.exc(MappingException.class, "CWWKD1104.empty.anno.value", Param.class.getSimpleName(), this.method.getName(), this.repositoryInterface.getName());
        }
        boolean isFirst = true;
        StringBuilder qlParamNames = new StringBuilder();
        for (String name : qlRequired) {
            if (!isFirst) {
                qlParamNames.append(", ");
            }
            qlParamNames.append(':').append(name);
            isFirst = false;
        }
        if (qlRequired.isEmpty()) {
            return DataExtension.exc(MappingException.class, "CWWKD1086.named.params.unused", this.method.getName(), this.repositoryInterface.getName(), extraParamNames, this.method.getAnnotation(jakarta.data.repository.Query.class).value(), ":" + firstExtraParam);
        }
        return DataExtension.exc(MappingException.class, "CWWKD1085.extra.method.params", this.method.getName(), this.repositoryInterface.getName(), extraParamNames, qlParamNames, this.method.getAnnotation(jakarta.data.repository.Query.class).value());
    }

    @Trivial
    private UnsupportedOperationException excIncompatible(Object param, Limit limit, PageRequest pageReq, Method method) {
        Class type;
        Class clazz = type = param instanceof Limit ? Limit.class : PageRequest.class;
        if (limit == null && pageReq == null) {
            return DataExtension.exc(UnsupportedOperationException.class, "CWWKD1099.first.keyword.incompat", method.getName(), this.repositoryInterface.getName(), type.getSimpleName());
        }
        if (param instanceof Limit ? limit != null : pageReq != null) {
            return DataExtension.exc(UnsupportedOperationException.class, "CWWKD1017.dup.special.param", method.getName(), this.repositoryInterface.getName(), type.getSimpleName());
        }
        throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1018.confl.special.param", method.getName(), this.repositoryInterface.getName(), Limit.class.getSimpleName(), PageRequest.class.getSimpleName());
    }

    @Trivial
    private UnsupportedOperationException excIncompatibleQueryResult(List<?> results, Object query) {
        String r = results.getClass().getName() + "<" + results.get(0).getClass().getName() + ">";
        if (query == null) {
            return DataExtension.exc(UnsupportedOperationException.class, "CWWKD1102.incompat.query.result", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName(), r);
        }
        return DataExtension.exc(UnsupportedOperationException.class, "CWWKD1103.incompat.query.result", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName(), query instanceof String ? query : query.getClass().getName(), r);
    }

    @Trivial
    private MappingException excLackingMethodArgNamedParams(Set<String> lacking) {
        this.validateParameterPositions();
        String first = null;
        StringBuilder all = new StringBuilder();
        for (String name : lacking) {
            if (first == null) {
                first = name;
            } else {
                all.append(", ");
            }
            all.append(':').append(name);
        }
        return DataExtension.exc(MappingException.class, "CWWKD1084.missing.named.params", this.method.getName(), this.repositoryInterface.getName(), all, this.method.getAnnotation(jakarta.data.repository.Query.class).value(), "@Param(\"" + first + "\")", "String " + first);
    }

    @Trivial
    private RuntimeException excMissingParamAnno(int p) {
        DataVersionCompatibility compat = this.producer.compat();
        switch (this.type) {
            case FIND: 
            case FIND_AND_DELETE: {
                this.validateParameterPositions();
                String specParams = this.type == QueryType.FIND ? compat.specialParamsForFind() : compat.specialParamsForFindAndDelete();
                throw DataExtension.exc(MappingException.class, "CWWKD1012.fd.missing.param.anno", p, this.method.getName(), this.repositoryInterface.getName(), specParams);
            }
            case QM_DELETE: 
            case COUNT: 
            case EXISTS: {
                throw DataExtension.exc(MappingException.class, "CWWKD1013.cde.missing.param.anno", p, this.method.getName(), this.repositoryInterface.getName());
            }
            case QM_UPDATE: {
                throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1014.upd.missing.param.anno", this.method.getName(), this.repositoryInterface.getName(), this.method.getParameterCount(), p, compat.paramAnnosForUpdate());
            }
        }
        throw new IllegalStateException(this.type.name());
    }

    @Trivial
    private UnsupportedOperationException excMixedQLParamTypes(int methodNPCount) {
        Parameter p;
        Param param;
        String firstNamedParam = null;
        StringBuilder allNamedParams = new StringBuilder().append('(');
        for (String name : this.jpqlParamNames) {
            if (firstNamedParam == null) {
                firstNamedParam = name;
            } else {
                allNamedParams.append(", ");
            }
            allNamedParams.append(':').append(name);
        }
        allNamedParams.append(')');
        Class firstNamedParamType = String.class;
        Parameter[] parameterArray = this.method.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        if (n2 < n && ((param = (p = parameterArray[n2]).getAnnotation(Param.class)) == null ? p.isNamePresent() && firstNamedParam.equals(p.getName()) : firstNamedParam.equals(param.value()))) {
            firstNamedParamType = p.getType();
        }
        return DataExtension.exc(UnsupportedOperationException.class, "CWWKD1019.mixed.positional.named", this.method.getName(), this.repositoryInterface.getName(), this.jpqlParamCount - methodNPCount, methodNPCount, allNamedParams, this.method.getAnnotation(jakarta.data.repository.Query.class).value(), ":" + firstNamedParam, "@Param(\"" + firstNamedParam + "\")", firstNamedParamType.getSimpleName() + " " + firstNamedParam);
    }

    @Trivial
    private NonUniqueResultException excNonUniqueResult(int numResults) {
        throw DataExtension.exc(NonUniqueResultException.class, "CWWKD1054.non.unique.result", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName(), numResults, List.of("findFirstByX(...)", "findByX(..., Limit.of(1))"));
    }

    @Trivial
    private UnsupportedOperationException excUnsupportedMethod() {
        return DataExtension.exc(UnsupportedOperationException.class, "CWWKD1011.unknown.method.pattern", this.method.getName(), this.repositoryInterface.getName(), Util.operationAnnoNames(this.producer), Util.resourceAccessorTypeNames(this.producer), Util.methodNamePrefixes(this.producer), this.entityInfo.getExampleMethodNames());
    }

    @Trivial
    @ManualTrace
    Object execute(EntityManager em, Object ... args) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"execute", (Object[])new Object[]{this.type});
        }
        Query update = em.createQuery(this.jpql);
        this.setParameters(update, args);
        int updateCount = update.executeUpdate();
        Object returnValue = this.toReturnValue(updateCount, this.method.getReturnType());
        if (trace && tc.isEntryEnabled()) {
            if (returnValue instanceof CompletableFuture) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)(String.valueOf(returnValue) + ": " + String.valueOf(((CompletableFuture)returnValue).getNow(null)) + " (" + updateCount + ")"));
            } else {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"execute", (Object)(String.valueOf(returnValue) + " (" + updateCount + ")"));
            }
        }
        return returnValue;
    }

    @Trivial
    @ManualTrace
    Object exists(EntityManager em, Object ... args) throws Exception {
        CompletableFuture<Boolean> returnVal;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"exists", (Object[])new Object[0]);
        }
        Query query = em.createQuery(this.jpql);
        query.setMaxResults(1);
        this.setParameters(query, args);
        List results = query.getResultList();
        boolean found = !results.isEmpty();
        Class<?> returnType = this.method.getReturnType();
        CompletableFuture<Boolean> completableFuture = returnVal = CompletableFuture.class.equals(returnType) || CompletionStage.class.equals(returnType) ? CompletableFuture.completedFuture(found) : Boolean.valueOf(found);
        if (trace && tc.isEntryEnabled()) {
            if (returnVal instanceof CompletableFuture) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"exists", (Object)(String.valueOf(returnVal) + ": " + found + " (" + results.size() + ")"));
            } else {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"exists", (Object)(String.valueOf(returnVal) + " (" + results.size() + ")"));
            }
        }
        return returnVal;
    }

    @Trivial
    @ManualTrace
    Object find(EntityManager em, Object ... args) throws Exception {
        Class<?> returnType;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"find", (Object[])new Object[]{this.type});
        }
        Limit limit = null;
        int max = this.maxResults;
        PageRequest pageReq = null;
        List<Sort<Object>> sortList = null;
        for (int i = this.jpqlParamCount; i < (args == null ? 0 : args.length); ++i) {
            Object param = args[i];
            if (param instanceof Limit) {
                if (max == 0 && limit == null && pageReq == null) {
                    limit = (Limit)param;
                    max = limit.maxResults();
                    continue;
                }
                throw this.excIncompatible(param, limit, pageReq, this.method);
            }
            if (param instanceof Order) {
                Iterable order = (Iterable)param;
                sortList = this.supplySorts(sortList, order);
                continue;
            }
            if (param instanceof PageRequest) {
                if (max == 0 && pageReq == null && limit == null) {
                    pageReq = (PageRequest)param;
                    max = pageReq.size();
                    continue;
                }
                throw this.excIncompatible(param, limit, pageReq, this.method);
            }
            if (param instanceof Sort) {
                List<Sort<Object>> newList = this.supplySorts(sortList, (Sort)param);
                sortList = newList;
                continue;
            }
            if (param instanceof Sort[]) {
                List<Sort<Object>> newList = this.supplySorts(sortList, (Sort[])param);
                sortList = newList;
                continue;
            }
            if (param == null) {
                boolean isSort = false;
                for (int s = 0; s < this.sortPositions.length; ++s) {
                    isSort |= this.sortPositions[s] == i;
                }
                if (isSort) continue;
                throw DataExtension.exc(NullPointerException.class, "CWWKD1087.null.param", this.method.getParameterTypes()[i].getName(), this.method.getName(), this.repositoryInterface.getName());
            }
            this.validateParameterPositions();
            throw DataExtension.exc(DataException.class, "CWWKD1023.extra.param", this.method.getName(), this.repositoryInterface.getName(), this.jpqlParamCount, this.method.getParameterTypes()[i].getName(), this.jpql);
        }
        if (sortList == null && this.sortPositions.length > 0) {
            sortList = this.sorts;
        }
        QueryInfo queryInfo = this;
        if (sortList == null || sortList.isEmpty()) {
            if (pageReq != null) {
                this.requireOrderedPagination(args);
            }
        } else {
            boolean forward = pageReq == null || pageReq.mode() != PageRequest.Mode.CURSOR_PREVIOUS;
            StringBuilder q = new StringBuilder(this.jpql);
            StringBuilder order = null;
            for (Sort<Object> sort : sortList) {
                this.validateSort(sort);
                order = order == null ? new StringBuilder(100).append(" ORDER BY ") : order.append(", ");
                this.generateSort(order, sort, forward);
            }
            if (pageReq == null || pageReq.mode() == PageRequest.Mode.OFFSET) {
                String jpqlOrdered = q.append((CharSequence)order).toString();
                queryInfo = new QueryInfo(this, jpqlOrdered, sortList);
            } else {
                queryInfo = new QueryInfo(this, null, sortList);
                queryInfo.generateCursorQueries(q, forward ? order : null, forward ? null : order);
            }
        }
        Object returnValue = queryInfo.find(limit, max, pageReq, sortList, em, args);
        if (this.isOptional) {
            Object object = returnValue = returnValue == null || returnValue instanceof Collection && ((Collection)returnValue).isEmpty() || returnValue instanceof Page && !((Page)returnValue).hasContent() ? Optional.empty() : Optional.of(returnValue);
        }
        if (CompletableFuture.class.equals(returnType = this.method.getReturnType()) || CompletionStage.class.equals(returnType)) {
            returnValue = CompletableFuture.completedFuture(returnValue);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"find", (Object)this.loggable(returnValue));
        }
        return returnValue;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Trivial
    @ManualTrace
    private Object find(Limit limit, int max, PageRequest pageReq, List<Sort<Object>> sortList, EntityManager em, Object ... args) throws Exception {
        Object returnValue;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"find", (Object[])new Object[]{"Limit: " + String.valueOf(limit), "max results: " + max, "PageRequest: " + String.valueOf(pageReq), "Sorts: " + String.valueOf(sortList)});
        }
        if (CursoredPage.class.equals(this.multiType)) {
            returnValue = new CursoredPageImpl(this, pageReq, args);
        } else if (Page.class.equals(this.multiType)) {
            PageRequest req = limit == null ? pageReq : this.toPageRequest(limit);
            returnValue = new PageImpl(this, req, args);
        } else {
            int startAt;
            if (pageReq != null && !PageRequest.Mode.OFFSET.equals((Object)pageReq.mode())) {
                throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1035.incompat.page.mode", pageReq.mode(), this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName(), CursoredPage.class.getSimpleName());
            }
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"createQuery", (Object[])new Object[]{this.jpql, this.entityInfo.entityClass.getName()});
            }
            Query query = em.createQuery(this.jpql);
            this.setParameters(query, args);
            if (this.type == QueryType.FIND_AND_DELETE) {
                query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
            }
            int n = limit != null ? this.computeOffset(limit) : (startAt = pageReq != null ? this.computeOffset(pageReq) : 0);
            if (max > 0) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("limit max results to " + max), (Object[])new Object[0]);
                }
                query.setMaxResults(max);
            }
            if (startAt > 0) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("start at (0-based) position " + startAt), (Object[])new Object[0]);
                }
                query.setFirstResult(startAt);
            }
            if (this.multiType != null && BaseStream.class.isAssignableFrom(this.multiType)) {
                Stream stream = query.getResultStream();
                if (Stream.class.equals(this.multiType)) {
                    returnValue = stream;
                } else if (IntStream.class.equals(this.multiType)) {
                    returnValue = stream.mapToInt(this::toInt);
                } else if (LongStream.class.equals(this.multiType)) {
                    returnValue = stream.mapToLong(this::toLong);
                } else {
                    if (!DoubleStream.class.equals(this.multiType)) throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1046.result.convert.err", List.class.getName(), this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName());
                    returnValue = stream.mapToDouble(this::toDouble);
                }
            } else {
                List results = query.getResultList();
                if (trace) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("result list type: " + (results == null ? null : results.getClass().toGenericString())), (Object[])new Object[0]);
                    if (results != null && !results.isEmpty()) {
                        Object r0 = results.get(0);
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("type of first result: " + (r0 == null ? null : r0.getClass().toGenericString())), (Object[])new Object[0]);
                    }
                }
                if (this.type == QueryType.FIND_AND_DELETE) {
                    this.delete(results, em);
                }
                if (results.isEmpty() && this.isOptional) {
                    returnValue = null;
                } else if (this.multiType == null && this.entityInfo.entityClass.equals(this.singleType)) {
                    returnValue = this.oneResult(results);
                } else if (this.multiType != null && this.multiType.isInstance(results) && (results.isEmpty() || this.singleType.isInstance(results.get(0)) && !(results.get(0) instanceof Object[]))) {
                    returnValue = results;
                } else if (this.multiType != null && Iterable.class.isAssignableFrom(this.multiType)) {
                    returnValue = this.convertToIterable(results, this.multiType, this.singleType, query);
                } else if (Iterator.class.equals(this.multiType)) {
                    returnValue = results.iterator();
                } else if (this.returnArrayType != null) {
                    int size = results.size();
                    Object firstNonNullResult = null;
                    for (Object e : results) {
                        if (e == null) continue;
                        firstNonNullResult = e;
                        break;
                    }
                    if (firstNonNullResult == null || this.type == QueryType.FIND_AND_DELETE || this.returnArrayType != Object.class && this.returnArrayType.isInstance(firstNonNullResult) || this.returnArrayType.isPrimitive() && Util.isWrapperClassFor(this.returnArrayType, firstNonNullResult.getClass())) {
                        returnValue = Array.newInstance(this.returnArrayType, size);
                        int i = 0;
                        for (Object result : results) {
                            Array.set(returnValue, i++, result);
                        }
                    } else {
                        if (!firstNonNullResult.getClass().isArray()) throw DataExtension.exc(MappingException.class, "CWWKD1046.result.convert.err", this.loggableAppend(firstNonNullResult.getClass().getName(), " (", firstNonNullResult, ")"), this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName());
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("convert " + firstNonNullResult.getClass().getName() + " to " + this.returnArrayType.getName()), (Object[])new Object[0]);
                        }
                        if (this.returnArrayType.isArray()) {
                            returnValue = Array.newInstance(this.returnArrayType, size);
                            int i = 0;
                            for (Object result : results) {
                                if (result == null) {
                                    Array.set(returnValue, i++, result);
                                    continue;
                                }
                                Class<?> subarrayType = this.returnArrayType.getComponentType();
                                int len = Array.getLength(result);
                                Object subarray = Array.newInstance(subarrayType, len);
                                for (int j = 0; j < len; ++j) {
                                    Object element = Array.get(result, j);
                                    if (!subarrayType.isInstance(element)) {
                                        element = this.convert(element, subarrayType, true);
                                    }
                                    Array.set(subarray, j, element);
                                }
                                Array.set(returnValue, i++, subarray);
                            }
                        } else {
                            if (size != 1) throw this.excNonUniqueResult(size);
                            if (this.isOptional && firstNonNullResult.getClass().equals(this.singleType)) {
                                returnValue = firstNonNullResult;
                            } else {
                                void var15_25;
                                int len = Array.getLength(firstNonNullResult);
                                returnValue = Array.newInstance(this.returnArrayType, len);
                                boolean bl = false;
                                while (var15_25 < len) {
                                    Object element = Array.get(firstNonNullResult, (int)var15_25);
                                    if (!this.returnArrayType.isInstance(element)) {
                                        element = this.convert(element, this.returnArrayType, true);
                                    }
                                    Array.set(returnValue, (int)var15_25, element);
                                    ++var15_25;
                                }
                            }
                        }
                    }
                } else {
                    if (results.isEmpty()) {
                        throw this.excEmptyResult();
                    }
                    returnValue = Iterable.class.isAssignableFrom(this.singleType) && !(results.get(0) instanceof Iterable) ? results : this.oneResult(results);
                    if (returnValue != null && !this.singleType.isAssignableFrom(returnValue.getClass())) {
                        returnValue = this.convert(returnValue, this.singleType, true);
                    }
                }
            }
        }
        if (!trace || !tc.isEntryEnabled()) return returnValue;
        Tr.exit((Object)this, (TraceComponent)tc, (String)"find", (Object)this.loggable(returnValue));
        return returnValue;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ManualTrace
    Object findAndUpdate(Object arg, EntityManager em) throws Exception {
        void var7_24;
        void var7_21;
        ArrayList<Object> results;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"findAndUpdate", (Object[])new Object[]{this.loggable(arg)});
        }
        boolean hasSingularEntityParam = false;
        if (this.entityParamType.isArray()) {
            void var7_10;
            int length = Array.getLength(arg);
            results = new ArrayList<Object>(length);
            boolean bl = false;
            while (var7_10 < length) {
                results.add(this.findAndUpdateOne(Array.get(arg, (int)var7_10), em));
                ++var7_10;
            }
        } else {
            arg = arg instanceof Stream ? ((Stream)((Stream)((Object)arg)).sequential()).collect(Collectors.toList()) : arg;
            results = new ArrayList();
            if (arg instanceof Iterable) {
                for (Object t : (Iterable)arg) {
                    results.add(this.findAndUpdateOne(t, em));
                }
            } else {
                hasSingularEntityParam = true;
                results = new ArrayList(1);
                results.add(this.findAndUpdateOne(arg, em));
            }
        }
        if (results.isEmpty()) {
            throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1092.lifecycle.arg.empty", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericParameterTypes()[0].getTypeName());
        }
        em.flush();
        Class<?> returnType = this.method.getReturnType();
        if (Void.TYPE.equals(returnType) || Void.class.equals(returnType)) {
            return null;
        }
        if (this.entityInfo.recordClass != null) {
            void var7_13;
            boolean bl = false;
            while (var7_13 < results.size()) {
                results.set((int)var7_13, this.entityInfo.toRecord(results.get((int)var7_13)));
                ++var7_13;
            }
        }
        if (this.returnArrayType != null) {
            Object[] newArray = (Object[])Array.newInstance(this.returnArrayType, results.size());
            Object[] objectArray = results.toArray(newArray);
        } else if (this.multiType == null) {
            if (results.size() == 1) {
                Object e = results.get(0);
            } else {
                if (!results.isEmpty()) throw this.excNonUniqueResult(results.size());
                Object var7_16 = null;
            }
        } else if (this.multiType.isInstance(results)) {
            ArrayList<Object> arrayList = results;
        } else if (Stream.class.equals(this.multiType)) {
            Stream stream = results.stream();
        } else if (Iterable.class.isAssignableFrom(this.multiType)) {
            Iterable<?> iterable = this.convertToIterable(results, this.multiType, null, null);
        } else {
            if (!Iterator.class.equals(this.multiType)) throw DataExtension.exc(MappingException.class, "CWWKD1003.rtrn.err", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), "Update", Util.lifeCycleReturnTypes(results.get(0).getClass().getSimpleName(), hasSingularEntityParam, false));
            Iterator iterator = results.iterator();
        }
        if (Optional.class.equals(returnType)) {
            Optional<Object> optional = var7_21 == null ? Optional.empty() : Optional.of(var7_21);
        } else if (CompletableFuture.class.equals(returnType) || CompletionStage.class.equals(returnType)) {
            CompletableFuture<void> completableFuture = CompletableFuture.completedFuture(var7_21);
        } else if (var7_21 != null && !returnType.isInstance(var7_21)) {
            throw DataExtension.exc(MappingException.class, "CWWKD1003.rtrn.err", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), "Update", Util.lifeCycleReturnTypes(results.get(0).getClass().getSimpleName(), hasSingularEntityParam, false));
        }
        if (!trace || !tc.isEntryEnabled()) return var7_24;
        Tr.exit((Object)this, (TraceComponent)tc, (String)"findAndUpdate", (Object)this.loggable(var7_24));
        return var7_24;
    }

    @ManualTrace
    private Object findAndUpdateOne(Object e, EntityManager em) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"findAndUpdateOne", (Object[])new Object[]{this.loggable(e)});
        }
        String jpql = this.jpql;
        int versionParamIndex = this.entityInfo.idClassAttributeAccessors == null ? 2 : this.entityInfo.idClassAttributeAccessors.size() + 1;
        Object version = null;
        if (this.entityInfo.versionAttributeName != null && (version = this.getAttribute(e, this.entityInfo.versionAttributeName)) == null) {
            jpql = jpql.replace("=?" + versionParamIndex, " IS NULL");
        }
        Object id = null;
        String idAttributeName = null;
        if (this.entityInfo.idClassAttributeAccessors == null && (id = this.getAttribute(e, idAttributeName = this.entityInfo.attributeNames.get("id(this)"))) == null) {
            jpql = jpql.replace("=?" + (versionParamIndex - 1), " IS NULL");
            if (version != null) {
                jpql = jpql.replace("=?" + versionParamIndex, "=?" + (versionParamIndex - 1));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && jpql != this.jpql) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"JPQL adjusted for NULL id or version", (Object[])new Object[]{jpql});
        }
        Class<?> entityClass = this.singleType.equals(this.entityInfo.recordClass) ? this.entityInfo.entityClass : this.singleType;
        TypedQuery query = em.createQuery(jpql, entityClass);
        query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        if (this.entityInfo.idClassAttributeAccessors == null) {
            int p = 1;
            if (id != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("set ?" + p + " " + String.valueOf(this.loggable(id))), (Object[])new Object[0]);
                }
                query.setParameter(p++, id);
            }
            if (version != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("set ?" + p + " " + String.valueOf(this.loggable(version))), (Object[])new Object[0]);
                }
                query.setParameter(p, version);
            }
        } else {
            this.setParametersFromIdClassAndVersion(1, (Query)query, e, version);
        }
        List results = query.getResultList();
        if (results.isEmpty()) {
            ArrayList<String> entityProps = new ArrayList<String>(2);
            if (id != null) {
                entityProps.add(this.loggableAppend(idAttributeName, "=", id));
            }
            if (this.entityInfo.versionAttributeName != null && version != null) {
                entityProps.add(this.loggableAppend(this.entityInfo.versionAttributeName, "=", version));
            }
            throw DataExtension.exc(OptimisticLockingFailureException.class, "CWWKD1050.opt.lock.exc", this.method.getName(), this.repositoryInterface.getName(), e.getClass().getName(), entityProps, Util.LIFE_CYCLE_METHODS_THAT_RETURN_ENTITIES_STATELESS);
        }
        Object returnValue = em.merge(this.toEntity(e));
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"findAndUpdateOne", (Object[])new Object[]{this.loggable(returnValue)});
        }
        return returnValue;
    }

    private void generateConstraint(String methodName, int start, int endBefore, StringBuilder q) {
        boolean isCollection;
        int length = endBefore - start;
        AttributeConstraint constraint = AttributeConstraint.Equal;
        switch (methodName.charAt(endBefore - 1)) {
            case 'n': {
                if (length <= 2) break;
                char ch = methodName.charAt(endBefore - 2);
                if (ch == 'a') {
                    if (QueryInfo.endsWith("GreaterTh", methodName, start, endBefore - 2)) {
                        constraint = AttributeConstraint.GreaterThan;
                        break;
                    }
                    if (!QueryInfo.endsWith("LessTh", methodName, start, endBefore - 2)) break;
                    constraint = AttributeConstraint.LessThan;
                    break;
                }
                if (ch == 'I') {
                    constraint = AttributeConstraint.In;
                    break;
                }
                if (ch != 'e' || !QueryInfo.endsWith("Betwe", methodName, start, endBefore - 2)) break;
                constraint = AttributeConstraint.Between;
                break;
            }
            case 'l': {
                if (length <= 4) break;
                char ch = methodName.charAt(endBefore - 2);
                if (ch == 'a') {
                    if (QueryInfo.endsWith("GreaterThanEqu", methodName, start, endBefore - 2)) {
                        constraint = AttributeConstraint.GreaterThanEqual;
                        break;
                    }
                    if (!QueryInfo.endsWith("LessThanEqu", methodName, start, endBefore - 2)) break;
                    constraint = AttributeConstraint.LessThanEqual;
                    break;
                }
                if (ch != 'l' || methodName.charAt(endBefore - 3) != 'u' || methodName.charAt(endBefore - 4) != 'N') break;
                constraint = AttributeConstraint.Null;
                break;
            }
            case 'e': {
                if (length <= 4) break;
                char ch = methodName.charAt(endBefore - 4);
                if (ch == 'L') {
                    if (methodName.charAt(endBefore - 3) != 'i' || methodName.charAt(endBefore - 2) != 'k') break;
                    constraint = AttributeConstraint.Like;
                    break;
                }
                if (ch == 'T') {
                    if (methodName.charAt(endBefore - 3) != 'r' || methodName.charAt(endBefore - 2) != 'u') break;
                    constraint = AttributeConstraint.True;
                    break;
                }
                if (!QueryInfo.endsWith("Fals", methodName, start, endBefore - 1)) break;
                constraint = AttributeConstraint.False;
                break;
            }
            case 'h': {
                if (length <= 8) break;
                char ch = methodName.charAt(endBefore - 8);
                if (ch == 'E') {
                    if (!QueryInfo.endsWith("ndsWit", methodName, start, endBefore - 1)) break;
                    constraint = AttributeConstraint.EndsWith;
                    break;
                }
                if (endBefore <= 10 || ch != 'a' || !QueryInfo.endsWith("StartsWit", methodName, start, endBefore - 1)) break;
                constraint = AttributeConstraint.StartsWith;
                break;
            }
            case 's': {
                if (!QueryInfo.endsWith("Contain", methodName, start, endBefore - 1)) break;
                constraint = AttributeConstraint.Contains;
                break;
            }
            case 'y': {
                if (!QueryInfo.endsWith("Empt", methodName, start, endBefore - 1)) break;
                constraint = AttributeConstraint.Empty;
            }
        }
        boolean negated = QueryInfo.endsWith(AttributeConstraint.Not.name(), methodName, start, endBefore -= constraint.lengthWithinMethodName());
        boolean ignoreCase = QueryInfo.endsWith(AttributeConstraint.IgnoreCase.name(), methodName, start, endBefore -= negated ? 3 : 0);
        String attribute = methodName.substring(start, endBefore -= ignoreCase ? 10 : 0);
        if (attribute.length() == 0) {
            throw this.excUnsupportedMethod();
        }
        String name = this.getAttributeName(attribute, true);
        StringBuilder attributeExpr = new StringBuilder();
        if (ignoreCase) {
            attributeExpr.append("LOWER(");
        }
        this.appendAttributeName(name, attributeExpr);
        if (ignoreCase) {
            attributeExpr.append(')');
        }
        if (negated) {
            constraint = constraint.negate();
            negated = constraint.isNegative();
        }
        if ((isCollection = this.entityInfo.collectionElementTypes.containsKey(name)) && (ignoreCase || !constraint.supportsCollections())) {
            throw DataExtension.exc(MappingException.class, "CWWKD1110.incompat.with.collection", this.method.getName(), this.repositoryInterface.getName(), ignoreCase ? AttributeConstraint.IgnoreCase.name() : constraint.name(), name, this.entityInfo.getType().getName(), Util.constraintsThatSupportCollections());
        }
        switch (constraint) {
            case Equal: 
            case GreaterThan: 
            case GreaterThanEqual: 
            case LessThan: 
            case LessThanEqual: 
            case Not: {
                q.append((CharSequence)attributeExpr).append(constraint.operator());
                QueryInfo.generateParam(q, ignoreCase, ++this.jpqlParamCount);
                break;
            }
            case StartsWith: 
            case NotStartsWith: {
                q.append((CharSequence)attributeExpr).append(negated ? " NOT " : " ").append("LIKE CONCAT(");
                QueryInfo.generateParam(q, ignoreCase, ++this.jpqlParamCount).append(", '%')");
                break;
            }
            case EndsWith: 
            case NotEndsWith: {
                q.append((CharSequence)attributeExpr).append(negated ? " NOT " : " ").append("LIKE CONCAT('%', ");
                QueryInfo.generateParam(q, ignoreCase, ++this.jpqlParamCount).append(")");
                break;
            }
            case Like: 
            case NotLike: {
                q.append((CharSequence)attributeExpr).append(negated ? " NOT " : " ").append("LIKE ");
                QueryInfo.generateParam(q, ignoreCase, ++this.jpqlParamCount);
                break;
            }
            case Between: 
            case NotBetween: {
                q.append((CharSequence)attributeExpr).append(constraint.operator());
                QueryInfo.generateParam(q, ignoreCase, ++this.jpqlParamCount).append(" AND ");
                QueryInfo.generateParam(q, ignoreCase, ++this.jpqlParamCount);
                break;
            }
            case Contains: 
            case NotContains: {
                if (isCollection) {
                    q.append(" ?").append(++this.jpqlParamCount).append(negated ? " NOT " : " ").append("MEMBER OF ").append((CharSequence)attributeExpr);
                    break;
                }
                q.append((CharSequence)attributeExpr).append(negated ? " NOT " : " ").append("LIKE CONCAT('%', ");
                QueryInfo.generateParam(q, ignoreCase, ++this.jpqlParamCount).append(", '%')");
                break;
            }
            case In: 
            case NotIn: {
                if (ignoreCase) {
                    throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1074.qbmn.incompat.keywords", this.method.getName(), this.repositoryInterface.getName(), AttributeConstraint.IgnoreCase.name(), constraint.name());
                }
                q.append((CharSequence)attributeExpr).append(constraint.operator());
                QueryInfo.generateParam(q, ignoreCase, ++this.jpqlParamCount);
                break;
            }
            case Null: 
            case NotNull: 
            case True: 
            case False: {
                q.append((CharSequence)attributeExpr).append(constraint.operator());
                break;
            }
            case Empty: {
                q.append((CharSequence)attributeExpr).append(isCollection ? AttributeConstraint.Empty.operator() : AttributeConstraint.Null.operator());
                break;
            }
            case NotEmpty: {
                q.append((CharSequence)attributeExpr).append(isCollection ? AttributeConstraint.NotEmpty.operator() : AttributeConstraint.NotNull.operator());
                break;
            }
            default: {
                throw new UnsupportedOperationException(constraint.name());
            }
        }
    }

    private void generateCount(String where) {
        String o = this.entityVar;
        StringBuilder q = new StringBuilder(21 + 2 * o.length() + this.entityInfo.name.length() + (where == null ? 0 : where.length())).append("SELECT COUNT(").append(o).append(") FROM ").append(this.entityInfo.name).append(' ').append(o);
        if (where != null) {
            q.append(where);
        }
        this.jpqlCount = q.toString();
    }

    private void generateCursorQueries(StringBuilder q, StringBuilder fwd, StringBuilder prev) {
        StringBuilder a;
        String paramPrefix;
        int numSorts = this.sorts.size();
        String string = paramPrefix = this.jpqlParamNames.isEmpty() ? "?" : ":cursor";
        StringBuilder stringBuilder = fwd == null ? null : (a = new StringBuilder(200).append(this.hasWhere ? " AND (" : " WHERE ("));
        StringBuilder b = prev == null ? null : new StringBuilder(200).append(this.hasWhere ? " AND (" : " WHERE (");
        for (int i = 0; i < numSorts; ++i) {
            if (a != null) {
                a.append(i == 0 ? "(" : " OR (");
            }
            if (b != null) {
                b.append(i == 0 ? "(" : " OR (");
            }
            for (int s = 0; s <= i; ++s) {
                Sort<Object> sort = this.sorts.get(s);
                String name = sort.property();
                boolean asc = sort.isAscending();
                boolean lower = sort.ignoreCase();
                if (a != null) {
                    if (lower) {
                        a.append(s == 0 ? "LOWER(" : " AND LOWER(");
                        this.appendAttributeName(name, a);
                        a.append(')');
                        a.append((char)(s < i ? 61 : (asc ? 62 : 60)));
                        a.append("LOWER(").append(paramPrefix).append(this.jpqlParamCount + 1 + s).append(')');
                    } else {
                        a.append(s == 0 ? "" : " AND ");
                        this.appendAttributeName(name, a);
                        a.append((char)(s < i ? 61 : (asc ? 62 : 60)));
                        a.append(paramPrefix).append(this.jpqlParamCount + 1 + s);
                    }
                }
                if (b == null) continue;
                if (lower) {
                    b.append(s == 0 ? "LOWER(" : " AND LOWER(");
                    this.appendAttributeName(name, b);
                    b.append(')');
                    b.append((char)(s < i ? 61 : (asc ? 60 : 62)));
                    b.append("LOWER(").append(paramPrefix).append(this.jpqlParamCount + 1 + s).append(')');
                    continue;
                }
                b.append(s == 0 ? "" : " AND ");
                this.appendAttributeName(name, b);
                b.append((char)(s < i ? 61 : (asc ? 60 : 62)));
                b.append(paramPrefix).append(this.jpqlParamCount + 1 + s);
            }
            if (a != null) {
                a.append(')');
            }
            if (b == null) continue;
            b.append(')');
        }
        if (a != null) {
            this.jpqlAfterCursor = new StringBuilder(q).append((CharSequence)a).append(')').append((CharSequence)fwd).toString();
        }
        if (b != null) {
            this.jpqlBeforeCursor = new StringBuilder(q).append((CharSequence)b).append(')').append((CharSequence)prev).toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"forward & previous cursor queries", (Object[])new Object[]{this.jpqlAfterCursor, this.jpqlBeforeCursor});
        }
    }

    private String generateDeleteById() {
        StringBuilder q;
        String o = this.entityVar;
        String o_ = this.entityVar_;
        if (this.entityInfo.idClassAttributeAccessors == null) {
            String idAttrName = this.entityInfo.attributeNames.get("id(this)");
            q = new StringBuilder(24 + this.entityInfo.name.length() + o.length() * 2 + idAttrName.length()).append("DELETE FROM ").append(this.entityInfo.name).append(' ').append(o).append(" WHERE ").append(o_).append(idAttrName).append("=?1");
        } else {
            q = new StringBuilder(200).append("DELETE FROM ").append(this.entityInfo.name).append(' ').append(o).append(" WHERE ");
            int count = 0;
            for (String idClassAttrName : this.entityInfo.idClassAttributeAccessors.keySet()) {
                if (++count != 1) {
                    q.append(" AND ");
                }
                q.append(o_).append(this.getAttributeName(idClassAttrName, true)).append("=?").append(count);
            }
        }
        return q.toString();
    }

    private StringBuilder generateDeleteEntity() {
        String o = this.entityVar;
        String o_ = this.entityVar_;
        StringBuilder q = new StringBuilder(100).append("DELETE FROM ").append(this.entityInfo.name).append(' ').append(o);
        if (this.method.getParameterCount() == 0) {
            this.type = QueryType.QM_DELETE;
            this.hasWhere = false;
        } else {
            this.setType(Delete.class, QueryType.LC_DELETE);
            this.hasWhere = true;
            q.append(" WHERE (");
            String idName = this.entityInfo.attributeNames.get("id(this)");
            if (idName == null && this.entityInfo.idClassAttributeAccessors != null) {
                boolean first = true;
                for (String name : this.entityInfo.idClassAttributeAccessors.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        q.append(" AND ");
                    }
                    name = this.entityInfo.attributeNames.get(name);
                    q.append(o_).append(name).append("=?").append(++this.jpqlParamCount);
                }
            } else {
                q.append(o_).append(idName).append("=?").append(++this.jpqlParamCount);
            }
            if (this.entityInfo.versionAttributeName != null) {
                q.append(" AND ").append(o_).append(this.entityInfo.versionAttributeName).append("=?").append(++this.jpqlParamCount);
            }
            q.append(')');
        }
        return q;
    }

    private void generateOrderBy(StringBuilder q) {
        boolean needsCursorQueries = CursoredPage.class.equals(this.multiType);
        StringBuilder fwd = needsCursorQueries ? new StringBuilder(100) : q;
        StringBuilder prev = needsCursorQueries ? new StringBuilder(100) : null;
        boolean first = true;
        for (Sort<Object> sort : this.sorts) {
            this.validateSort(sort);
            fwd.append(first ? " ORDER BY " : ", ");
            this.generateSort(fwd, sort, true);
            if (needsCursorQueries) {
                prev.append(first ? " ORDER BY " : ", ");
                this.generateSort(prev, sort, false);
            }
            first = false;
        }
        if (needsCursorQueries) {
            this.generateCursorQueries(q, fwd, prev);
            q.append((CharSequence)fwd);
        }
    }

    @Trivial
    private static StringBuilder generateParam(StringBuilder q, boolean lower, int num) {
        q.append(lower ? "LOWER(?" : Character.valueOf('?')).append(num);
        return lower ? q.append(')') : q;
    }

    @Trivial
    @ManualTrace
    private StringBuilder generateParamBasedQuery(StringBuilder q, Annotation methodAnno, boolean countPages) {
        int p;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"generateParamBasedQuery", (Object[])new Object[]{q, methodAnno == null ? null : methodAnno.annotationType().getSimpleName(), countPages});
        }
        String o = this.entityVar;
        String o_ = this.entityVar_;
        DataVersionCompatibility compat = this.entityInfo.builder.provider.compat;
        Boolean isNamePresent = null;
        Parameter[] params = null;
        Set specParamTypes = compat.specialParamTypes();
        Class<?>[] paramTypes = this.method.getParameterTypes();
        int numAttributeParams = paramTypes.length;
        while (numAttributeParams > 0 && specParamTypes.contains(paramTypes[numAttributeParams - 1])) {
            if (compat.isSpecialParamValid(paramTypes[--numAttributeParams], this.type)) continue;
            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1020.invalid.param.type", this.method.getName(), this.repositoryInterface.getName(), paramTypes[numAttributeParams].getSimpleName(), methodAnno.annotationType().getSimpleName());
        }
        Annotation[][] annosForAllParams = this.method.getParameterAnnotations();
        String[] attrNames = new String[numAttributeParams];
        AttributeConstraint[] constraints = new AttributeConstraint[numAttributeParams];
        char[] updateOps = new char[numAttributeParams];
        int[] qpStarts = new int[numAttributeParams];
        int qp = 1;
        for (int p2 = 0; p2 < numAttributeParams; ++p2) {
            qpStarts[p2] = qp;
            if ((qp = compat.inspectMethodParam(p2, paramTypes[p2], annosForAllParams[p2], attrNames, constraints, updateOps, qp)) == -1) {
                throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1117.anno.constraint.conflict", p2 + 1, this.method.getName(), this.repositoryInterface.getName(), Arrays.toString(annosForAllParams[p2]), paramTypes[p2].getClass().getName());
            }
            if (qp == -2) {
                throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1118.param.anno.conflict", p2 + 1, this.method.getName(), this.repositoryInterface.getName(), Arrays.toString(annosForAllParams[p2]));
            }
            if (qp == -3) {
                throw new IllegalArgumentException("jakarta.data.constraint.Constraint");
            }
            String name = attrNames[p2];
            if (name == null) {
                for (Annotation anno : annosForAllParams[p2]) {
                    if (!(anno instanceof By)) continue;
                    name = ((By)anno).value();
                }
            }
            if (name == null || name.length() == 0 && attrNames[p2] != null) {
                if (isNamePresent == null) {
                    params = this.method.getParameters();
                    isNamePresent = params[p2].isNamePresent();
                }
                if (Boolean.TRUE.equals(isNamePresent)) {
                    name = params[p2].getName();
                } else {
                    throw this.excMissingParamAnno(p2 + 1);
                }
            }
            attrNames[p2] = this.getAttributeName(name, true);
        }
        if (q == null && this.type == QueryType.FIND) {
            q = this.generateSelectClause().append(" FROM ").append(this.entityInfo.name).append(' ').append(o);
        } else if (q == null) {
            q = new StringBuilder(250).append("UPDATE ").append(this.entityInfo.name).append(' ').append(o).append(" SET");
            boolean first = true;
            for (p = 0; p < numAttributeParams; ++p) {
                char op = updateOps[p];
                if (op == '\u0000') continue;
                if (op != '=' && this.entityInfo.idClassAttributeAccessors != null && paramTypes[p].equals(this.entityInfo.idType)) {
                    throw new MappingException("One or more of the " + Arrays.toString(annosForAllParams[p]) + " annotations specifes an operation that cannot be used on parameter " + (p + 1) + " of the " + this.method.getName() + " method of the " + this.repositoryInterface.getName() + " repository when the Id is an IdClass.");
                }
                String name = attrNames[p];
                q.append(first ? " " : ", ");
                this.appendAttributeName(name, q);
                q.append("=");
                first = false;
                boolean withFunction = false;
                switch (op) {
                    case '=': {
                        break;
                    }
                    case '+': {
                        Class attrType = (Class)this.entityInfo.attributeTypes.get(name);
                        withFunction = CharSequence.class.isAssignableFrom(attrType);
                        if (withFunction) {
                            q.append("CONCAT(").append(o_).append(name).append(',');
                            break;
                        }
                        q.append(o_).append(name).append('+');
                        break;
                    }
                    default: {
                        q.append(o_).append(name).append(op);
                    }
                }
                ++this.jpqlParamCount;
                q.append('?').append(qpStarts[p]);
                if (!withFunction) continue;
                q.append(')');
            }
            if (first) {
                throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1009.lifecycle.param.err", this.method.getName(), this.repositoryInterface.getName(), this.method.getParameterCount(), Update.class.getSimpleName());
            }
        }
        int startIndexForWhereClause = q.length();
        for (p = 0; p < numAttributeParams; ++p) {
            if (constraints[p] == null) continue;
            if (this.hasWhere) {
                q.append(" AND ");
            } else {
                q.append(" WHERE (");
                this.hasWhere = true;
            }
            String name = attrNames[p];
            boolean isCollection = this.entityInfo.collectionElementTypes.containsKey(name);
            ++this.jpqlParamCount;
            compat.appendConstraint(q, o_, name, constraints[p], qpStarts[p], isCollection, annosForAllParams[p]);
        }
        if (this.hasWhere) {
            q.append(')');
        }
        if (countPages && this.type == QueryType.FIND) {
            this.generateCount(numAttributeParams == 0 ? null : q.substring(startIndexForWhereClause));
        }
        if (this.type == QueryType.FIND || this.type == QueryType.FIND_AND_DELETE) {
            this.initDynamicSortPositions(paramTypes);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"generateParamBasedQuery", (Object[])new Object[]{q});
        }
        return q;
    }

    @FFDCIgnore(value={RuntimeException.class})
    private StringBuilder generateSelectClause() {
        String[] cols;
        StringBuilder q = new StringBuilder(200);
        String o = this.entityVar;
        String o_ = this.entityVar_;
        Object[] selections = this.entityInfo.builder.provider.compat.getSelections((AnnotatedElement)this.method);
        if (selections.length == 0) {
            cols = null;
        } else {
            if (this.type == QueryType.FIND_AND_DELETE) {
                throw new UnsupportedOperationException("The " + this.method.getName() + " method of the " + this.repositoryInterface.getName() + " repository has a " + this.method.getGenericReturnType().getTypeName() + " return type and specifies to return the " + Arrays.toString(selections) + " entity attributes, but delete operations can only return void, a deletion count, a boolean deletion indicator, or the removed entities.");
            }
            cols = new String[selections.length];
            for (int i = 0; i < cols.length; ++i) {
                String name = this.getAttributeName((String)selections[i], true);
                cols[i] = name == null ? selections[i] : name;
            }
        }
        Class<?> singleType = this.singleType;
        if (singleType.isPrimitive()) {
            singleType = Util.wrapperClassIfPrimitive(singleType);
        }
        if (this.type == QueryType.FIND_AND_DELETE && !singleType.isAssignableFrom(Util.wrapperClassIfPrimitive(this.entityInfo.idType)) && !singleType.isAssignableFrom(this.entityInfo.getType())) {
            throw DataExtension.exc(MappingException.class, "CWWKD1006.delete.rtrn.err", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), this.entityInfo.getType().getName(), this.entityInfo.idType.getName());
        }
        if (cols == null || cols.length == 0) {
            if (singleType.isAssignableFrom(this.entityInfo.entityClass) || this.entityInfo.inheritance && this.entityInfo.entityClass.isAssignableFrom(singleType)) {
                if (!"this".equals(o)) {
                    q.append("SELECT ").append(o);
                }
            } else if (this.entityInfo.idClassAttributeAccessors != null && singleType.equals(this.entityInfo.idType)) {
                q.append("SELECT NEW ").append(singleType.getName()).append('(');
                boolean first = true;
                for (String idClassAttributeName : this.entityInfo.idClassAttributeAccessors.keySet()) {
                    String name = this.getAttributeName(idClassAttributeName, true);
                    q.append(first ? "" : ", ").append(o_).append(name);
                    first = false;
                }
                q.append(')');
            } else {
                RecordComponent[] recordComponents = singleType.getRecordComponents();
                if (recordComponents == null) {
                    String singleAttributeName = null;
                    for (Map.Entry<String, Class<?>> entry : this.entityInfo.attributeTypes.entrySet()) {
                        Class<?> attributeType = entry.getValue();
                        if (attributeType.isPrimitive()) {
                            attributeType = Util.wrapperClassIfPrimitive(attributeType);
                        }
                        if (!singleType.isAssignableFrom(attributeType)) continue;
                        if (singleAttributeName == null) {
                            singleAttributeName = entry.getKey();
                            continue;
                        }
                        throw DataExtension.exc(MappingException.class, "CWWKD1008.ambig.rtrn.err", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), List.of(singleAttributeName, entry.getKey()));
                    }
                    if (singleAttributeName == null) {
                        throw DataExtension.exc(MappingException.class, "CWWKD1005.find.rtrn.err", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName(), this.entityInfo.entityClass.getName(), List.of("List", "Optional", "Page", "CursoredPage", "Stream"));
                    }
                    q.append("SELECT ").append(o_).append(singleAttributeName);
                } else {
                    q.append("SELECT NEW ").append(singleType.getName()).append('(');
                    Object[] names = new String[recordComponents.length];
                    for (int i = 0; i < recordComponents.length; ++i) {
                        Object[] select = this.entityInfo.builder.provider.compat.getSelections((AnnotatedElement)recordComponents[i]);
                        if (select == null || select.length == 0) {
                            names[i] = recordComponents[i].getName();
                            continue;
                        }
                        if (select.length == 1) {
                            names[i] = select[0];
                            continue;
                        }
                        throw new UnsupportedOperationException("@Select " + Arrays.toString(select));
                    }
                    try {
                        boolean first = true;
                        for (String string : names) {
                            String string2 = this.getAttributeName(string, true);
                            q.append(first ? "" : ", ");
                            this.appendAttributeName(string2, q);
                            first = false;
                        }
                    }
                    catch (RuntimeException x) {
                        MappingException mx = DataExtension.exc(MappingException.class, "CWWKD1101.attr.subset.mismatch", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), singleType.getName(), Arrays.toString(names), this.entityInfo.getType().getName(), this.entityInfo.getAttributeNames());
                        throw (MappingException)mx.initCause((Throwable)x);
                    }
                    q.append(')');
                }
            }
        } else {
            boolean selectAsColumns;
            Class<?> entityType = this.entityInfo.getType();
            boolean bl = selectAsColumns = singleType.isAssignableFrom(entityType) || singleType.isInterface() || singleType.isPrimitive() || singleType.getName().startsWith("java") || this.entityInfo.inheritance && entityType.isAssignableFrom(singleType);
            if (!selectAsColumns && cols.length == 1) {
                String singleAttributeName = cols[0];
                Class attributeType = this.entityInfo.collectionElementTypes.get(singleAttributeName);
                if (attributeType == null) {
                    attributeType = (Class)this.entityInfo.attributeTypes.get(singleAttributeName);
                }
                boolean bl2 = selectAsColumns = attributeType != null && (Object.class.equals(attributeType) || singleType.isAssignableFrom(attributeType));
            }
            if (selectAsColumns) {
                for (int i = 0; i < cols.length; ++i) {
                    q.append(i == 0 ? "SELECT " : ", ");
                    this.appendAttributeName(cols[i], q);
                }
            } else {
                q.append("SELECT NEW ").append(singleType.getName()).append('(');
                for (int i = 0; i < cols.length; ++i) {
                    if (i > 0) {
                        q.append(", ");
                    }
                    this.appendAttributeName(cols[i], q);
                }
                q.append(')');
            }
        }
        return q;
    }

    @Trivial
    private void generateSort(StringBuilder q, Sort<?> sort, boolean sameDirection) {
        String propName = sort.property();
        if (sort.ignoreCase()) {
            q.append("LOWER(");
        }
        this.appendAttributeName(propName, q);
        if (sort.ignoreCase()) {
            q.append(")");
        }
        if (sameDirection) {
            if (sort.isDescending()) {
                q.append(" DESC");
            }
        } else if (sort.isAscending()) {
            q.append(" DESC");
        }
    }

    private StringBuilder generateUpdateEntity() {
        StringBuilder q;
        String o = this.entityVar;
        String o_ = this.entityVar_;
        if (this.entityInfo.attributeNamesForEntityUpdate != null && Util.UPDATE_COUNT_TYPES.contains(this.singleType)) {
            this.setType(Update.class, QueryType.LC_UPDATE);
            q = new StringBuilder(100).append("UPDATE ").append(this.entityInfo.name).append(' ').append(o).append(" SET ");
            boolean first = true;
            for (String name : this.entityInfo.attributeNamesForEntityUpdate) {
                if (first) {
                    first = false;
                } else {
                    q.append(", ");
                }
                q.append(o_).append(name).append("=?").append(++this.jpqlParamCount);
            }
        } else {
            this.setType(Update.class, QueryType.LC_UPDATE_RET_ENTITY);
            q = new StringBuilder(100).append("SELECT ").append(o).append(" FROM ").append(this.entityInfo.name).append(' ').append(o);
        }
        this.hasWhere = true;
        q.append(" WHERE (");
        String idName = this.entityInfo.attributeNames.get("id(this)");
        if (idName == null && this.entityInfo.idClassAttributeAccessors != null) {
            boolean first = true;
            for (String name : this.entityInfo.idClassAttributeAccessors.keySet()) {
                if (first) {
                    first = false;
                } else {
                    q.append(" AND ");
                }
                name = this.entityInfo.attributeNames.get(name);
                q.append(o_).append(name).append("=?").append(++this.jpqlParamCount);
            }
        } else {
            q.append(o_).append(idName).append("=?").append(++this.jpqlParamCount);
        }
        if (this.entityInfo.versionAttributeName != null) {
            q.append(" AND ").append(o_).append(this.entityInfo.versionAttributeName).append("=?").append(++this.jpqlParamCount);
        }
        q.append(')');
        return q;
    }

    private void generateWhereClause(String methodName, int start, int endBefore, StringBuilder q) {
        this.hasWhere = true;
        q.append(" WHERE (");
        int and = start;
        int or = start;
        int iNext = start;
        int i = start;
        while (this.hasWhere && i >= start && iNext < endBefore) {
            iNext = Math.min(and = and == -1 || and > i + 1 ? and : methodName.indexOf("And", i + 1), or = or == -1 || or > i + 1 ? or : methodName.indexOf("Or", i + 1));
            if (iNext < 0) {
                iNext = Math.max(and, or);
            }
            this.generateConstraint(methodName, i, iNext < 0 || iNext >= endBefore ? endBefore : iNext, q);
            if (iNext > 0 && iNext < endBefore) {
                q.append(iNext == and ? " AND " : " OR ");
                iNext += iNext == and ? 3 : 2;
            }
            i = iNext;
        }
        if (this.hasWhere) {
            q.append(')');
        }
    }

    @Trivial
    @ManualTrace
    private Object getAttribute(Object entity, String attributeName) throws Exception {
        List<Member> accessors;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getAttribute", (Object[])new Object[]{this.loggable(entity), attributeName});
        }
        if ((accessors = this.entityInfo.attributeAccessors.get(attributeName)) == null) {
            throw new IllegalArgumentException(attributeName);
        }
        Object value = entity;
        for (Member accessor : accessors) {
            Class<?> type = accessor.getDeclaringClass();
            if (type.isInstance(value)) {
                if (accessor instanceof Method) {
                    value = ((Method)accessor).invoke(value, new Object[0]);
                    continue;
                }
                value = ((Field)accessor).get(value);
                continue;
            }
            throw DataExtension.exc(MappingException.class, "CWWKD1059.attr.cast.err", this.method.getName(), this.repositoryInterface.getName(), attributeName, this.loggableAppend(entity.getClass().getName(), " (" + String.valueOf(entity) + ")"), accessor.getName(), type.getName(), this.loggableAppend(value.getClass().getName(), " (" + String.valueOf(value) + ")"));
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getAttribute", (Object)this.loggable(value));
        }
        return value;
    }

    @Trivial
    private String getAttributeName(String name, boolean failIfNotFound) {
        String attributeName;
        int len = name.length();
        if (len > 6 && name.charAt(len - 1) == ')') {
            if (name.regionMatches(true, len - 6, "(this", 0, 5)) {
                if (len == 8 && name.regionMatches(true, 0, "id", 0, 2) && this.entityInfo.idClassAttributeAccessors == null) {
                    attributeName = this.entityInfo.attributeNames.get("id(this)");
                    if (attributeName == null && failIfNotFound) {
                        throw DataExtension.exc(MappingException.class, "CWWKD1093.fn.not.applicable", name, this.entityInfo.getType().getName(), this.method.getName(), this.repositoryInterface.getName(), "@Id");
                    }
                } else if (len == 13 && name.regionMatches(true, 0, "version", 0, 7)) {
                    if (this.entityInfo.versionAttributeName == null && failIfNotFound) {
                        throw DataExtension.exc(MappingException.class, "CWWKD1093.fn.not.applicable", name, this.entityInfo.getType().getName(), this.method.getName(), this.repositoryInterface.getName(), "@Version");
                    }
                    attributeName = this.entityInfo.versionAttributeName;
                } else {
                    attributeName = new StringBuilder(len - 4 + this.entityVar.length()).append(name.substring(0, len - 5)).append(this.entityVar).append(')').toString();
                }
            } else {
                attributeName = name;
            }
        } else {
            if (len == 0) {
                throw DataExtension.exc(MappingException.class, "CWWKD1024.missing.entity.attr", this.method.getName(), this.repositoryInterface.getName(), this.entityInfo.getType().getName(), this.entityInfo.attributeTypes.keySet());
            }
            String lowerName = name.toLowerCase();
            attributeName = this.entityInfo.attributeNames.get(lowerName);
            if (attributeName == null && (attributeName = this.entityInfo.attributeNames.get(lowerName = lowerName.replace('.', '_'))) == null && (attributeName = this.entityInfo.attributeNames.get(lowerName = lowerName.replace("_", ""))) == null && failIfNotFound) {
                if (Util.hasOperationAnno(this.method, this.producer)) {
                    throw DataExtension.exc(MappingException.class, "CWWKD1010.unknown.entity.attr", name, this.entityInfo.getType().getName(), this.method.getName(), this.repositoryInterface.getName(), this.entityInfo.attributeTypes.keySet());
                }
                throw DataExtension.exc(MappingException.class, "CWWKD1091.method.name.parse.err", name, this.entityInfo.getType().getName(), this.method.getName(), this.repositoryInterface.getName(), Util.operationAnnoNames(this.producer), this.entityInfo.attributeTypes.keySet());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getAttributeName " + name + ": " + attributeName), (Object[])new Object[0]);
        }
        return attributeName;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    Object[] getCursorValues(Object entity) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        ArrayList<Object> cursorValues = new ArrayList<Object>();
        for (Sort<Object> sort : this.sorts) {
            try {
                List<Member> accessors = this.entityInfo.attributeAccessors.get(sort.property());
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("getCursorValues for " + String.valueOf(this.loggable(entity))), (Object[])new Object[]{accessors});
                }
                Object value = entity;
                for (Member accessor : accessors) {
                    if (accessor instanceof Method) {
                        value = ((Method)accessor).invoke(value, new Object[0]);
                        continue;
                    }
                    value = ((Field)accessor).get(value);
                }
                cursorValues.add(value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException accessors) {
                void x;
                FFDCFilter.processException((Throwable)accessors, (String)"io.openliberty.data.internal.persistence.QueryInfo", (String)"3384", (Object)this, (Object[])new Object[]{entity});
                throw new DataException((Throwable)(x instanceof InvocationTargetException ? x.getCause() : x));
            }
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getCursorValues: " + String.valueOf(this.loggable(cursorValues))), (Object[])new Object[0]);
        }
        return cursorValues.toArray();
    }

    @Trivial
    public final EntityInfo getEntityInfo() {
        return this.entityInfo;
    }

    @Trivial
    private <T> Sort<T> getWithAttributeName(String name, Sort<T> sort) {
        if ((name = this.getAttributeName(name, true)) == sort.property()) {
            return sort;
        }
        return sort.isAscending() ? (sort.ignoreCase() ? Sort.ascIgnoreCase((String)name) : Sort.asc((String)name)) : (sort.ignoreCase() ? Sort.descIgnoreCase((String)name) : Sort.desc((String)name));
    }

    @Trivial
    private static int indexOfAfterWhitespace(String text, String ql, int startAt) {
        int length = ql.length();
        while (startAt < length && Character.isWhitespace(ql.charAt(startAt))) {
            ++startAt;
        }
        return ql.regionMatches(true, startAt, text, 0, 2) ? startAt : -1;
    }

    private String inferCountFromSelect(String ql, int select0, int selectLen) {
        for (int i = select0; i < select0 + selectLen - 9; ++i) {
            char ch = ql.charAt(i);
            if (ch != 'D' && ch != 'd' || i != select0 && Character.isJavaIdentifierPart(ql.charAt(i - 1)) || Character.isJavaIdentifierPart(ql.charAt(i - 1)) || !ql.regionMatches(true, i + 1, "ISTINCT", 0, 7)) continue;
            return ql.substring(select0, select0 + selectLen);
        }
        return this.entityVar;
    }

    @Trivial
    QueryInfo init(EntityInfo entityInfo, RepositoryImpl<?> repository) {
        return this.init(Map.of(entityInfo.name, CompletableFuture.completedFuture(entityInfo)), repository);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Trivial
    @ManualTrace
    @FFDCIgnore(value={Throwable.class})
    QueryInfo init(Map<String, CompletableFuture<EntityInfo>> entityInfos, RepositoryImpl<?> repository) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"init", (Object[])new Object[]{entityInfos, this});
        }
        try {
            DataVersionCompatibility compat = repository.provider.compat;
            EntityInfo entityInfo = this.entityInfo = entityInfos.size() == 1 ? entityInfos.values().iterator().next().join() : null;
            if (repository.validator != null) {
                boolean[] v = repository.validator.isValidatable(this.method);
                this.validateParams = v[0];
                this.validateResult = v[1];
            }
            boolean countPages = Page.class.equals(this.multiType) || CursoredPage.class.equals(this.multiType);
            StringBuilder q = null;
            Delete delete = this.method.getAnnotation(Delete.class);
            Find find = this.method.getAnnotation(Find.class);
            Insert insert = this.method.getAnnotation(Insert.class);
            Update update = this.method.getAnnotation(Update.class);
            Save save = this.method.getAnnotation(Save.class);
            jakarta.data.repository.Query query = this.method.getAnnotation(jakarta.data.repository.Query.class);
            OrderBy[] orderBy = (OrderBy[])this.method.getAnnotationsByType(OrderBy.class);
            Annotation count = compat.getCountAnnotation(this.method);
            Annotation exists = compat.getExistsAnnotation(this.method);
            Annotation methodTypeAnno = this.validateAnnotationCombinations(delete, insert, update, save, find, query, orderBy, count, exists);
            if (query != null) {
                this.initQueryLanguage(query.value(), entityInfos, repository.primaryEntityInfoFuture, compat);
            } else if (save != null) {
                this.setType(Save.class, QueryType.SAVE);
            } else if (insert != null) {
                this.setType(Insert.class, QueryType.INSERT);
            } else if (this.entityParamType != null) {
                if (update != null) {
                    q = this.generateUpdateEntity();
                } else {
                    if (delete == null) throw new UnsupportedOperationException("The " + this.method.getName() + " method of the " + repository.repositoryInterface.getName() + " repository interface must be annotated with one of (Delete, Insert, Save, Update) because the method's parameter accepts entity instances. The following annotations were found: " + Arrays.toString(this.method.getAnnotations()));
                    q = this.generateDeleteEntity();
                }
            } else {
                q = methodTypeAnno != null ? this.initQueryByParameters(methodTypeAnno, countPages) : this.initQueryByMethodName(countPages);
                if (this.type == QueryType.FIND_AND_DELETE && this.multiType != null && Stream.class.isAssignableFrom(this.multiType)) {
                    throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1006.delete.rtrn.err", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), this.entityInfo.getType().getName(), this.entityInfo.idType.getName());
                }
            }
            if (orderBy.length > 0) {
                if (this.type != QueryType.FIND && this.type != QueryType.FIND_AND_DELETE) {
                    throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1096.orderby.incompat", this.method.getName(), this.repositoryInterface.getName());
                }
                if (this.sorts != null) {
                    throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1090.orderby.conflict", this.method.getName(), this.repositoryInterface.getName());
                }
                this.sorts = new ArrayList<Sort<Object>>(orderBy.length);
                if (q == null) {
                    if (this.jpql == null) {
                        q = this.generateSelectClause();
                        q.append(" FROM ").append(this.entityInfo.name).append(' ').append(this.entityVar);
                        if (countPages) {
                            this.generateCount(null);
                        }
                    } else {
                        q = new StringBuilder(this.jpql);
                    }
                }
                for (int i = 0; i < orderBy.length; ++i) {
                    this.addSort(orderBy[i].ignoreCase(), orderBy[i].value(), orderBy[i].descending());
                }
                if (this.sortPositions.length == 0) {
                    this.sortPositions = NONE_STATIC_SORT_ONLY;
                    this.generateOrderBy(q);
                }
            }
            if (this.type == QueryType.FIND && query == null && this.sortPositions.length == 0 && (this.sorts == null || this.sorts.isEmpty()) && (Page.class.equals(this.multiType) || CursoredPage.class.equals(this.multiType))) {
                this.sortPositions = NONE_STATIC_SORT_ONLY;
                String idAttr = this.entityInfo.attributeNames.get("id(this)");
                this.sorts = List.of(Sort.asc((String)idAttr));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("default sorting of " + String.valueOf(this.sorts)), (Object[])new Object[0]);
                }
                this.generateOrderBy(q);
            }
            this.jpql = q == null ? this.jpql : q.toString();
            this.validate();
            if (!trace || !tc.isEntryEnabled()) return this;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"init", (Object)new Object[]{this, this.entityInfo});
            return this;
        }
        catch (Throwable x) {
            String message = x.getMessage();
            if (message == null || !message.startsWith("CWWKD1")) {
                Tr.error((TraceComponent)tc, (String)"CWWKD1000.repo.general.err", (Object[])new Object[]{this.method.getName(), this.repositoryInterface.getName(), x});
            }
            if (!trace || !tc.isEntryEnabled()) throw x;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"init", (Object)x);
            throw x;
        }
    }

    @Trivial
    private void initDynamicSortPosition(int index) {
        if (this.sortPositions.length == 0) {
            this.sortPositions = new int[]{index};
        } else {
            int[] previous = this.sortPositions;
            this.sortPositions = new int[previous.length + 1];
            System.arraycopy(previous, 0, this.sortPositions, 0, previous.length);
            this.sortPositions[this.sortPositions.length - 1] = index;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("found sort criteria position (1-based): " + (index + 1)), (Object[])new Object[0]);
        }
    }

    @Trivial
    private void initDynamicSortPositions(Class<?>[] paramTypes) {
        for (int i = this.jpqlParamCount; i < paramTypes.length; ++i) {
            if (!Util.SORT_PARAM_TYPES.contains(paramTypes[i])) continue;
            this.initDynamicSortPosition(i);
        }
    }

    private void initQueryLanguage(String ql, Map<String, CompletableFuture<EntityInfo>> entityInfos, CompletableFuture<EntityInfo> primaryEntityInfoFuture, DataVersionCompatibility compat) {
        int startAt;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        LinkedHashSet<String> qlParamNames = new LinkedHashSet<String>();
        int length = ql.length();
        int firstChar = 32;
        for (startAt = 0; startAt < length; ++startAt) {
            char c = ql.charAt(startAt);
            firstChar = c;
            if (!Character.isWhitespace(c)) break;
        }
        if (firstChar == 68 || firstChar == 100) {
            if (startAt + 12 < length && ql.regionMatches(true, startAt + 1, "ELETE", 0, 5) && Character.isWhitespace(ql.charAt(startAt + 6))) {
                this.type = QueryType.QM_DELETE;
                startAt += 7;
            }
            modifyAt = this.parseQuery(ql, startAt, null, true, entityInfos, qlParamNames);
            if (this.entityInfo == null) {
                this.setEntityInfo(entityInfos, primaryEntityInfoFuture);
            }
            this.jpql = modifyAt.isEmpty() || this.entityInfo.recordClass == null ? ql : this.replaceQuery(ql, -1, modifyAt);
        } else if (firstChar == 85 || firstChar == 117) {
            int entityNameStartAt = -1;
            if (startAt + 13 < length && ql.regionMatches(true, startAt + 1, "PDATE", 0, 5) && Character.isWhitespace(ql.charAt(startAt + 6))) {
                char ch;
                this.type = QueryType.QM_UPDATE;
                entityNameStartAt = startAt += 7;
                while (startAt < length && Character.isWhitespace(ql.charAt(startAt))) {
                    ++startAt;
                }
                StringBuilder entityName = new StringBuilder();
                while (startAt < length && Character.isJavaIdentifierPart(ch = ql.charAt(startAt))) {
                    entityName.append(ch);
                    ++startAt;
                }
                if (entityName.length() <= 0) {
                    throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1030.ql.lacks.entity", ql, this.method.getName(), this.repositoryInterface.getName(), "UPDATE", "UPDATE [entity_name] SET [update_items] WHERE [conditional_expression]");
                }
                this.setEntityInfo(entityName.toString(), entityInfos, ql);
                this.entityVar = this.parseIdentificationVariable(startAt, length, ql);
                this.entityVar_ = this.entityVar == "this" ? "" : this.entityVar + ".";
            }
            modifyAt = this.parseQuery(ql, startAt, null, false, entityInfos, qlParamNames);
            modifyAt.put(entityNameStartAt, QueryEdit.REPLACE_RECORD_ENTITY);
            if (this.entityInfo == null) {
                this.setEntityInfo(entityInfos, primaryEntityInfoFuture);
            }
            this.jpql = this.entityInfo.recordClass == null ? ql : this.replaceQuery(ql, -1, modifyAt);
        } else {
            this.type = QueryType.FIND;
            int select0 = -1;
            if (length > startAt + 6 && ql.regionMatches(true, startAt, "SELECT", 0, 6) && !Character.isJavaIdentifierPart(ql.charAt(startAt + 6))) {
                select0 = startAt += 6;
            }
            modifyAt = this.parseQuery(ql, startAt, select0 >= 0, true, entityInfos, qlParamNames);
            if (this.entityInfo == null) {
                this.setEntityInfo(entityInfos, primaryEntityInfoFuture);
            }
            this.jpql = this.replaceQuery(ql, select0, modifyAt);
        }
        int qlParamNameCount = qlParamNames.size();
        boolean hasExtraParam = false;
        Parameter[] params = this.method.getParameters();
        Set specParamTypes = compat.specialParamTypes();
        int i = 0;
        while (i < params.length && !specParamTypes.contains(params[i].getType())) {
            Param param = params[i].getAnnotation(Param.class);
            String paramName = null;
            if (param != null) {
                paramName = param.value();
            } else if (qlParamNameCount > 0 && params[i].isNamePresent()) {
                paramName = params[i].getName();
            }
            if (paramName != null) {
                boolean isDuplicate;
                if (this.jpqlParamNames.isEmpty()) {
                    this.jpqlParamNames = new LinkedHashSet<String>();
                }
                boolean bl = isDuplicate = !this.jpqlParamNames.add(paramName);
                if (qlParamNames.contains(paramName)) {
                    if (isDuplicate) {
                        throw DataExtension.exc(MappingException.class, "CWWKD1083.dup.method.param", this.method.getName(), this.repositoryInterface.getName(), paramName, "@Param(\"" + paramName + "\")", params[i].getType().getSimpleName() + " " + paramName);
                    }
                } else {
                    hasExtraParam = true;
                }
            }
            this.jpqlParamCount = ++i;
        }
        this.sortPositions = NONE_QUERY_LANGUAGE_ONLY;
        for (i = this.jpqlParamCount; i < params.length; ++i) {
            if (!Util.SORT_PARAM_TYPES.contains(params[i].getType())) continue;
            this.initDynamicSortPosition(i);
        }
        int paramNamesCount = this.jpqlParamNames.size();
        if (hasExtraParam || qlParamNameCount != paramNamesCount) {
            LinkedHashSet<String> lacking = new LinkedHashSet<String>(qlParamNames);
            lacking.removeAll(this.jpqlParamNames);
            if (!lacking.isEmpty()) {
                throw this.excLackingMethodArgNamedParams(lacking);
            }
            LinkedHashSet<String> extras = new LinkedHashSet<String>(this.jpqlParamNames);
            extras.removeAll(qlParamNames);
            if (!extras.isEmpty()) {
                throw this.excExtraMethodArgNamedParams(extras, qlParamNames);
            }
        }
        if (paramNamesCount > 0 && paramNamesCount < this.jpqlParamCount) {
            throw this.excMixedQLParamTypes(paramNamesCount);
        }
    }

    private StringBuilder initQueryByMethodName(boolean countPages) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        String methodName = this.method.getName();
        String o = this.entityVar;
        StringBuilder q = null;
        int by = methodName.indexOf("By");
        if (methodName.startsWith("find")) {
            int orderBy = -1;
            if (by >= 9 && methodName.regionMatches(by - 5, "Order", 0, 5)) {
                orderBy = by - 5;
                by = -1;
            } else if (by > 0) {
                orderBy = methodName.indexOf("OrderBy", by + 2);
            }
            this.parseFindClause(by > 0 ? by : (orderBy > 0 ? orderBy : -1));
            q = this.generateSelectClause().append(" FROM ").append(this.entityInfo.name).append(' ').append(o);
            if (by > 0) {
                int where = q.length();
                this.generateWhereClause(methodName, by + 2, orderBy > 0 ? orderBy : methodName.length(), q);
                if (countPages) {
                    this.generateCount(q.substring(where));
                }
            }
            this.initDynamicSortPositions(this.method.getParameterTypes());
            if (orderBy >= 0) {
                this.parseOrderBy(orderBy, q);
            }
            this.type = QueryType.FIND;
        } else if (methodName.startsWith("delete") || methodName.startsWith("remove")) {
            int orderBy = -1;
            boolean isFindAndDelete = this.isFindAndDelete();
            if (isFindAndDelete) {
                if (by >= 11 && methodName.regionMatches(by - 5, "Order", 0, 5)) {
                    orderBy = by - 5;
                    by = -1;
                } else if (by > 0) {
                    orderBy = methodName.indexOf("OrderBy", by + 2);
                }
                this.type = QueryType.FIND_AND_DELETE;
                q = this.generateSelectClause().append(" FROM ").append(this.entityInfo.name).append(' ').append(o);
                this.jpqlDelete = this.generateDeleteById();
            } else {
                this.type = QueryType.QM_DELETE;
                q = new StringBuilder(150).append("DELETE FROM ").append(this.entityInfo.name).append(' ').append(o);
            }
            if (by > 0) {
                this.generateWhereClause(methodName, by + 2, orderBy > 0 ? orderBy : methodName.length(), q);
            }
            this.initDynamicSortPositions(this.method.getParameterTypes());
            if (orderBy > 0) {
                this.parseOrderBy(orderBy, q);
            }
            this.type = this.type == null ? QueryType.QM_DELETE : this.type;
        } else if (methodName.startsWith("count")) {
            q = new StringBuilder(150).append("SELECT COUNT(").append(o).append(") FROM ").append(this.entityInfo.name).append(' ').append(o);
            if (by > 0 && methodName.length() > by + 2) {
                this.generateWhereClause(methodName, by + 2, methodName.length(), q);
            }
            this.type = QueryType.COUNT;
        } else if (methodName.startsWith("exists")) {
            q = new StringBuilder(200).append("SELECT ID(").append(o).append(") FROM ").append(this.entityInfo.name).append(' ').append(o);
            if (by > 0 && methodName.length() > by + 2) {
                this.generateWhereClause(methodName, by + 2, methodName.length(), q);
            }
            this.type = QueryType.EXISTS;
            this.validateReturnForExists();
        } else {
            throw this.excUnsupportedMethod();
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(methodName + " is identified as a " + String.valueOf(this.type) + " method"), (Object[])new Object[0]);
        }
        return q;
    }

    @Trivial
    @ManualTrace
    private StringBuilder initQueryByParameters(Annotation methodTypeAnno, boolean countPages) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"initQueryByParameters", (Object[])new Object[]{methodTypeAnno == null ? null : methodTypeAnno.annotationType().getSimpleName(), countPages});
        }
        String o = this.entityVar;
        StringBuilder q = null;
        if (methodTypeAnno instanceof Find) {
            this.type = QueryType.FIND;
            q = this.generateParamBasedQuery(null, methodTypeAnno, countPages);
        } else if (methodTypeAnno instanceof Update) {
            this.type = QueryType.QM_UPDATE;
            q = this.generateParamBasedQuery(null, methodTypeAnno, countPages);
        } else if (methodTypeAnno instanceof Delete) {
            if (this.isFindAndDelete()) {
                this.type = QueryType.FIND_AND_DELETE;
                q = this.generateSelectClause().append(" FROM ").append(this.entityInfo.name).append(' ').append(o);
                this.jpqlDelete = this.generateDeleteById();
            } else {
                this.type = QueryType.QM_DELETE;
                q = new StringBuilder(150).append("DELETE FROM ").append(this.entityInfo.name).append(' ').append(o);
            }
            if (this.method.getParameterCount() > 0) {
                this.generateParamBasedQuery(q, methodTypeAnno, countPages);
            }
        } else if ("Count".equals(methodTypeAnno.annotationType().getSimpleName())) {
            this.type = QueryType.COUNT;
            q = new StringBuilder(150).append("SELECT COUNT(").append(o).append(") FROM ").append(this.entityInfo.name).append(' ').append(o);
            if (this.method.getParameterCount() > 0) {
                this.generateParamBasedQuery(q, methodTypeAnno, countPages);
            }
        } else if ("Exists".equals(methodTypeAnno.annotationType().getSimpleName())) {
            this.type = QueryType.EXISTS;
            this.validateReturnForExists();
            q = new StringBuilder(200).append("SELECT ID(").append(o).append(") FROM ").append(this.entityInfo.name).append(' ').append(o);
            if (this.method.getParameterCount() > 0) {
                this.generateParamBasedQuery(q, methodTypeAnno, countPages);
            }
        } else {
            throw new IllegalArgumentException(methodTypeAnno.toString());
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"initQueryByParameters", (Object)new Object[]{q, this.type});
        }
        return q;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Trivial
    @ManualTrace
    Object insert(Object arg, EntityManager em) throws Exception {
        void var9_25;
        void var9_23;
        int entityCount;
        ArrayList<Object> results;
        arg = arg instanceof Stream ? ((Stream)((Stream)((Object)arg)).sequential()).collect(Collectors.toList()) : arg;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"insert", (Object[])new Object[]{this.loggable(arg)});
        }
        boolean resultVoid = Void.TYPE.equals(this.singleType) || Void.class.equals(this.singleType);
        boolean hasSingularEntityParam = false;
        if (this.entityParamType.isArray()) {
            int length = Array.getLength(arg);
            ArrayList<Object> arrayList = results = resultVoid ? null : new ArrayList<Object>(length);
            for (entityCount = 0; entityCount < length; ++entityCount) {
                Object object = this.toEntity(Array.get(arg, entityCount));
                em.persist(object);
                if (results == null) continue;
                results.add(object);
            }
            em.flush();
        } else if (arg instanceof Iterable) {
            results = resultVoid ? null : new ArrayList();
            for (Object t : (Iterable)arg) {
                ++entityCount;
                Object entity = this.toEntity(t);
                em.persist(entity);
                if (results == null) continue;
                results.add(entity);
            }
            em.flush();
        } else {
            entityCount = 1;
            hasSingularEntityParam = true;
            results = resultVoid ? null : new ArrayList<Object>(1);
            Object entity = this.toEntity(arg);
            em.persist(entity);
            em.flush();
            if (results != null) {
                results.add(entity);
            }
        }
        if (entityCount == 0) {
            throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1092.lifecycle.arg.empty", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericParameterTypes()[0].getTypeName());
        }
        Class<?> returnType = this.method.getReturnType();
        if (resultVoid) {
            Object var9_15 = null;
        } else {
            if (this.entityInfo.recordClass != null) {
                for (int i = 0; i < results.size(); ++i) {
                    results.set(i, this.entityInfo.toRecord(results.get(i)));
                }
            }
            if (this.returnArrayType != null) {
                Object[] newArray = (Object[])Array.newInstance(this.returnArrayType, results.size());
                Object[] objectArray = results.toArray(newArray);
            } else if (this.multiType == null) {
                if (results.size() == 1) {
                    Object e = results.get(0);
                } else {
                    if (!results.isEmpty()) throw DataExtension.exc(ClassCastException.class, "CWWKD1094.return.mismatch", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName(), results.size(), "@Insert", Util.lifeCycleReturnTypes(this.entityInfo.getType().getName(), hasSingularEntityParam, false));
                    Object var9_18 = null;
                }
            } else if (this.multiType.isInstance(results)) {
                ArrayList<Object> arrayList = results;
            } else if (Stream.class.equals(this.multiType)) {
                Stream stream = results.stream();
            } else if (Iterable.class.isAssignableFrom(this.multiType)) {
                Iterable<?> iterable = this.convertToIterable(results, this.multiType, null, null);
            } else {
                if (!Iterator.class.equals(this.multiType)) throw DataExtension.exc(MappingException.class, "CWWKD1003.rtrn.err", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), "Insert", Util.lifeCycleReturnTypes(results.get(0).getClass().getSimpleName(), hasSingularEntityParam, false));
                Iterator iterator = results.iterator();
            }
        }
        if (CompletableFuture.class.equals(returnType) || CompletionStage.class.equals(returnType)) {
            CompletableFuture<void> completableFuture = CompletableFuture.completedFuture(var9_23);
        } else if (!resultVoid && !returnType.isInstance(var9_23)) {
            throw DataExtension.exc(MappingException.class, "CWWKD1003.rtrn.err", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), "Insert", Util.lifeCycleReturnTypes(results.get(0).getClass().getSimpleName(), hasSingularEntityParam, false));
        }
        if (!trace || !tc.isEntryEnabled()) return var9_25;
        Tr.exit((Object)this, (TraceComponent)tc, (String)"insert", (Object)this.loggable(var9_25));
        return var9_25;
    }

    @Trivial
    @FFDCIgnore(value={Throwable.class})
    public void introspect(PrintWriter writer, String indent, CompletableFuture<QueryInfo> future) {
        writer.println((String)indent + "QueryInfo@" + Integer.toHexString(this.hashCode()));
        indent = (String)indent + "  ";
        writer.println((String)indent + "entity: " + String.valueOf(this.entityInfo));
        writer.println((String)indent + "repository: " + this.repositoryInterface.getName());
        Type[] paramTypes = this.method.getGenericParameterTypes();
        Annotation[][] paramAnnos = this.method.getParameterAnnotations();
        Parameter[] params = this.method.getParameters();
        for (Annotation anno : this.method.getAnnotations()) {
            writer.println((String)indent + String.valueOf(anno));
        }
        writer.println((String)indent + this.method.getGenericReturnType().getTypeName() + " " + this.method.getName() + (paramTypes.length == 0 ? "()" : "("));
        for (int i = 0; i < paramTypes.length; ++i) {
            for (Annotation paramAnno : paramAnnos[i]) {
                writer.println((String)indent + "  " + String.valueOf(paramAnno));
            }
            writer.println((String)indent + "  " + paramTypes[i].getTypeName() + " " + params[i].getName() + (i == paramTypes.length - 1 ? (char)')' : ','));
        }
        writer.println((String)indent + "return array type: " + (this.returnArrayType == null ? null : this.returnArrayType.getName()));
        writer.println((String)indent + "multiple result type: " + (this.multiType == null ? null : this.multiType.getName()));
        writer.println((String)indent + "single result type: " + (this.singleType == null ? null : this.singleType.getName()));
        writer.println((String)indent + "collection or array element type of single result type: " + (this.singleTypeElementType == null ? null : this.singleTypeElementType.getName()));
        writer.println((String)indent + "result is Optional? " + this.isOptional);
        writer.println((String)indent + "entity identifier variable: " + this.entityVar + " [" + this.entityVar_ + "]");
        writer.println((String)indent + "hasWhere? " + this.hasWhere);
        writer.println((String)indent + "type: " + String.valueOf(this.type));
        writer.println((String)indent + "life cycle method entity parameter type: " + (this.entityParamType == null ? null : this.entityParamType.getName()));
        String jpqlIndent = (String)indent + "      ";
        writer.print((String)indent + "JPQL: ");
        Util.printlnIndented(this.jpql, writer, jpqlIndent);
        writer.print((String)indent + "JPQL for afterCursor: ");
        Util.printlnIndented(this.jpqlAfterCursor, writer, jpqlIndent);
        writer.print((String)indent + "JPQL for jpqlBeforeCursor: ");
        Util.printlnIndented(this.jpqlBeforeCursor, writer, jpqlIndent);
        writer.print((String)indent + "JPQL count query: ");
        Util.printlnIndented(this.jpqlCount, writer, jpqlIndent);
        writer.print((String)indent + "JPQL delete query: ");
        Util.printlnIndented(this.jpqlDelete, writer, jpqlIndent);
        writer.println((String)indent + "JPQL parameter count: " + this.jpqlParamCount);
        writer.println((String)indent + "JPQL parameter names: " + String.valueOf(this.jpqlParamNames));
        writer.println((String)indent + "maximum results: " + this.maxResults);
        writer.println((String)indent + "sorts: " + String.valueOf(this.sorts));
        writer.print((String)indent + "positions of sort-related method parameters: ");
        if (this.sortPositions.length == 0) {
            if (this.sortPositions == NONE) {
                writer.println("no sort parameters and no static sort");
            } else if (this.sortPositions == NONE_QUERY_LANGUAGE_ONLY) {
                writer.println("no sort parameters, but has @Query");
            } else if (this.sortPositions == NONE_STATIC_SORT_ONLY) {
                writer.println("no sort parameters, but has OrderBy");
            } else {
                writer.println();
            }
        } else {
            writer.println(Arrays.toString(this.sortPositions));
        }
        writer.println((String)indent + "validate method parameters? " + this.validateParams);
        writer.println((String)indent + "validate method result? " + this.validateResult);
        if (future != null) {
            writer.print((String)indent + "state: ");
            if (future.isCancelled()) {
                writer.println("cancelled");
            } else if (future.isDone()) {
                try {
                    future.join();
                    writer.println("completed");
                }
                catch (Throwable x) {
                    writer.println("failed");
                    Util.printStackTrace(x, writer, (String)indent + "  ", null);
                }
            } else {
                writer.println("not completed");
            }
        }
    }

    @Trivial
    private boolean isFindAndDelete() {
        boolean isFindAndDelete;
        boolean bl = isFindAndDelete = this.isOptional || this.multiType != null || !Util.RETURN_TYPES_FOR_DELETE_ONLY.contains(this.singleType);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("isFindAndDelete? " + isFindAndDelete + "; optional?: " + this.isOptional + "; multiType: " + (this.multiType == null ? null : this.multiType.getSimpleName()) + "; singleType: " + (this.singleType == null ? null : this.singleType.getSimpleName())), (Object[])new Object[0]);
        }
        if (!(!isFindAndDelete || this.type == null || this.type.equals(this.entityInfo.entityClass) || this.type.equals(this.entityInfo.recordClass) || this.type.equals(Object.class) || Util.wrapperClassIfPrimitive(this.singleType).equals(Util.wrapperClassIfPrimitive(this.entityInfo.idType)))) {
            throw DataExtension.exc(MappingException.class, "CWWKD1006.delete.rtrn.err", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), this.entityInfo.getType().getName(), this.entityInfo.idType.getName());
        }
        return isFindAndDelete;
    }

    @Trivial
    final Object loggable(Object value) {
        return this.entityInfo.builder.provider.loggable(this.repositoryInterface, this.method, value);
    }

    @Trivial
    private final String loggableAppend(String prefix, Object ... possibleSuffix) {
        return this.entityInfo.builder.provider.loggableAppend(this.repositoryInterface, this.method, prefix, possibleSuffix);
    }

    void missingPageRequest() {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        boolean signatureHasPageReq = false;
        for (int i = this.jpqlParamCount; i < paramTypes.length; ++i) {
            signatureHasPageReq |= PageRequest.class.equals(paramTypes[i]);
        }
        if (signatureHasPageReq) {
            throw DataExtension.exc(NullPointerException.class, "CWWKD1087.null.param", PageRequest.class.getName(), this.method.getName(), this.repositoryInterface.getName());
        }
        throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1041.rtrn.mismatch.pagereq", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName());
    }

    @Trivial
    private final Object oneResult(List<?> results) {
        int size = results.size();
        if (size == 1) {
            return results.get(0);
        }
        if (size == 0) {
            throw this.excEmptyResult();
        }
        throw this.excNonUniqueResult(results.size());
    }

    private void parseFindClause(int by) {
        boolean distinct;
        String methodName = this.method.getName();
        int start = 4;
        int endBefore = by == -1 ? methodName.length() : by;
        boolean first = methodName.regionMatches(start, "First", 0, 5);
        boolean bl = distinct = !first && methodName.regionMatches(start, "Distinct", 0, 8);
        while (first || distinct) {
            if (first) {
                start += 5;
                start = this.parseFirst(start, endBefore);
                first = false;
                distinct = methodName.regionMatches(start, "Distinct", 0, 8);
                continue;
            }
            if (!distinct) continue;
            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1056.unsupported.keyword", this.method.getName(), this.repositoryInterface.getName(), "Distinct");
        }
    }

    private int parseFirst(int start, int endBefore) {
        int i;
        int num;
        String methodName = this.method.getName();
        int n = num = start == endBefore ? 1 : 0;
        if (num == 0) {
            for (i = start; i < endBefore; ++i) {
                char ch = methodName.charAt(i);
                if (ch >= '0' && ch <= '9') {
                    if (num > (Integer.MAX_VALUE - (ch - 48)) / 10) {
                        throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1028.first.exceeds.max", methodName, this.repositoryInterface.getName(), methodName.substring(start, endBefore), "Integer.MAX_VALUE (2147483647)");
                    }
                    num = num * 10 + (ch - 48);
                    continue;
                }
                if (num != 0) break;
                num = 1;
                break;
            }
        }
        if (num == 0) {
            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1029.first.neg.or.zero", methodName, this.repositoryInterface.getName(), 0);
        }
        this.maxResults = num;
        return i;
    }

    private String parseIdentificationVariable(int startAt, int endBefore, String ql) {
        String entityVar = "this";
        while (startAt < endBefore && Character.isWhitespace(ql.charAt(startAt))) {
            ++startAt;
        }
        if (startAt < endBefore) {
            int idVar0 = startAt;
            int idVarLen = 0;
            while (startAt < endBefore && Character.isJavaIdentifierPart(ql.charAt(startAt))) {
                ++startAt;
            }
            idVarLen = startAt - idVar0;
            if (idVarLen > 0) {
                String s;
                if (!(idVarLen != 2 || ql.charAt(idVar0) != 'A' && ql.charAt(idVar0) != 'a' || ql.charAt(idVar0 + 1) != 'S' && ql.charAt(idVar0 + 1) != 's')) {
                    while (startAt < endBefore && Character.isWhitespace(ql.charAt(startAt))) {
                        ++startAt;
                    }
                    idVar0 = startAt;
                    while (startAt < endBefore && Character.isJavaIdentifierPart(ql.charAt(startAt))) {
                        ++startAt;
                    }
                }
                if (startAt > idVar0 && !Util.QL_KEYWORDS_AFTER_ENTITY_NAME.contains((s = ql.substring(idVar0, startAt)).toUpperCase())) {
                    entityVar = s;
                }
            }
        }
        return entityVar;
    }

    private void parseOrderBy(int orderBy, StringBuilder q) {
        String methodName = this.method.getName();
        this.sorts = this.sorts == null ? new ArrayList() : this.sorts;
        int length = methodName.length();
        int asc = 0;
        int desc = 0;
        int i = orderBy + 7;
        while (i >= 0 && i < length) {
            String attribute;
            int iNext = Math.min(asc = asc == -1 || asc > i ? asc : methodName.indexOf("Asc", i), desc = desc == -1 || desc > i ? desc : methodName.indexOf("Desc", i));
            if (iNext < 0) {
                iNext = Math.max(asc, desc);
            }
            boolean descending = iNext > 0 && iNext == desc;
            int endBefore = iNext < 0 ? methodName.length() : iNext;
            boolean ignoreCase = QueryInfo.endsWith(AttributeConstraint.IgnoreCase.name(), methodName, i, endBefore);
            if (ignoreCase) {
                endBefore -= 10;
            }
            if ((attribute = methodName.substring(i, endBefore)).length() == 0) {
                String lowerOrderBy = methodName.substring(orderBy + 7).toLowerCase();
                for (String lowerAttrName : this.entityInfo.attributeNames.keySet()) {
                    String keyword = lowerAttrName.contains("asc") ? "Asc" : (lowerAttrName.contains("desc") ? "Desc" : null);
                    if (keyword == null || !lowerOrderBy.contains(lowerAttrName)) continue;
                    throw DataExtension.exc(MappingException.class, "CWWKD1105.keyword.in.orderby", methodName, this.repositoryInterface.getName(), this.entityInfo.attributeNames.get(lowerAttrName), this.entityInfo.getType().getName(), keyword);
                }
            }
            this.addSort(ignoreCase, attribute, descending);
            if (iNext > 0) {
                iNext += iNext == desc ? 4 : 3;
            }
            i = iNext;
        }
        if (this.sortPositions == NONE && !this.sorts.isEmpty()) {
            this.sortPositions = NONE_STATIC_SORT_ONLY;
            this.generateOrderBy(q);
        }
    }

    private TreeMap<Integer, QueryEdit> parseQuery(String ql, int startAt, Boolean findQueryStartsWithSelect, boolean initEntityVar, Map<String, CompletableFuture<EntityInfo>> entityInfos, LinkedHashSet<String> qlParamNames) {
        int i;
        boolean countMustOmitSelect;
        boolean countPages;
        boolean isCursoredPage;
        TreeMap<Integer, QueryEdit> modifyAt = new TreeMap<Integer, QueryEdit>();
        int length = ql.length();
        boolean needsConstructorEnd = false;
        boolean needsParenthesesEnd = false;
        if (findQueryStartsWithSelect == null) {
            isCursoredPage = false;
            countPages = false;
            countMustOmitSelect = false;
        } else {
            isCursoredPage = CursoredPage.class.equals(this.multiType);
            boolean bl = countPages = isCursoredPage || Page.class.equals(this.multiType);
            if (findQueryStartsWithSelect == Boolean.TRUE) {
                countMustOmitSelect = countPages;
                if (this.producer.compat().atLeast(1, 1) && this.singleType.isRecord()) {
                    for (i = startAt; i < length && Character.isWhitespace(ql.charAt(i)); ++i) {
                    }
                    if (i + 3 < length && !Character.isJavaIdentifierPart(ql.charAt(i + 3)) && ql.regionMatches(true, i, "NEW", 0, 3)) {
                        i += 3;
                    } else {
                        modifyAt.put(i, QueryEdit.ADD_CONSTRUCTOR_BEGIN);
                        needsConstructorEnd = true;
                    }
                }
            } else {
                countMustOmitSelect = false;
                modifyAt.put(-1, QueryEdit.ADD_SELECT_IF_NEEDED);
            }
        }
        Integer addFromAt = findQueryStartsWithSelect == null ? Integer.valueOf(-1) : null;
        int depth = 0;
        boolean isLiteral = false;
        StringBuilder paramName = null;
        while (i < length) {
            block48: {
                block52: {
                    char ch;
                    block53: {
                        int l;
                        boolean isOrder;
                        boolean isWhere;
                        block55: {
                            block54: {
                                block51: {
                                    block50: {
                                        block49: {
                                            block47: {
                                                ch = ql.charAt(i);
                                                if (isLiteral || ch != ':') break block47;
                                                paramName = new StringBuilder(30);
                                                break block48;
                                            }
                                            if (isLiteral || ch != '(') break block49;
                                            ++depth;
                                            break block48;
                                        }
                                        if (isLiteral || ch != ')') break block50;
                                        depth = depth > 0 ? depth - 1 : 0;
                                        break block48;
                                    }
                                    if (ch != '\'') break block51;
                                    if (isLiteral) {
                                        if (i + 1 < length && ql.charAt(i + 1) == '\'') {
                                            ++i;
                                        } else {
                                            isLiteral = false;
                                        }
                                    } else {
                                        isLiteral = true;
                                        if (paramName != null) {
                                            qlParamNames.add(paramName.toString());
                                            paramName = null;
                                        }
                                    }
                                    break block48;
                                }
                                if (!Character.isJavaIdentifierStart(ch)) break block52;
                                if (paramName != null) break block53;
                                if (i + 4 >= length || Character.isJavaIdentifierPart(ql.charAt(i + 4)) || !ql.regionMatches(true, i, "FROM", 0, 4)) break block54;
                                if (depth == 0 && addFromAt == null) {
                                    addFromAt = -1;
                                }
                                if (depth == 0 && countMustOmitSelect) {
                                    countMustOmitSelect = false;
                                    modifyAt.put(-i, QueryEdit.OMIT_SELECT_IN_COUNT);
                                }
                                if (depth == 0 && needsConstructorEnd) {
                                    needsConstructorEnd = false;
                                    modifyAt.put(i - 1, QueryEdit.ADD_CONSTRUCTOR_END);
                                }
                                modifyAt.put((i += 4) + 1, QueryEdit.REPLACE_RECORD_ENTITY);
                                if (depth == 0 && initEntityVar) {
                                    char c;
                                    while (i < length && Character.isWhitespace(ql.charAt(i))) {
                                        ++i;
                                    }
                                    StringBuilder entityName = new StringBuilder();
                                    while (i < length && Character.isJavaIdentifierPart(c = ql.charAt(i))) {
                                        entityName.append(c);
                                        ++i;
                                    }
                                    if (entityName.length() > 0) {
                                        this.setEntityInfo(entityName.toString(), entityInfos, ql);
                                    } else if (findQueryStartsWithSelect == null) {
                                        throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1030.ql.lacks.entity", ql, this.method.getName(), this.repositoryInterface.getName(), "DELETE", "DELETE FROM [entity_name] WHERE [conditional_expression]");
                                    }
                                    this.entityVar = this.parseIdentificationVariable(i, length, ql);
                                    this.entityVar_ = this.entityVar == "this" ? "" : this.entityVar + ".";
                                    initEntityVar = false;
                                }
                                --i;
                                break block48;
                            }
                            if (depth != 0) break block48;
                            isWhere = false;
                            isOrder = false;
                            l = 5;
                            if (i + 5 < length && !Character.isJavaIdentifierPart(ql.charAt(i + l)) && ((isWhere = ql.regionMatches(true, i, "WHERE", 0, l)) || (isOrder = ql.regionMatches(true, i, "ORDER", 0, l)) || ql.regionMatches(true, i, "GROUP", 0, l) || ql.regionMatches(true, i, "UNION", 0, l))) break block55;
                            l = 6;
                            if (i + 6 < length && !Character.isJavaIdentifierPart(ql.charAt(i + l)) && (ql.regionMatches(true, i, "HAVING", 0, l) || ql.regionMatches(true, i, "EXCEPT", 0, l))) break block55;
                            l = 9;
                            if (i + 9 >= length || Character.isJavaIdentifierPart(ql.charAt(i + l)) || !ql.regionMatches(true, i, "INTERSECT", 0, l)) break block48;
                        }
                        if (isCursoredPage && !isWhere && !isOrder) {
                            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1120.cursor.keyword.mismatch", this.method.getName(), this.repositoryInterface.getName(), ql.substring(i, i + l), ql);
                        }
                        if (countMustOmitSelect) {
                            countMustOmitSelect = false;
                            modifyAt.put(-i, QueryEdit.OMIT_SELECT_IN_COUNT);
                        }
                        if (needsConstructorEnd) {
                            needsConstructorEnd = false;
                            modifyAt.put(i - 1, QueryEdit.ADD_CONSTRUCTOR_END);
                        }
                        if (needsParenthesesEnd) {
                            needsParenthesesEnd = false;
                            modifyAt.put(i, QueryEdit.ADD_PARENTHESIS_END);
                            if (isCursoredPage) {
                                throw this.excCursorPaginationNotAllowed(ql, i, isOrder);
                            }
                        }
                        if (addFromAt == null) {
                            addFromAt = i;
                        }
                        i += l;
                        if (isWhere) {
                            this.hasWhere = true;
                            if (isCursoredPage) {
                                modifyAt.put(i, QueryEdit.ADD_PARENTHESIS_BEGIN);
                                needsParenthesesEnd = true;
                            }
                        } else if (isOrder) {
                            if (countPages) {
                                modifyAt.put(-i, QueryEdit.OMIT_ORDER_IN_COUNT);
                            }
                        } else if (this.jpqlCount == null) {
                            this.jpqlCount = ql.substring(i - l, i);
                        }
                        --i;
                        break block48;
                    }
                    paramName.append(ch);
                    while (length > i + 1 && Character.isJavaIdentifierPart(ch = ql.charAt(i + 1))) {
                        paramName.append(ch);
                        ++i;
                    }
                    break block48;
                }
                if (paramName != null) {
                    qlParamNames.add(paramName.toString());
                    paramName = null;
                }
            }
            ++i;
        }
        if (initEntityVar) {
            this.entityVar = "this";
            this.entityVar_ = "";
        }
        if (paramName != null) {
            qlParamNames.add(paramName.toString());
        }
        if (countMustOmitSelect) {
            modifyAt.put(-length, QueryEdit.OMIT_SELECT_IN_COUNT);
        }
        if (addFromAt == null) {
            addFromAt = findQueryStartsWithSelect == Boolean.TRUE ? Integer.valueOf(length) : (startAt < length && ql.charAt(startAt) == '(' ? Integer.valueOf(-1) : Integer.valueOf(0));
        }
        if (addFromAt != -1) {
            modifyAt.put(addFromAt, QueryEdit.ADD_FROM);
        }
        if (needsConstructorEnd) {
            modifyAt.put(length - 1, QueryEdit.ADD_CONSTRUCTOR_END);
        }
        if (needsParenthesesEnd) {
            modifyAt.put(length, QueryEdit.ADD_PARENTHESIS_END);
        }
        return modifyAt;
    }

    private String replaceQuery(String ql, int selectItemsStartAt, TreeMap<Integer, QueryEdit> modifyAt) {
        String recordName = this.entityInfo.recordClass == null ? null : this.entityInfo.recordClass.getSimpleName();
        int rLen = recordName == null ? 0 : recordName.length();
        int eLen = this.entityInfo.name.length();
        int qlLen = ql.length();
        StringBuilder q = new StringBuilder(10 * modifyAt.size() + (modifyAt.firstKey() <= 0 ? 100 : 0) + qlLen);
        int qStartAt = 0;
        StringBuilder c = this.jpqlCount == null && (Page.class.equals(this.multiType) || CursoredPage.class.equals(this.multiType)) ? new StringBuilder(qlLen + 50) : null;
        int cStartAt = 0;
        int cEndAt = qlLen;
        block11: for (Map.Entry<Integer, QueryEdit> mod : modifyAt.entrySet()) {
            int m = mod.getKey();
            switch (mod.getValue()) {
                case OMIT_SELECT_IN_COUNT: {
                    if (c == null) continue block11;
                    cStartAt = -m;
                    int selectItemsLength = cStartAt - selectItemsStartAt;
                    c.append("SELECT COUNT(");
                    c.append(this.inferCountFromSelect(ql, selectItemsStartAt, selectItemsLength));
                    c.append(") ");
                    continue block11;
                }
                case OMIT_ORDER_IN_COUNT: {
                    if (c == null) continue block11;
                    cEndAt = -m - 5;
                    continue block11;
                }
                case ADD_SELECT_IF_NEEDED: {
                    q.append((CharSequence)this.generateSelectClause()).append(' ');
                    if (c == null) continue block11;
                    c.append("SELECT COUNT(").append(this.entityVar).append(") ");
                    continue block11;
                }
                case ADD_CONSTRUCTOR_BEGIN: {
                    int n = qStartAt;
                    qStartAt = m;
                    q.append(ql.substring(n, qStartAt));
                    if (!Character.isWhitespace(ql.charAt(m - 1))) {
                        q.append(' ');
                    }
                    q.append("NEW ").append(this.singleType.getName()).append('(');
                    continue block11;
                }
                case ADD_CONSTRUCTOR_END: {
                    int n = qStartAt;
                    qStartAt = m;
                    q.append(ql.substring(n, qStartAt));
                    char next = ql.charAt(m);
                    qStartAt = ++m;
                    if (Character.isWhitespace(next)) {
                        q.append(')').append(next);
                        continue block11;
                    }
                    q.append(next).append(") ");
                    continue block11;
                }
                case ADD_FROM: {
                    int n = qStartAt;
                    qStartAt = cStartAt = m;
                    q.append(ql.substring(n, cStartAt));
                    if (m > 0 && !Character.isWhitespace(ql.charAt(m - 1))) {
                        q.append(' ');
                    }
                    q.append("FROM ").append(this.entityInfo.name);
                    if (c != null) {
                        c.append("FROM ").append(this.entityInfo.name);
                    }
                    if (this.entityVar_.length() > 0) {
                        q.append(' ').append(this.entityVar);
                        if (c != null) {
                            c.append(' ').append(this.entityVar);
                        }
                    }
                    if (m >= qlLen || Character.isWhitespace(ql.charAt(m))) continue block11;
                    q.append(' ');
                    if (c == null) continue block11;
                    c.append(' ');
                    continue block11;
                }
                case ADD_PARENTHESIS_BEGIN: {
                    int n = qStartAt;
                    qStartAt = m;
                    q.append(ql.substring(n, qStartAt));
                    if (m < qlLen && ql.charAt(m) == ' ') {
                        qStartAt = ++m;
                        q.append(' ');
                    }
                    q.append('(');
                    continue block11;
                }
                case ADD_PARENTHESIS_END: {
                    int n = qStartAt;
                    qStartAt = m;
                    q.append(ql.substring(n, qStartAt - 1));
                    char last = ql.charAt(m - 1);
                    if (Character.isWhitespace(last)) {
                        q.append(')').append(last);
                        continue block11;
                    }
                    q.append(last).append(") ");
                    continue block11;
                }
                case REPLACE_RECORD_ENTITY: {
                    char ch;
                    if (rLen <= 0) continue block11;
                    q.append(ql.substring(qStartAt, m));
                    if (c != null) {
                        c.append(ql.substring(cStartAt, cEndAt < m ? cEndAt : m));
                    }
                    while (m < qlLen && !Character.isJavaIdentifierPart(ch = ql.charAt(m))) {
                        q.append(ch);
                        if (c != null && m < cEndAt) {
                            c.append(ch);
                        }
                        ++m;
                    }
                    if ((m + rLen == qlLen || m + rLen < qlLen && !Character.isJavaIdentifierPart(ql.charAt(m + rLen))) && ql.regionMatches(false, m, recordName, 0, rLen)) {
                        q.append(this.entityInfo.name);
                        if (c != null && (m += rLen) <= cEndAt) {
                            c.append(this.entityInfo.name);
                        }
                    }
                    qStartAt = m;
                    cStartAt = m < cEndAt ? m : cEndAt;
                    continue block11;
                }
            }
            throw new IllegalArgumentException(mod.getValue().toString());
        }
        if (qStartAt < qlLen) {
            q.append(ql.substring(qStartAt));
        }
        if (c != null) {
            if (cStartAt < cEndAt) {
                c.append(ql.substring(cStartAt, cEndAt));
            }
            this.jpqlCount = c.toString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)ql, (Object[])new Object[]{"count query: " + this.jpqlCount});
            }
        }
        return q.toString();
    }

    @Trivial
    private void requireOrderedPagination(Object[] args) {
        if (this.sortPositions.length > 0) {
            Class<?>[] paramTypes = this.method.getParameterTypes();
            for (int s = 0; s < this.sortPositions.length; ++s) {
                Object paramTypeName;
                int p = this.sortPositions[s];
                if (!Order.class.equals(paramTypes[p]) && !Sort.class.equals(paramTypes[p]) && !Sort[].class.equals(paramTypes[p])) continue;
                Object object = paramTypeName = Sort[].class.equals(paramTypes[p]) ? Sort.class.getName() + "[]" : paramTypes[p].getName();
                if (args[p] == null) {
                    throw DataExtension.exc(NullPointerException.class, "CWWKD1087.null.param", paramTypeName, this.method.getName(), this.repositoryInterface.getName());
                }
                throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1088.empty.sorts", paramTypeName, this.method.getName(), this.repositoryInterface.getName());
            }
        }
        if (this.sortPositions == NONE) {
            throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1089.unordered.pagination", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Trivial
    @ManualTrace
    Object save(Object arg, EntityManager em) throws Exception {
        void var9_23;
        void var9_21;
        int entityCount;
        ArrayList<Object> results;
        arg = arg instanceof Stream ? ((Stream)((Stream)((Object)arg)).sequential()).collect(Collectors.toList()) : arg;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"save", (Object[])new Object[]{this.loggable(arg)});
        }
        boolean resultVoid = Void.TYPE.equals(this.singleType) || Void.class.equals(this.singleType);
        boolean hasSingularEntityParam = false;
        if (this.entityParamType.isArray()) {
            results = new ArrayList<Object>();
            int length = Array.getLength(arg);
            for (entityCount = 0; entityCount < length; ++entityCount) {
                results.add(em.merge(this.toEntity(Array.get(arg, entityCount))));
            }
            em.flush();
        } else if (Iterable.class.isAssignableFrom(this.entityParamType)) {
            results = new ArrayList();
            for (Object t : (Iterable)arg) {
                ++entityCount;
                results.add(em.merge(this.toEntity(t)));
            }
            em.flush();
        } else {
            entityCount = 1;
            hasSingularEntityParam = true;
            results = resultVoid ? null : new ArrayList<Object>(1);
            Object entity = em.merge(this.toEntity(arg));
            if (results != null) {
                results.add(entity);
            }
            em.flush();
        }
        if (entityCount == 0) {
            throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1092.lifecycle.arg.empty", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericParameterTypes()[0].getTypeName());
        }
        Class<?> returnType = this.method.getReturnType();
        if (resultVoid) {
            Object var9_13 = null;
        } else {
            if (this.entityInfo.recordClass != null) {
                for (int i = 0; i < results.size(); ++i) {
                    results.set(i, this.entityInfo.toRecord(results.get(i)));
                }
            }
            if (this.returnArrayType != null) {
                Object[] newArray = (Object[])Array.newInstance(this.returnArrayType, results.size());
                Object[] objectArray = results.toArray(newArray);
            } else if (this.multiType == null) {
                if (results.size() == 1) {
                    Object e = results.get(0);
                } else {
                    if (!results.isEmpty()) throw DataExtension.exc(ClassCastException.class, "CWWKD1094.return.mismatch", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName(), results.size(), "@Save", Util.lifeCycleReturnTypes(this.entityInfo.getType().getName(), hasSingularEntityParam, false));
                    Object var9_16 = null;
                }
            } else if (this.multiType.isInstance(results)) {
                ArrayList<Object> arrayList = results;
            } else if (Stream.class.equals(this.multiType)) {
                Stream stream = results.stream();
            } else if (Iterable.class.isAssignableFrom(this.multiType)) {
                Iterable<?> iterable = this.convertToIterable(results, this.multiType, null, null);
            } else {
                if (!Iterator.class.equals(this.multiType)) throw DataExtension.exc(MappingException.class, "CWWKD1003.rtrn.err", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), "Save", Util.lifeCycleReturnTypes(results.get(0).getClass().getSimpleName(), hasSingularEntityParam, false));
                Iterator iterator = results.iterator();
            }
        }
        if (CompletableFuture.class.equals(returnType) || CompletionStage.class.equals(returnType)) {
            CompletableFuture<void> completableFuture = CompletableFuture.completedFuture(var9_21);
        } else if (!resultVoid && !returnType.isInstance(var9_21)) {
            throw DataExtension.exc(MappingException.class, "CWWKD1003.rtrn.err", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), "Save", Util.lifeCycleReturnTypes(results.get(0).getClass().getSimpleName(), hasSingularEntityParam, false));
        }
        if (!trace || !tc.isEntryEnabled()) return var9_23;
        Tr.exit((Object)this, (TraceComponent)tc, (String)"save", (Object)this.loggable(var9_23));
        return var9_23;
    }

    @Trivial
    private void setEntityInfo(Map<String, CompletableFuture<EntityInfo>> entityInfos, CompletableFuture<EntityInfo> primaryEntityInfoFuture) {
        if (this.singleType != null) {
            CompletableFuture<EntityInfo> failedFuture = null;
            for (CompletableFuture<EntityInfo> future : entityInfos.values()) {
                if (future.isCompletedExceptionally()) {
                    failedFuture = future;
                    continue;
                }
                this.entityInfo = future.join();
                if (!this.singleType.equals(this.entityInfo.entityClass) && !this.singleType.equals(this.entityInfo.recordClass)) continue;
                return;
            }
            if (failedFuture != null) {
                failedFuture.join();
            }
        }
        if (primaryEntityInfoFuture == null) {
            throw DataExtension.exc(MappingException.class, "CWWKD1001.no.primary.entity", this.method.getName(), this.repositoryInterface.getName(), "DataRepository<EntityClass, EntityIdClass>");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && !primaryEntityInfoFuture.isDone()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"await completion of primary entity info", (Object[])new Object[]{primaryEntityInfoFuture});
        }
        this.entityInfo = primaryEntityInfoFuture.join();
    }

    @Trivial
    private void setEntityInfo(String entityName, Map<String, CompletableFuture<EntityInfo>> entityInfos, String ql) {
        CompletableFuture<EntityInfo> future = entityInfos.get(entityName);
        if (future == null) {
            String recordEntityName = entityName + "Entity";
            future = entityInfos.get(recordEntityName);
            if (future == null) {
                this.entityInfo = null;
            } else {
                this.entityInfo = future.join();
                if (this.entityInfo.recordClass == null) {
                    this.entityInfo = null;
                }
            }
            if (this.entityInfo == null) {
                for (String name : entityInfos.keySet()) {
                    if (recordEntityName.equalsIgnoreCase(name) && entityInfos.get((Object)name).join().recordClass != null) {
                        name = name.substring(0, name.length() - "Entity".length());
                    }
                    if (!entityName.equalsIgnoreCase(name)) continue;
                    throw DataExtension.exc(MappingException.class, "CWWKD1031.ql.similar.entity", this.method.getName(), this.repositoryInterface.getName(), entityName, name, ql);
                }
                future = entityInfos.get("ERROR!");
                if (future == null) {
                    throw DataExtension.exc(MappingException.class, "CWWKD1032.ql.unknown.entity", this.method.getName(), this.repositoryInterface.getName(), entityName, Util.lifeCycleAnnoNames(this.producer), ql);
                }
            }
        } else {
            this.entityInfo = future.join();
        }
    }

    @Trivial
    private void setParameter(int p, Query query, Object entity, String attrName) throws Exception {
        Object v = entity;
        for (Member accessor : this.entityInfo.attributeAccessors.get(attrName)) {
            v = accessor instanceof Method ? ((Method)accessor).invoke(v, new Object[0]) : ((Field)accessor).get(v);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set ?" + p + " " + String.valueOf(this.loggable(v))), (Object[])new Object[0]);
        }
        query.setParameter(p, v);
    }

    @Trivial
    void setParameters(Query query, Object ... args) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        DataVersionCompatibility compat = this.producer.compat();
        Iterator<String> namedParams = this.jpqlParamNames.iterator();
        int p = 0;
        for (int i = 0; i < this.jpqlParamCount; ++i) {
            Object[] values = compat.toConstraintValues(args[i]);
            if (values == null) {
                if (namedParams.hasNext()) {
                    String paramName = namedParams.next();
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("set :" + paramName + " " + String.valueOf(this.loggable(args[i]))), (Object[])new Object[0]);
                    }
                    query.setParameter(paramName, args[i]);
                    ++p;
                    continue;
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("set ?" + (p + 1) + " " + String.valueOf(this.loggable(args[i]))), (Object[])new Object[0]);
                }
                query.setParameter(++p, args[i]);
                continue;
            }
            for (Object value : values) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("set ?" + (p + 1) + " " + String.valueOf(this.loggable(value))), (Object[])new Object[0]);
                }
                query.setParameter(++p, value);
            }
        }
    }

    void setParametersFromCursor(Query query, PageRequest.Cursor cursor) throws Exception {
        int paramNum = this.jpqlParamCount;
        if (this.jpqlParamNames.isEmpty()) {
            for (int i = 0; i < cursor.size(); ++i) {
                Object value = cursor.get(i);
                if (this.entityInfo.idClassAttributeAccessors != null && this.entityInfo.idType.isInstance(value)) {
                    for (Member accessor : this.entityInfo.idClassAttributeAccessors.values()) {
                        Object v;
                        Object object = v = accessor instanceof Field ? ((Field)accessor).get(value) : ((Method)accessor).invoke(value, new Object[0]);
                        if (++paramNum - this.jpqlParamCount > this.sorts.size()) {
                            this.cursorSizeMismatchError(cursor);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("set [cursor] ?" + paramNum + " " + String.valueOf(this.loggable(value)) + "-->" + String.valueOf(this.loggable(v))), (Object[])new Object[0]);
                        }
                        query.setParameter(paramNum, v);
                    }
                    continue;
                }
                if (++paramNum - this.jpqlParamCount > this.sorts.size()) {
                    this.cursorSizeMismatchError(cursor);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("set [cursor] ?" + paramNum + " " + String.valueOf(this.loggable(value))), (Object[])new Object[0]);
                }
                query.setParameter(paramNum, value);
            }
        } else {
            for (int i = 0; i < cursor.size(); ++i) {
                Object value = cursor.get(i);
                if (this.entityInfo.idClassAttributeAccessors != null && this.entityInfo.idType.isInstance(value)) {
                    for (Member accessor : this.entityInfo.idClassAttributeAccessors.values()) {
                        Object v;
                        Object object = v = accessor instanceof Field ? ((Field)accessor).get(value) : ((Method)accessor).invoke(value, new Object[0]);
                        if (++paramNum - this.jpqlParamCount > this.sorts.size()) {
                            this.cursorSizeMismatchError(cursor);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("set [cursor] :cursor" + paramNum + " " + value.getClass().getName() + "-->" + (v == null ? null : v.getClass().getSimpleName())), (Object[])new Object[0]);
                        }
                        query.setParameter("cursor" + paramNum, v);
                    }
                    continue;
                }
                if (++paramNum - this.jpqlParamCount > this.sorts.size()) {
                    this.cursorSizeMismatchError(cursor);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("set [cursor] :cursor" + paramNum + " " + (value == null ? null : value.getClass().getSimpleName())), (Object[])new Object[0]);
                }
                query.setParameter("cursor" + paramNum, value);
            }
        }
        if (this.sorts.size() > paramNum - this.jpqlParamCount) {
            this.cursorSizeMismatchError(cursor);
        }
    }

    @Trivial
    private void setParametersFromIdClassAndVersion(int startingParamIndex, Query query, Object entity, Object version) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        int p = startingParamIndex;
        for (String idClassAttr : this.entityInfo.idClassAttributeAccessors.keySet()) {
            this.setParameter(p++, query, entity, this.getAttributeName(idClassAttr, true));
        }
        if (version != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("set ?" + p + " " + String.valueOf(version)), (Object[])new Object[0]);
            }
            query.setParameter(p++, version);
        }
    }

    private void setType(Class<? extends Annotation> annoClass, QueryType operationType) {
        this.type = operationType;
        if (this.entityParamType == null) {
            int paramCount = this.method.getParameterCount();
            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1009.lifecycle.param.err", this.method.getName(), this.repositoryInterface.getName(), paramCount == 1 ? this.method.getGenericParameterTypes()[0] : Integer.valueOf(paramCount), annoClass.getSimpleName());
        }
    }

    @Trivial
    private List<Sort<Object>> supplySorts(List<Sort<Object>> combined, Iterable<Sort<Object>> additional) {
        boolean hasIdClass;
        Iterator<Sort<Object>> addIt = additional.iterator();
        boolean bl = hasIdClass = this.entityInfo.idClassAttributeAccessors != null;
        if (combined == null && addIt.hasNext()) {
            List<Sort<Object>> list = combined = this.sorts == null ? new ArrayList<Sort<Object>>() : new ArrayList<Sort<Object>>(this.sorts);
        }
        while (addIt.hasNext()) {
            Sort<Object> sort = addIt.next();
            if (sort == null) {
                throw new IllegalArgumentException("Sort: null");
            }
            if (hasIdClass && "id(this)".equalsIgnoreCase(sort.property())) {
                for (String name : this.entityInfo.idClassAttributeAccessors.keySet()) {
                    combined.add(this.getWithAttributeName(this.getAttributeName(name, true), sort));
                }
                continue;
            }
            combined.add(this.getWithAttributeName(sort.property(), sort));
        }
        return combined;
    }

    @Trivial
    private List<Sort<Object>> supplySorts(List<Sort<Object>> combined, Sort<Object> ... additional) {
        boolean hasIdClass;
        boolean bl = hasIdClass = this.entityInfo.idClassAttributeAccessors != null;
        if (combined == null && additional.length > 0) {
            combined = this.sorts == null ? new ArrayList<Sort<Object>>() : new ArrayList<Sort<Object>>(this.sorts);
        }
        for (Sort<Object> sort : additional) {
            if (sort == null) {
                throw new IllegalArgumentException("Sort: null");
            }
            if (hasIdClass && "id(this)".equalsIgnoreCase(sort.property())) {
                for (String name : this.entityInfo.idClassAttributeAccessors.keySet()) {
                    combined.add(this.getWithAttributeName(this.getAttributeName(name, true), sort));
                }
                continue;
            }
            combined.add(this.getWithAttributeName(sort.property(), sort));
        }
        return combined;
    }

    @Trivial
    private final double toDouble(Object o) {
        return (Double)this.convert(o, Double.TYPE, true);
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    private final Object toEntity(Object o) {
        if (o == null) {
            throw DataExtension.exc(NullPointerException.class, "CWWKD1015.null.entity.param", this.method.getName(), this.repositoryInterface.getName());
        }
        Object entity = o;
        Class<?> oClass = o.getClass();
        if (oClass.isRecord()) {
            try {
                Class<?> entityClass = oClass.getClassLoader().loadClass(oClass.getName() + "Entity");
                Constructor<?> ctor = entityClass.getConstructor(oClass);
                entity = ctor.newInstance(o);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException entityClass) {
                void x;
                FFDCFilter.processException((Throwable)entityClass, (String)"io.openliberty.data.internal.persistence.QueryInfo", (String)"5535", (Object)this, (Object[])new Object[]{o});
                Throwable targetx = x instanceof InvocationTargetException ? x.getCause() : x;
                IllegalArgumentException iax = DataExtension.exc(IllegalArgumentException.class, "CWWKD1070.record.convert.err", this.loggableAppend(oClass.getName(), " (" + String.valueOf(o) + ")"), this.method.getName(), this.repositoryInterface.getName(), targetx.getMessage());
                throw (IllegalArgumentException)iax.initCause((Throwable)x);
            }
        }
        if (entity != o && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("toEntity " + String.valueOf(this.loggable(o))), (Object[])new Object[]{oClass.getName() + " --> " + entity.getClass().getName()});
        }
        return entity;
    }

    @Trivial
    private final int toInt(Object o) {
        return (Integer)this.convert(o, Integer.TYPE, true);
    }

    @Trivial
    private final long toLong(Object o) {
        return (Long)this.convert(o, Long.TYPE, true);
    }

    private final PageRequest toPageRequest(Limit limit) {
        if (limit.startAt() != 1L) {
            throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1041.rtrn.mismatch.pagereq", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName());
        }
        return PageRequest.ofSize((int)limit.maxResults());
    }

    private final Object toReturnValue(int i, Class<?> returnType) {
        Object result;
        if (Integer.TYPE.equals(returnType) || Integer.class.equals(returnType) || Number.class.equals(returnType)) {
            result = i;
        } else if (Long.TYPE.equals(returnType) || Long.class.equals(returnType)) {
            result = (long)i;
        } else if (Boolean.TYPE.equals(returnType) || Boolean.class.equals(returnType)) {
            result = i != 0;
        } else if (Void.TYPE.equals(returnType) || Void.class.equals(returnType)) {
            result = null;
        } else if (CompletableFuture.class.equals(returnType) || CompletionStage.class.equals(returnType)) {
            result = CompletableFuture.completedFuture(this.toReturnValue(i, this.singleType));
        } else {
            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1007.updel.rtrn.err", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), this.type == QueryType.QM_DELETE ? "Delete" : "Update");
        }
        return result;
    }

    @Trivial
    public String toString() {
        StringBuilder b = new StringBuilder("QueryInfo@").append(Integer.toHexString(this.hashCode())).append(' ').append(this.method.getGenericReturnType().getTypeName()).append(' ').append(this.method.getName());
        boolean first = true;
        for (Class<?> p : this.method.getParameterTypes()) {
            b.append(first ? "(" : ", ").append(p.getSimpleName());
            first = false;
        }
        b.append(first ? "() " : ") ");
        if (this.jpql != null) {
            b.append(this.jpql);
        }
        if (this.jpqlParamCount > 0) {
            b.append(" [").append(this.jpqlParamCount).append(this.jpqlParamNames.isEmpty() ? " positional params]" : " named params]");
        }
        return b.toString();
    }

    @Trivial
    @ManualTrace
    Object update(Object arg, EntityManager em) throws Exception {
        arg = arg instanceof Stream ? ((Stream)((Stream)((Object)arg)).sequential()).collect(Collectors.toList()) : arg;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"update", (Object[])new Object[]{this.loggable(arg)});
        }
        int updateCount = 0;
        int numExpected = 0;
        if (arg instanceof Iterable) {
            for (Object e : (Iterable)arg) {
                ++numExpected;
                updateCount += this.updateOne(e, em);
            }
        } else if (this.entityParamType.isArray()) {
            numExpected = Array.getLength(arg);
            for (int i = 0; i < numExpected; ++i) {
                updateCount += this.updateOne(Array.get(arg, i), em);
            }
        } else {
            numExpected = 1;
            updateCount = this.updateOne(arg, em);
        }
        if (numExpected == 0) {
            throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1092.lifecycle.arg.empty", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericParameterTypes()[0].getTypeName());
        }
        if (updateCount < numExpected) {
            if (numExpected == 1) {
                throw DataExtension.exc(OptimisticLockingFailureException.class, "CWWKD1051.single.opt.lock.exc", this.method.getName(), this.repositoryInterface.getName(), this.entityInfo.entityClass.getName(), Util.LIFE_CYCLE_METHODS_THAT_RETURN_ENTITIES_STATELESS);
            }
            throw DataExtension.exc(OptimisticLockingFailureException.class, "CWWKD1052.multi.opt.lock.exc", this.method.getName(), this.repositoryInterface.getName(), numExpected - updateCount, numExpected, this.entityInfo.entityClass.getName(), Util.LIFE_CYCLE_METHODS_THAT_RETURN_ENTITIES_STATELESS);
        }
        Object returnValue = this.toReturnValue(updateCount, this.method.getReturnType());
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"update", (Object)this.loggable(returnValue));
        }
        return returnValue;
    }

    @Trivial
    @ManualTrace
    private int updateOne(Object e, EntityManager em) throws Exception {
        int numUpdated;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"updateOne", (Object[])new Object[]{this.loggable(e)});
        }
        Class<?> entityClass = this.entityInfo.getType();
        if (e == null) {
            throw DataExtension.exc(NullPointerException.class, "CWWKD1015.null.entity.param", this.method.getName(), this.repositoryInterface.getName());
        }
        if (!entityClass.isInstance(e)) {
            throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1016.incompat.entity.param", this.method.getName(), this.repositoryInterface.getName(), entityClass.getName(), e.getClass().getName());
        }
        String jpql = this.jpql;
        SortedSet<String> attrsToUpdate = this.entityInfo.attributeNamesForEntityUpdate;
        int versionParamIndex = this.entityInfo.idClassAttributeAccessors == null ? attrsToUpdate.size() + 2 : attrsToUpdate.size() + this.entityInfo.idClassAttributeAccessors.size() + 1;
        Object version = null;
        if (this.entityInfo.versionAttributeName != null && (version = this.getAttribute(e, this.entityInfo.versionAttributeName)) == null) {
            jpql = jpql.replace("=?" + versionParamIndex, " IS NULL");
        }
        Object id = null;
        String idAttributeName = null;
        if (this.entityInfo.idClassAttributeAccessors == null && (id = this.getAttribute(e, idAttributeName = this.entityInfo.attributeNames.get("id(this)"))) == null) {
            jpql = jpql.replace("=?" + (versionParamIndex - 1), " IS NULL");
            if (version != null) {
                jpql = jpql.replace("=?" + versionParamIndex, "=?" + (versionParamIndex - 1));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && jpql != this.jpql) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"JPQL adjusted for NULL id or version", (Object[])new Object[]{jpql});
        }
        TypedQuery update = em.createQuery(jpql, this.entityInfo.entityClass);
        int p = 1;
        for (String attrName : attrsToUpdate) {
            this.setParameter(p++, (Query)update, e, attrName);
        }
        if (this.entityInfo.idClassAttributeAccessors == null) {
            if (id != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("set ?" + p + " " + String.valueOf(this.loggable(id))), (Object[])new Object[0]);
                }
                update.setParameter(p++, id);
            }
            if (this.entityInfo.versionAttributeName != null && version != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("set ?" + p + " " + String.valueOf(this.loggable(version))), (Object[])new Object[0]);
                }
                update.setParameter(p++, version);
            }
        } else {
            this.setParametersFromIdClassAndVersion(p, (Query)update, e, version);
        }
        if ((numUpdated = update.executeUpdate()) > 1) {
            throw new DataException("Found " + numUpdated + " matching entities.");
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"updateOne", (Object)numUpdated);
        }
        return numUpdated;
    }

    @Trivial
    private void validate() {
        if (this.type == null) {
            throw this.excUnsupportedMethod();
        }
        int methodParamCount = this.method.getParameterCount();
        if (this.jpql != null && methodParamCount < this.jpqlParamCount && this.type != QueryType.LC_DELETE && this.type != QueryType.LC_UPDATE && this.type != QueryType.LC_UPDATE_RET_ENTITY) {
            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1021.insufficient.params", this.method.getName(), this.repositoryInterface.getName(), methodParamCount, this.jpqlParamCount, this.jpql);
        }
        if (this.jpql != null && this.jpqlParamCount < methodParamCount && this.type != QueryType.FIND && this.type != QueryType.FIND_AND_DELETE) {
            if (this.type == QueryType.QM_DELETE) {
                Class<?>[] paramTypes = this.method.getParameterTypes();
                for (int i = this.jpqlParamCount; i < methodParamCount; ++i) {
                    if (!Util.SORT_PARAM_TYPES.contains(paramTypes[i]) && !Limit.class.equals(paramTypes[i])) continue;
                    throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1097.param.incompat", this.method.getName(), this.repositoryInterface.getName(), paramTypes[i].getSimpleName());
                }
            }
            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1022.too.many.params", this.method.getName(), this.repositoryInterface.getName(), this.jpqlParamCount, methodParamCount, this.jpql);
        }
        if (this.type == QueryType.FIND && CursoredPage.class.equals(this.multiType)) {
            if (!this.singleType.equals(this.entityInfo.getType())) {
                throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1037.cursor.rtrn.mismatch", this.singleType.getSimpleName(), this.method.getName(), this.repositoryInterface.getName(), this.entityInfo.getType().getName(), this.method.getGenericReturnType().getTypeName());
            }
            if (this.sortPositions == NONE_QUERY_LANGUAGE_ONLY && this.sorts == null) {
                throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1100.cursor.requires.sort", this.method.getName(), this.repositoryInterface.getName(), this.method.getGenericReturnType().getTypeName(), "Order, Sort, Sort[]");
            }
        }
    }

    @Trivial
    private Annotation validateAnnotationCombinations(Delete delete, Insert insert, Update update, Save save, Find find, jakarta.data.repository.Query query, OrderBy[] orderBy, Annotation count, Annotation exists) {
        int o = orderBy.length == 0 ? 0 : 1;
        int f = find == null ? 0 : 1;
        int q = query == null ? 0 : 1;
        int ius = (insert == null ? 0 : 1) + (update == null ? 0 : 1) + (save == null ? 0 : 1);
        int iusce = ius + (count == null ? 0 : 1) + (exists == null ? 0 : 1);
        int iusdce = iusce + (delete == null ? 0 : 1);
        if (iusdce + f > 1 || iusce + o > 1 || iusdce + q > 1) {
            ArrayList<String> annoClassNames = new ArrayList<String>();
            for (Annotation anno : Arrays.asList(count, delete, exists, find, insert, query, save, update)) {
                if (anno == null) continue;
                annoClassNames.add(anno.annotationType().getName());
            }
            if (orderBy.length > 0) {
                annoClassNames.add(OrderBy.class.getName());
            }
            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1002.method.annos.err", this.method.getName(), this.repositoryInterface.getName(), annoClassNames);
        }
        return ius == 1 ? (insert != null ? insert : (update != null ? update : save)) : (iusdce == 1 ? (delete != null ? delete : (count != null ? count : exists)) : (q == 1 ? query : (f == 1 ? find : null)));
    }

    @Trivial
    private void validateParameterPositions() {
        DataVersionCompatibility compat = this.entityInfo.builder.provider.compat;
        Class<?>[] paramTypes = this.method.getParameterTypes();
        Set specParamTypes = compat.specialParamTypes();
        int specParamIndex = Integer.MAX_VALUE;
        int otherParamIndex = -1;
        for (int i = 0; i < paramTypes.length; ++i) {
            if (specParamTypes.contains(paramTypes[i])) {
                specParamIndex = i < specParamIndex ? i : specParamIndex;
                continue;
            }
            otherParamIndex = i;
        }
        if (specParamIndex < otherParamIndex) {
            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1098.spec.param.position.err", this.method.getName(), this.repositoryInterface.getName(), paramTypes[specParamIndex].getName(), compat.specialParamsForFind());
        }
    }

    @Trivial
    private void validateReturnForExists() {
        if (!Boolean.TYPE.equals(this.singleType) && !Boolean.class.equals(this.singleType) || this.multiType != null && !CompletableFuture.class.equals(this.multiType) && !CompletionStage.class.equals(this.multiType)) {
            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1003.rtrn.err", this.method.getGenericReturnType().getTypeName(), this.method.getName(), this.repositoryInterface.getName(), "exists", "boolean, Boolean");
        }
    }

    @Trivial
    private void validateSort(Sort<?> sort) {
        String propName = sort.property();
        if (propName.charAt(propName.length() - 1) != ')') {
            Class propertyClass = (Class)this.entityInfo.attributeTypes.get(propName);
            if (sort.ignoreCase() && !CharSequence.class.isAssignableFrom(propertyClass) && !Character.TYPE.equals(propertyClass) && !Character.class.equals((Object)propertyClass)) {
                throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1026.ignore.case.not.text", propName, this.entityInfo.getType().getName(), sort, propertyClass.getName(), this.method.getName(), this.repositoryInterface.getName());
            }
        }
    }
}

