/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import org.jboss.jdeparser.JArray;
import org.jboss.jdeparser.JArrayCompRef;
import org.jboss.jdeparser.JAssignment;
import org.jboss.jdeparser.JAssignmentTarget;
import org.jboss.jdeparser.JAtom;
import org.jboss.jdeparser.JCast;
import org.jboss.jdeparser.JClass;
import org.jboss.jdeparser.JExpression;
import org.jboss.jdeparser.JExpressionImpl;
import org.jboss.jdeparser.JFieldRef;
import org.jboss.jdeparser.JFormatter;
import org.jboss.jdeparser.JInvocation;
import org.jboss.jdeparser.JMethod;
import org.jboss.jdeparser.JNarrowedClass;
import org.jboss.jdeparser.JStringLiteral;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JVar;

public abstract class JExpr {
    private static final JExpression __this = new JAtom("this");
    private static final JExpression __super = new JAtom("super");
    private static final JExpression __null = new JAtom("null");
    public static final JExpression TRUE = new JAtom("true");
    public static final JExpression FALSE = new JAtom("false");
    static final String charEscape = "\b\t\n\f\r\"'\\";
    static final String charMacro = "btnfr\"'\\";

    private JExpr() {
    }

    public static JExpression assign(JAssignmentTarget lhs, JExpression rhs) {
        return new JAssignment(lhs, rhs);
    }

    public static JExpression assignPlus(JAssignmentTarget lhs, JExpression rhs) {
        return new JAssignment(lhs, rhs, "+");
    }

    public static JInvocation _new(JClass c) {
        return new JInvocation(c);
    }

    public static JInvocation _new(JType t) {
        return new JInvocation(t);
    }

    public static JInvocation invoke(String method) {
        return new JInvocation((JExpression)null, method);
    }

    public static JInvocation invoke(JMethod method) {
        return new JInvocation((JExpression)null, method);
    }

    public static JInvocation invoke(JExpression lhs, JMethod method) {
        return new JInvocation(lhs, method);
    }

    public static JInvocation invoke(JExpression lhs, String method) {
        return new JInvocation(lhs, method);
    }

    public static JFieldRef ref(String field) {
        return new JFieldRef((JExpression)null, field);
    }

    public static JFieldRef ref(JExpression lhs, JVar field) {
        return new JFieldRef(lhs, field);
    }

    public static JFieldRef ref(JExpression lhs, String field) {
        return new JFieldRef(lhs, field);
    }

    public static JFieldRef refthis(String field) {
        return new JFieldRef(null, field, true);
    }

    public static JExpression dotclass(JClass cl) {
        return new DotRef(cl, ".class");
    }

    public static JExpression dotthis(JClass cl) {
        return new DotRef(cl, ".this");
    }

    public static JExpression dotsuper(JClass cl) {
        return new DotRef(cl, ".super");
    }

    public static JArrayCompRef component(JExpression lhs, JExpression index) {
        return new JArrayCompRef(lhs, index);
    }

    public static JCast cast(JType type, JExpression expr) {
        return new JCast(type, expr);
    }

    public static JArray newArray(JType type) {
        return JExpr.newArray(type, null);
    }

    public static JArray newArray(JType type, JExpression size) {
        return new JArray(type.erasure(), size);
    }

    public static JArray newArray(JType type, int size) {
        return JExpr.newArray(type, JExpr.lit(size));
    }

    public static JExpression _this() {
        return __this;
    }

    public static JExpression _super() {
        return __super;
    }

    public static JExpression _null() {
        return __null;
    }

    public static JExpression lit(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static JExpression lit(int n) {
        return new JAtom(Integer.toString(n));
    }

    public static JExpression lit(long n) {
        return new JAtom(Long.toString(n) + "L");
    }

    public static JExpression lit(float f) {
        if (f == Float.NEGATIVE_INFINITY) {
            return new JAtom("java.lang.Float.NEGATIVE_INFINITY");
        }
        if (f == Float.POSITIVE_INFINITY) {
            return new JAtom("java.lang.Float.POSITIVE_INFINITY");
        }
        if (Float.isNaN(f)) {
            return new JAtom("java.lang.Float.NaN");
        }
        return new JAtom(Float.toString(f) + "F");
    }

    public static JExpression lit(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return new JAtom("java.lang.Double.NEGATIVE_INFINITY");
        }
        if (d == Double.POSITIVE_INFINITY) {
            return new JAtom("java.lang.Double.POSITIVE_INFINITY");
        }
        if (Double.isNaN(d)) {
            return new JAtom("java.lang.Double.NaN");
        }
        return new JAtom(Double.toString(d) + "D");
    }

    public static String quotify(char quote, String s) {
        int n = s.length();
        StringBuilder sb = new StringBuilder(n + 2);
        sb.append(quote);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            int j = charEscape.indexOf(c);
            if (j >= 0) {
                if (quote == '\"' && c == '\'' || quote == '\'' && c == '\"') {
                    sb.append(c);
                    continue;
                }
                sb.append('\\');
                sb.append(charMacro.charAt(j));
                continue;
            }
            if (c < ' ' || '~' < c) {
                sb.append("\\u");
                String hex = Integer.toHexString(c & 0xFFFF);
                for (int k = hex.length(); k < 4; ++k) {
                    sb.append('0');
                }
                sb.append(hex);
                continue;
            }
            sb.append(c);
        }
        sb.append(quote);
        return sb.toString();
    }

    public static JExpression lit(char c) {
        return new JAtom(JExpr.quotify('\'', "" + c));
    }

    public static JExpression lit(String s) {
        return new JStringLiteral(s);
    }

    public static JExpression direct(final String source) {
        return new JExpressionImpl(){

            @Override
            public void generate(JFormatter f) {
                f.p('(').p(source).p(')');
            }
        };
    }

    private static class DotRef
    extends JExpressionImpl {
        private final JClass cl;
        private final String ref;

        public DotRef(JClass cl, String ref) {
            this.cl = cl;
            this.ref = ref;
        }

        @Override
        public void generate(JFormatter f) {
            JClass c = this.cl instanceof JNarrowedClass ? ((JNarrowedClass)this.cl).basis : this.cl;
            f.g(c).p(this.ref);
        }
    }
}

