/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.tss;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.csiv2.Authenticator;
import com.ibm.ws.transport.iiop.security.SASException;
import com.ibm.ws.transport.iiop.security.SASInvalidEvidenceException;
import com.ibm.ws.transport.iiop.security.SASInvalidMechanismException;
import com.ibm.ws.transport.iiop.security.config.tss.TSSASMechConfig;
import com.ibm.ws.transport.iiop.security.util.Util;
import com.ibm.wsspi.security.csiv2.TrustedIDEvaluator;
import java.nio.charset.StandardCharsets;
import javax.security.auth.Subject;
import org.omg.CSI.EstablishContext;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.GSSUP.InitialContextToken;
import org.omg.IOP.Codec;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TSSGSSUPMechConfig
extends TSSASMechConfig {
    private transient Authenticator authenticator = null;
    public static final String mechanism = "GSSUP";
    private String targetName;
    private boolean required;
    static final long serialVersionUID = 7106726903269059196L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TSSGSSUPMechConfig() {
    }

    public TSSGSSUPMechConfig(Authenticator authenticator, String targetName, boolean required) {
        this.authenticator = authenticator;
        this.targetName = targetName;
        this.required = required;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public short getSupports() {
        return 64;
    }

    @Override
    public short getRequires() {
        return this.required ? (short)64 : 0;
    }

    @Override
    public AS_ContextSec encodeIOR(Codec codec) throws Exception {
        AS_ContextSec result = new AS_ContextSec();
        result.target_supports = (short)64;
        result.target_requires = (short)(this.required ? 64 : 0);
        result.client_authentication_mech = Util.encodeOID("oid:2.23.130.1.1.1");
        result.target_name = Util.encodeGSSExportName("oid:2.23.130.1.1.1", this.targetName);
        return result;
    }

    @Override
    @FFDCIgnore(value={AuthenticationException.class})
    public Subject check(EstablishContext msg, Codec codec) throws SASException {
        Subject authenticationLayerSubject = null;
        if (msg != null && msg.client_authentication_token != null && msg.client_authentication_token.length > 0) {
            InitialContextToken token = new InitialContextToken();
            if (!Util.decodeGSSUPToken(codec, msg.client_authentication_token, token)) {
                String messageFromBundle = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_SERVER_CANNOT_DECODE_GSSUP", (Object[])new Object[0], (String)"CWWKS9549E: The server cannot decode the GSSUP token sent by the client and it cannot authenticate the token.");
                throw new SASInvalidMechanismException(messageFromBundle, 1229066437);
            }
            if (token.target_name == null) {
                return null;
            }
            try {
                String tokenTargetName = new String(token.target_name, StandardCharsets.UTF_8);
                if (!this.targetName.equals(tokenTargetName)) {
                    throw new SASException(2);
                }
                String username = Util.extractUserNameFromScopedName(token.username);
                authenticationLayerSubject = this.authenticator.authenticate(username, new String(token.password, StandardCharsets.UTF_8));
            }
            catch (AuthenticationException e) {
                throw new SASInvalidEvidenceException(e.getMessage(), 1229079296);
            }
        } else if (this.required) {
            throw new SASInvalidEvidenceException("Client authentication is required at the server, but there was no client authentication token sent by the client.", 1229079296);
        }
        return authenticationLayerSubject;
    }

    @Override
    public boolean isTrusted(TrustedIDEvaluator trustedIDEvaluator, EstablishContext msg, Codec codec) {
        InitialContextToken token;
        if (msg != null && msg.client_authentication_token != null && msg.client_authentication_token.length > 0 && Util.decodeGSSUPToken(codec, msg.client_authentication_token, token = new InitialContextToken())) {
            String user = Util.extractUserNameFromScopedName(token.username);
            String password = new String(token.password, StandardCharsets.UTF_8);
            return trustedIDEvaluator.isTrusted(user, password);
        }
        return false;
    }

    @Override
    public String getMechanism() {
        return mechanism;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString("", buf);
        return buf.toString();
    }

    @Override
    @Trivial
    public void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("TSSGSSUPMechConfig: [\n");
        buf.append(moreSpaces).append("targetName:   ").append(this.targetName).append("\n");
        buf.append(moreSpaces).append("required  :   ").append(this.required).append("\n");
        buf.append(spaces).append("]\n");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.security.config.tss.TSSGSSUPMechConfig", TSSGSSUPMechConfig.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    }
}

